/**
 * @(#) Supplier.java
 */

public class Supplier extends User
{
    /**
     * importDrinks - sukuria pas tiekj reikiam skaii grim
     * @param numOfDrinks - kiek grim sukurti
     */
    public void importDrinks( int numOfDrinks, float drinkPrice, String typeOfDrinks )
    {
        int i = 0;
        while ( i < numOfDrinks )
        {
            Drink myDrink;
            myDrink = new Drink( typeOfDrinks, drinkPrice );
            this.drinks.add( myDrink );
            i++;
        }
        this.say("I tiekjo gavau "+ numOfDrinks + " grim");
    }

    /**
     * supply - papildo grim aparat tiekjo turimais grimais
     * @param numOfItems - kiek grim reikia sudti  aparat
     * @param machine - aparatas, kur reikia papildyti
     */
    public void supply( int numOfItems, DrinkMachine machine )
    {
        if (this.drinks.size() >= numOfItems)
        {
            int drinksInserted = 0;
            while ( this.drinks.size() > 0 && drinksInserted < numOfItems)
            {
                machine.insertDrink( this.drinks.get( drinksInserted ) );
                this.drinks.remove( drinksInserted );
                drinksInserted++;
            }
            this.say(" aparat dta "+ numOfItems + " grim");
        }
    }

    /**
     * getMoney - iima i aparato pinigus
     * @param machine - aparatas i kurio iimti pinigus
     */
    public void getMoney( DrinkMachine machine )
    {
        this.money.increase( machine.getMoneyAmount() );
        machine.removeMoney();
    }

    /**
     * iveda  ekran tekst
     * @param text - tekstas, kur pasakyti
     */
    public void say( String text )
    {
        System.out.println("Supplier:" + text );
    }
}
