
import java.util.ArrayList;
import java.util.Iterator;

/**
 * @(#) DrinkMachine.java
 */

public class DrinkMachine
{


    private Money money = new Money();
    private ArrayList drinks = new ArrayList();

    public void insertMoney( float amount )
    {
        this.money.increase( amount );
        this.say("Vartotojas djo pinig: " + amount );
    }

    public float getMoneyAmount() {
        return money.getAmount();
    }

    /**
     * removeMoney - iima i aparato pinigus
     */
    public void removeMoney()
    {
        this.money.setAmount( 0 );
        this.say("Aparatas tuias. Pinigai iimti");
    }

    public void showDrinks()
    {
        Iterator drinksIterator = this.drinks.iterator();
        System.out.println("Aparate dar yra:");
        int i = 0;
        while ( drinksIterator.hasNext() )
        {
            Drink oneDrink = (Drink) drinksIterator.next();
            System.out.println( i++ + ". Grimas:" + oneDrink.getDescription() + "   Kaina:" + oneDrink.getPrice() );

        }
    }

    /**
     * insertDrink - prideda  aparat nauj grim
     * @param insertableDrink - naujo grimo objektas
     */
    public void insertDrink( Object insertableDrink )
    {
        this.drinks.add( insertableDrink );
        Drink insertedDrink = (Drink) insertableDrink;
        this.say("Grimas "+insertedDrink.getDescription()+" pridtas" );
    }

    /**
     * removeDrink - panaikina grim i aparato
     * @param indexOfDrink - grimo indeksas
     */

    public void removeDrink( int indexOfDrink )
    {
        Drink removeableDrink = (Drink) this.drinks.get( indexOfDrink );
        this.drinks.remove( indexOfDrink );
        this.say( "Grimas "+ removeableDrink.getDescription() +" buvo paimtas" );
    }

    /**
     * getDrink - i aparato panaikin grim ir j returnina
     * @param indexOfDrink - grimo indeksas
     * @return Drink panaikintas grimas
     */

    public Drink getDrink( int indexOfDrink )
    {
        if (indexOfDrink < this.drinks.size())
            return (Drink) this.drinks.get( indexOfDrink );

        return null;

    }

    public void say( String text )
    {
        System.out.println( "Machine :" + text );
    }
}
