import javax.swing.*;
import java.util.*;
import java.awt.event.*;
import java.awt.*;

public class ZaidimoFrame2 extends JFrame implements MouseListener {

    private static final int DYDIS = 50;
    Lenta2 lenta2;
    Set<Set<Integer>> laimejimuAibe;
    private int ejimas;
    private boolean baigta;
    private JTextArea pranesimas;

    public ZaidimoFrame2() {
        super();
        lenta2 = new Lenta2(this, DYDIS);
        pranesimas = new JTextArea(2, 15);
        pranesimas.setEditable(false);
        pranesimas.setText("Kryziuku ejimas");
        ejimas = 0;
        baigta = false;

        laimejimuAibe = new HashSet<Set<Integer>>();
        for (int i = 0; i < 3; i++) {
            Set<Integer> horizontale = new HashSet<Integer>();
            Set<Integer> vertikale = new HashSet<Integer>();
            for (int j = 0; j < 3; j++) {
                horizontale.add(i * 3 + j);
                vertikale.add(j * 3 + i);
            }
            laimejimuAibe.add(horizontale);
            laimejimuAibe.add(vertikale);
        }
        Set<Integer> istrizaine1 = new HashSet<Integer>();
        Set<Integer> istrizaine2 = new HashSet<Integer>();
        for (int i = 0; i < 3; i++) {
            istrizaine1.add(i * 3 + i);
            istrizaine2.add(i * 3 + 2 - i);
        }
        laimejimuAibe.add(istrizaine1);
        laimejimuAibe.add(istrizaine2);

        this.setLayout(new BorderLayout());
        getContentPane().add(lenta2, BorderLayout.CENTER);
        getContentPane().add(pranesimas, BorderLayout.SOUTH);
        this.setSize(DYDIS * 3 + 50, DYDIS * 3 + 90);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == lenta2) {
            if (!baigta) {
                int xKoord = e.getX() / DYDIS;
                int yKoord = e.getY() / DYDIS;
                if ((xKoord > -1) && (xKoord < 3) && (yKoord > -1)
                        && (yKoord < 3)) {
                    int koord = xKoord * 3 + yKoord;
                    if (lenta2.gautiFigura(koord) == null) {
                        lenta2.nustatytiFigura(koord, ejimas);
                        if (patikrintiLaimejima()) {
                            pranesimas
                                    .setText(((ejimas == 0) ? "Kryziukai"
                                            : "Nuliukai")
                                            + " laimejo.\n Paspausk bet kur naujam zaidimui");
                            baigta = true;
                        } else if (patikrintiArPilnas()) {
                            pranesimas.setText("Lygiosios.\n Paspausk bet kur naujam zaidimui");
                            baigta = true;
                        } else {
                            ejimas = (ejimas + 1) % 2;
                            pranesimas.setText(((ejimas == 0) ? "Kryziuku"
                                    : "Nuliuku")
                                    + " ejimas");
                        }
                    }
                }
            } else {
                lenta2.istrintiReiksmes();
                baigta = false;
                pranesimas.setText("Kryziuku ejimas");
            }
        }
        this.repaint();
        this.validate();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private boolean patikrintiLaimejima() {
        Set<Integer> zaidejoLaukeliai = new HashSet<Integer>();
        for (int i = 0; i < 9; i++) {
            if ((lenta2.gautiFigura(i) != null)
                    && (lenta2.gautiFigura(i) == ejimas)) {
                zaidejoLaukeliai.add(i);
            }
        }

        boolean laimeta = true;
        for (Set<Integer> dabLaimejimuAibe : laimejimuAibe) {
            laimeta = true;
            for (int i : dabLaimejimuAibe)
                if (!zaidejoLaukeliai.contains(i))
                    laimeta = false;
            if (laimeta)
                break;
        }

        return laimeta;
    }

    private boolean patikrintiArPilnas() {
        boolean pilnas = true;
        for (int i = 0; i < 9; i++) {
            if (lenta2.gautiFigura(i) == null) {
                pilnas = false;
                break;
            }
        }
        return pilnas;
    }

    public static void main(String args[]) {
        ZaidimoFrame2 frame = new ZaidimoFrame2();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

}