package klientai;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;
import java.io.*;



public class Main {
    private static ArrayList sarasas = new ArrayList();


    /** Creates a new instance of Main */
    public Main() {
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        // TODO code application logic here
       javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                createAndShowGUI();
            }
        });
    }

    private static void createAndShowGUI() {
        final JFrame frame = new JFrame("Klientai");
        JPanel panel = new JPanel(new GridLayout(0,1));

        JButton batonas1 = new JButton("Ideti nauja klienta");
        batonas1.addActionListener(
                new ActionListener(){
                    public void actionPerformed(ActionEvent e)
		    {
                          newKlientas();
                    }
                }
                );
        panel.add(batonas1);

        JButton batonas2 = new JButton("Rodyk klientu sarasa");
        batonas2.addActionListener(
                new ActionListener(){
                    public void actionPerformed(ActionEvent e)
		    {
                          rodykSarasa();
                    }
                }
                );
        panel.add(batonas2);

        JButton save = new JButton("Isaugoti duomenis");
        save.addActionListener( new ActionListener(){
                    public void actionPerformed(ActionEvent e)
		    {
                        try
                        {
                          FileOutputStream out = new FileOutputStream("duomenys.dat");
                          ObjectOutputStream s = new ObjectOutputStream(out);
                          s.writeObject(sarasas);
                          s.flush();
                        }
                        catch (IOException exc)
                        {
                            JOptionPane.showMessageDialog(frame, exc, "Klaida!", JOptionPane.ERROR_MESSAGE);
                        }

                    }
        });
        panel.add(save);

        JButton load = new JButton("Pakrauti duomenis");
        load.addActionListener( new ActionListener(){
                    public void actionPerformed(ActionEvent e)
		    {
                        try
                        {
                            FileInputStream in = new FileInputStream("duomenys.dat");
                            ObjectInputStream s = new ObjectInputStream(in);
                            sarasas = (ArrayList)s.readObject();
                        }
                        catch (IOException exc)
                        {
                            JOptionPane.showMessageDialog(frame, exc, "Klaida!", JOptionPane.ERROR_MESSAGE);
                        }
                        catch (ClassNotFoundException exc)
                        {
                            JOptionPane.showMessageDialog(frame, exc, "Klaida!", JOptionPane.ERROR_MESSAGE);
                        }

                    }
        });
        panel.add(load);

        JButton batonas_exit = new JButton("Iseiti");
        batonas_exit.addActionListener( new ActionListener(){
                    public void actionPerformed(ActionEvent e)
		    {
                          System.exit(0);
                    }
        });
        panel.add(batonas_exit);

        frame.getContentPane().add(panel, BorderLayout.CENTER);
        frame.pack();
        frame.setVisible(true);
    }

    public static void addKlientas(Klientas k)
    {
        sarasas.add(k);
    }

    public static void newKlientas()
    {
        final JFrame frame = new JFrame("Naujo kliento tipo");
        JPanel panel = new JPanel(new GridLayout(1,0));

        JButton batonas1 = new JButton("Fizinis asmuo");
        batonas1.addActionListener(
                new ActionListener(){
                    public void actionPerformed(ActionEvent e)
		    {
                          addKlientas(new FizinisAsmuo());
                          frame.setVisible(false);
                    }
                }
                );
        panel.add(batonas1);

        JButton batonas2 = new JButton("Juridinis asmuo");
        batonas2.addActionListener(
                new ActionListener(){
                    public void actionPerformed(ActionEvent e)
		    {
                          addKlientas(new JuridinisAsmuo());
                          frame.setVisible(false);
                    }
                }
                );
        panel.add(batonas2);



        JButton batonas3 = new JButton("Atsaukti");
        batonas3.addActionListener(new ActionListener(){ public void actionPerformed(ActionEvent e)
		    {frame.setVisible(false);} });
        //panel.add(batonas3);

        frame.getContentPane().add(new JLabel("Isirinkite kliento tip:"), BorderLayout.NORTH);
        frame.getContentPane().add(panel, BorderLayout.CENTER);
        frame.getContentPane().add(batonas3, BorderLayout.SOUTH);
        frame.pack();
        frame.setVisible(true);
    }

    public static void rodykSarasa()
    {
        final JFrame frame = new JFrame("Klientu sarasas");
        //JPanel panel = new JPanel(new GridLayout(0,1));

        final JList list = new JList(sarasas.toArray());
        list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        list.setLayoutOrientation(JList.VERTICAL);
        JScrollPane listScroller = new JScrollPane(list);
        listScroller.setPreferredSize(new Dimension(120, 100));



        JPanel panel2 = new JPanel(new GridLayout(1,0));

        final JButton batonas2 = new JButton("Parodyk");
        batonas2.addActionListener(new ActionListener(){ public void actionPerformed(ActionEvent e)
		    {((Klientas)list.getSelectedValue()).rodykDuomenis();} });
        batonas2.setEnabled(false);
        panel2.add(batonas2);


        list.addListSelectionListener(new ListSelectionListener()
        {
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting() == false) {

                    if (list.getSelectedIndex() == -1) {
                    //No selection, disable fire button.
                        batonas2.setEnabled(false);

                    } else {
                    //Selection, enable the fire button.
                        batonas2.setEnabled(true);
                    }
                }
            }


        });

        JButton batonas1 = new JButton("Paslepk");
        batonas1.addActionListener(new ActionListener(){ public void actionPerformed(ActionEvent e)
		    {frame.setVisible(false);} });
        panel2.add(batonas1);



        frame.getContentPane().add(listScroller, BorderLayout.CENTER);
        frame.getContentPane().add(panel2, BorderLayout.SOUTH);
        frame.pack();
        frame.setVisible(true);
    }

    public static boolean trinkIsSaraso(Klientas k)
    {
        return sarasas.remove(k);
    }

}
