package TurboJava;
//    Java-
//  
// :  ..  2000.  maslov@kaluga.ru

import java.awt.*;
import java.awt.event.*;
import java.io.*;

public class Editor 
	extends Frame 
	implements WindowListener,ActionListener
	{
	public TextArea text; //  
	public String fileName="Unknown"; //   .
	String homeDir; //  
	String fileSeparator = System.getProperty("file.separator"); 
	FileDialog writeFile, readFile;
	Exec exec; Debug debug; //    
	public ConsoleWindow console; //     stdout

	//   .
	public void windowOpened(WindowEvent e) {}
	public void windowClosing(WindowEvent e){dispose();}
	public void windowClosed(WindowEvent e){}
	public void windowIconified(WindowEvent e){}
	public void windowDeiconified(WindowEvent e){}
	public void windowActivated(WindowEvent e){}
	public void windowDeactivated(WindowEvent e){}
	public Menu mWindow, mFile, mDebug, mProgram; // 

Editor (ConsoleWindow console, Point location)
	{ this.console = console;
	Init();
	setLocation(location.x+20, location.y+20);
	}

Editor()
	{
	Init();
	console=new ConsoleWindow("Java console");
	Dimension size = getSize();
	Point p = getLocation();
	console.setSize(size.width,200);
	console.setLocation(p.x, p.y+size.height);
	println(" Java IDE by Maslov V.V. V 2.0 Kaluga 2000");
	text.requestFocus();
	}

private void Init() //    
	{
	setTitle(fileName);
	text = new TextArea();
	addWindowListener(this);
	setSize(600,200);
//		getContentPane().add(text);
	add(text);
	homeDir = System.getProperty("user.dir");
//System.out.println("HomeDir="+homeDir);
	readFile = new FileDialog(this,"SelectFile",FileDialog.LOAD);
	readFile.setDirectory(homeDir);
	writeFile = new FileDialog(this,"SelectFile",FileDialog.SAVE);
	writeFile.setDirectory(homeDir);
	CreateMenu();		
	show();
	}

private void CreateMenu() //   
	{
	MenuItem i;
	mWindow = new Menu("Window");
	mWindow.addActionListener(this);

	mWindow.add(new MenuItem("New"));

	mWindow.add(new MenuItem("Clear"));

	i=new MenuItem("Test",new MenuShortcut(KeyEvent.VK_T)); i.setActionCommand(i.getLabel()); mWindow.add(i);
//	mWindow.add(new MenuItem("Test",new MenuShortcut(KeyEvent.VK_T)));

	MenuItem miCompileProgram,miRun, miRunApplet, miStop;

	mProgram = new Menu("Program");
	mProgram.addActionListener(this);

	miCompileProgram=new MenuItem("Compile",new MenuShortcut(KeyEvent.VK_K));
	miCompileProgram.setActionCommand(miCompileProgram.getLabel());
	mProgram.add(miCompileProgram);

	miRun = new MenuItem("Run",new MenuShortcut(KeyEvent.VK_R));
	miRun.setActionCommand(miRun.getLabel());
	mProgram.add(miRun);

	miRunApplet = new MenuItem("Run Applet",new MenuShortcut(KeyEvent.VK_A));
	miRunApplet.setActionCommand(miRunApplet.getLabel());
	mProgram.add(miRunApplet);

	mProgram.addSeparator();

	miStop = new MenuItem("Stop");
	mProgram.add(miStop);

	MenuItem miCompileDebug, miDebug, miNext, miInTo, miOut, miContinue, miSetBreakpoint, miStopDebug,
	miWatch;

	mDebug = new Menu("Debug");
	mDebug.addActionListener(this);

	miCompileDebug = new MenuItem("Compile");  miCompileDebug.setActionCommand("DCompile");mDebug.add( miCompileDebug);
	 miDebug = new MenuItem("Debug");  miDebug.setActionCommand("DRun");mDebug.add( miDebug);
	 miNext = new MenuItem("Next",new MenuShortcut(KeyEvent.VK_N));  miNext.setActionCommand("DNext");mDebug.add( miNext);
	miInTo = new MenuItem("InTo",new MenuShortcut(KeyEvent.VK_I));  miInTo.setActionCommand("DStep");mDebug.add( miInTo);
	miOut = new MenuItem("Out",new MenuShortcut(KeyEvent.VK_U));  miOut.setActionCommand("DOut");mDebug.add( miOut);
	miContinue = new MenuItem("Continue"); miContinue.setActionCommand("DContinue");mDebug.add(miContinue);
	miSetBreakpoint = new MenuItem("SetBreakpoint"); miSetBreakpoint.setActionCommand("SetBreakpoint");mDebug.add(miSetBreakpoint);
	miWatch = new MenuItem("Watch"); miWatch.setActionCommand("DWatch");mDebug.add(miWatch);
	mDebug.addSeparator();
	miStopDebug = new MenuItem("Stop Debug"); miStopDebug.setActionCommand("DStop");mDebug.add(miStopDebug);

	mFile = new Menu("File");
	mFile.addActionListener(this);
//	mFile.add(new MenuItem("SetHome"));

	i=new MenuItem("Open",new MenuShortcut(KeyEvent.VK_O)); i.setActionCommand(i.getLabel()); mFile.add(i);

//	mFile.add(new MenuItem("Save",new MenuShortcut(KeyEvent.VK_S)));
	i=new MenuItem("Save",new MenuShortcut(KeyEvent.VK_S)); i.setActionCommand(i.getLabel()); mFile.add(i);

	mFile.add(new MenuItem("SaveAs"));
	mFile.add(new MenuItem("SaveListing"));
	mFile.addSeparator();

	i = new MenuItem("SaveBlock"); mFile.add(i);

	i = new MenuItem("ReadBlock"); mFile.add(i);

	mFile.addSeparator();

	mFile.add(new MenuItem("New File"));
	mFile.addSeparator();

//	mFile.add(new MenuItem("Exit",new MenuShortcut(KeyEvent.VK_E)));
	i=new MenuItem("Exit",new MenuShortcut(KeyEvent.VK_E)); i.setActionCommand(i.getLabel()); mFile.add(i);

	MenuBar mBar = new MenuBar();
	mBar.add(mFile);
	mBar.add(mProgram);
	mBar.add(mDebug);
	mBar.add(mWindow);
	setMenuBar(mBar);
	}		



	public void actionPerformed(ActionEvent e) //   
		{ 
//System.out.println("Menu event: "+e);
String cmd = e.getActionCommand(); 
		if (cmd.equals("Exit")) 
			{ console.dispose(); 
			System.exit(0);
			}
		else if (cmd.equals("Open")) {OpenFile();}
		else if (cmd.equals("Save")) {SaveFile();}
		else if (cmd.equals("SaveAs")) {SaveAsFile();}
		else if (cmd.equals("SaveListing")) {SaveListing();}
		else if (cmd.equals("New"))  {Editor ed = new Editor(console, getLocation());}
		else if (cmd.equals("Clear")) {text.setText("");}
		else if (cmd.equals("Test")) {System.out.println(getPackageName());}
		else if (cmd.equals("New File")) {text.setText(""); fileName="Unknown";}
		else if (cmd.equals("DNext")) 
			{
			debug.out.println("next");
			debug.out.flush();
			}
		else if (cmd.equals("DContinue")) 
			{
			debug.out.println("cont");
			debug.out.flush();
			}
		else if (cmd.equals("DStep")) 
			{
			debug.out.println("step");
			debug.out.flush();
			}
		else if (cmd.equals("DOut")) 
			{
			debug.out.println("step up");
			debug.out.flush();
			}
		else if (cmd.equals("DWatch")) 
			{ String command ="print "+text.getSelectedText().trim(); 
			println(command);
			debug.out.println(command);
			debug.out.flush();
			}
		else if (cmd.equals("SetBreakpoint")) 
			{
//			debug.out.println("stop at "+editor.getRunName()+":2");
			debug.out.flush();
			}
		else if (cmd.equals("Run"))
			{ exec = new Exec("java -cp "+homeDir+" "+getPackageName()+getRunName(),console); exec.start();
			}
		else if (cmd.equals("Run Applet"))
			{ // exec = new Exec("appletviewer  "+getRunName()+".html",console); exec.start();
exec = new Exec("appletviewer file:"+homeDir+getRunName()+".html",console); exec.start();
			}
		else if (cmd.equals("DRun"))
			{ 
			debug = new Debug("jdb -classpath "+homeDir+" "+getPackageName()+getRunName(),this); debug.start();
			}
		else if (cmd.equals("Compile")) 
			{
			  exec = new Exec("javac -d "+homeDir + " -classpath "+homeDir+" "+fileName,console); exec.start();
			}
		else if (cmd.equals("DCompile")) 
			{  exec = new Exec("javac -g -d "+homeDir + " -classpath "+homeDir+" "+fileName,console); exec.start();}

//		else if (cmd.equals("SetHome")) {SetHome();}
		else if (cmd.equals("Stop")) 
			{ 
			if (exec != null) exec.p.destroy();
			}
		else if (cmd.equals("DStop")) 
			{ 
			debug.out.println("exit");
			debug.out.flush();
			}
		else if (cmd.equals("SaveBlock")){SaveBlock();}
		else if (cmd.equals("ReadBlock")){ReadBlock();}
		}

	public void OpenFile() //   
		{ 
		readFile.setModal(true); readFile.show();
		String name = readFile.getFile();
//System.out.println(fileName);
		if (name != null)
			{ String s;
			fileName = readFile.getDirectory()+ name;
			try {
			char buf[] = new char[1024];
			int r;
			Reader in = new FileReader(fileName);
			text.setText(null);
			while((r=in.read(buf,0,1024)) > -1) text.append(new String(buf,0,r));
			in.close();
			setTitle(fileName); SetHome();
			text.setCaretPosition(0);
			} catch(IOException e) {};
			}
		}

	public void SaveAsFile() //    
		{
		writeFile.setModal(true); writeFile.show();
		String name = writeFile.getFile();
//System.out.println(fileName);
		if (name != null)
			{ String s;
			fileName = writeFile.getDirectory()+ name;
			try {
			Writer out = new FileWriter(fileName);
			out.write(text.getText().toCharArray());
			out.close();
			setTitle(fileName);
			} catch(IOException e) {};
			}
		}

	public void SaveFile() //    
		{
		if (fileName != null)
			{ String s;
			try {
			Writer out = new FileWriter(fileName);
			out.write(text.getText().toCharArray());
			out.close();
			} catch(IOException e) {};
			}
		}

	public void SaveListing() //   .txt   
		{
		if (fileName != null)
			{ String s;
			try {
			PrintWriter out = new PrintWriter(new FileWriter(fileName+".txt"));
//			PrintWriter out = new PrintWriter(System.out);
			s = text.getText();
			int i1=0, i2=0, last = s.length(), n=0; 
			while((i2 = s.indexOf('\n',i1))> -1)
				{ ++n;
				if (i2>i1) out.println(n+"\t"+s.substring(i1,i2));
				else out.println(""+n);
				i1=i2+1;
				if (i1>last) break;
				}
			++n;
			if (i1<=last) out.print(n+"\t"+s.substring(i1));
			else out.print(n+"\t"+s);
			out.close();
			} catch(IOException e) {};
			}
		}

	public void print(String s) //   
		{ 
		console.print(s);
		}

	public void println(String s)
		{ 
		console.println(s);
		}

	public String getRunName() // convert filename to package.name
		{
		if (fileName.startsWith(homeDir))
			{ String s = fileName.substring(homeDir.length(),fileName.lastIndexOf('.'));
			String name = s.replace(fileSeparator.charAt(0),'.');
			if (name.charAt(0) == '.') name = name.substring(1);
			return name;
			}
		else
			{ println("*** Error home directory location ***");
			return null;
			}
		}

	public void SetHome() //   
		{
//		readFile.show();
		if(readFile.getDirectory()!=null)
			{homeDir = readFile.getDirectory();
			System.setProperty("user.dir",homeDir);
			writeFile.setDirectory(homeDir);
			println("Homedir="+homeDir);
			}
		}

	public void SelectLine(int line) // Bold line in source
		{ int start=0,end=0;
		String src = text.getText();
		if (line <=1) 
			{start = 0;
			}
		else
			{ end = src.length()-1;
for (int i=1; (i< line)&&(start<end)&&(start>-1); ++i) start = src.indexOf('\n',start+1);
			if (start==-1) return;
			}
		end = src.indexOf('\n',start+1);
		if (end==-1) end = src.length();
//println("line="+line+"start="+start+" end="+end);
		text.setSelectionStart(start);
		text.setSelectionEnd(end);
//		text.setCaretPosition(start);
		}

	public void SaveBlock()  //    
		{ String fileName; 
		writeFile = new FileDialog(this,"SelectFile",FileDialog.SAVE);
		writeFile.setDirectory(homeDir);
		writeFile.setModal(true); writeFile.show();
		String name = writeFile.getFile();
//System.out.println(fileName);
		if (name != null)
			{ String s;
			fileName = writeFile.getDirectory()+ name;
			try {
			Writer out = new FileWriter(fileName);
			out.write(text.getText().toCharArray());
			out.close();
			} catch(IOException e) {};
			}
		}

	public void ReadBlock() //    
		{ String fileName;
		readFile = new FileDialog(this,"SelectFile",FileDialog.LOAD);
		readFile.setDirectory(homeDir);
		readFile.setModal(true); readFile.show();
		String name = readFile.getFile();
//System.out.println(fileName);
		if (name != null)
			{
			fileName = readFile.getDirectory()+ name;
			try {
			char buf[] = new char[1024];
			int r;
			Reader in = new FileReader(fileName);
			while((r=in.read(buf,0,1024)) > -1) text.insert(new String(buf,0,r), text.getCaretPosition());
			in.close();
			} catch(IOException e) {};
			}
		}

	public String getPackageName() //   package
		{ String buf = text.getText();
		String name;
		int i = buf.indexOf("package");
		if (i > -1)
			{ int i2 = buf.indexOf(";",i);
			if (i2 > i)
				{ name = buf.substring(i+8, i2);
				return name.trim()+".";
				}
			else return "";
			}
		return "";
		}

	public static void main(String arg[]) //  
		{
		System.out.println("TurboJava IDE by Maslov V.V. V 2.0 Kaluga 2000");
//System.getProperties().list(System.out);
//String homeDir = System. user.dir
		Editor window = new Editor();
		}
	}

