CREATE TABLE ROTA5605.NUOMOS_PUNKTAS(
 REGISTRACIJOSNR INTEGER NOT NULL CHECK (REGISTRACIJOSNR > 100),
 PAVADINIMAS VARCHAR(32),
 MIESTAS VARCHAR(32) NOT NULL,
PRIMARY KEY (REGISTRACIJOSNR));

CREATE TABLE ROTA5605.AUTOMOBILIS(
 ID INTEGER PRIMARY KEY GENERATED ALWAYS AS IDENTITY (START WITH 1, 
INCREMENT BY 1),
 MODELIS VARCHAR (30) NOT NULL,
 NUOMOS_KAINA DECIMAL(12,2) NOT NULL CHECK (NUOMOS_KAINA > 0),
 NUOMOJA INTEGER NOT NULL CHECK (NUOMOJA > 100),
FOREIGN KEY IMONEI (NUOMOJA) REFERENCES ROTA5605.NUOMOS_PUNKTAS ON 
DELETE CASCADE ON UPDATE RESTRICT);

CREATE TABLE ROTA5605.ASMUO(
 ASMENSKODAS DECIMAL (11,0) NOT NULL CHECK (ASMENSKODAS >30000000000 AND 
ASMENSKODAS < 50000000000),
 VARDAS VARCHAR (20) NOT NULL,
 PAVARDE VARCHAR (40) NOT NULL,
 MIESTAS VARCHAR (20) NOT NULL,
 GATVE VARCHAR (30),
 TELEFONAS VARCHAR (11),
 EPASTAS VARCHAR(100),
PRIMARY KEY (ASMENSKODAS));

CREATE TABLE ROTA5605.NUOMA(
 ID INTEGER NOT NULL PRIMARY KEY GENERATED ALWAYS AS IDENTITY (START 
WITH 1, INCREMENT BY 1),
 UZSAKOVAS DECIMAL (11,0) NOT NULL CHECK ( UZSAKOVAS > 30000000000 AND UZSAKOVAS 
< 50000000000),
 AUTOMOBILIS INTEGER NOT NULL,
 DATA DATE,
 REGISTRAVO VARCHAR (50),
FOREIGN KEY UZSAKOVUI (UZSAKOVAS) REFERENCES ROTA5605.ASMUO ON DELETE 
CASCADE ON UPDATE RESTRICT);
