--####################################

CREATE TABLE ARKA4473.IMONE (
    REGISTRACIJOSNR INTEGER      NOT NULL CHECK (REGISTRACIJOSNR > 100000000),
    PAVADINIMAS     VARCHAR (32) NOT NULL,
    IKURIMODATA     DATE,
    MIESTAS         VARCHAR (32) NOT NULL,
    DARBUOTOJUSK    INTEGER      NOT NULL CHECK (DARBUOTOJUSK > 0),
    PRIMARY KEY (REGISTRACIJOSNR)
);

--####################################

CREATE TABLE ARKA4473.BALDAS ( 
    ID          INTEGER        PRIMARY KEY GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    PAVADINIMAS VARCHAR (32)   NOT NULL, 
    KAINA       DECIMAL (12,2) NOT NULL CHECK (KAINA > 0), 
    GAMINTOJAS  INTEGER        NOT NULL CHECK (GAMINTOJAS > 100000000), 
    FOREIGN KEY IMONEI (GAMINTOJAS) REFERENCES ARKA4473.IMONE ON DELETE CASCADE ON UPDATE RESTRICT
);

--####################################

CREATE TABLE ARKA4473.ASMUO (
    ASMENSKODAS   DECIMAL (11,0)      NOT NULL CHECK (ASMENSKODAS > 30000000000 AND ASMENSKODAS < 50000000000),
    VARDAS        VARCHAR (20)        NOT NULL,
    PAVARDE       VARCHAR (40)        NOT NULL,
    MIESTAS       VARCHAR (30)        NOT NULL,
    GATVE         VARCHAR (30),
    TELEFONAS     VARCHAR (11)        NOT NULL,
    PASTOINDEKSAS VARCHAR (5)         NOT NULL,
    EPASTAS       VARCHAR (100),
    PRIMARY KEY (ASMENSKODAS)
);

--####################################

CREATE TABLE ARKA4473.PARDAVEJAS (
    ASMUO         DECIMAL (11,0) NOT NULL CHECK (ASMUO > 30000000000 AND ASMUO < 50000000000),
    ISSILAVINIMAS VARCHAR (20)            CHECK (ISSILAVINIMAS IN ('Pagrindinis','Vidurinis','Aukstasis')) DEFAULT 'Vidurinis',
    SPECIALYBE    VARCHAR (30)   NOT NULL,
    DIRBANUO      DATE,
    ATLYGINIMAS   DECIMAL (12,2) NOT NULL CHECK (ATLYGINIMAS > 0),
    PRIMARY KEY (ASMUO),
    FOREIGN KEY ASMENIUI (ASMUO) REFERENCES ARKA4473.ASMUO ON DELETE CASCADE ON UPDATE RESTRICT
);

--####################################

CREATE TABLE ARKA4473.PARDAVIMAS (
    ID         INTEGER          NOT NULL PRIMARY KEY GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    UZSAKOVAS  DECIMAL (11,0)   NOT NULL CHECK (UZSAKOVAS > 30000000000 AND UZSAKOVAS < 50000000000),
    BALDAS     INTEGER          NOT NULL,
    KIEKIS     SMALLINT         NOT NULL CHECK (KIEKIS > 0),
    DATA       DATE,
    REGISTRAVO DECIMAL (11,0)   NOT NULL CHECK (REGISTRAVO > 30000000000 AND REGISTRAVO < 50000000000),
    FOREIGN KEY UZSAKOVUI (UZSAKOVAS) REFERENCES ARKA4473.ASMUO ON DELETE CASCADE ON UPDATE RESTRICT, 
    FOREIGN KEY REGISTRUOTOJUI (REGISTRAVO) REFERENCES ARKA4473.PARDAVEJAS ON DELETE CASCADE ON UPDATE RESTRICT
);

--####################################