-------------------------------------------------------------------
CREATE TABLE Anoulee.Darbuotojai (
  Nr_D               INTEGER       NOT NULL   CHECK (Nr_D > 0),
  Vardas             CHAR (10)     NOT NULL,
  Pavarde            CHAR (20)     NOT NULL,
  Telefonas          CHAR (15),
  E_mail             CHAR (32)     DEFAULT   'supirkimas@gyvuliu.com',
  Gimimo_data        DATE          NOT NULL,
  PRIMARY KEY (Nr_D));
-----------------------------------------------------------------
CREATE TABLE Anoulee.Gyvuliai (
  Nr_G               INTEGER       NOT NULL  PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1),
  Rusis              CHAR (25)     NOT NULL,
  Svoris             INTEGER       NOT NULL,
  Gimimas            DATE          NOT NULL);
  ---------------------------------------------------------------
CREATE TABLE Anoulee.Klientai (
  Nr_K               INTEGER       NOT NULL CHECK (Nr_K > 0),
  Nr_D               INTEGER       NOT NULL CHECK (Nr_D > 0),
  Vardas             CHAR (10)     NOT NULL,
  Pavarde            CHAR (20)     NOT NULL,
  Asmens_kodas       CHAR (12)     NOT NULL,  
  Adresas            VARCHAR (250) NOT NULL,
  PRIMARY KEY (Nr_K),
----
  FOREIGN KEY Darbuotojo_Nr(Nr_D)
  REFERENCES Anoulee.Darbuotojai
    ON DELETE CASCADE    
    ON UPDATE RESTRICT ); 

---------------------------------------------------------------------
 CREATE TABLE Anoulee.Pardavimas (
  Nr_K                   INTEGER       NOT NULL CHECK (Nr_K > 0),
  Nr_G                   INTEGER       NOT NULL CHECK (Nr_G > 0),
  Pardavimo_data         DATE          NOT NULL,
  Kaina                  INTEGER       NOT NULL,
  Pinigu_ismokejimo_data DATE,  
 
  ----
  FOREIGN KEY Knt_Nr(Nr_K)
  REFERENCES Anoulee.Klientai
   ON DELETE CASCADE
   ON UPDATE RESTRICT ,
  FOREIGN KEY Gyvulio_Nr(Nr_G)
  REFERENCES Anoulee.Gyvuliai
    ON DELETE CASCADE
    ON UPDATE RESTRICT );
 


