#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlenv.h>
#include "ivedimas.h"

EXEC SQL INCLUDE SQLCA;

EXEC SQL BEGIN DECLARE SECTION;
short ndarbuotojoNr_D;
short ngyvulioNr_G;
short nklientoNr_K;
char  nvardas                [16]   = {'\0'};
char  npavarde               [26]   = {'\0'};
char  ntelefonas             [20]   = {'\0'};
char  ne_mail                [35]   = {'\0'};
char  ngimimo_data           [20];
char  nrusis                 [26];
char  nsvoris                [26]   = {'\0'};
char  ngimimas               [25];
char  nasmens_kodas          [];
char  nadresas               [20];
char  npardavimo_data        [20];
short nkaina;
char  npinigu_ismokejimo_data[20];
char  new_SQLMessage            [512] = {'\0'};
EXEC SQL END DECLARE SECTION;


short getInsertedGyvulioNr_G()
{
        EXEC SQL WHENEVER SQLERROR  GOTO error;
	EXEC SQL WHENEVER NOT FOUND GOTO end;
	
	EXEC SQL DECLARE curGyvulis CURSOR FOR SELECT MAX(Nr_G) FROM Anoulee.Gyvuliai;
	EXEC SQL OPEN  curGyvulis;
	EXEC SQL FETCH curGyvulis INTO :ngyvulioNr_G;
	
	
error:
	if ((SQLCODE != 0) && (SQLCODE != 100)) 
	{
		printf("\nSQL KLAIDA.\n");
		sqlaintp(new_SQLMessage, 512, 70, &sqlca);
		printf("SQL PRANESIMAS: %s\n",new_SQLMessage);
		return 0;
	}
	
end:
	EXEC SQL WHENEVER SQLERROR CONTINUE;
	EXEC SQL WHENEVER NOT FOUND CONTINUE;
	EXEC SQL CLOSE curGyvulis;
	return ngyvulioNr_g;
	}
	
short getInsertedKlientoNr_K()
{
	EXEC SQL WHENEVER SQLERROR  GOTO  error;
	EXEC SQL WHENEVER NOT FOUND GOTO  end;

	EXEC SQL DECLARE curKlientas CURSOR FOR SELECT MAX(Nr_K) FROM Anoulee.Klientai;
	EXEC SQL OPEN  curKlientas;
	EXEC SQL FETCH curKlientas INTO :nklientoNr_K;

error:
	if ((SQLCODE != 0) && (SQLCODE != 100)) 
	{
		printf("\nSQL KLAIDA.\n");
		sqlaintp(new_SQLMessage, 512, 70, &sqlca);
		printf("SQL PRANESIMAS: %s\n",new_SQLMessage);
		return 0;
	}
	
end:
	EXEC SQL WHENEVER SQLERROR  CONTINUE;
	EXEC SQL WHENEVER NOT FOUND CONTINUE;
	EXEC SQL CLOSE curKlientas;
	return nklientoNr_K;
}

//============================== KLIENTAS ======================================
void newKlientas()
{
	int  gyvulis = 0;
        char str[256];

	printf("naujas klientas:\n");
	printf("------------------------------\n");
	printf("Vardas: ");
	fgets(nvardas, sizeof(nvardas),stdin);
	rmvNewLine(nvardas);

	printf("Pavarde: ");
	fgets(npavarde, sizeof(npavarde),stdin);
	rmvNewLine(npavarde);
	
	printf("Asmens kodas: ");
	fgets(nasmens_kodas, sizeof(nasmens_kodas),stdin);
	rmvNewLine(nasmens_kodas);
	
	printf("Adresas: ");
	fgets(nadresas, sizeof(nadresas), stdin);
	rmvNewLine(nadresas);
	
	EXEC SQL WHENEVER SQLERROR  GOTO error;
	EXEC SQL WHENEVER NOT FOUND GOTO insertGyvuliai;
	EXEC SQL INSERT   INTO Anoulee.Klientai VALUES(0,:nvardas,:npavarde,:nasmens_kodas,:nadresas);
	
insertGyvuliai:
	EXEC SQL WHENEVER NOT FOUND GOTO end;
	nklientoNr_K = getInsertedKlientoNr_K();
	
	while(1)
	{
		printf("Gyvuliai -------------\n");
		showGyvuliai();
	        printf("Gyvulio Nr_G: ");
		fgets(str,sizeof(str),stdin);
		
		short Nr_G = nklientoNr_K;
		sscanf(str,"%d",&ngyvulioNr_G);// probably sscanf is making error? 
		
		if(nGyvulioNr_G == 0)
			break;
		printf("Kiekis: ");
		fgets(str,sizeof(str),stdin);
		sscanf(str,"%d",&nkiekis);		
		
		npirkejoNr = id;
		printf("Pirkejas (%d) nusipirko (%d) disku - ID (%d) \n\n",npirkejoNr,nkiekis,ndiskoID); // npirkejoNr wrong
		EXEC SQL INSERT INTO mima4630.Prekyba (Pirkejo_Nr,Disko_ID,Kiekis) VALUES(:npirkejoNr,:ndiskoID,:nkiekis);
		diskas = 1;
	}
	
error:
	if (((SQLCODE != 0) && (SQLCODE != 100)) || diskas == 0) 
	{
		printf("\nSQL klaida.\n");
		sqlaintp(new_SQLMessage, 512, 70, &sqlca);
		printf("SQL Pranesimas: %s\n",new_SQLMessage);
		printf("Duomenys nurodyti nekorektiskai\n");
		EXEC SQL ROLLBACK;
	}
end:
	EXEC SQL WHENEVER SQLERROR CONTINUE;
	EXEC SQL WHENEVER NOT FOUND CONTINUE;	
	if(diskas == 1)
	{
		printf("Duomenys sekmingai ikelti\n");
		EXEC SQL COMMIT;
	}
	else
	{
		printf("Duomenys neikelti\n");
		EXEC SQL ROLLBACK;
	}	

}

//=========================== ATLIKEJAS ========================================
void newAtlikejas()
{
	char str[256];

	printf("NAUJAS ATLIKEJAS\n");
	printf("------------------------------\n");
	printf("Vardas: ");
	fgets(nvardas,sizeof(nvardas),stdin);
	rmvNewLine(nvardas);

	printf("Pavarde: ");
	fgets(npavarde,sizeof(npavarde),stdin);
	rmvNewLine(npavarde);
	
	printf("Profesija [smuikininkas,gitaristas,pianistas,bosistas]: ");
	fgets(nprofesija,sizeof(nprofesija),stdin);
	rmvNewLine(nprofesija);

	printf("Debiutas (mm/dd/yyyy): ");
	fgets(ndebiutas,sizeof(ndebiutas),stdin);
	rmvNewLine(ndebiutas);
	
	printf("Weburl: ");
	fgets(nweburl,sizeof(nweburl),stdin);
	rmvNewLine(nweburl);
		
	EXEC SQL WHENEVER SQLERROR GOTO error;
	EXEC SQL WHENEVER NOT FOUND GOTO end;


	EXEC SQL INSERT INTO mima4630.Atlikejai VALUES(0,:nvardas,:npavarde,:nprofesija,:nweburl,:ndebiutas);
	showAtlikejai();

error:
	if ((SQLCODE != 0) && (SQLCODE != 100)) 
	{
		printf("\nSQL klaida.\n");
		sqlaintp(new_SQLMessage, 512, 70, &sqlca);
		printf("Duomenys nurodyti nekorektiskai\n");
	}
end:
	EXEC SQL WHENEVER SQLERROR CONTINUE;
	EXEC SQL WHENEVER NOT FOUND CONTINUE;
	EXEC SQL COMMIT;
	if(SQLCODE == 0)
	printf("Duomenys sekmingai ikelti\n");
}

//=========================== DISKAS ===========================================
void newDiskas()
{
	int atlikejas = 0;
	char str[256];

	printf("NAUJAS DISKAS:\n");
	printf("------------------------------\n");
	printf("Pavadinimas: ");
	fflush(stdin);
	fgets(npavadinimas,sizeof(npavadinimas),stdin);
	rmvNewLine(npavadinimas);

	printf("Kaina: ");
	fgets(str,sizeof(str),stdin);
	sscanf(str,"%d",&nkaina);
	
	printf("Tirazas: ");
	fgets(str,sizeof(str),stdin);
	sscanf(str,"%d",&ntirazas);
	
	printf("Leidimo Metai: ");
	fgets(str,sizeof(str),stdin);
	sscanf(str,"%d",&nleidimoMetai);
	
	printf("Zanras [dziazas,klasika,rokas]: ");
	fflush(stdin);
	fgets(nzanras,sizeof(nzanras),stdin);
	rmvNewLine(nzanras);
		
	EXEC SQL WHENEVER SQLERROR GOTO error;
	EXEC SQL WHENEVER NOT FOUND GOTO insertAtlikejas;
	EXEC SQL INSERT INTO mima4630.Diskai VALUES(0,:npavadinimas,:nkaina,:ntirazas,:nleidimoMetai,:nzanras);
	
insertAtlikejas:
	EXEC SQL WHENEVER NOT FOUND GOTO end;
	ndiskoID = getInsertedDiskoID();
	while(1)
	{
		printf("\nAtlikejai -------------\n");
		showAtlikejai();
	    printf("Atlikejo Nr: ");
		fgets(str,sizeof(str),stdin);
		short id = ndiskoID;
		
		sscanf(str,"%d",&natlikejoNr);
		ndiskoID = id;
		
		if(natlikejoNr == 0)break;
		printf("Disko ID %d, atlikejas nr. %d\n\n",ndiskoID,natlikejoNr);
		EXEC SQL INSERT INTO mima4630.Atlikimas VALUES(:natlikejoNr,:ndiskoID);
		atlikejas = 1;
		
	}
	
error:
	if (((SQLCODE != 0) && (SQLCODE != 100)) || atlikejas == 0) 
	{
		printf("\nSQL klaida.\n");
		sqlaintp(new_SQLMessage, 512, 70, &sqlca);
		printf("SQL Pranesimas: %s\n",new_SQLMessage);
		printf("Duomenys nurodyti nekorektiskai\n");
		EXEC SQL ROLLBACK;
	}
end:
	EXEC SQL WHENEVER SQLERROR CONTINUE;
	EXEC SQL WHENEVER NOT FOUND CONTINUE;	
	if(atlikejas == 1)
	{
		printf("Duomenys sekmingai ikelti\n");
		EXEC SQL COMMIT;
	}
	else
	{
		printf("Duomenys neikelti\n");
		EXEC SQL ROLLBACK;
	}
}

