CREATE TABLE irdo4538.Projektuotojas 
(
   Vardas    CHAR(12)   NOT NULL,
   Pavarde   CHAR(20)   NOT NULL,
   ID        SMALLINT   NOT NULL,

  PRIMARY KEY (ID)
);

CREATE TABLE irdo4538.Modeliai 
(
   Modelis           CHAR(20)      NOT NULL,
   Ilgis             DECIMAL(5,2)  CHECK(Ilgis > 0 AND Ilgis < 1000),
   Plotis            DECIMAL(5,2)  CHECK(Plotis > 0 AND Plotis < 1000),
   Grimzle           DECIMAL(5,2)  CHECK(Grimzle > 0 AND Grimzle < 1000),
   Galia             DECIMAL(5,2)  CHECK(Galia > 0 AND Galia < 1000),

  PRIMARY KEY (Modelis)
);

CREATE TABLE irdo4538.Uzsakovas
(
   Vardas    CHAR(12)   NOT NULL,
   Pavarde   CHAR(20)   NOT NULL,
   AK        CHAR(11)   NOT NULL,
   Tel_Nr    CHAR(9)    NOT NULL,

  PRIMARY KEY (AK)
);

CREATE TABLE irdo4538.Laivas 
(
   Vardas            VARCHAR(25)   NOT NULL,
   Metai             SMALLINT      NOT NULL,
   Modelis           CHAR(20)      NOT NULL,
   Registracijos_Nr  CHAR(6)       NOT NULL,
   Greitis           SMALLINT      NOT NULL,
   Kaina             DECIMAL(9,2)  CHECK(Kaina > 0.00 AND Kaina < 10000000.00),
   Savininkas        CHAR(11)      NOT NULL,

  PRIMARY KEY (Registracijos_Nr),

  FOREIGN KEY modeliui (Modelis)     REFERENCES irdo4538.Modeliai ON DELETE CASCADE ON UPDATE RESTRICT,  
  FOREIGN KEY uzsakovui (Savininkas) REFERENCES irdo4538.Uzsakovas ON DELETE CASCADE ON UPDATE RESTRICT
);

CREATE TABLE irdo4538.Priklauso 
(
   Projektuotojo_ID  SMALLINT      NOT NULL,
   Modelis           CHAR(20)      NOT NULL,

  PRIMARY KEY (Projektuotojo_ID, Modelis),

  FOREIGN KEY projektuotojui (Projektuotojo_ID) REFERENCES irdo4538.Projektuotojas ON DELETE CASCADE ON UPDATE RESTRICT,
  FOREIGN KEY modeliui (Modelis)                REFERENCES irdo4538.Modeliai ON DELETE RESTRICT ON UPDATE RESTRICT
);
