//////////////////////////////////////////////////////////////////////////////////////
// Projektas		:	Matematine viktorina.										//
// Projekto tikslas	:	Matematines viktorinos serverio ir kliento realizacija.		//
//----------------------------------------------------------------------------------//
// Failas			:	"math_common.h"												//
// Failo tikslas	:	Realizuoti daugiakliencio matematines viktorinos serverio	//
//						bei kliento bedrasias funkcijas.							//
// Failo autorius	:	Aidas Semezys.												//
//						Copyright (C), 2003											//
//////////////////////////////////////////////////////////////////////////////////////


//------------------------------------------------------------------------------------
//							HEADER'IU ITRAUKIMAS
//------------------------------------------------------------------------------------
#include	"math_common.h"


//------------------------------------------------------------------------------------
//							FUNKCIJU REALIZACIJA
//------------------------------------------------------------------------------------

//-------------------------------------------
// Funkciju, skirtu siunciamu duomenu paketu
// sudejimui ir isskaidymui, reaizacija.

// Paketo supakavimas
void MarshalPacket (char *Packet, int DataSize)
{
	char MarshaledData [2000] = {0};				// Laikinas buferis supakuotiems duomenims
	unsigned short int PacketSize = DataSize + 2;	// Paketo dydis.
	int iCounter;									// Skaitliukas.

	// Ikeliame i paketa jo dydzio baitus.
	PacketSize = htons (PacketSize);
	MarshaledData [0] = (char)PacketSize;
	PacketSize >>= 8;
	MarshaledData [1] = (char)PacketSize;
	if ( MarshaledData [0] == '\0' ) 
		MarshaledData [0] = '\xFF';
	if ( MarshaledData [1] == '\0' )
		MarshaledData [1] = '\xFF';


	// Atliekame duomenu nukopijavima.
	for ( iCounter = 0; iCounter < DataSize; iCounter++ )
		MarshaledData [iCounter + 2] = Packet [iCounter];
	MarshaledData [iCounter + 2] = '\0';

	// Nukopijuojame atgal i paketo buferi.
	strcpy (Packet, MarshaledData);
}


// Paketo ispakavimas.
void UnmarshalPacket (char *Packet, int PacketSize)
{
	char UnmarshaledData [2000] = {0};	// Laikinas buferis ispakuotiems duomenims.
	int iCounter;						// Skaitliukas.


	// Ispakuojame paketa, t.y. nuimame paketo ilgio baitus.
	for ( iCounter = 2; iCounter < PacketSize; iCounter++ )
		UnmarshaledData [iCounter - 2] = Packet [iCounter];
	UnmarshaledData [iCounter - 2] = '\0';

	// Nukopijuojame i ankstesne duomenu vieta grazinimui (jau teisingu duomenu).
	strcpy (Packet, UnmarshaledData);
}
//---------------------------------------------

//---------------------------------------------
// Funkciju, skirtu duomenu paketams issiusti
// ir gauti, realizacija.

// Duomenu issiuntimas.
int SendAllData (SOCKET *SockDesc, const char *DataBuffer, int MaxBufferSize)
{
	int SentBytes = 0;				// Jau issiustu baitu skaicius.
	int BytesLeft = MaxBufferSize;	// Kiek baitu dar liko issiusti.
	int nBytes;						// Per viena karta issiunciamu baitu sk.


	while( SentBytes < MaxBufferSize )
	{
		// Bandome issiusti kazkokia tai dali duomenu.
		nBytes = send ((*SockDesc), DataBuffer + SentBytes, BytesLeft, 0);


		// Tikriname ar neivyko klaidu, jei ivyko nutraukiame
		// funkcijos vykdyma ir pranesame apie tai kvietejui.
		if ( nBytes == SOCKET_ERROR )
			return SOCKET_ERROR;

		
		// Atitinkamai modifikuojame issiustu ir dar likusiu
		// baitu skaitliukus.
		SentBytes += nBytes;
		BytesLeft -= nBytes;
	}
	
	return SentBytes;	// Graziname issiustu baitu skaiciu.
}


// Dauomenu gavimas.
int ReceiveAllData (SOCKET *SockDesc, char* ArrayOfDataPackets [], int *PackQuant)
{
	char DataBuffer [2000] = {0};		// Duomenu buferis.
	int nBytes;							// Baitu, gautu vienu kreipiniu i recv(), skaicius.
	int BytesReceived = 0;				// Jau gautu baitu skaicius.
	unsigned short int PacketSize = 0;	// Kintamasis paketo dydziui saugoti.
	int SomeFlag = 0;		// Veliavele, skirta pazymeti, ar jau suzinotas paketo dydis, ar ne.
	char TempBuffer [2000] = {0};		// Naudingas paketo turinys.
	unsigned int iCounter, jCounter;	// Skaitliukai.
	

	// Kreipiames i recv(), noredami gauti kazkokia tai dali informacijos.
	nBytes = recv ((*SockDesc), DataBuffer + BytesReceived, sizeof (DataBuffer), 0);

	// Modifikuojame jau perskaitytu baitu skaitliuka.
	BytesReceived += nBytes;

	// Atliekame reikiamus veiksmus tolesniam darbui pagal nBytes reiksme.
	// Jei nBytes == 0, tai reiskia, kad vartotojas nutrauke rysi su serveriu.
	if ( 0 == nBytes )
		return 0;

	// Priesingu atveju, pranesame, kad skaitant ivyko klaida.
	else if ( SOCKET_ERROR == nBytes )
		return SOCKET_ERROR;

	// Priesingu atveju, mes perskaiteme kazkokia dali informacijos.
	// Ja reikia apiforminti taip, kaip to laukia HandleDataFromClient().
	else
	{
		// Atliekame skaityma is soketo, kol viskas neperskaityta.
		while ( 1 )
		{
			// Jei buvo perskaityta paketo pradzia, tai reikia
			// Pasiziureti, koks paties paketo ilgis ir pazymeti
			// veliavele, kad jau zinome kazkurio tai paketo ilgi.
			if ( BytesReceived >= 2 && SomeFlag == 0 )
			{
				if ( DataBuffer [0] == '\xFF' )
					DataBuffer [0] = '\0';
				if ( DataBuffer [1] == '\xFF' )
					DataBuffer [1] = '\0';

				PacketSize = (short int)0;
				PacketSize |= DataBuffer [1];
				PacketSize <<= 8;
				PacketSize |= DataBuffer [0];
				PacketSize = ntohs (PacketSize);

				SomeFlag = 1;
			}


			// Jei turime maziau baitu nei nurodyta paketo dydyje.
			if ( BytesReceived < PacketSize && SomeFlag == 1 )
			{
				// Perskaitome dar.
				// Kreipiames i recv(), noredami gauti kazkokia tai dali informacijos.
				nBytes = recv ((*SockDesc), DataBuffer + BytesReceived, sizeof (DataBuffer), 0);

				// Modifikuojame jau perskaitytu baitu skaitliuka.
				BytesReceived += nBytes;

				// Atliekame reikiamus veiksmus tolesniam darbui pagal nBytes reiksme.
				// Jei nBytes == 0, tai reiskia, kad vartotojas nutrauke rysi su serveriu.
				if ( 0 == nBytes )
					return 0;

				// Priesingu atveju, pranesame, kad skaitant ivyko klaida.
				else if ( SOCKET_ERROR == nBytes )
					return SOCKET_ERROR;

				else continue;
			}

			// Jei perskaitytos informacijos kiekis buferyje yra toks,
			// koks nurodytas paketo dydzio baituose, tai reiskia, kad
			// turime viska nusiskaite. Isskiriame is paketo naudinga
			// informacija ir baigiame skaitymo cikla.
			else if ( PacketSize == BytesReceived )
			{
				UnmarshalPacket (DataBuffer, PacketSize);
				ArrayOfDataPackets [*PackQuant] = (char*) malloc (BytesReceived);
				memset (ArrayOfDataPackets [*PackQuant], 0, BytesReceived);
				strcpy (ArrayOfDataPackets [*PackQuant], DataBuffer);
				(*PackQuant)++;
				break;
			}

			// Priesingu atveju, jei perskaitytos informacijos kiekis
			// buferyje yra didesnis nei paketo dydis, reikia isskirti
			// pilno paketo naudinga informacija ir sutvarkius likuti
			// duomenu buferyje taip, kad jis butu pradzioje, pratesti
			// skaitymo is soketo veiksmus.
			else if ( BytesReceived > PacketSize )
			{
				// Nusikopijuojame paketa i laikina buferi.
				for ( iCounter = 0; iCounter < PacketSize; iCounter++ )
					TempBuffer [iCounter] = DataBuffer [iCounter];
				TempBuffer [iCounter] = '\0';

				// Ispakuojame paketa.
				UnmarshalPacket (TempBuffer, PacketSize);

				// Patalpiname ispakuota informacija i informacijos
				// eiluciu masyva.
				ArrayOfDataPackets [*PackQuant] = (char*) malloc (BytesReceived);
				memset (ArrayOfDataPackets [*PackQuant], 0, BytesReceived);
				strcpy (ArrayOfDataPackets [*PackQuant], TempBuffer);

				// Padidiname gautu paketu skaitliuka.
				(*PackQuant)++;

				// Perkeliame kito paketo dali i buferio pradzia.
				for ( iCounter = 0, jCounter = PacketSize;
					  iCounter < (unsigned int)(BytesReceived - PacketSize);
					  iCounter++, jCounter++ )
					DataBuffer [iCounter] = DataBuffer [jCounter];
				DataBuffer [iCounter] = '\0';

				// Modifikuojame nuskaitytu baitu skaitliuka ir
				// veliavele taip, kad pranesti, jog reikia vel
				// suzinoti naujo paketo dydi.
				BytesReceived -= PacketSize;
				SomeFlag = 0;
			}
		}
	}

	return 1;
}
