//////////////////////////////////////////////////////////////////////////////////////
// Projektas		:	Matematine viktorina.										//
// Projekto tikslas	:	Matematines viktorinos serverio ir kliento realizacija.		//
//----------------------------------------------------------------------------------//
// Failas			:	"math_server.h"												//
// Failo tikslas	:	Apibrezti daugiakliencio matematines viktorinos serverio	//
//						specifine globalia informacija, kuri dar neapibrezta faile	//
//						math_common.h.
// Failo autorius	:	Aidas Semezys.												//
//						Copyright (C), 2003											//
//////////////////////////////////////////////////////////////////////////////////////


//------------------------------------------------------------------------------------
//							HEADER'IU ITRAUKIMAS
//------------------------------------------------------------------------------------
#include	"math_common.h"		// Itraukiamas bendras serverio/kliento aprasu failas.

#include	<math.h>			// 1. Itraukiame '.h' faila matematiniams veiksmams.
#ifndef		WIN32OS				// Jei tai ne Windows tipo OS, tai
#include	<pthread.h>			// 2. Itraukiame darbui su POSIX gijomis skirta '.h'.
#endif


//------------------------------------------------------------------------------------
//						GLOBALUS KINTAMIEJI IR KONSTANTOS
//------------------------------------------------------------------------------------
#define		SERVER_PORT			10000	// Serverio portas, kuriuo jis lauks klientu.
#define		MAX_QUEUE_LENGTH	5		// Maksimalus laukianciu prisijungimo prie
										// serverio klientu skaicius.


// Apibreziame tipa, kuriuo bus aprasomas viktorinos dalyvio rangas.
typedef enum { LOSER, TIRO, MEDIOCRE, WHIZZ, EXPERT } PLAYER_RANG;


// Struktura, skirta vieno viktorinos dalyvio informacijai saugoti,
// t.y. saraso mazgo struktura.
typedef struct tagClientInfo {
	SOCKET					SocketNumber;		// Soketo, kuris klienta atitinka serveryje, numeris.
	char					ClientName [30];	// Kliento vardas, kuriuo jis prisiregitravo lygyje.
	unsigned int			ParticipationLevel;	// Lygio numeris.
	unsigned int			Points;				// Taskai, kuriuos klientas surinko.
	unsigned int			AnsInQueue;			// Atsakymai is eiles.
	PLAYER_RANG				Rang;				// Rangas, kuri yra pasiekes zaidejas.
	char					AnsToCurTask [100];	// Einamosios uzduoties atsakymas.
	struct tagClientInfo	*Next;				// Nuoroda i sekanti elementa.
} CLIENT_INFO;


// Paties viktorinos dalyviu tam tikrame lygyje
// saraso formatas.
typedef struct tagLevelInfoList {
	CLIENT_INFO		*FirstElem;
	CLIENT_INFO		*LastElem;
} LEVEL_INFO_LIST;



// Kiekvieno is dvieju lygiu zaideju sarasai.
LEVEL_INFO_LIST		FirstLevelPlayers;
LEVEL_INFO_LIST		SecondLevelPlayers;


unsigned int MaxDesc;			// Maximalus is dabar egzistojanciu soketu deskriptoriaus nr.
fd_set TheMainSet;				// Pagrindines programos soketu aibe.
char TaskForSend1 [1000];		// Pirmo lygio uzduoties issiuntimui skirtas buferis.
char TaskForSend2 [1000];		// Antro lygio uzduoties issiuntimui skirtas buferis.


// Kintamuju, skirtu darbui su gijomis bei ju
// sinchrinizavimui, apibrezimas.
#ifdef	WIN32OS

	// Windows aplinkai
	HANDLE	hFirstLevel, hSecondLevel;
	DWORD dwFirstLevelThreadID, dwSecondLevelThreadID;
	HANDLE hFLPMutex, hSLPMutex;

#else

	// Ne Windows tipo sistemoms (naudojame POSIX).
	pthread_t ptFirstLevel, ptSecondLevel;
	pthread_mutex_t ptFLPMutex, ptSLPMutex;

#endif


//------------------------------------------------------------------------------------
//							FUNKCIJU PROTOTIPAI
//------------------------------------------------------------------------------------

// Funkciju, inicializuojanciu serverio rutinas, antrastes.
SOCKET InitializeServer ( void );
int CreateThreadsAndMutexes ( fd_set*, fd_set* );

// Funkciju, skirtu valdyti atskirus lygius
// implementuojancioms gijoms, antrastes.
void FirstLevelFunction ( fd_set* );
void SecondLevelFunction ( fd_set* );

// Funkciju, skirtu apdoroti prisijungiancio ar jau
// viktorinoje dalyvaujancio kliento duomenims, antrastes.
int HandleNewConnection ( SOCKET*, unsigned int*, fd_set* );
void HandleDataFromClient ( SOCKET, fd_set*, fd_set*, fd_set* );

// Funkciju, skirtu vartotoju duomenims i viktorinos lygio
// informacini sarasa itraukti ir salinti, antrastes.
void InsertClientData ( SOCKET, LEVEL_INFO_LIST*, char*, unsigned int, fd_set* );
int FindAndRemoveClientData ( SOCKET, LEVEL_INFO_LIST* );

// Funkcijos, atsakingos uz lygmeni atitinkanciu uzduociu generavima, antraste.
void GenerateNewTask ( char*, const int, long*, double*, char* );

// Funkciju, skirtu vartotojo atsakymams priimti, is ju isrinkti ta,
// kuris pagal laika buvo issiustas anksciausiai ir apdoroti statistine
// informacija, antrastes.
int SelectFirstCorrectAnswer ( LEVEL_INFO_LIST*, long*, double*, char*, fd_set*, char* );
void InsertUserAnswer ( SOCKET, char* );
void HandleStatisticsStuff ( LEVEL_INFO_LIST*, char* );

// Funkciju, skirtu galimu serverio komandu realizavimui, antrastes.
void Command_JOIN ( SOCKET, char*, fd_set*, fd_set*, fd_set* );
void Command_INFO ( SOCKET );
void Command_LEAVE ( SOCKET );
void Command_QUIT ( SOCKET );
void Command_STATS ( SOCKET, char* );
void Command_TOP ( SOCKET );
