//////////////////////////////////////////////////////////////////////////////////////
// Projektas		:	Matematine viktorina.										//
// Projekto tikslas	:	Matematines viktorinos serverio ir kliento realizacija.		//
//----------------------------------------------------------------------------------//
// Failas			:	"math_client_drv.c"											//
// Failo tikslas	:	Realizuoti matematines viktorinos klientine aplikacija.		//
// Failo autorius	:	Aidas Semezys.												//
//						Copyright (C), 2003											//
//////////////////////////////////////////////////////////////////////////////////////


//------------------------------------------------------------------------------------
//							HEADER'IU ITRAUKIMAS
//------------------------------------------------------------------------------------
#include	"math_client.h"


//------------------------------------------------------------------------------------
//							PAGRINDINE PROGRAMA
//------------------------------------------------------------------------------------
int main (void)
{
	SOCKET ClientSockDesc;	// Kliento pagrindinio soketo-klausytojo deskriptorius.
	char UserInput [2000];	// Masyvas vartotojo komandoms nuskaityti.
	int SendResult;			// Siuntimo funkcijos resultatui saugoti.
	char *Packets [10];		// Buferiu masyvas duomenims gauti.
	int Quant = 0;			// Skaitliukas gautiems paketams skaiciuoti.
	int iCounter, jCounter;	// Skaitliukai.
	unsigned int ParseResult;// Komandu analizes rezultatui saugoti.
	fd_set ReadMask;		// Reikalinga selectui.
	struct timeval TimeVal;	// reikalinga selectui.
	int Flag;				// Veliavele.


//------------------------------------------------------------
// Jei kompiliuojama Windows tipo sistemoje, tai reikia
// pradedant darba inicializuoti soketu biblioteka.
#ifdef	WIN32OS
	WSADATA	wsaData;
	if ( -1 == WSAStartup (MAKEWORD (1, 1), &wsaData) )
	{
		printf ("MathClient error: WSAStartup() failed.\n");
		exit ( EXIT_FAILURE );
	}
#endif
//------------------------------------------------------------


	// Bandome sukurti ir suristi su reikiamu adresu ir portu serverio
	// pagrindini deskriptoriu, t.y. inicializuojame serveri.
	if ( INVALID_SOCKET == (ClientSockDesc = InitializeClient ()) )
	{
		printf ("MathClient error: client initialization failed.\n");
		goto EXIT;
	}

	// Amzinas ciklas, kurio pagalba vartotojas yra rezime 'gyvas'.
	while ( 1 )
	{
		// Isvalome standartinio I/O buferi.
		fflush ( stdin );

		// Isvalome UserInput
		memset (UserInput, 0, sizeof (UserInput));

		// Uzklausiame vartotojo jo pasirinkimo.
		fgets (UserInput, sizeof (UserInput), stdin);
		UserInput [strlen (UserInput) - 1] = '\0';

		if ( 0 == strcmp (UserInput, "") ) continue;

		// Isanalizuojame ivesta komanda.
		ParseResult = ParseCommandInput1 (UserInput);

		// Jei tai neatpazinta komanda ar klaida,
		// tai griztam i ciklo pradzia.
		if ( 0 == ParseResult ) continue;

		

		// Supakuojame informacija.
		MarshalPacket (UserInput, strlen (UserInput));

		// Siunciame turima paketa serveriui.
		if ( SOCKET_ERROR == (SendResult = SendAllData (&ClientSockDesc,
			UserInput, strlen (UserInput))) )
		{
			printf ("MathClient error: data transmission to the server failed.\n");
			break;
		}

		// Gauname rezultata.
		if ( SOCKET_ERROR == ReceiveAllData (&ClientSockDesc, Packets, &Quant) )
		{
			printf ("MathClient error: data reception from server failed.\n");
			break;
		}

		// Atspausdiname rezultata.
		for ( iCounter = 0; iCounter < Quant; iCounter++ )
		{
			// Reikia patikrinti, ar neivyko klaida uzsiregistruojant
			// serveryje jau egzistuojanciu vardu, kuri mes nurodeme
			// su komanda JOIN. Jei taip, tai i idetini cikla ieiti nereikia.
			if ( 3 == ParseResult )
			{
				for ( jCounter = 0; jCounter < 9 ; jCounter++ )
				{
					UserInput [jCounter] =
					Packets [iCounter][strlen(Packets [iCounter]) - 9 + jCounter];
				}
				UserInput [jCounter] = '\0';
				if ( 0 == strcmp (UserInput, "INCORRECT") )
				{
					ParseResult = 0;
					Packets [iCounter][strlen(Packets [iCounter]) - 9] = '\0';
				}
			}

			printf ("%s", Packets [iCounter]);
			free (Packets [iCounter]);
		}

		// Sumazinti paketu skaitliuka iki 0.
		Quant = 0;


		// Jei tai QUIT, tai paliekame cikla.
		if ( 2 == ParseResult ) break;

		// Jei komanda buvo JOIN, tai reikia ieiti i nauja cikla, t.y. dalyvauti
		// viktorinoje pasirinktu lygiu. Cia galioja kitos komandos.
		if ( 3 == ParseResult )
		{
			while ( 1 )
			{
				// Isvalome standartini ivedimo srauta.
				fflush (stdin);

				// Patikriname ar nera atsiustu duomenu.
				FD_ZERO (&ReadMask);
				FD_SET (ClientSockDesc, &ReadMask);
#ifndef	WIN32OS
				FD_SET (fileno (stdin), &ReadMask);
#endif
				TimeVal.tv_sec = 0;
				TimeVal.tv_usec = 0;

				// Jei ivyko klaida.
				if ( SOCKET_ERROR == select (ClientSockDesc + 1, &ReadMask,
					NULL, NULL, &TimeVal) )
				{
					printf ("MathClient error: select() failure.\n");
					continue;
				}

				// Jei klaidos nera.
				else
				{
					// Tikriname ar gavome duomenu. Jei taip, tai
					// nuskaitome ir atvaizduojame juos.
					if ( FD_ISSET (ClientSockDesc, &ReadMask) )
					{
						// Gauname duomenis.
						if ( SOCKET_ERROR == ReceiveAllData (&ClientSockDesc, Packets, &Quant) )
						{
							printf ("MathClient error: data reception from server failed.\n");
							goto EXIT;
						}

						// Atspausdiname duomenis.
						for ( iCounter = 0; iCounter < Quant; iCounter++ )
						{
							printf ("%s", Packets [iCounter]);
							free (Packets [iCounter]);
						}

						// Sumazinti paketu skaitliuka iki 0.
						Quant = 0;
					}

					// Priesingu atveju, patikrinam ar nera duomenu
					// standartiniam ivedimo sraute.
					Flag = 0;
#ifndef	WIN32OS
					if ( FD_ISSET (fileno (stdin), &ReadMask) )
						Flag = 1;
#else
					if ( kbhit () )
						Flag = 1;
#endif
				}

				// Taigi jei yra duomenu ivedimo sraute nuskaitom juos.
				if ( Flag == 1 )
				{
					// Isvalome standartinio I/O buferi.
					fflush ( stdin );

					// Isvalome UserInput
					memset (UserInput, 0, sizeof (UserInput));

					// Uzklausiame vartotojo jo pasirinkimo.
					fgets (UserInput, sizeof (UserInput), stdin);

					UserInput [strlen (UserInput) - 1] = '\0';
					if ( 0 == strcmp (UserInput, "") ) continue;

					// Isanalizuojame ivesta komanda.
					ParseResult = ParseCommandInput2 (UserInput);

					// Jei vartotojas ivede nezinoma komanda arba pastebeta klaida.
					if ( 0 == ParseResult ) continue;



					// Supakuojame informacija.
					MarshalPacket (UserInput, strlen (UserInput));

					// Siunciame turima paketa serveriui.
					if ( SOCKET_ERROR == (SendResult = SendAllData (&ClientSockDesc,
							UserInput, strlen (UserInput))) )
					{
						printf ("MathClient error: data transmission to the server failed.\n");
						goto EXIT;
					}

					// Gauname rezultata.
					if ( SOCKET_ERROR == ReceiveAllData (&ClientSockDesc, Packets, &Quant) )
					{
						printf ("MathClient error: data reception from server failed.\n");
						goto EXIT;
					}

					// Atspausdiname rezultata.
					for ( iCounter = 0; iCounter < Quant; iCounter++ )
					{
						printf ("%s", Packets [iCounter]);
						free (Packets [iCounter]);
					}

					// Sumazinti paketu skaitliuka iki 0.
					Quant = 0;



					// Tikriname, ar tai nebuvo LEAVE komanda.
					// Jei taip, tai iseiname is idetinio ciklo.
					if ( 2 == ParseResult ) break;
				}
			}
		}
	}

	// Uzdarome soketa ir tokiu budu pranesame serveriui apie nutraukta rysi.
	closesocket (ClientSockDesc);

EXIT:
//------------------------------------------------------------
// Jei kompiliuojama Windows tipo sistemoje, tai reikia
// baigus darba atlaisvinti soketu biblioteka.
#ifdef	WIN32OS
	if ( -1 == WSACleanup () )
	{
		printf ("MathClient error: WSACleanup() failed.\n");
		exit ( EXIT_FAILURE );
	}
#endif
//------------------------------------------------------------

	return 1;
}
