//////////////////////////////////////////////////////////////////////////////////////
// Projektas		:	Matematine viktorina.										//
// Projekto tikslas	:	Matematines viktorinos serverio ir kliento realizacija.		//
//----------------------------------------------------------------------------------//
// Failas			:	"math_client.c"												//
// Failo tikslas	:	Realizuoti matematines viktorinos klientines aplikacijos	//
//						funkcionaluma uztikrinancias funkcijas.						//
// Failo autorius	:	Aidas Semezys.												//
//						Copyright (C), 2003											//
//////////////////////////////////////////////////////////////////////////////////////


//------------------------------------------------------------------------------------
//							HEADER'IU ITRAUKIMAS
//------------------------------------------------------------------------------------
#include	"math_client.h"


//------------------------------------------------------------------------------------
//							FUNKCIJU REALIZACIJA
//------------------------------------------------------------------------------------


//-----------------------------------
// Kliento inicializacija.
SOCKET InitializeClient ( void )
{
	SOCKET ClientSockDesc;						// Kliento soketo deskriptorius.
	char ServerHostName [256] = {0};			// Hosto, kuriame paleistas serveris, vardas.
	unsigned short int ServerPortNumber;		// Porto numeris, kuriuo serveris laukia klientu.
	struct sockaddr_in ServerAddress;			// Serverio adreso struktura.
	struct hostent *ptrServerHostEntry = NULL;	// Serverio hosto informacine struktura.
	char Temp [10] = {0};
#ifdef WIN32OS
	const char yes = '1';
#else
	const int yes = 1;
#endif
	char* Packets [1];							// Bufferis pasveikinimo duomenims laikyti.
	int DummyPackQ = 0;							// Gautu paketu skaiciaus kintamasis.


	// Uzklausiame vartotojo hosto, kuriame paleistas serveris, vardo.
	while ( 0 == strcmp (ServerHostName, "") )
	{
		printf ("Server host name  : ");
		fgets (ServerHostName, sizeof (ServerHostName), stdin);
	}
	ServerHostName [strlen (ServerHostName) - 1] = '\0';


	// Uzklausiame vartotojo porto, kuriuo serveris laukia prisijungimu, numerio.
	while ( 0 == strcmp (Temp, "") )
	{
		printf ("Server port number: ");
		fgets (Temp, sizeof (Temp), stdin);
	}
	Temp [strlen (Temp) - 1] = '\0';
	ServerPortNumber = (unsigned short int)atoi (Temp);
		

	// Pagal turima hosto varda susizinome hosto informacija.
	if ( NULL == (ptrServerHostEntry = gethostbyname (ServerHostName)) )
		return INVALID_SOCKET;


	// Inicializuojame soketo adreso struktura.
	ServerAddress.sin_family	= AF_INET;
	ServerAddress.sin_port		= htons ( ServerPortNumber );
	ServerAddress.sin_addr		= *(struct in_addr *)ptrServerHostEntry->h_addr;
	memset (&(ServerAddress.sin_zero), 0, 8);


	// Sukuriame pati soketo deskriptoriu.
	if ( INVALID_SOCKET == (ClientSockDesc = socket (AF_INET, SOCK_STREAM, 0)) )
		return INVALID_SOCKET;


	// Uzdedame opcija soketo adreso ir porto pakartotinam panaudojimui.
	if ( SOCKET_ERROR == setsockopt (ClientSockDesc,
		SOL_SOCKET, SO_REUSEADDR, &yes, sizeof (yes)) )
		return INVALID_SOCKET;


	// Bandome prisijungti prie serverio.
	if ( SOCKET_ERROR == connect (ClientSockDesc,
		(struct sockaddr *)&ServerAddress, sizeof (struct sockaddr)) )
	{
		closesocket (ClientSockDesc);
		return INVALID_SOCKET;
	}
	

	// Isvedame informacija apie sekminga prisijungima.
	printf ("MathClient: connected successfully to host \'%s\' - (%s).\n",
		ServerHostName, inet_ntoa (*(struct in_addr *)ptrServerHostEntry->h_addr) );


	// Gauname serverio pasveikinima.
	if ( SOCKET_ERROR == ReceiveAllData (&ClientSockDesc, Packets, &DummyPackQ) )
	{
		closesocket (ClientSockDesc);
		return INVALID_SOCKET;
	}

	// Atspauzdiname serverio pasveikinima:
	printf ("%s", Packets [0]);
	free (Packets [0]);

	// Graziname sukurto soketo deskriptoriu.
	return ClientSockDesc;
}
//----------------------------------------


//----------------------------------------
// Vartotojo ivestu komandu analize 1.
// Graziname: 0 - neatpazinta komanda, arba klaida.
//			  1 - gera komanda.
//			  2 - komanda, kuri nurodo palikti pagrindini cikla (pvz.QUIT).
//			  3 - JOIN, t.y. kita komandu grupe pradeda galioti, ir ieiti
//				  i kita cikla reikia.
int ParseCommandInput1 (char *UserInput)
{
	// Jei tai komanda INFO, tai graziname 1.
	if ( 0 == strcmp (UserInput, "INFO") );

	// Jei tai QUIT, tai graziname 2, kad iseitume is pagrindinio ciklo.
	else if ( 0 == strcmp (UserInput, "QUIT") )
		return 2;

	// Jei tai JOIN komanda, reikia isparsinti ir parametrus.
	else if ( UserInput [0] == 'J' && UserInput [1] == 'O' &&
			  UserInput [2] == 'I' && UserInput [3] == 'N' )
	{
		// Jei toliau 1/2/3, tai skaitome toliau.
		if ( UserInput [4] == ' ' && (UserInput [5] == '1' ||
			 UserInput [5] == '2') && UserInput [6] == ' ' )
		{
			// Jei toliau netuscia, tesiame.
			// Priesingu atveju, reikalaujame, kad ivestu ir varda.
			if ( UserInput [7] == '\0' || UserInput [7] == ' ' )
			{
				printf ("MathClient error: JOIN has two parameters - {1/2/3} {name}.\n");
				return 0;
			}

			return 3;
		}

		// Jei tai ne 1/2/3.
		else
		{
			printf ("MathClient error: JOIN has two parameters - {1/2/3} {name}.\n");
			return 0;
		}
	}

	// Jei tai nezinoma komanda.
	else
	{
		printf ("MathClient error: invalid command \'%s\'\n", UserInput);
		return 0;
	}

	return 1;
}
//-----------------------------------------------------


//-----------------------------------------------------
// Vartotojo ivestu komandu analize 2.
// Graziname: 0 - neatpazinta komanda, arba klaida.
//			  1 - gera komanda.
//			  2 - komanda, kuri nurodo palikti idetini cikla (pvz.LEAVE).
int ParseCommandInput2 (char *UserInput)
{
	char TempData [100] = {0};	// Tarpinis duomenu buferis.
	time_t AnswerTime;			// Atsakymo laikas.


	// Jei tai komanda TOP, tai graziname 1.
	if ( 0 == strcmp (UserInput, "TOP") ||
		 0 == strcmp (UserInput, "INFO") );

	// Jei tai LEAVE, tai graziname 2, kad iseitume is idetinio ciklo,
	// i kuri patekome, kai surinkome komanda JOIN.
	else if ( 0 == strcmp (UserInput, "LEAVE") )
		return 2;

	// Jei tai STATS komanda, reikia isparsinti ir parametrus.
	else if ( UserInput [0] == 'S' && UserInput [1] == 'T' &&
			  UserInput [2] == 'A' && UserInput [3] == 'T' &&
			  UserInput [4] == 'S' )
	{
		// Jei po STATS nera tarpo.
		if ( UserInput [5] != ' ' )
		{
			printf ("MathClient error: STATS has one parameter - {name}.\n");
			return 0;
		}

		// Jei toliau netuscia, tesiame.
		// Priesingu atveju, reikalaujame, kad ivestu ir varda.
		if ( UserInput [6] == '\0' || UserInput [6] == ' ' )
		{
			printf ("MathClient error: STATS has one parameter - {name}.\n");
			return 0;
		}
	}

	else if ( (UserInput [0] == 'J' && UserInput [1] == 'O' &&
		       UserInput [2] == 'I' && UserInput [3] == 'N') ||
			  (UserInput [0] == 'Q' && UserInput [1] == 'U' &&
			   UserInput [2] == 'I' && UserInput [3] == 'T') )
	{
		printf ("MathClient error: invalid command.\n");
		return 0;
	}

	// Jei tai nezinoma komanda, tai traktuojame ivestus duomenis
	// kaip ivesta atsakyma i serverio klausimus.
	else
	{
		// Pasiimam atsakymo issiuntimo laika
		time (&AnswerTime);
		TempData [0] = (char)AnswerTime;
		AnswerTime >>= 8;
		TempData [1] = (char)AnswerTime;
		AnswerTime >>= 8;
		TempData [2] = (char)AnswerTime;
		AnswerTime >>= 8;
		TempData [3] = (char)AnswerTime;
		TempData [4] = '\0';

		// Prikopijuojam duomenis.
		strcat (TempData, UserInput);
		strcpy (UserInput, TempData);
	}

	return 1;
}
