//////////////////////////////////////////////////////////////////////////////////////
// Projektas		:	Matematine viktorina.										//
// Projekto tikslas	:	Matematines viktorinos serverio ir kliento realizacija.		//
//----------------------------------------------------------------------------------//
// Failas			:	"math_server.c"												//
// Failo tikslas	:	Realizuoti daugiakliencio matematines viktorinos serverio	//
//						funkcionaluma uztikrinancias funkcijas.						//
// Failo autorius	:	Aidas Semezys.												//
//						Copyright (C), 2003											//
//////////////////////////////////////////////////////////////////////////////////////


//------------------------------------------------------------------------------------
//							HEADER'IU ITRAUKIMAS
//------------------------------------------------------------------------------------
#include	"math_server.h"


//------------------------------------------------------------------------------------
//							FUNKCIJU REALIZACIJA
//------------------------------------------------------------------------------------

//-------------------------------------------
// Serverio inicializacija.
SOCKET InitializeServer ( void )
{
	SOCKET ServerSockDesc;						// Serverio soketo deskriptorius.
	char cServerHostName [256] = {0};			// Hosto, kuriame serveris paleistas, vardas.
	struct sockaddr_in ServerAddress;			// Serverio adreso struktura.
	struct hostent *ptrServerHostEntry = NULL;	// Serverio hosto informacine struktura.
#ifdef WIN32OS
	const char yes = '1';
#else
	const int yes = 1;
#endif


	// Susizinome hosto, kuriame paleistas serveris, varda.
	if ( INVALID_SOCKET == gethostname (cServerHostName, sizeof (cServerHostName)) )
		return INVALID_SOCKET;


	// Pagal turima hosto varda susizinome hosto informacija.
	if ( NULL == (ptrServerHostEntry = gethostbyname (cServerHostName)) )
		return INVALID_SOCKET;


	// Inicializuojame soketo adreso struktura.
	ServerAddress.sin_family	= AF_INET;
	ServerAddress.sin_port		= htons ( SERVER_PORT );
	ServerAddress.sin_addr		= *(struct in_addr *)ptrServerHostEntry->h_addr;
	memset (&(ServerAddress.sin_zero), 0, 8);


	// Sukuriame pati soketo deskriptoriu.
	if ( INVALID_SOCKET == (ServerSockDesc = socket (AF_INET, SOCK_STREAM, 0)) )
		return INVALID_SOCKET;


	// Uzdedame opcija soketo adreso ir porto pakartotinam panaudojimui.
	if ( SOCKET_ERROR == setsockopt (ServerSockDesc,
		SOL_SOCKET, SO_REUSEADDR, &yes, sizeof (yes)) )
		return INVALID_SOCKET;


	// Surisame sukurta deskriptoriu su turimu adresu.
	if ( SOCKET_ERROR == bind (ServerSockDesc,
		(struct sockaddr *)&ServerAddress, sizeof (ServerAddress)) )
	{
		closesocket ( ServerSockDesc );
		return INVALID_SOCKET;
	}


	// Liepiame sukurtam soketui laukti prisijungimu per porta,
	// su kuriuo jis suristas.
	if ( SOCKET_ERROR == listen (ServerSockDesc, MAX_QUEUE_LENGTH) )
	{
		closesocket ( ServerSockDesc );
		return INVALID_SOCKET;
	}

	// Isvedame informacija apie sekminga serverio inicializacija.
	printf ("MathServer: started successfully on host \'%s\' - (%s).\n",
		cServerHostName, inet_ntoa (*(struct in_addr *)ptrServerHostEntry->h_addr) );

	// Graziname sukurto soketo deskriptoriu.
	return ServerSockDesc;
}
//----------------------------------------------------


//----------------------------------------------------
// Giju ir sinchronizaciniu objektu sukurimo funkcija.
int CreateThreadsAndMutexes (fd_set *FirstLevelSet, fd_set *SecondLevelSet)
{

#ifdef WIN32OS	// Jei tai Windows tipo OS, tai naudojame WIN32 Thread API

	// Sukuriame sincronizacinius objektus, t.y. mutex'us.
	hFLPMutex = CreateMutex (NULL, FALSE, NULL);
	hSLPMutex = CreateMutex (NULL, FALSE, NULL);

	// Jei nors vieno is ju nepavyko sukurti, tai nutraukiame programa.
	if ( hFLPMutex == NULL || hSLPMutex == NULL )
	{
		printf ("MathServer error: failure while creating synchronization objects.\n");
		return 0;
	}

	// Sukuriame uz pirmaji lygi atsakinga gija.
	hFirstLevel = CreateThread (NULL, 0, (LPTHREAD_START_ROUTINE)FirstLevelFunction,
		(LPVOID)FirstLevelSet, CREATE_SUSPENDED, &dwFirstLevelThreadID);
	if ( hFirstLevel == NULL )
	{
		printf ("MathServer error: failure while initializing first level routines.\n");
		return 0;
	}

	// Priskiriame jai prioriteta ir paleidziame.
	if ( !SetThreadPriority (hFirstLevel, THREAD_PRIORITY_NORMAL) )
	{
		printf ("MathServer error: failure while initializing first level routines.\n");
		return 0;
	}
	if ( -1 == ResumeThread (hFirstLevel) )
	{
		printf ("MathServer error: failure while initializing first level routines.\n");
		return 0;
	}


	// Sukuriame uz antraji lygi atsakinga gija.
	hSecondLevel = CreateThread (NULL, 0, (LPTHREAD_START_ROUTINE)SecondLevelFunction,
		(LPVOID)SecondLevelSet, CREATE_SUSPENDED, &dwSecondLevelThreadID);
	if ( hSecondLevel == NULL )
	{
		printf ("MathServer error: failure while initializing second level routines.\n");
		return 0;
	}

	// Priskiriame jai prioriteta ir paleidziame.
	if ( !SetThreadPriority (hSecondLevel, THREAD_PRIORITY_NORMAL) )
	{
		printf ("MathServer error: failure while initializing second level routines.\n");
		return 0;
	}
	if ( -1 == ResumeThread (hSecondLevel) )
	{
		printf ("MathServer error: failure while initializing second level routines.\n");
		return 0;
	}

#else	// Priesingu atveju naudojame POSIX gijas.

	// Sukuriame sincronizacinius objektus, t.y. mutex'us.
	// Jei nors vieno is ju nepavyko sukurti, tai nutraukiame programa.
	if ( !pthread_mutex_init (&hFLPMutex, NULL) ||
		 !pthread_mutex_init (&hSLPMutex, NULL) )
	{
		printf ("MathServer error: failure while creating synchronization objects.\n");
		return 0;
	}

	// Sukuriame uz pirmaji lygi atsakinga gija.
	if ( !pthread_create (&ptFirstLevel, NULL, (void*)FirstLevelFunction,
		(void*)FirstLevelSet )
	{
		printf ("MathServer error: failure while initializing first level routines.\n");
		return 0;
	}

	// Sukuriame uz antraji lygi atsakinga gija.
	if ( !pthread_create (&ptSecondLevel, NULL, (void*)SecondLevelFunction,
		(void*)SecondLevelSet )
	{
		printf ("MathServer error: failure while initializing second level routines.\n");
		return 0;
	}

#endif

	return 1;
}
//------------------------------------------


//------------------------------------------
// Pirmaji lygi valdancios gijos funkcija.
void FirstLevelFunction (fd_set *MainLevelSet)
{
	fd_set TempLevelSet;			// Pagalbine soketu deskriptoriu aibe.
	fd_set TempSetForSendingTask;
	unsigned int iCounter;			// Skaitliukas.
	struct timeval TimeVal;			// Laiko struktura, skirta darbui su select.
	char DataBuffer [2000] = {0};	// Buferis, skirtas duomenims kaupti.

	unsigned int Answered = 1;		// Veliavele, pasakanti ar uzduotis atsakyta.
	char Task [500] = {0};			// Uzduoties eilute.
	long lnResult;					// Resultato kaip sveikojo skaiciaus kint.
	double fResult;					// Rezultato kaip realaus skaiciaus kint.
	char cResult [20] = {0};		// Rezultato kaip eilutes saugojimui.
	char AnswererName [30] = {0};	// Atsakiusiojo vardas.



	// Inicializuojame laiko struktura taip,
	// kad select() f-ja nieko nelauktu.
	TimeVal.tv_sec = 0;
	TimeVal.tv_usec = 0;

	// inicializuojame pagalbines deskriptoriu aibes.
	FD_ZERO (&TempLevelSet);
	FD_ZERO (&TempSetForSendingTask);
	
	// Tesiame tol, kol serveris nebus isjungtas.
	while ( 1 )
	{
		// Jeigu sena atsakyta arba tai yra pirmoji uzduotis,
		// tai sugeneruojame ja ir jei yra kam, pasiunciame.
		if ( Answered )
		{
			// Sugeneruojam.
			GenerateNewTask (Task, 1, &lnResult, &fResult, cResult);

			// Supakuojame uzduoties pranesima.
			strcpy (TaskForSend1, "\n/-----------------------------------------------\\\n");
			strcat (TaskForSend1, " MathServer level 1\n\n Question: ");
			strcat (TaskForSend1, Task);
			strcat (TaskForSend1, "\\-----------------------------------------------/\n\n");
			MarshalPacket (TaskForSend1, strlen (TaskForSend1));

			// Isvalome sia uzduoti gavusiuju aibe.
			FD_ZERO (&TempSetForSendingTask);

			// Pazymim, kad uzduotis dar neatsakyta.
			Answered = 0;
		}

		for ( iCounter = 0; iCounter <= MaxDesc; iCounter++ )
		{
			if ( FD_ISSET (iCounter, MainLevelSet) &&
				!FD_ISSET (iCounter, &TempSetForSendingTask) )
			{
				if ( SOCKET_ERROR == SendAllData (&iCounter,
					TaskForSend1, strlen (TaskForSend1)) )
					printf ("MathServer error: failure while sending task.\n");
				else
					FD_SET (iCounter, &TempSetForSendingTask);
			}

			if ( !FD_ISSET (iCounter, MainLevelSet) &&
				  FD_ISSET (iCounter, &TempSetForSendingTask) )
				  FD_CLR (iCounter, &TempSetForSendingTask);
		}

		// Nukopijuojame pagrindines lygio deskriptoriu aibes turini i pagalbine.
		TempLevelSet = *MainLevelSet;

		// Atliekame pagalbines aibes modifikacija kreipdamiesi i select().
		// Bet pries tai patikriname ar aibe nera tuscia.
		if ( TempLevelSet.fd_count == 0 ) continue;
		if ( SOCKET_ERROR == select (MaxDesc + 1, &TempLevelSet, NULL, NULL, &TimeVal) )
		{
			printf ("MathServer error: select() failure in FirstLevelFunction().\n");
			perror ("select");
		}

		// Skanuojame visa soketu deskriptoriu aibe.
		for ( iCounter = 0; iCounter <= MaxDesc; iCounter++ )
		{
			// Jei tai deskriptorius, priklausantis sio lygio
			// deskriptoriu aibei ir jis turi, ka pasakyti,
			// tai apdorojame jo duomenis pries tai juos isklause.
			if ( FD_ISSET (iCounter, &TempLevelSet) )
			{
				// Turime atlikti kliento duomenu apdorojima.
				HandleDataFromClient ((SOCKET)iCounter, MainLevelSet, NULL, NULL);
			}
		}

		// Jeigu tai buvo atsakymai i klausima, tai dabar yra ju kazkiek,
		// todel reikia juos apdoroti, t.y. isrinkti ta, kuris issiunte
		// pirmiausiai.
		FD_ZERO (&TempLevelSet);
		Answered = SelectFirstCorrectAnswer (&FirstLevelPlayers, &lnResult,
			&fResult, cResult, &TempLevelSet, AnswererName);

		// Jei atsakyta, tai issiunciame pranesima apie atsakyma.
		if ( Answered )
		{
			// Issiunciame visiems dalyviams pranesima apie tai, kas atsake.
			strcpy (DataBuffer, "\n/-----------------------------------------------\\\n");
			strcat (DataBuffer, " MathServer level 1\n\n Question answered by ");
			strcat (DataBuffer, AnswererName);
			strcat (DataBuffer, "\n\\-----------------------------------------------/\n\n");
			MarshalPacket (DataBuffer, strlen (DataBuffer));
			for ( iCounter = 0; iCounter <= MaxDesc; iCounter++ )
			{
				if ( FD_ISSET (iCounter, MainLevelSet) )
					SendAllData (&iCounter, DataBuffer, strlen (DataBuffer));
			}

			HandleStatisticsStuff (&FirstLevelPlayers, AnswererName);
		}
		else
		{
			// Issiunciam dummy paketa tiems, kurie bande atsakyti, bet nebuvo atsakyta.
			sprintf (DataBuffer, "");
			MarshalPacket (DataBuffer, strlen (DataBuffer));
			for ( iCounter = 0; iCounter <= MaxDesc; iCounter++ )
			{
				if ( FD_ISSET (iCounter, &TempLevelSet) )
					SendAllData (&iCounter, DataBuffer, strlen (DataBuffer));
			}
		}
	}
}
//----------------------------------------------


//----------------------------------------------
// Antraji lygi valdancios gijos funkcija.
void SecondLevelFunction (fd_set *MainLevelSet)
{
	fd_set TempLevelSet;			// Pagalbine soketu deskriptoriu aibe.
	fd_set TempSetForSendingTask;
	unsigned int iCounter;			// Skaitliukas.
	struct timeval TimeVal;			// Laiko struktura, skirta darbui su select.
	char DataBuffer [2000] = {0};	// Buferis, skirtas duomenims kaupti.

	unsigned int Answered = 1;		// Veliavele, pasakanti ar uzduotis atsakyta.
	char Task [500] = {0};			// Uzduoties eilute.
	long lnResult;					// Resultato kaip sveikojo skaiciaus kint.
	double fResult;					// Rezultato kaip realaus skaiciaus kint.
	char cResult [20] = {0};		// Rezultato kaip eilutes saugojimui.
	char AnswererName [30] = {0};	// Atsakiusiojo vardas.



	// Inicializuojame laiko struktura taip,
	// kad select() f-ja nieko nelauktu.
	TimeVal.tv_sec = 0;
	TimeVal.tv_usec = 0;

	// inicializuojame pagalbines deskriptoriu aibes.
	FD_ZERO (&TempLevelSet);
	FD_ZERO (&TempSetForSendingTask);
	
	// Tesiame tol, kol serveris nebus isjungtas.
	while ( 1 )
	{
		// Jeigu sena atsakyta arba tai yra pirmoji uzduotis,
		// tai sugeneruojame ja ir jei yra kam, pasiunciame.
		if ( Answered )
		{
			// Sugeneruojam.
			GenerateNewTask (Task, 2, &lnResult, &fResult, cResult);

			// Supakuojame uzduoties pranesima.
			strcpy (TaskForSend2, "\n/-----------------------------------------------\\\n");
			strcat (TaskForSend2, " MathServer level 2\n\n Question: ");
			strcat (TaskForSend2, Task);
			strcat (TaskForSend2, "\\-----------------------------------------------/\n\n");
			MarshalPacket (TaskForSend2, strlen (TaskForSend2));

			// Isvalome sia uzduoti gavusiuju aibe.
			FD_ZERO (&TempSetForSendingTask);

			// Pazymim, kad uzduotis dar neatsakyta.
			Answered = 0;
		}

		for ( iCounter = 0; iCounter <= MaxDesc; iCounter++ )
		{
			if ( FD_ISSET (iCounter, MainLevelSet) &&
				!FD_ISSET (iCounter, &TempSetForSendingTask) )
			{
				if ( SOCKET_ERROR == SendAllData (&iCounter,
					TaskForSend2, strlen (TaskForSend2)) )
					printf ("MathServer error: failure while sending task.\n");
				else
					FD_SET (iCounter, &TempSetForSendingTask);
			}

			if ( !FD_ISSET (iCounter, MainLevelSet) &&
				  FD_ISSET (iCounter, &TempSetForSendingTask) )
				  FD_CLR (iCounter, &TempSetForSendingTask);
		}

		// Nukopijuojame pagrindines lygio deskriptoriu aibes turini i pagalbine.
		TempLevelSet = *MainLevelSet;

		// Atliekame pagalbines aibes modifikacija kreipdamiesi i select().
		// Bet pries tai patikriname ar aibe nera tuscia.
		if ( TempLevelSet.fd_count == 0 ) continue;
		if ( SOCKET_ERROR == select (MaxDesc + 1, &TempLevelSet, NULL, NULL, &TimeVal) )
		{
			printf ("MathServer error: select() failure in SecondLevelFunction().\n");
			perror ("select");
		}

		// Skanuojame visa soketu deskriptoriu aibe.
		for ( iCounter = 0; iCounter <= MaxDesc; iCounter++ )
		{
			// Jei tai deskriptorius, priklausantis sio lygio
			// deskriptoriu aibei ir jis turi, ka pasakyti,
			// tai apdorojame jo duomenis pries tai juos isklause.
			if ( FD_ISSET (iCounter, &TempLevelSet) )
			{
				// Turime atlikti kliento duomenu apdorojima.
				HandleDataFromClient ((SOCKET)iCounter, MainLevelSet, NULL, NULL);
			}
		}

		// Jeigu tai buvo atsakymai i klausima, tai dabar yra ju kazkiek,
		// todel reikia juos apdoroti, t.y. isrinkti ta, kuris issiunte
		// pirmiausiai.
		FD_ZERO (&TempLevelSet);
		Answered = SelectFirstCorrectAnswer (&SecondLevelPlayers, &lnResult,
			&fResult, cResult, &TempLevelSet, AnswererName);

		// Jei atsakyta, tai issiunciame pranesima apie atsakyma.
		if ( Answered )
		{
			// Issiunciame visiems dalyviams pranesima apie tai, kas atsake.
			strcpy (DataBuffer, "\n/-----------------------------------------------\\\n");
			strcat (DataBuffer, " MathServer level 2\n\n Question answered by ");
			strcat (DataBuffer, AnswererName);
			strcat (DataBuffer, "\n\\-----------------------------------------------/\n\n");
			MarshalPacket (DataBuffer, strlen (DataBuffer));
			for ( iCounter = 0; iCounter <= MaxDesc; iCounter++ )
			{
				if ( FD_ISSET (iCounter, MainLevelSet) )
					SendAllData (&iCounter, DataBuffer, strlen (DataBuffer));
			}

			HandleStatisticsStuff (&SecondLevelPlayers, AnswererName);
		}
		else
		{
			// Issiunciam dummy paketa tiems, kurie bande atsakyti, bet nebuvo atsakyta.
			sprintf (DataBuffer, "");
			MarshalPacket (DataBuffer, strlen (DataBuffer));
			for ( iCounter = 0; iCounter <= MaxDesc; iCounter++ )
			{
				if ( FD_ISSET (iCounter, &TempLevelSet) )
					SendAllData (&iCounter, DataBuffer, strlen (DataBuffer));
			}
		}
	}
}
//----------------------------------------


//----------------------------------------
// Nauju prisijungimu apdorojimas.
int HandleNewConnection (SOCKET *ServSockDesc, unsigned int *MaxDesc, fd_set *MainSet)
{
	struct sockaddr_in RemoteAddress;	// Struktura bandancio prisijungti adresui.
	SOCKET NewConnectionDesc;			// Soketo deskriptorius bendravimui su nauju klientu.
	int AddressSize;					// Adreso strukturos dydziui saugoti.
	char Buffer [1000] = {0};			// Buferis pasveikinimo informacijai laikyti.
	struct hostent *HostEntry;			// Struktura informacijai apie nauja klienta.
#ifdef WIN32OS
	const char yes = '1';
#else
	const int yes = 1;
#endif


	//Inicializuojame adreso strukturos dydzio kintamaji.
	AddressSize = sizeof (struct sockaddr_in);


	// Bandome priimti nauja prisijungima ir sukurti deskriptoriu.
	// bendravimui su juo.
	if ( SOCKET_ERROR == (NewConnectionDesc =
		accept ((*ServSockDesc), (struct sockaddr *)&RemoteAddress, &AddressSize)) )
		return SOCKET_ERROR;


	// Uzdedame opcija soketo adreso ir porto pakartotinam panaudojimui.
	if ( SOCKET_ERROR == setsockopt (NewConnectionDesc,
		SOL_SOCKET, SO_REUSEADDR, &yes, sizeof (yes)) )
		return SOCKET_ERROR;


	// Paskelbiam apie prisijungima serveryje.
	printf ("MathServer: new connection from \'%s\' accepted successfully.\n",
		inet_ntoa (RemoteAddress.sin_addr));


	// Gauname informacija apie prisijungusi klienta.
	if ( NULL == (HostEntry = gethostbyaddr ((void*)&(RemoteAddress.sin_addr),
		sizeof (RemoteAddress.sin_addr), AF_INET)) )
	{
		closesocket (NewConnectionDesc);
		printf ("MathServer: new connection from \'%s\' was immediately closed because of gethostbyaddr() failure.\n");
		return SOCKET_ERROR;
	}


	// Talpiname pasveikinima i tam isskirta buferi.
	strcpy (Buffer, "\n/*****************************************************************************\\\n");
	strcat (Buffer, " Dear guest from \'");
	strcat (Buffer, HostEntry->h_name);
	strcat (Buffer, "\', we welcome you at MathServer!\n\n");
	strcat (Buffer, " JOIN 1/2 name - lets you join numbered level of the mathematical quiz.\n");
	strcat (Buffer, " INFO          - retrieves information about current situation at MathServer.\n");
	strcat (Buffer, " QUIT          - disconnects you from MathServer.\n");
	strcat (Buffer, "\\*****************************************************************************/\n\n");


	// Supakuojame bufferi.
	MarshalPacket (Buffer, strlen (Buffer));


	// Pasiunciame pasveikinimo informacija naujai prisijungusiajam.
	if ( SOCKET_ERROR == SendAllData (&NewConnectionDesc, Buffer, strlen (Buffer)) )
	{
		closesocket (NewConnectionDesc);
		printf ("MathServer: new connection from \'%s\' was immediately closed because of send() failure.\n");
		return SOCKET_ERROR;
	}


	// Itraukiame sukurta soketo deskriptoriu i pagrindine soketu aibe.
	FD_SET (NewConnectionDesc, MainSet);


	// Atitinkamai modifikuojame maksimalaus deskriptoriaus kintamaji.
	if ( (*MaxDesc) < NewConnectionDesc )
		(*MaxDesc) = NewConnectionDesc;


	return 1;
}
//-----------------------------------------


//-----------------------------------------
// Kliento siunciamu duomenu apdorojimas.
void HandleDataFromClient (SOCKET ClientSockDesc, fd_set *MainSet,
						   fd_set *FirstLevelSet, fd_set *SecondLevelSet)
{
	int BytesOfPacketReceived = 0;	// Gautu vieno paketo baitu skaicius.
	char *ClientDataBuffers [10];	// Buferis kliento pasiustai informacijai saugoti.
	int ReceiveResult;				// Duomenu gavimo funkcijos grazinamam rez. saugoti.
	int PacketsQuantity = 0;		// Duomenu gavimo operacija gautu paketu skaicius.
	int iCounter;					// Skaitliukas.
	char Command [2000] = {0};		// Komandai saugoti.


	// Bandome gauti i isskirta buferi kliento pasiusta informacija.
	ReceiveResult = ReceiveAllData (&ClientSockDesc, ClientDataBuffers, &PacketsQuantity);

	// Atliekame veiksmus pagal duomenu gavimo funkcijos pranesta rezultata.
	// jei gautas pranesimas, kad vartotojas nutrauke rysi su serveriu.
	if ( ReceiveResult == 0 )
	{
		// Isvedame pranesima apie prarasta rysi.
		printf ("MathServer: client at socket %d has quit the connection.\n", ClientSockDesc);

		// Naikiname soketa.
		closesocket (ClientSockDesc);

		// Pasaliname deskriptoriu is pagrindines aibes.
		FD_CLR (ClientSockDesc, MainSet);
	}

	// Priesingu atveju, jei ivyko klaida skaitant duomenis.
	else if ( ReceiveResult == SOCKET_ERROR )
	{
		// Isvedame pranesima apie klaida.
		printf ("MathServer error: data reception from client was erroneous at socket %d.\n", ClientSockDesc);

		// Dabar reikia surast ir pasalinti informacija
		// is kazkurio tai lygio dalyviu saraso.
		if ( 0 == FindAndRemoveClientData (ClientSockDesc, &FirstLevelPlayers) )
			FindAndRemoveClientData (ClientSockDesc, &SecondLevelPlayers);

		// Naikiname soketa.
		closesocket (ClientSockDesc);

		// Pasaliname is deskriptoriu aibes.
		FD_CLR (ClientSockDesc, MainSet);
	}

	// Priesingu atveju, jei viskas baigesi gerai, tai apdorojame
	// kliento uzklausas.
	else if ( ReceiveResult == 1 )
	{
		// Apdorojame visu paketu isskirta naudinga informacija atskirai.
		for ( iCounter = 0; iCounter < PacketsQuantity; iCounter++ )
		{
			// Isskiriame keturis pirmus baitus: pacia komanda.
			Command [0] = ClientDataBuffers [iCounter][0];
			Command [1] = ClientDataBuffers [iCounter][1];
			Command [2] = ClientDataBuffers [iCounter][2];
			Command [3] = ClientDataBuffers [iCounter][3];
			Command [4] = '\0';


			// Jei vartotojas pasiunte komanda JOIN n <name>
			if ( 0 == strcmp (Command, "JOIN") )
			{
				// Ivykdome vartotojo komanda JOIN
				Command_JOIN (ClientSockDesc, ClientDataBuffers [iCounter], MainSet,
					FirstLevelSet, SecondLevelSet);
			}

			// Priesingu atveju, jei pasiunte komanda INFO.
			else if ( 0 == strcmp (Command, "INFO") )
			{
				// Ivykdome vartotojo komanda INFO.
				Command_INFO (ClientSockDesc);
			}

			// Priesingu atveju, jei pasiunte komanda LEAVE.
			else if ( 0 == strcmp (Command, "LEAV") )
			{
				// Ivykdome vartotojo komanda LEAVE.
				Command_LEAVE (ClientSockDesc);
				
				// Pasaliname is lygio deskriptoriu aibes.
				FD_CLR (ClientSockDesc, MainSet);

				// Iterpiu i pagrindines programos deskriptoriu aibe.
				FD_SET (ClientSockDesc, &TheMainSet);
			}

			// Priesingu atveju, jei pasiunte komanda QUIT.
			else if ( 0 == strcmp (Command, "QUIT") )
			{
				Command_QUIT (ClientSockDesc);
			}

			// Priesingu atveju, jei pasiunte komanda STATS.
			else if ( 0 == strcmp (Command, "STAT") )
			{
				// Ivykdome vartotojo komanda STATS.
				Command_STATS (ClientSockDesc, ClientDataBuffers [iCounter]);
			}

			// Priesingu atveju, jei pasiunte komanda TOP.
			else if ( 0 == strcmp (Command, "TOP") )
			{
				// Ivykdome vartotojo komanda TOP.
				Command_TOP (ClientSockDesc);
			}

			// Priesingu atveju, tai yra vartotojo pateikiamas
			// atsakymas i einamaji jo lygio viktorinoje pateikiama klausima.
			else
			{
				// Iterpiame jo atsakyma i jo info strukturoje tam skirta lauka.
				InsertUserAnswer (ClientSockDesc, ClientDataBuffers [iCounter]);
			}

			// Atlaisviname atminti.
			free (ClientDataBuffers [iCounter]); 
		}
	}
}
//---------------------------------------------


//---------------------------------------------
// Funkcija, skirta kliento informacijos patalpinimui i nurodyta sarasa.
void InsertClientData (SOCKET SockDesc, LEVEL_INFO_LIST *LevelPlayers,
					   char *NameToAssign, unsigned int LevelToJoin, fd_set *LevelSet )
{
	// Is pradziu reikia susizinoti koki lygi cia aptarnausime.
	// Tai darome del sinchronizacijos.
	if ( LevelPlayers == &FirstLevelPlayers )

#ifdef	WIN32OS
		WaitForSingleObject (hFLPMutex, INFINITE);
#else
		pthread_mutex_lock (&ptFLPMutex);
#endif

	else if ( LevelPlayers == &SecondLevelPlayers )

#ifdef	WIN32OS
		WaitForSingleObject (hSLPMutex, INFINITE);
#else
		pthread_mutex_lock (&ptSLPMutex);
#endif


	// Jei tai pirmas pareiskimas i si lygi.
	if ( NULL == LevelPlayers->FirstElem )
	{
		// Isskiriame atminties sio zaidejo informacijai.
		LevelPlayers->FirstElem = (CLIENT_INFO*)
			malloc (sizeof (CLIENT_INFO));

		// Nukopijuojame ir inicializuojame sio kliento informacinio mazgo laukus.
		strcpy (LevelPlayers->FirstElem->ClientName, NameToAssign);
		strcpy (LevelPlayers->FirstElem->AnsToCurTask, "");
		LevelPlayers->FirstElem->ParticipationLevel = LevelToJoin;
		LevelPlayers->FirstElem->Points = 0;
		LevelPlayers->FirstElem->AnsInQueue = 0;
		LevelPlayers->FirstElem->Rang = LOSER;
		LevelPlayers->FirstElem->SocketNumber = SockDesc;
		LevelPlayers->FirstElem->Next = NULL;

		// Paskutinio elemento rodykle nukreipiame i pirmaji elementa,
		// kuri ka tik inicializavome.
		LevelPlayers->LastElem = LevelPlayers->FirstElem;
	}

	// Priesingu atveju, jei tai jau ne pirmasis pareiskimas.
	else
	{
		// Isskiriame atminties sio zaidejo informacijai.
		LevelPlayers->LastElem->Next = (CLIENT_INFO*)
			malloc (sizeof (CLIENT_INFO));

		// Priskiriame ka tik sukurto elemento adresa paskutiniojo
		// elemento rodyklei.
		LevelPlayers->LastElem = LevelPlayers->LastElem->Next;

		// Nukopijuojame ir inicializuojame sio kliento informacinio mazgo laukus.
		strcpy (LevelPlayers->LastElem->ClientName, NameToAssign);
		strcpy (LevelPlayers->LastElem->AnsToCurTask, "");
		LevelPlayers->LastElem->ParticipationLevel = LevelToJoin;
		LevelPlayers->LastElem->Points = 0;
		LevelPlayers->LastElem->AnsInQueue = 0;
		LevelPlayers->LastElem->Rang = LOSER;
		LevelPlayers->LastElem->SocketNumber = SockDesc;
		LevelPlayers->LastElem->Next = NULL;
	}


	// Iterpiame i pirmo lygio deskriptoriu aibe.
	FD_SET (SockDesc, LevelSet);


	// Na ir pabaigoje, t.y. jau iterpe nauja lygio dalyvi,
	// galime atlaisvinti sinchronizacini objekta.
	if ( LevelPlayers == &FirstLevelPlayers )

#ifdef	WIN32OS
		ReleaseMutex (hFLPMutex);
#else
		pthread_mutex_unlock (&ptFLPMutex);
#endif

	else if ( LevelPlayers == &SecondLevelPlayers )

#ifdef	WIN32OS
		ReleaseMutex (hSLPMutex);
#else
		pthread_mutex_unlock (&ptSLPMutex);
#endif

}
//-----------------------------------------


//-----------------------------------------
// Funkcija, skirta kliento informacijos suradimui ir pasalinimui.
int FindAndRemoveClientData (SOCKET ClientSockDesc, LEVEL_INFO_LIST *LevelPlayers)
{
	CLIENT_INFO *TempPtr1, *TempPtr2;	// Rodykles i kliento informacine struktura.
	int Result = 0;						// Rezultato kintamasis.


	// Is pradziu reikia susizinoti koki lygi cia aptarnausime.
	// Tai darome del sinchronizacijos.
	if ( LevelPlayers == &FirstLevelPlayers )

#ifdef	WIN32OS
		WaitForSingleObject (hFLPMutex, INFINITE);
#else
		pthread_mutex_lock (&ptFLPMutex);
#endif

	else if ( LevelPlayers == &SecondLevelPlayers )

#ifdef	WIN32OS
		WaitForSingleObject (hSLPMutex, INFINITE);
#else
		pthread_mutex_lock (&ptSLPMutex);
#endif


	// Priskiriame abiems laikinoms lokalioms rodyklems
	// pirmojo saraso elemento adresa.
	TempPtr1 = TempPtr2 = LevelPlayers->FirstElem;
	while ( TempPtr1 != NULL )
	{
		// Jei tai rastasis elementas.
		if ( TempPtr1->SocketNumber == ClientSockDesc )
		{
			// Jei tai vienintelis elementas, t.y. ir pirmas ir paskutinis.
			if ( LevelPlayers->FirstElem == TempPtr1 &&
				 LevelPlayers->LastElem == TempPtr1 )
				LevelPlayers->FirstElem = LevelPlayers->LastElem = NULL;

			// Jei tai pirmasis elementas, tai nurodome jam antraji.
			else if ( LevelPlayers->FirstElem == TempPtr1 )
				LevelPlayers->FirstElem = LevelPlayers->FirstElem->Next;
			
			// Jei tai paskutinis elementas, tai nurodome jam priespaskutini.
			else if ( LevelPlayers->LastElem == TempPtr1 )
				LevelPlayers->LastElem = TempPtr2;

			// Sudeliojame rodykles kaip reikia.
			TempPtr2->Next = TempPtr1->Next;

			// Sunaikiname rastaji informacini bloka.
			free ( TempPtr1 );

			// Pazymime rezultato kintamaji teigiamai.
			Result = 1;

			break;
		}

		// Jei dar neradome, tai paslenkame rodykles taip, kad jos
		// eitu viena paskui kita.
		TempPtr2 = TempPtr1;
		TempPtr1 = TempPtr1->Next;
	}

		// Na ir pabaigoje, t.y. jau iterpe nauja lygio dalyvi,
	// galime atlaisvinti sinchronizacini objekta.
	if ( LevelPlayers == &FirstLevelPlayers )

#ifdef	WIN32OS
		ReleaseMutex (hFLPMutex);
#else
		pthread_mutex_unlock (&ptFLPMutex);
#endif

	else if ( LevelPlayers == &SecondLevelPlayers )

#ifdef	WIN32OS
		ReleaseMutex (hSLPMutex);
#else
		pthread_mutex_unlock (&ptSLPMutex);
#endif


	return Result;
}
//-----------------------------------------


//-----------------------------------------
// Uzduoties generavimo funkcija.
void GenerateNewTask (char* Task, const int Level, long *lnResult,
					  double *fResult, char *cResult)
{
	// Visu galimu funkciju masyvas.
	char* Functions [15] = {"add", "sub", "mul", "div", "mod", "abs",
							"hex", "bin", "oct", "ceil", "floor", "pow",
							"sqrt", "sin", "cos"};

	char Temp [100] = {0};			// Buferis konvertavimui ir t.t.
	unsigned int FunctionIndex;		// Funkciju masyvo indeksas.
	int	nDigit1, nDigit2;			// Sveikieji skaiciai veiksmams.
	int Counter, Cnt, Flag = 0;		// skaitliukai.
	double fDigit1, fDigit2;		// Realus skaiciai veiksmams.
	char *chPtr;
	int SecondTime = 0;

	long lnResultStorage = 0;
	double fResultStorage = 0.0;
	char cResultStorage [100] = {0};
	char TaskStorage [200] = {0};


	// Sugeneruojame indeksa.
	FunctionIndex = (rand () * 15) / RAND_MAX;


LABEL:
	// Pagall turima funkcija atliekame reikiamus veiksmus
	if ( 0 == strcmp (Functions [FunctionIndex], "add") )
	{
		// Sugeneruojame du sveikus skaicius.
		nDigit1 = rand ();
		nDigit2 = rand ();

		// Konvertuojame juos i eilutes.
		itoa (nDigit1, Temp, 10);
		strcpy (Task, Temp);
		strcat (Task, " + ");
		itoa (nDigit2, Temp, 10);
		strcat (Task, Temp);

		// Atliekame skaiciu sudeti ir patalpiname ja i rezultato lauka.
		(*lnResult) = (nDigit1 + nDigit2);
		(*fResult) = 999999999.0;
		strcpy (cResult, "");
	}
	else if ( 0 == strcmp (Functions [FunctionIndex], "sub") )
	{
		// Sugeneruojame du sveikus skaicius.
		nDigit1 = rand ();
		nDigit2 = rand ();

		// Konvertuojame juos i eilutes.
		itoa (nDigit1, Temp, 10);
		strcpy (Task, Temp);
		strcat (Task, " - ");
		itoa (nDigit2, Temp, 10);
		strcat (Task, Temp);

		// Atliekame rezultato gavima ir jo priskyrima rezult. kint.
		(*lnResult) = (nDigit1 - nDigit2);
		(*fResult) = 999999999.0;
		strcpy (cResult, "");
	}
	else if ( 0 == strcmp (Functions [FunctionIndex], "mul") )
	{
		// Sugeneruojame du sveikus skaicius.
		nDigit1 = rand ()*100/RAND_MAX;
		nDigit2 = rand ()*100/RAND_MAX;

		// Konvertuojame juos i eilutes.
		itoa (nDigit1, Temp, 10);
		strcpy (Task, Temp);
		strcat (Task, " * ");
		itoa (nDigit2, Temp, 10);
		strcat (Task, Temp);

		// Atliekame rezultato gavima ir jo priskyrima rezult. kint.
		(*lnResult) = (nDigit1 * nDigit2);
		(*fResult) = 999999999.0;
		strcpy (cResult, "");
	}
	else if ( 0 == strcmp (Functions [FunctionIndex], "div") )
	{
		// Sugeneruojame du sveikus skaicius.
		nDigit1 = rand ()*1000/RAND_MAX;
		nDigit2 = rand ()*1000/RAND_MAX;

		// Konvertuojame juos i eilutes.
		itoa (nDigit1, Temp, 10);
		strcpy (Task, Temp);
		strcat (Task, " / ");
		itoa (nDigit2, Temp, 10);
		strcat (Task, Temp);

		// Atliekame rezultato gavima ir jo priskyrima rezult. kint.
		(*lnResult) = 999999999;
		(*fResult) = (nDigit1 / nDigit2);
		strcpy (cResult, "");
	}
	else if ( 0 == strcmp (Functions [FunctionIndex], "mod") )
	{
		// Sugeneruojame du sveikus skaicius.
		nDigit1 = rand ()*1000/RAND_MAX;
		nDigit2 = rand ()*1000/RAND_MAX;

		// Konvertuojame juos i eilutes.
		itoa (nDigit1, Temp, 10);
		strcpy (Task, Temp);
		strcat (Task, " mod ");
		itoa (nDigit2, Temp, 10);
		strcat (Task, Temp);

		// Atliekame rezultato gavima ir jo priskyrima rezult. kint.
		(*lnResult) = (nDigit1 % nDigit2);
		(*fResult) = 999999999.0;
		strcpy (cResult, "");
	}
	else if ( 0 == strcmp (Functions [FunctionIndex], "abs") )
	{
		// Sugeneruojame sveika skaiciu.
		nDigit1 = rand ();
		nDigit2 = rand ();
		if ( nDigit2 > 1000 ) nDigit1 = 0 - nDigit1;

		// Konvertuojame juos i eilutes.
		itoa (nDigit1, Temp, 10);
		sprintf (Task, "| %s |", Temp);

		// Atliekame rezultato gavima ir jo priskyrima rezult. kint.
		(*lnResult) = abs (nDigit1);
		(*fResult) = 999999999.0;
		strcpy (cResult, "");
	}
	else if ( 0 == strcmp (Functions [FunctionIndex], "hex") )
	{
		// Sugeneruojame sveika skaiciu.
		nDigit1 = rand ()*100/RAND_MAX;
		
		// Konvertuojame ji i eilute.
		itoa (nDigit1, Temp, 10);
		sprintf (Task, "hex ( %s )", Temp);
		
		// Atliekame rezultato gavima ir jo priskyrima rezult. kint.
		(*lnResult) = 999999999;
		(*fResult) = 999999999.0;
		sprintf (cResult, "%x", nDigit1);
	}
	else if ( 0 == strcmp (Functions [FunctionIndex], "bin") )
	{
		// Sugeneruojame sveika skaiciu.
		nDigit1 = rand ()*100/RAND_MAX;
		
		// Konvertuojame ji i eilute.
		itoa (nDigit1, Temp, 10);
		sprintf (Task, "bin ( %s )", Temp);
		
		// Atliekame rezultato gavima ir jo priskyrima rezult. kint.
		(*lnResult) = 999999999;
		(*fResult) = 999999999.0;

		// Atliekame dvejetainio skaiciaus gavima dalindami stulpeliu.
		Counter = 0;
		while ( nDigit1 != 1 && nDigit1 != 0 )
		{
			nDigit2 = (int)(nDigit1 / 2);
			Temp [Counter] = (nDigit1 - (nDigit2 * 2)) + 0x30;
			nDigit1 = nDigit2;
			Counter++;
		}
		Temp [Counter] = nDigit1 + 0x30;
		Temp [Counter + 1] = '\0';

		// Atvirksciai perkpijuojame gauta rezultata, kad jis butu teisingas.		
		for (Counter = (strlen (Temp) - 1), Cnt = 0; Counter >= 0; Counter--, Cnt++ )
		{
			if ( Flag == 0 && Temp [Counter] == '0' )
			{ --Cnt; continue; }
			cResult [Cnt] = Temp [Counter];
			Flag = 1;
		}
		cResult [Cnt] = '\0';
		if ( 0 == strcmp (cResult, "") )
			strcpy (cResult, "0");
	}
	else if ( 0 == strcmp (Functions [FunctionIndex], "oct") )
	{
		// Sugeneruojame sveika skaiciu.
		nDigit1 = rand ()*100/RAND_MAX;
		
		// Konvertuojame ji i eilute.
		itoa (nDigit1, Temp, 10);
		sprintf (Task, "oct ( %s )", Temp);
		
		// Atliekame rezultato gavima ir jo priskyrima rezult. kint.
		(*lnResult) = 999999999;
		(*fResult) = 999999999.0;
		sprintf (cResult, "%o", nDigit1);
	}
	else if ( 0 == strcmp (Functions [FunctionIndex], "ceil") )
	{
		// Sugeneruojame du realius skaicius.
		fDigit1 = (double)rand ();
		fDigit2 = (double)rand ();

		// Padaliname juos.
		fDigit1 = fDigit2 / fDigit1;
		
		// Konvertuojame juos i eilute.
		chPtr = fcvt (fDigit1, 4, &Counter, &Flag);
		sprintf (Task, "] 0.%s e%d [", chPtr, Counter);

		// Atliekame rezultato gavima ir jo priskyrima rezult. kint.
		(*lnResult) = (long)ceil (fDigit1);
		(*fResult) = 999999999.0;
		strcpy (cResult, "");
	}
	else if ( 0 == strcmp (Functions [FunctionIndex], "floor") )
	{
		// Sugeneruojame du realius skaicius.
		fDigit1 = (double)rand ();
		fDigit2 = (double)rand ();

		// Padaliname juos.
		fDigit1 = fDigit2 / fDigit1;
		
		// Konvertuojame juos i eilute.
		chPtr = fcvt (fDigit1, 4, &Counter, &Flag);
		sprintf (Task, "[ 0.%s e%d ]", chPtr, Counter);

		// Atliekame rezultato gavima ir jo priskyrima rezult. kint.
		(*lnResult) = (long)floor (fDigit1);
		(*fResult) = 999999999.0;
		strcpy (cResult, "");
	}
	else if ( 0 == strcmp (Functions [FunctionIndex], "pow") )
	{
		// Sugeneruojame du sveikus skaicius.
		nDigit1 = rand ()*11/RAND_MAX;
		nDigit2 = rand ()*11/RAND_MAX;

		// Supakuojame juos i uzduoties buferi.
		itoa (nDigit1, Temp, 10);
		sprintf (Task, "%d ^ ", nDigit1);
		itoa (nDigit2, Temp, 10);
		strcat (Task, Temp);

		// Atliekame rezultato suskaiciavima ir priskyrima rezultato kintamajam.
		(*lnResult) = (long)pow ((double)nDigit1, (double)nDigit2);
		(*fResult) = 999999999.0;
		strcpy (cResult, "");
	}
	else if ( 0 == strcmp (Functions [FunctionIndex], "sqrt") )
	{
		// Sugeneruojame viena sveika skaiciu.
		nDigit1 = rand ()*100/RAND_MAX;

		// Pakeliame ji kvadratu.
		fDigit1 = pow ((double)nDigit1, 2.0);

		// Supakuojame ji i uzduoties buferi.
		chPtr = fcvt (fDigit1, 0, &Counter, &Flag);
		if ( 0 == strcmp (chPtr, "") )
			strcpy (chPtr, "0");
		sprintf (Task, "sqrt ( %s )", chPtr);

		// Atliekame rezultato paskaiciavima ir patalpinima i rez. kint.
		(*lnResult) = (long)sqrt (fDigit1);
		(*fResult) = 999999999.0; sqrt (fDigit1);
		strcpy (cResult, "");
	}
	else if ( 0 == strcmp (Functions [FunctionIndex], "sin") )
	{
		// Sugeneruojame viena sveika skaiciu,
		// kuris bus 15 kartotinis nuo 0 iki 360.
		nDigit1 = (rand ()*25/RAND_MAX)*15;
		
		// Supakuojame ji i uzduoties paketa.
		itoa (nDigit1, Temp, 10);
		sprintf (Task, "sin ( %s )", Temp);

		// Atliekame rezultato paskaiciavima ir patalpinima i rez. kint.
		(*lnResult) = 999999999;
		(*fResult) = sin ((double)((3.1415926535/180) * nDigit1));
		strcpy (cResult, "");
	}
	else if ( 0 == strcmp (Functions [FunctionIndex], "cos") )
	{
		// Sugeneruojame viena sveika skaiciu,
		// kuris bus 15 kartotinis nuo 0 iki 360.
		nDigit1 = (rand ()*25/RAND_MAX)*15;
		
		// Supakuojame ji i uzduoties paketa.
		itoa (nDigit1, Temp, 10);
		sprintf (Task, "cos ( %s )", Temp);

		// Atliekame rezultato paskaiciavima ir patalpinima i rez. kint.
		(*lnResult) = 999999999;
		(*fResult) = cos ((double)((3.1415926535/180) * nDigit1));
		strcpy (cResult, "");
	}


//-------------------------------------------------------------------
//	PIRMO LYGIO UZDUOTIES GENERAVIMO PABAIGA
	// Jeigu tai buvo kreipinys is pirmojo lygmens, tai baigiame.
	if ( 1 == Level ) 
	{
		strcat (Task, "\n");
		return;
	}

	// Priesingu atveju, jei buvo sugeneruotos f-jos
	// hex, bin, oct, tai toliau irgi nieko nedarome.
	else if ( FunctionIndex == 6 ||
			  FunctionIndex == 7 ||
			  FunctionIndex == 8 )
	{
		strcat (Task, "\n");
		return;
	}

	// Priesingu atveju, apgaubiame skliausteliais jau
	// tureta uzduoti ir tesiame toliau.
	else 
	{
		strcpy (Temp, "( ");
		strcat (Temp, Task);
		strcat (Temp, " )");
		strcpy (Task, Temp);
	}
//-------------------------------------------------------------------


	// Nukopijuojame turimus rezultatus i saugykla.
	if ( !SecondTime )
	{
		lnResultStorage = (*lnResult);
		fResultStorage = (*fResult);
		strcpy (cResultStorage, cResult);
		strcpy (TaskStorage, Task);

		SecondTime = 1;

		// Sugeneruojame funkcijos indeksa, tik toki, kad
		// tai nebutu kitos nei desimtaine skaiciavimo sistemos
		// funkcija.
		FunctionIndex = rand ()*15/RAND_MAX;
		while ( 6 == FunctionIndex || 7 == FunctionIndex || 8 == FunctionIndex )
			FunctionIndex = rand ()*15/RAND_MAX;

		// Kreipiames dar karta i funkciju generavimo rutina.
		goto LABEL;
	}

	else
	{
		// Dabar sugeneruojame dar viena funkcija is paprastuju.
		FunctionIndex = rand ()*4/RAND_MAX;
		if ( FunctionIndex == 0 ) // Jei ADD
		{
			// Patalpiname uzduoti i Task.
			strcpy (Temp, Task);
			strcpy (Task, TaskStorage);
			strcat (Task, " + ");
			strcat (Task, Temp);

			// Dabar reikia suskaiciuoti rezultata.
			if ( (*lnResult) != 999999999 ) // lnResult netuscias o fResult tuscias.
			{
				if ( lnResultStorage != 999999999 ) // Abu long'ai.
				{
					(*lnResult) = (*lnResult) + lnResultStorage;
					(*fResult) = 999999999.0;
					strcpy (cResult, "");
				}
				else // vienas long kitas double
				{
					(*fResult) = (*lnResult) + fResultStorage;
					(*lnResult) = 999999999;
					strcpy (cResult, "");
				}
			}
			else // lnResult tuscias, o fResult netuscias.
			{
				if ( lnResultStorage != 999999999 ) // vienas double kitas long.
				{
					(*fResult) = (*fResult) + lnResultStorage;
					(*lnResult) = 999999999;
					strcpy (cResult, "");
				}
				else // Abu double.
				{
					(*fResult) = (*fResult) + fResultStorage;
					(*lnResult) = 999999999;
					strcpy (cResult, "");
				}
			}
		}

		else if ( FunctionIndex == 1 )	// Jei SUB
		{
			// Patalpiname uzduoti i Task.
			strcpy (Temp, Task);
			strcpy (Task, TaskStorage);
			strcat (Task, " - ");
			strcat (Task, Temp);

			// Dabar reikia suskaiciuoti rezultata.
			if ( (*lnResult) != 999999999 ) // lnResult netuscias o fResult tuscias.
			{
				if ( lnResultStorage != 999999999 ) // Abu long'ai.
				{
					(*lnResult) = lnResultStorage - (*lnResult);
					(*fResult) = 999999999.0;
					strcpy (cResult, "");
				}
				else // vienas long kitas double
				{
					(*fResult) = fResultStorage - (double)(*lnResult);
					(*lnResult) = 999999999;
					strcpy (cResult, "");
				}
			}
			else // lnResult tuscias, o fResult netuscias.
			{
				if ( lnResultStorage != 999999999 ) // vienas double kitas long.
				{
					(*fResult) = (double)lnResultStorage - (*fResult);
					(*lnResult) = 999999999;
					strcpy (cResult, "");
				}
				else // Abu double.
				{
					(*fResult) = fResultStorage - (*fResult);
					(*lnResult) = 999999999;
					strcpy (cResult, "");
				}
			}
		}

		else if ( FunctionIndex == 2 )	// Jei MUL
		{
			// Patalpiname uzduoti i Task.
			strcpy (Temp, Task);
			strcpy (Task, TaskStorage);
			strcat (Task, " * ");
			strcat (Task, Temp);

			// Dabar reikia suskaiciuoti rezultata.
			if ( (*lnResult) != 999999999 ) // lnResult netuscias o fResult tuscias.
			{
				if ( lnResultStorage != 999999999 ) // Abu long'ai.
				{
					(*lnResult) = (*lnResult) * lnResultStorage;
					(*fResult) = 999999999.0;
					strcpy (cResult, "");
				}
				else // vienas long kitas double
				{
					(*fResult) = (double)(*lnResult) * fResultStorage;
					(*lnResult) = 999999999;
					strcpy (cResult, "");
				}
			}
			else // lnResult tuscias, o fResult netuscias.
			{
				if ( lnResultStorage != 999999999 ) // vienas double kitas long.
				{
					(*fResult) = (*fResult) * lnResultStorage;
					(*lnResult) = 999999999;
					strcpy (cResult, "");
				}
				else // Abu double.
				{
					(*fResult) = (*fResult) * fResultStorage;
					(*lnResult) = 999999999;
					strcpy (cResult, "");
				}
			}
		}

		else if ( FunctionIndex == 3 )	// Jei DIV
		{
			// Patalpiname uzduoti i Task.
			strcpy (Temp, Task);
			strcpy (Task, TaskStorage);
			strcat (Task, " / ");
			strcat (Task, Temp);

			// Dabar reikia suskaiciuoti rezultata.
			if ( (*lnResult) != 999999999 ) // lnResult netuscias o fResult tuscias.
			{
				if ( lnResultStorage != 999999999 ) // Abu long'ai.
				{
					(*lnResult) = 999999999;
					(*fResult) = lnResultStorage / (*lnResult);
					strcpy (cResult, "");
				}
				else // vienas long kitas double
				{
					(*fResult) = fResultStorage / (double)(*lnResult);
					(*lnResult) = 999999999;
					strcpy (cResult, "");
				}
			}
			else // lnResult tuscias, o fResult netuscias.
			{
				if ( lnResultStorage != 999999999 ) // vienas double kitas long.
				{
					(*fResult) = lnResultStorage / (*fResult);
					(*lnResult) = 999999999;
					strcpy (cResult, "");
				}
				else // Abu double.
				{
					(*fResult) = fResultStorage / (*fResult);
					(*lnResult) = 999999999;
					strcpy (cResult, "");
				}
			}
		}

		strcat (Task, "\n");
	}
}
//------------------------------------------


//------------------------------------------
// Pirmo gero atsakymo isrinkimo funkcija.
int SelectFirstCorrectAnswer (LEVEL_INFO_LIST *LevelPlayers, long *lnCorAns, double *fCorAns,
							  char *cCorAns, fd_set *ListOfAnswerers, char *AnswererName)
{
	char CorrectAnswer [100] = {0};		// Tesingo atsakymo eilute.
	char UserAnswer [100] = {0};		// Vartotojo atsakymui.
	CLIENT_INFO *TempPtr;				// Rodykle i info struktura.
	time_t BestTime, temp, UserTime;	// Pirmiausiai issiuntusio laikui.
	unsigned int iCounter;				// Skaitliukas.
	int Result = 0;


	// Isrenkame, kuriame is atsakymo lauku yra atsakymas.
	if ( *lnCorAns == 999999999 &&
		 0 == strcmp (cCorAns, "") )
	{
		gcvt (*fCorAns, 4, CorrectAnswer);
		iCounter = strlen (CorrectAnswer);
		if ( CorrectAnswer [iCounter - 1] == '.' )
		{
			CorrectAnswer [iCounter] = '0';
			CorrectAnswer [iCounter + 1] = '0';
			CorrectAnswer [iCounter + 2] = '0';
			CorrectAnswer [iCounter + 3] = '\0';
		}
	}
	else if ( *fCorAns == 999999999.0 &&
		  	  0 == strcmp (cCorAns, "") )
	{ ltoa (*lnCorAns, CorrectAnswer, 10); }
	else if ( *lnCorAns == 999999999 &&
			  *fCorAns == 999999999.0 )
	{ strcpy (CorrectAnswer, cCorAns); }


	// Apeiname visus sio viktorinos lygio dalyvius ir
	// tikriname, kurie is ju pateikia atsakyma, ar ju
	// atsakymas teisingas, ar jie atsake pirmi.
	TempPtr = LevelPlayers->FirstElem;
	BestTime = 0;
	while ( TempPtr != NULL )
	{
		// Jei zaidejas pateike atsakyma.
		if ( 0 != strcmp (TempPtr->AnsToCurTask, "") )
		{
			// Itraukiame i atsakinejusiu dalyviu sarasa.
			FD_SET (TempPtr->SocketNumber, ListOfAnswerers);

			// Isskiriame atsakyma.
			for (iCounter = 4; iCounter < strlen (TempPtr->AnsToCurTask); iCounter++ )
				UserAnswer [iCounter - 4] = TempPtr->AnsToCurTask [iCounter];
			UserAnswer [iCounter - 4] = '\0';

			// Isskiriame laika, kada atsakymas buvo issiustas.
			UserTime = (time_t)0;
			UserTime |= (unsigned char)TempPtr->AnsToCurTask [3];
			UserTime <<= 24;
			temp = (unsigned char)TempPtr->AnsToCurTask [2];
			temp <<= 16;
			UserTime |= temp;
			temp = (unsigned char)TempPtr->AnsToCurTask [1];
			temp <<= 8;
			UserTime |= temp;
			UserTime |= (unsigned char)TempPtr->AnsToCurTask [0];

			// Jei atsakymas teisingas.
			if ( 0 == strcmp (CorrectAnswer, UserAnswer) )
			{
				Result = 1;

				// Patikriname ar jo laikas geresnis.
				if ( BestTime == 0 ) {
					BestTime = UserTime;
					strcpy (AnswererName, TempPtr->ClientName);
				}
				else
				{
					// Jei laikas geresnis, tai isidemime ji ir zaidejo info strukt.
					if ( UserTime < BestTime )
					{
						BestTime = UserTime;
						strcpy (AnswererName, TempPtr->ClientName);
					}
				}
			}

			// Taip pat isvalome atsakymo buferi.
			strcpy (TempPtr->AnsToCurTask, "");
		}

		// Einame prie sekancio elemento.
		TempPtr = TempPtr->Next;
	}

	return Result;
}
//---------------------------------------------


//---------------------------------------------
// Dalyvio atsakymo i klausima iterpimas i jo info struktura.
void InsertUserAnswer (SOCKET ClientSockDesc, char *Answer)
{
	CLIENT_INFO *TempPtr;	// Nuoroda i kliento inform. struktura.
	int Flag;				// Veliavele.


	// Randame lygi, kuriame yra atsakyma pateikiantis
	// klientas, ir jo info strukt.
	TempPtr = FirstLevelPlayers.FirstElem;
	Flag = 0;
	while ( TempPtr != NULL )
	{
		// Jei radome.
		if ( TempPtr->SocketNumber == ClientSockDesc )
		{ Flag = 1;	break; }

		// Einame toliau.
		TempPtr = TempPtr->Next;
	}

	if ( Flag == 0 )
	{
			TempPtr = SecondLevelPlayers.FirstElem;
			while ( TempPtr != NULL )
			{
				// Jei radome.
				if ( TempPtr->SocketNumber == ClientSockDesc )
				{ Flag = 1; break; }

				// Einame toliau.
				TempPtr = TempPtr->Next;
			}
	}

	// Nukopijuojame vartotojo pateikiama atsakyma i tam skirta
	// jo info strukturos dali.
	strcpy (TempPtr->AnsToCurTask, Answer);
}
//-------------------------------------------


//-------------------------------------------
// Funkcija statistinei informacijai apdoroti.
void HandleStatisticsStuff (LEVEL_INFO_LIST *Players, char *Name)
{
	static char PrevAnswerer [30] = {0};	// Pries tai atsakes.
	CLIENT_INFO *TempPtr1, *TempPtr;		// Laikina rodykle.


	// Prasibegam zaideju sarasu, kol randam atsakiusiji.
	TempPtr1 = Players->FirstElem;
	while ( TempPtr1 != NULL )
	{
		// Jei radom, iseinam is ciklo.
		if ( 0 == strcmp (TempPtr1->ClientName, Name) )
			TempPtr = TempPtr1;
		else
			TempPtr1->AnsInQueue = 0;

		// Einame prie sekancio elemento.
		TempPtr1 = TempPtr1->Next;
	}

	// Jei tas pats kaip ir pries tai atsake, tai padidinam jo
	// is eiles atsakytu klausimu skaitliuka.
	if ( 0 == strcmp (PrevAnswerer, "") ||
		0 == strcmp (PrevAnswerer, TempPtr->ClientName) )
		TempPtr->AnsInQueue++;
	else
		TempPtr->AnsInQueue = 0;

	// Padidinam tasku skaiciu.
	TempPtr->Points++;
	
	// Pagal is eiles atsakytu kl. skaiciu
	// modifikuojame zaidejo ranga.
	if ( TempPtr->AnsInQueue == 3 )
		TempPtr->Rang = TIRO;
	else if ( TempPtr->AnsInQueue == 5 )
		TempPtr->Rang = MEDIOCRE;
	else if ( TempPtr->AnsInQueue == 7 )
		TempPtr->Rang = WHIZZ;
	else if ( TempPtr->AnsInQueue == 10 )
		TempPtr->Rang = EXPERT;
}
//----------------------------------------------


//----------------------------------------------
//	KOMANDU REALIZACIJA
// Komandos TOP realizacija.
void Command_TOP (SOCKET ClientSockDesc)
{
	CLIENT_INFO *Players;	// Lygio, kuriame yra klausiantysis klientas, zaideju masyvas.
	CLIENT_INFO *TempPtr;	// Reikalinga rodykle prabegimui per zaideju sarasa.
	CLIENT_INFO *PtrTemp;	// :] reikia ir tiek;
	CLIENT_INFO TempStruct;
	unsigned int Flag;		// Veliavele.
	int PlayerQuantity = 0;	// Zaideju skaicius lygyje.
	int iCounter, jCounter;	// Skaitliukai.
	char DataBuffer [2000] = {0}; // Buferis, skirtas TOP duomenu siuntimui.
	char Temp [200] = {0};	// Pagalbinis buferis.


	// Randame lygi, kuriame yra klausiantysis klientas.
	TempPtr = FirstLevelPlayers.FirstElem;
	Flag = 0;
	while ( TempPtr != NULL )
	{
		// Jei radome.
		if ( TempPtr->SocketNumber == ClientSockDesc )
		{ 
			Flag = 1;
			TempPtr = FirstLevelPlayers.FirstElem;
			break;
		}

		// Einame toliau.
		TempPtr = TempPtr->Next;
	}

	if ( Flag == 0 )
	{
			TempPtr = SecondLevelPlayers.FirstElem;
			while ( TempPtr != NULL )
			{
				// Jei radome.
				if ( TempPtr->SocketNumber == ClientSockDesc )
				{ 
					Flag = 1;
					TempPtr = SecondLevelPlayers.FirstElem;
					break;
				}

				// Einame toliau.
				TempPtr = TempPtr->Next;
			}
	}


	// Suskaiciuojame kiek yra dalyviu siame lygyje.
	PtrTemp = TempPtr;
	while ( TempPtr != NULL )
	{ PlayerQuantity++; TempPtr = TempPtr->Next; }


	// Isskiriame vietos masyvui.
	Players = (CLIENT_INFO*) malloc (PlayerQuantity * sizeof (CLIENT_INFO));


	// Nukopijuojame zaideju informacija i sita masyva.
	TempPtr = PtrTemp;
	iCounter = 0;
	while ( TempPtr != NULL )
	{
		// Nukopijuojame informacija.
		strcpy (Players [iCounter].ClientName, TempPtr->ClientName);
		Players [iCounter].ParticipationLevel = TempPtr->ParticipationLevel;
		Players [iCounter].Points = TempPtr->Points;
		Players [iCounter].Rang = TempPtr->Rang;

		// Einame prie sekancio elemento;
		TempPtr = TempPtr->Next;
		iCounter++;
	}


	// Isrusiuojame turima informacijos masyva pagal tasku skaiciu.
	for ( iCounter = (PlayerQuantity - 1); iCounter >= 0; iCounter-- )
	{
		for ( jCounter = 1; jCounter <= iCounter; jCounter++ )
		{
			if ( Players [jCounter - 1].Points < Players [jCounter].Points )
			{
				strcpy (TempStruct.ClientName, Players [jCounter - 1].ClientName);
				TempStruct.ParticipationLevel = Players [jCounter - 1].ParticipationLevel;
				TempStruct.Points = Players [jCounter - 1].Points;
				TempStruct.Rang = Players [jCounter - 1].Rang;
				
				strcpy (Players [jCounter - 1].ClientName, Players [jCounter].ClientName);
				Players [jCounter - 1].ParticipationLevel = Players [jCounter].ParticipationLevel;
				Players [jCounter - 1].Points = Players [jCounter].Points;
				Players [jCounter - 1].Rang = Players [jCounter].Rang;

				strcpy (Players [jCounter].ClientName, TempStruct.ClientName);
				Players [jCounter].ParticipationLevel = TempStruct.ParticipationLevel;
				Players [jCounter].Points = TempStruct.Points;
				Players [jCounter].Rang = TempStruct.Rang;
			}
		}
	}

	
	// Suformuojame zinute kuria pasiusime.
	strcpy (DataBuffer, "\n/*****************************************************************************\\\n");
	strcat (DataBuffer, " Level's top participants.\n\n");
	sprintf (Temp, " %20s | %10s | %10s \n", "NAME", "POINTS", "RANG");
	strcat (DataBuffer, Temp);
	strcat (DataBuffer, " ----------------------------------------------- \n");
	for ( iCounter = 0; iCounter < PlayerQuantity; iCounter++ )
	{
		sprintf (Temp, " %20s | %10d | ",
			Players [iCounter].ClientName,
			Players [iCounter].Points);
		strcat (DataBuffer, Temp);
		if ( Players [iCounter].Rang == LOSER )
			sprintf (Temp, "%10s \n", "Loser");
		else if ( Players [iCounter].Rang == TIRO )
			sprintf (Temp, "%10s \n", "Tiro");
		else if ( Players [iCounter].Rang == MEDIOCRE )
			sprintf (Temp, "%10s \n", "Mediocre");
		else if ( Players [iCounter].Rang == WHIZZ )
			sprintf (Temp, "%10s \n", "Whizz");
		else if ( Players [iCounter].Rang == EXPERT )
			sprintf (Temp, "%10s \n", "Expert");
		strcat (DataBuffer, Temp);
	}
	strcat (DataBuffer, "\\*****************************************************************************/\n\n");

	
	// Supakuojame pranesima.
	MarshalPacket (DataBuffer, strlen (DataBuffer));

	// Issiunciame ji.
	while ( SOCKET_ERROR == SendAllData (&ClientSockDesc,
		DataBuffer, strlen (DataBuffer)) );
}



// Komandos STATS realizacija.
void Command_STATS (SOCKET ClientSockDesc, char *Command)
{
	char NameToInformAbout [30] = {0};	// Vardas, apie kuri klientas pareiske nora gauti stat.
	unsigned int iCounter;				// Skaitliukas.
	char MessageToSend [2000] = {0};	// Gautai informacija pasiusti skirtas buferis.
	char Temp [200] = {0};				// Pagalbinis buferis.
	CLIENT_INFO *TempPtr;				// Pointeris i kurio nors levelio dalyviu sarasa.
	unsigned int Flag;					// Reikalinga veliavele.
	

	// Bandome isskirti varda.
	for ( iCounter = 6; iCounter < strlen (Command); iCounter++ )
		NameToInformAbout [iCounter - 6] = Command [iCounter];
	NameToInformAbout [iCounter - 6] = '\0';


	// Randame lygi, kuriame yra klausiantysis klientas.
	TempPtr = FirstLevelPlayers.FirstElem;
	Flag = 0;
	while ( TempPtr != NULL )
	{
		// Jei radome.
		if ( TempPtr->SocketNumber == ClientSockDesc )
		{ 
			Flag = 1;
			TempPtr = FirstLevelPlayers.FirstElem;
			break;
		}

		// Einame toliau.
		TempPtr = TempPtr->Next;
	}

	if ( Flag == 0 )
	{
			TempPtr = SecondLevelPlayers.FirstElem;
			while ( TempPtr != NULL )
			{
				// Jei radome.
				if ( TempPtr->SocketNumber == ClientSockDesc )
				{ 
					Flag = 1;
					TempPtr = SecondLevelPlayers.FirstElem;
					break;
				}

				// Einame toliau.
				TempPtr = TempPtr->Next;
			}
	}


	// Bandome kliento lygyje surasti vartotoja su jo nurodytu vardu.
	while ( TempPtr != NULL )
	{
		// Jei jau radome toki vartotoja, tai sutekiame visa jo informacija klausianciajam.
		if ( 0 == strcmp (NameToInformAbout, TempPtr->ClientName) )
		{
			strcpy (MessageToSend, "\n/*****************************************************************************\\\n");
			strcat (MessageToSend, " MathServer Client Information.\n\n");
			sprintf (Temp, " Name               : %s\n", TempPtr->ClientName);
			strcat (MessageToSend, Temp);
			sprintf (Temp, " Participation level: %d\n", TempPtr->ParticipationLevel);
			strcat (MessageToSend, Temp);
			sprintf (Temp, " Points             : %d\n", TempPtr->Points);
			strcat (MessageToSend, Temp);
			sprintf (Temp, " Answers in turn    : %d\n", TempPtr->AnsInQueue);
			strcat (MessageToSend, Temp);
			sprintf (Temp, " Rang               : ");
			if ( TempPtr->Rang == LOSER )
				strcat (Temp, "Loser\n");
			else if ( TempPtr->Rang == TIRO )
				strcat (Temp, "Tiro\n");
			else if ( TempPtr->Rang == MEDIOCRE )
				strcat (Temp, "Mediocre\n");
			else if ( TempPtr->Rang == WHIZZ )
				strcat (Temp, "Whizz\n");
			else if ( TempPtr->Rang == EXPERT )
				strcat (Temp, "Expert\n");
			strcat (MessageToSend, Temp);
			strcat (MessageToSend, "\\*****************************************************************************/\n\n");

			MarshalPacket (MessageToSend, strlen (MessageToSend));
			while ( SOCKET_ERROR == SendAllData (&ClientSockDesc,
				MessageToSend, strlen (MessageToSend)) );
			return;
		}

		// Einame prie sekancio elemento.
		TempPtr = TempPtr->Next;
	}

	// issiunciame perspejima, kad tokio vartotojo lygyje nera.
	strcpy (MessageToSend, "\n/*****************************************************************************\\\n");
	strcat (MessageToSend, "MathServer: you have requested information about non-existing participant.\n");
	strcat (MessageToSend, "\\*****************************************************************************/\n\n");
	MarshalPacket (MessageToSend, strlen (MessageToSend));
	while ( SOCKET_ERROR == SendAllData (&ClientSockDesc,
		MessageToSend, strlen (MessageToSend)) );
}



// Komandos QUIT realizacija.
void Command_QUIT (SOCKET ClientSockDesc)
{
	char DataBuffer [500] = {0};	// Duomenu siuntimui skirtas buferis.

	// Nukopijuojame i buferi pranesima.
	strcpy (DataBuffer, "\n/*****************************************************************************\\\n");
	strcat (DataBuffer, "MathServer: disconnected successfully.\n");
	strcat (DataBuffer, "\\*****************************************************************************/\n\n");

	// Supakuojame pranesima.
	MarshalPacket (DataBuffer, strlen (DataBuffer));

	// Issiunciame pranesima.
	while ( SOCKET_ERROR == SendAllData (&ClientSockDesc,
		DataBuffer, strlen (DataBuffer)) );
}



// Komandos LEAVE realizacija.
void Command_LEAVE (SOCKET ClientSockDesc)
{
	char Buffer [1000] = {0};	// Duomenu siuntimui reikalingas buferis.


	// Pasaliname kliento informacija is to lygio,
	// kuriame jis dalyvavo, saraso.
	if ( 0 == FindAndRemoveClientData (ClientSockDesc, &FirstLevelPlayers) )
		FindAndRemoveClientData (ClientSockDesc, &SecondLevelPlayers);

	// Pasiunciame pranesima klientui, ka tik palikusiam lygi.
	strcpy (Buffer, "\n/*****************************************************************************\\\n");
	strcat (Buffer, "MathServer: you have left the level. If you want to participate again, JOIN!\n");
	strcat (Buffer, "\\*****************************************************************************/\n\n");
	MarshalPacket (Buffer, strlen (Buffer));
	while ( SOCKET_ERROR == SendAllData (&ClientSockDesc, Buffer, strlen (Buffer)) );
}



// Komandos	INFO realizacija.
void Command_INFO (SOCKET SockDesc)
{
	char InfoMessage [5000] = {0};	// Buferis, skirtas informacinei zinutei saugoti.
	char TempString [200] = {0};	// Laikinas buferis informacijai formatuoti.
	char *TempStr;
	struct hostent *HostEntry;		// Struktura saugoti host info.
	time_t NowTime;					// Sio momento laikui.
	int FLPQ, SLPQ;					// First level player quantity, ...
	CLIENT_INFO *TempPtr;			// rodykle i struktura CLIENT_INFO.


	// Isspausdiname serveryje pranesima.
	printf ("MathServer: retrieving server info at socket %d.\n", SockDesc);

	// Nukopijuojame pavadinimo eilute.
	strcpy (InfoMessage, "\n/*****************************************************************************\\\n");
	strcat (InfoMessage, " MathServer information.\n\n");

	// Randame serverio hosto varda.
	if ( SOCKET_ERROR == gethostname (TempString, sizeof (TempString)) )
		return;

	// Randame serverio IP adresa.
	if ( NULL == (HostEntry = gethostbyname (TempString)) )
		return;

	// Patalpiname sia informacija i informacini buferi.
	sprintf (TempString, "MathServer running on %s - (%s).\n",
		HostEntry->h_name, inet_ntoa (*(struct in_addr*)HostEntry->h_addr));
	strcat (InfoMessage, TempString);

	// Suzinome serverio laika ir patalpiname i informacini buferi.
	time (&NowTime);
	TempStr = asctime (localtime (&NowTime));
	TempStr [strlen (TempStr) - 1] = '\0';
	sprintf (TempString, "It is now %s at MathServer.\n", TempStr);
	strcat (InfoMessage, TempString);

	// Suskaiciuojame lygiu zaideju skaicius.
	FLPQ = SLPQ = 0;
	TempPtr = FirstLevelPlayers.FirstElem;
	while ( TempPtr != NULL )
	{ FLPQ++; TempPtr = TempPtr->Next; }

	TempPtr = SecondLevelPlayers.FirstElem;
	while ( TempPtr != NULL )
	{ SLPQ++; TempPtr = TempPtr->Next; }

	// Pateikiame bazine informacija.
	sprintf (TempString, "MathServer currently offers 2 difficulty levels with %d participants.\n",
		FLPQ + SLPQ);
	strcat (InfoMessage, TempString);

	// Pateikiame pirmo lygio dalyviu sarasa.
	sprintf (TempString, "Level 1 (%d players): ", FLPQ);
	strcat (InfoMessage, TempString);
	TempPtr = FirstLevelPlayers.FirstElem;
	while ( TempPtr != NULL )
	{
		strcat (InfoMessage, TempPtr->ClientName);
		strcat (InfoMessage, ", ");
		TempPtr = TempPtr->Next;
	}
	strcat (InfoMessage, "\n");
	
	// Pateikiame antro lygio dalyviu sarasa.
	sprintf (TempString, "Level 2 (%d players): ", SLPQ);
	strcat (InfoMessage, TempString);
	TempPtr = SecondLevelPlayers.FirstElem;
	while ( TempPtr != NULL )
	{
		strcat (InfoMessage, TempPtr->ClientName);
		strcat (InfoMessage, ", ");
		TempPtr = TempPtr->Next;
	}
	strcat (InfoMessage, "\n");
	strcat (InfoMessage, "\\*****************************************************************************/\n\n");


	// Supakuojame pranesima.
	MarshalPacket (InfoMessage, strlen (InfoMessage));

	// Issiunciame pranesima.
	while ( SOCKET_ERROR == SendAllData (&SockDesc,
		InfoMessage, strlen (InfoMessage)) );
}



// Komandos JOIN realizacija.
void Command_JOIN (SOCKET SockDesc, char *Command, fd_set *MainSet, fd_set *FirstLevelSet,
				   fd_set *SecondLevelSet)
{
	unsigned int LevelToJoin;		// Lygis, i kuri klientas pareiske nora istoti.
	char NameToAssign [30] = {0};	// Vardas, kuriuo klientas pareiske nora uzsiregistruoti.
	unsigned int iCounter;			// Skaitliukas.
	char MessageToSend [2000] = {0};// Zinutei priimtam i lygi klientui pasiusti.
	CLIENT_INFO *TempPtr;			// Pointeris i kurio nors levelio dalyviu sarasa.
	

	// Bandome isskirti is komandos eilutes lygio numeri.
	LevelToJoin = (unsigned int)(Command [5] - 0x30);

	// Bandome isskirti varda.
	for ( iCounter = 7; iCounter < strlen (Command); iCounter++ )
		NameToAssign [iCounter - 7] = Command [iCounter];
	NameToAssign [iCounter - 7] = '\0';


	// Pagal kliento norima lygi priskiriame pointeriui atitinkama reiksme.
	if ( 1 == LevelToJoin )
		TempPtr = FirstLevelPlayers.FirstElem;
	else if ( 2 == LevelToJoin )
		TempPtr = SecondLevelPlayers.FirstElem;
	

	// Patikriname ar tokiu vardu, kokiu nori uzsiregistruoti sis klientas,
	// dar niekas nera uzsiregistraves.
	while ( TempPtr != NULL )
	{
		// Jei jau toks yra, tai pranesame apie tai klientui ir
		// baigiame sios funkcijos vykdyma.
		if ( 0 == strcmp (NameToAssign, TempPtr->ClientName) )
		{
			strcpy (MessageToSend, "\n/*****************************************************************************\\\n ");
			strcat (MessageToSend, " MathServer: name \'");
			strcat (MessageToSend, NameToAssign);
			strcat (MessageToSend, "\' already exists. Choose another and try again.\n");
			strcat (MessageToSend, "\\*****************************************************************************/\n\nINCORRECT");
			MarshalPacket (MessageToSend, strlen (MessageToSend));
			while ( SOCKET_ERROR == SendAllData (&SockDesc,
				MessageToSend, strlen (MessageToSend)) );
			return;
		}

		// Einame prie sekancio elemento.
		TempPtr = TempPtr->Next;
	}


	// Sukuriame kliento informacijos mazga ir pagal lygi itraukiame
	// i to lygio mazgu sarasa.
	if ( 1 == LevelToJoin )
		InsertClientData (SockDesc, &FirstLevelPlayers,
		NameToAssign, LevelToJoin, FirstLevelSet);
	else if ( 2 == LevelToJoin )
		InsertClientData (SockDesc, &SecondLevelPlayers,
		NameToAssign, LevelToJoin, SecondLevelSet);
	

	// Dabar Pasaliname is pagrindines deskriptoriu aibes soketo deskriptoriu,
	// kuris susijes su siuo klientu.
	FD_CLR (SockDesc, MainSet);


	// Reikia pasiusti pranesima apie sekminga istojima i lygi.
	strcpy (MessageToSend, "\n/*****************************************************************************\\\n ");
	strcat (MessageToSend, NameToAssign);
	strcat (MessageToSend, ", welcome to the level ");
	strcat (MessageToSend, itoa (LevelToJoin, NameToAssign, 10));
	strcat (MessageToSend, " of mathquiz!\n\n");
	strcat (MessageToSend, " STATS name - gives you information about named person.\n");
	strcat (MessageToSend, " TOP        - gives you the list of the level's best participants.\n");
	strcat (MessageToSend, " INFO       - retrieves information about current situation at MathServer.\n");
	strcat (MessageToSend, " LEAVE      - lets you leave the current level of mathquiz.\n");
	strcat (MessageToSend, "\\*****************************************************************************/\n\n");

	// Supakuojame zinute.
	MarshalPacket (MessageToSend, strlen (MessageToSend));

	// Issiunciame ja.
	while ( SOCKET_ERROR == SendAllData (&SockDesc,
		MessageToSend, strlen (MessageToSend)) );	
}
//-----------------------------------------
