//////////////////////////////////////////////////////////////////////////////////////
// Projektas		:	Matematine viktorina.										//
// Projekto tikslas	:	Matematines viktorinos serverio ir kliento realizacija.		//
//----------------------------------------------------------------------------------//
// Failas			:	"math_server_drv.c"											//
// Failo tikslas	:	Realizuoti daugiaklienti matematines viktorinos serveri.	//
// Failo autorius	:	Aidas Semezys.												//
//						Copyright (C), 2003											//
//////////////////////////////////////////////////////////////////////////////////////


//------------------------------------------------------------------------------------
//							HEADER'IU ITRAUKIMAS
//------------------------------------------------------------------------------------
#include	"math_server.h"


//------------------------------------------------------------------------------------
//							PAGRINDINE PROGRAMA
//------------------------------------------------------------------------------------
int main (void)
{
	SOCKET ServSockDesc;	// Serverio pagrindinio soketo-klausytojo deskriptorius.
	fd_set TempSet;			// Pagalbine pagrindines programos soketu aibe.
	fd_set FirstLevelSet, SecondLevelSet; // Aibes lygiams palaikyti.
	unsigned int iCounter;	// Skaitliukas.
	struct timeval TimeVal;	// Laiko struktura dirbti su select().



//------------------------------------------------------------
// Jei kompiliuojama Windows tipo sistemoje, tai reikia
// pradedant darba inicializuoti soketu biblioteka.
#ifdef	WIN32OS
	WSADATA	wsaData;
	if ( -1 == WSAStartup (MAKEWORD (1, 1), &wsaData) )
	{
		printf ("MathServer error: WSAStartup() failed.\n");
		exit ( EXIT_FAILURE );
	}
#endif
//------------------------------------------------------------


	// Bandome sukurti ir suristi su reikiamu adresu ir portu serverio
	// pagrindini deskriptoriu, t.y. inicializuojame serveri.
	if ( INVALID_SOCKET == (ServSockDesc = InitializeServer ()) )
	{
		printf ("MathServer error: server initialization failed.\n");
		exit ( EXIT_FAILURE );
	}


	// Inicializuojame soketu aibes.
	FD_ZERO (&TheMainSet);
	FD_ZERO (&FirstLevelSet);
	FD_ZERO (&SecondLevelSet);
	FD_ZERO (&TempSet);


	// Itraukiame serverio klausanti soketa i pagrindine aibe
	// ir juo inicializuojame maksimalaus deskriptoriaus kintamaji.
	FD_SET (ServSockDesc, &TheMainSet);
	MaxDesc = ServSockDesc;


	// Inicializuojame laiko struktura.
	TimeVal.tv_sec = 0;
	TimeVal.tv_usec = 0;


	//-----------------------------------------------------------
	// Cia turime sukurti ir paleisti dar tris gijas, kurios 
	// kiekviena valdys atskira viktorinos lygi nepriklausomai
	// nuo kitu.
	if ( !CreateThreadsAndMutexes (&FirstLevelSet, &SecondLevelSet) )
		goto EXIT;


	// Pagrindinis amzinas ciklas, kuris palaiko serveri rezimu 'gyvas',
	// kol programa, t.y. serveris, nebus isreikstinai nutraukta.
	while ( 1 )
	{
		// Nukopijuojame pagrindines soketu aibes turini i pagalbine.
		TempSet = TheMainSet;


		// Isrenkame i spagalbines soketu aibes tuos deskriptorius, kurie
		// apraso soketus, turincius duomenu, paruostu skaitymui.
		if ( SOCKET_ERROR == select (MaxDesc + 1, &TempSet, NULL, NULL, &TimeVal) )
		{
			printf ("MathServer error: select() failure in main() module.\n");
			perror ("select");
			goto EXIT;
		}


		// Nuskanuokime galimu deskriptoriu erdve iki turimo maksimalaus.
		for ( iCounter = 0; iCounter <= MaxDesc; iCounter++ )
		{
			// Tikriname su kiekviena skaitliuko reiksme, ar jo aprasomas
			// soketas nepriklauso pagrindinei soketu aibei.
			if ( FD_ISSET (iCounter, &TempSet) )
			{
				// Jei tos skaitliuko reiksmes aprasomas soketas yra 'ServSockDesc',
				// t.y. nauju prisijungimu laukiantis, tai reikia apdoroti naujo
				// kliento prisijungima.
				if ( iCounter == ServSockDesc )
				{
					// Apdorojame nauja prisijungima.
					if ( SOCKET_ERROR == HandleNewConnection (&ServSockDesc,
						&MaxDesc, &TheMainSet) )
						printf ("MathServer error: acceptance of new connection was erroneous.\n");
				}


				// Jei tai ne nauju prisijungimu laukiancio soketo deskriptorius,
				// tai reiskia, kad gauta informacija is kazkurio kliento. Reikia
				// ja priimti ir atitinkamai apdoroti.
				else
				{
					// Priimame ir apdorojame pranesima.
					HandleDataFromClient ((SOCKET)iCounter, &TheMainSet,
						&FirstLevelSet,	&SecondLevelSet);
				}
			}
		}
	}

EXIT:
//------------------------------------------------------------
// Jei kompiliuojama Windows tipo sistemoje, tai reikia
// baigus darba atlaisvinti soketu biblioteka.
#ifdef	WIN32OS
	if ( -1 == WSACleanup () )
	{
		printf ("MathServer error: WSACleanup() failed.\n");
		exit ( EXIT_FAILURE );
	}
#endif
//------------------------------------------------------------

	return 1;
}
