CREATE TABLE ALSO4297.Grupe (
	Grupes_nr		INTEGER		NOT NULL,
	Grupes_pavadinimas	VARCHAR(20)	NOT NULL,
		
	PRIMARY KEY (Grupes_nr))
#
CREATE TABLE ALSO4297.Darbuotojas (
	Darbuotojo_nr	INTEGER		NOT NULL,
	AK					VARCHAR(11)	NOT NULL,
	Vardas			VARCHAR(15)	NOT NULL,	
	Pavarde			VARCHAR(15) NOT NULL,		
	Gatve				VARCHAR(15) NOT NULL,	
	Namas				INTEGER		NOT NULL,
	Butas				INTEGER		NOT NULL,
	Grupes_nr		INTEGER,
	
	PRIMARY KEY (Darbuotojo_nr),
	
	FOREIGN KEY Globuoja_grupe (Grupes_nr)
  	REFERENCES ALSO4297.Grupe
    	ON DELETE SET NULL
    	ON UPDATE RESTRICT)
#
CREATE TABLE ALSO4297.Vaikas (
	Vaiko_nr	INTEGER		NOT NULL,
	AK		VARCHAR(11)	NOT NULL,
	Vardas		VARCHAR(15) 	NOT NULL,	
	Pavarde		VARCHAR(15) 	NOT NULL,		
	Lytis		VARCHAR(7) 	NOT NULL,	
	Gimimo_data	DATE		NOT NULL,
	Grupes_nr	INTEGER,
	
	PRIMARY KEY (Vaiko_nr),
	
	FOREIGN KEY Priklauso_grupei (Grupes_nr)
  	REFERENCES ALSO4297.Grupe
    	ON DELETE SET NULL
    	ON UPDATE RESTRICT)
#
CREATE TABLE ALSO4297.Giminaitis (
	Giminaicio_nr	INTEGER		NOT NULL,
	AK					VARCHAR(11)	NOT NULL,
	Vardas			VARCHAR(15)	NOT NULL,	
	Pavarde			VARCHAR(15) NOT NULL,		
	Gatve				VARCHAR(15) NOT NULL,	
	Namas				INTEGER		NOT NULL,
	Butas				INTEGER		NOT NULL,
	
	PRIMARY KEY (Giminaicio_nr))
#
CREATE TABLE ALSO4297.Santykis (
	Giminaicio_nr		INTEGER		NOT NULL,
	Vaiko_nr				INTEGER		NOT NULL,
		
	PRIMARY KEY (Giminaicio_nr, Vaiko_nr),
	
	FOREIGN KEY Priklauso (Giminaicio_nr)
  	REFERENCES ALSO4297.Giminaitis
    	ON DELETE CASCADE
    	ON UPDATE RESTRICT,
    	
	FOREIGN KEY Turi_vaika (Vaiko_nr)
  	REFERENCES ALSO4297.Vaikas
    	ON DELETE CASCADE
    	ON UPDATE RESTRICT)
#



CREATE VIEW ALSO4297.GrupesInfo(Nr, Vaiku_skaicius) AS
	SELECT ALSO4297.Grupe.Grupes_nr, COUNT(*)
	FROM ALSO4297.Grupe, ALSO4297.Vaikas 
	WHERE ALSO4297.Vaikas.Grupes_nr = ALSO4297.Grupe.Grupes_nr 
	GROUP BY ALSO4297.Grupe.Grupes_nr
#


-- sukuria vaiko nr.
CREATE TRIGGER ALSO4297.NaujasVaikoNr
  NO CASCADE BEFORE INSERT ON ALSO4297.Vaikas
  REFERENCING NEW AS NaujasVaikas
  FOR EACH ROW MODE DB2SQL
  SET NaujasVaikas.Vaiko_nr = (SELECT COALESCE (MAX (Vaiko_nr), 0) + 1 
                              FROM ALSO4297.Vaikas)
#
-- patikrina, ar visi vaikai priklauso kokiai nors grupei
CREATE TRIGGER ALSO4297.PriklausoGrupei
  NO CASCADE BEFORE INSERT ON ALSO4297.Vaikas
  REFERENCING NEW AS NaujasVaikas
  FOR EACH ROW MODE DB2SQL
  WHEN (NaujasVaikas.Grupes_nr is NUll)
  SIGNAL SQLSTATE '99999' ('Vaikas nepriklauso jokiai grupei!')
#

CREATE UNIQUE INDEX ALSO4297.VaikoAK
ON ALSO4297.Vaikas (AK)
#
