import java.io.*;
import java.net.*;
//import java.util.*;
import java.util.Vector;

public class chatServer {
	private static final int MAX_CLIENTS = 50;
	private ServerSocket listenSocket = null;
	private boolean running = true;
	private static int port; 
	static Vector clients = new Vector();
		
   public static void main(String[] args) {
      if(args.length != 1) {
         System.out.println("error: bad parametres. " + 
                            "Usage:\n java server [port_number]\n");
      System.exit(1);
      }
      port = Integer.parseInt(args[0]);
      
      System.out.println("Please, enter your command: ");
      new Thread(){
         public void run(){
    		   try {
               BufferedReader consol = new BufferedReader(new InputStreamReader(System.in));
               while(true) {                   
                  String comm = consol.readLine();
                  if(comm.equals("!stop")) System.exit(1);
                  else if(comm.equals("!list")) list();
                  else if(comm.equals("!help")) { 
                     System.out.println("\nAvailable commands:\n "
                                        + "!stop - stop the server\n"
                                        + " !help - print this help\n"
                                        + " !list - list of logged on users\n");
                  }
                  else
                     System.out.println("Bad command!");
                  System.out.println("\nPlease, enter your command: ");
               }
   	      } catch(IOException excp) {
   	  	     System.err.println("Failed I/O: " + excp);
   	      } 
  	      }
      }.start();
       
   	chatServer server = new chatServer();
   	server.serverListen();  
   } 
   
   public chatServer() {
   	  try {
   	  	 listenSocket = new ServerSocket(port, MAX_CLIENTS);
   	  } catch(IOException excp) {
   	  	   System.err.println("Unable listen port" + port + 
   	  	                      ": " + excp);
   	  	   System.exit(1);
   	  }
   }
   
   static public void list() {
      synchronized(clients) {     
    	   for(int i = 0; i<clients.size(); i++ ) {
    		  	Client cl = (Client)clients.get(i);
    		  	System.out.println(cl.nick);
    		} 
    	}
   }
   
   public void serverListen() {
   	  Socket clientSocket = null;
   	  
   	  try {
   	  	 while(running) {
   	  	 	clientSocket = listenSocket.accept();
   	  	 	listenForClient newClient = new listenForClient(clientSocket);
   	  	 	Thread newClientThread = new Thread(newClient);
   	  	 	newClientThread.start();
   	  	 }
   	  } catch(IOException excp) {
   	  	   System.err.println("Failed thread: " + excp);
   	  }
   }
   
   protected void stop() {
   	  if(running) {
   	  	 running = false;
   	  }
   }     
  
   class listenForClient implements Runnable {
	   private Socket mySocket = null;
      private PrintStream clientSend = null;
      private DataInputStream clientReceive = null;
      final Client cl = new Client();
      	
   	public listenForClient(Socket newSocket) {
         mySocket = newSocket;
         cl.sock  = newSocket;
        	clients.add(cl); 
      }
   
      public void run() {
         String line;
         try {
   	  	    clientSend = new PrintStream(mySocket.getOutputStream());
   	  	    clientReceive = new DataInputStream(mySocket.getInputStream());
   	  	       	  	       	  	 
   	     	 clientSend.println("You are connected. Type \"!e\" to exit. \n" + 
   	     	                    "v v v Enter nick? v v v ");
   	     	 cl.nick = clientReceive.readLine();
   	     	 clientSend.println("Hello, " + cl.nick + "! Now you can talk:)\n");
   	  	    while((line = clientReceive.readLine()) != null) {
   	  	       sendToAll(cl.nick + ": "  + line);
   	  	    
   	  	    } 
   	   } catch(IOException excp) {
   	  	     System.err.println("Failed I/O: " + excp);
   	   } finally {
   	        try {
   	  	        if(clientSend != null) clientSend.close();
   	  	        if(clientReceive != null) clientReceive.close();
   	  	        if(mySocket != null) mySocket.close();
   	  	        //cl.sock.close();
   	  	        clients.remove(cl);
   	  	     } catch(IOException excp) {
   	  	          System.err.println("Failed I/O: " + excp);
   	  	     }
   	   }   
      }
      
      public void sendToAll(String msg)	{
         synchronized(clients) {     
    		   for(int i = 0; i<clients.size(); i++ ) {
    		   	Client cl = (Client)clients.get(i);
    		   	try {
      	      	clientSend  = new PrintStream(cl.sock.getOutputStream());
      	      	clientSend.println(msg);
            	} catch(IOException excp) {
      	           System.err.println("Failed I/O: " + excp);
            	}
    		   }
    	   }
   	}       
   }  
   
   class Client {                                  
	  	Socket sock; 
	  	String nick = "";
   } 
} 