/*
*   Vladislav Mickevic
*   MIF VU Informatika
*   3 kursas, 1 grupe
*
*   LAN chat server. 
*
*/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <time.h>
#include "server.hpp"

time_t now = time(NULL);

int help() {
   cout << endl << "List of komands (when server is started): " << endl
        << "!help - print this help" << endl
        << "!kick - kick the user" << endl
        << "!list - list of logged on users" << endl
        << "!stop - stop the server" << endl << endl;
    return 1;
}

void *cinThrd(void *arg) {
   string command;
   while(true) {
      cout << "Enter your command: ";
      cin >> command;
      if(command == "!help") {
         logFile << ctime(&now) << " Command from server !help" << endl;
         help();
      }
      else if(command == "!list") {
         logFile << ctime(&now) << " Command from server !list" << endl;
         list();
      }
      else if(command == "!kick") {
         cout << endl << "Enter user nickname: " << endl;
         string nick;
         cin >> nick;
         logFile <<  ctime(&now) << " Command from server !kick"
                 << " for user " << nick << endl;
         removeUser(nick);
         cout << endl;
      }
      else if(command == "!stop")  {
         cout << "Server stoped." << endl;
         logFile << ctime(&now) << " Command from server !stop" << endl
                 << ctime(&now) << " Server stoped." << endl;
         exit(0);
      }
      else cout << "Bad command!" << endl;
   }
}

int list() {
   cout << endl;
   for(int i=0; i<MAX_USERS; i++)
      if(users[i]) cout << users[i]->nick << endl;
   cout << endl;
   return 1;
}

int initUsers() {
	id = 0;
   for(int i=0; i<MAX_USERS; i++)
      users[i] = NULL;
   return 1;
}

int addUser(int sock, string nick) {
   if(id > MAX_USERS) {
      logFile << "[" << ctime(&now) << "] "
              << nick << " try to connect..." << endl
              << "Server busy..." << endl;
      return 2;
   }
   for(int i=0; i<MAX_USERS; i++)
      if (users[i])
         if (users[i]->nick == nick) {
            logFile << ctime(&now) << "Someone is trying to connect as "
                    << nick << "..." << endl;
            char buf[] = "Your nick is in use!";
            send(sock, buf, BUFSIZE, 0);
            close(sock);
            return 2;
      }
   for(int i=0; i<MAX_USERS; i++)
      if (users[i] == NULL) {
         users[i] = new usersss();
         users[i]->sock = sock;
         users[i]->nick = nick;
         id++;
         logFile << ctime(&now) << nick
                 << " conected!" << endl;
         string text = nick + " connected!";
         char* buf = new char[BUFSIZE];
         strcpy(buf, (text).c_str());
         sendMessage(buf, nick);
         delete []buf;
         return 1;
      }
   return 1;
}

int removeUser(string nick) {
   for(int i=0; i<MAX_USERS; i++)
      if(users[i])
         if(users[i]->nick == nick) {
            close(users[i]->sock);
            delete users[i];
            users[i] = NULL;
            id--;
            logFile << ctime(&now) << nick
                    << " disconnected!" << endl;
            string text = nick + " disconnected!";
            char* buf = new char[BUFSIZE];
            strcpy(buf, (text).c_str());
            sendMessage(buf, nick);
            delete []buf;
            return 1;
         }
   return 1;
}

void *serverJob(void *arg) {
   int sock = (int)arg;
   char bufer[BUFSIZE];
   int bytes_read;
   bytes_read = recv(sock, bufer, sizeof(bufer), 0);
   string nick;
   if(bytes_read <= 0) close(sock);
   else nick = (string)bufer;
   if(addUser(sock, nick) == 2) return NULL;
   string text;
   char* buf = bufer;
   bytes_read = recv(sock, bufer, sizeof(bufer), 0);
   while(true) {
      bytes_read = recv(sock, bufer, sizeof(bufer), 0);
      if(bytes_read <= 0) break;
      text = (string)bufer;
      text = ">  " + nick + ": " + text;
      strcpy(buf, (text).c_str());
      sendMessage(buf, nick);
   }
   removeUser(nick);
}

int sendMessage(char* buf, string nick) {
   for(int i=0; i<MAX_USERS; i++)
      if(users[i])
         send(users[i]->sock, buf, BUFSIZE, 0);
   return 1;
}

int main(int argc, char *argv[]) {
   if(argc != 2) {
      cout << "error: bad parametres" << endl
           << endl << "Usage: " << endl
           << "   ./server [port_number]" << endl;
      return 1;
   }
   if(strcmp(argv[1], "--help") == 0) {
      cout << endl << "Usage: " << endl
           << "   ./server [port_number]" << endl;
      help();
      return 1;
   }
   int listener;
   struct sockaddr_in addr;
   int bytes_read;

   listener = socket(AF_INET, SOCK_STREAM, 0);
   if(listener < 0) {
      perror("socket");
      exit(1);
   }
   addr.sin_family = AF_INET;
   addr.sin_port = htons(atoi(argv[1]));
   addr.sin_addr.s_addr = INADDR_ANY;
   if(bind(listener, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
      perror("bind");
      exit(2);
    }

   listen(listener, 5);
   initUsers();

   char buf[BUFSIZE];
   int sock;

   logFile << ctime(&now) << " Server started." << endl;
  /* cout << "Server started." << endl
        << "Type \"!help\" for more information! " << endl;
   pthread_t thrd1;
   if(pthread_create(&thrd1, NULL, cinThrd, NULL) != 0) {
      logFile << ctime(&now) << "error: thread" << endl;
      return 1;
   } */
   
   if(getppid()!=1){         //padarom teva vaiku ir teva uzdarom.
      if(fork()!=0) exit(0);
      setsid();
   }
   
   while(true) {
      sock = accept(listener, NULL, NULL);
      if(sock < 0) {
         perror("accept");
         exit(3);
      }
      pthread_t thrd;
      if(pthread_create(&thrd, NULL, serverJob, (void *)sock) != 0) {
         logFile << ctime(&now) << "error: thread" << endl;
         break;
      }
   }
   //close(listener);
   cout << "Server stoped." << endl;
   return 0;
}

