/*
*   Vladislav Mickevic
*   MIF VU Informatika
*   3 kursas, 1 grupe
*
*   LAN chat client. 
*
*/

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#define BUFSIZE 256

int help();
int check(char*);
void *listening(void *arg);

int help() {
   cout << endl << "List of available commands: " << endl
        << "!e - to exit" << endl
        << "!h - print help" << endl << endl;
   return 1;
}

int check(char* bufer) {
   if(bufer[0] == '!')
      if(bufer[1] == 'e')
         return 1;
      else if(bufer[1] == 'h') {
            help();
            return 1;
         }
   else return 0;
}

void *listening(void *arg) {
   int read_bytes;
   char buf[BUFSIZE];
   int sock = (int)arg;
   while(1) {
      read_bytes = recv(sock, buf, sizeof(buf), 0);
      if(read_bytes <= 0) {
         close(sock);
         cout << "error: server connection lost" << endl;
         exit(2);
      }
      cout << buf << endl;
   }
}

int main(int argc, char *argv[]) {
   if(argc == 2) {
      if(strcmp(argv[1], "--help") == 0) {
         cout << endl << "Usage: " << endl
              << "   ./client [server_adresss] [port_number]" << endl;
         help();
         return 1;
      }
      else cout << "error: bad parametres";
      return 1;
   }
   if(argc != 3) {
      cout << "error: bad parametres" << endl
           << endl << "Usage: " << endl
           << "   ./server [server_adresss] [port_number]" << endl;
           return 1;
   }
   struct sockaddr_in addr;
   int sock;
   sock = socket(AF_INET, SOCK_STREAM, 0);
   if(sock < 0) {
      perror("socket");
      exit(1);
   }

   addr.sin_family = AF_INET;
   addr.sin_port = htons(atoi(argv[2]));
   addr.sin_addr.s_addr = inet_addr(argv[1]);
   if(connect(sock, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
      perror("connect");
      exit(2);
   }
   pthread_t thrd;
   if(pthread_create(&thrd, NULL, listening, (void *)sock) != 0) {
      cout << "error: thread" << endl;
      return 1;
   }
   cout << "Welcome to LAN chat!" << endl;
   char bufer[BUFSIZE];
   char *buf = bufer;
   string nick;
   cout << "Enter a nickname: ";
   cin >> nick;
   strcpy(buf, (nick).c_str());
   send(sock, buf, BUFSIZE, 0);
   cout << "You are logged on." << endl
        << "Type \"!h\" for information." ;
   cout << endl;
   while(1) {
      cin.getline(buf, BUFSIZE);
      if(check(buf) == 1) break;
      send(sock, buf, sizeof(bufer), 0);
   }
   cout << "Good bye." << endl;
   close(sock);
   return 1;
}

