
import java.util.*;
public class degaline{
  static final int MASINU_SK = 10;

  public static void main(String args[]) {
    Thread autoThreads[] = new Thread[MASINU_SK];
    try {
      
      Kolonele kolonele1 = new Kolonele();
      Kolonele kolonele2 = new Kolonele();
      Random num = new Random(MASINU_SK);
      
      
      for (int i = 0 ; i < MASINU_SK/2 ; i++) {
        Auto auto = new Auto(i, kolonele1, 1);
        (autoThreads[i] = new Thread(auto)).start();
  
      }
      
   
      for (int i = MASINU_SK/2; i < MASINU_SK; i++) {
        Auto auto = new Auto(i, kolonele2, 2);
        (autoThreads[i] = new Thread(auto)).start();
      }

      //Leidziame simuliacija
      for (int i = 0; i < MASINU_SK/2; i++) {
        autoThreads[i].join();
      }
    } catch (InterruptedException e) {
    }

    //Po sim. pabaigos vid. laikas.
    System.out.println("Vidutinis laikas benzino ipylimui= " +
      Auto.skaicVid());
  }
}


class Kolonele {
  private static final int LAISVA = 0;
  private static final int UZIMTA = 1;
  private int state = LAISVA;
 

  /**
   * Kada masina nori ipylti degalu (meth. call) 
   * pridedame 1/2 sekundes laiko.
   */
  synchronized public void naudotisKolonele() {
    try {
        while(true) {
        if (state == LAISVA)
          break;
        wait();
      }

      //Koloneles aktivacijos simuliacija (1/2sek.)
      Thread.sleep(500);
      
      state = UZIMTA;
      notifyAll();
    } catch (InterruptedException e) {
    }
  }

  /**
   * Degalu ipylimo simuliacija (5sek.).
   */
  synchronized public void piltiDegalu() {
    try {
      while(true) {
        if (state == UZIMTA)
          break;
        wait();
      }
      //Ipylimas
      Thread.sleep(5000);

    } catch (InterruptedException e) {
    }
  }

  /**
   * Isvaziuoti, kolonele tampa laisva
   */
  synchronized public void isvaziuoti() {
    try {
      while(true) {
        if (state == UZIMTA)
          break;
        wait();
      }
      //Isvaziavimo simuliacija (1/2sek.)
      Thread.sleep(500);

      state = LAISVA;
      notifyAll();
    } catch (InterruptedException e) {
    }
  }
}



class Auto implements Runnable {
  private static int vlaikas = 0,                                   
       vmasinu = 0;              
  private int klientoNumeris;      
  private int manoKolonelesNum;                                 
                                   
  private Kolonele manoKolonele;             
                                  
  /**
   * Sulieti: kliento numeri ir kolonele, kuri jis naudosis
   */
  public Auto(int klientoNumeris, Kolonele kolonele, int manoKolonelesNum) {
    this.manoKolonele = kolonele;
    this.manoKolonelesNum = manoKolonelesNum;
    this.klientoNumeris = klientoNumeris;
  }


  // Skaiciuojame vidurki
  
  public static float skaicVid() {
    return vlaikas/vmasinu;
  }

    public void run() {
    final int LAUK_LAIKAS = 30000;
    long pradLaikas, pabLaikas;
    Random random = new Random(klientoNumeris);
    int laukLaikas = random.nextInt(LAUK_LAIKAS);
    //Lauki pries atvazioudamas
    try {
      Thread.sleep(laukLaikas);
    } catch (InterruptedException e) {
    }

    //naudotis kolonele, pilti degalu, isvaziuoti
    System.out.println("Klientas "+ klientoNumeris +
               " atvaziavo prie koloneles #" + manoKolonelesNum);
    pradLaikas = (new Date()).getTime();
    manoKolonele.naudotisKolonele();
    System.out.println("Klientas "+ klientoNumeris +
               " pilsta benzina");
    manoKolonele.piltiDegalu();

    System.out.println("Klientas "+ klientoNumeris +
               " isvaziuoja. " + "Kolonele #" +  manoKolonelesNum + " laisva");
    manoKolonele.isvaziuoti();
    pabLaikas = (new Date()).getTime();
    System.out.println("Truko = "+ (pabLaikas - pradLaikas));

    
    
    synchronized(Auto.class) {
      vlaikas += (pabLaikas - pradLaikas);
      vmasinu++;
    }
  }
}


