//ServerThread.java
import java.io.*;
import java.net.*;

public class ServerThread implements Runnable {
	private Socket client;
	private int bad_quess_num;
	private char[] word;
	private char hidden_word[];
	private PrintStream send = null;
   private DataInputStream recv = null;
   private char gallows[];

	ServerThread(Socket client) {
		this.client = client;   // konstruktorius
	}
	public void run() {
		game(); // pereinam prie funkcijos game()
   }
   public void game() {
		String was = "";
		String recvmsg, sendmsg;
		try {
			recv = new DataInputStream(client.getInputStream()); // sukuriam input-output srautus
			send = new PrintStream(client.getOutputStream());
			
			newWord(); // funkcija, kad sugalvoti nauja zodi
			
			sendmsg = new String(new String(gallows)+"\n");
			send.println(sendmsg);
			send.println("Spejamas zodis: " + new String(hidden_word)); 
			send.println("Iveskit raide: ");   		 
    		while((recvmsg = recv.readLine()) != null) {    			
    			char[] symbols;  
    			symbols = recvmsg.toCharArray();
    			if(!isExist(was, symbols[0])) { // ziurim, ar ivedinejom toki simboli pries tai ar ne
    			   if(!newHidden(symbols[0])) { // jeigu neatspejom raides
    			   	hang();
    			      sendmsg = new String(new String(gallows)+"\n");
			         send.println(sendmsg); 
			         if(bad_quess_num == 7) { // ziurim kelinta karta neatspejom zodzio
			            send.println("Labai gaila, bet zodis buvo "
			                          + new String(word) + "!");
			            send.println("Dar karteli?(t)");
			            if((recvmsg = recv.readLine()).equals("t")) {
					         newWord(); // vel sugalvojam nauja zodi
					         was = "";
					         sendmsg = new String(new String(gallows)+"\n");
		                	send.println(sendmsg);
					         send.println("Spejamas zodis: " + new String(hidden_word)); 
				       	}
				       	else break; // iseiti is ciklo
			         }
    			   }
    			   sendmsg = new String(new String(gallows)+"\n");
		         send.println(sendmsg);
				   was += symbols[0];
			   }
			   else send.println("Raide " + symbols[0] + " buvo!");
				String hidden_string = new String(hidden_word);
				send.println("Spetos raides: " + was
				             + "\n" + "Zodis: " + hidden_string);
				send.println("Iveskit raide: ");   
				if(arAtspeta()) {
					send.println("Zodis atspetas! Norite dar? (t)");
					if((recvmsg = recv.readLine()).equals("t")) {
					   newWord();
					   was = "";
					   sendmsg = new String(new String(gallows)+"\n");
			         send.println(sendmsg);
					   send.println("Spejamas zodis: " + new String(hidden_word)); 
					}
					else break; 
				}			
			}
			recv.close(); // uzdarom visus srautus
			send.close();
			client.close();
	   }
		catch (IOException e)
		{
			System.out.println("in or out failed");
		}	
	}
	
	private boolean isExist(String was, char here) {
		char[] sym;
		boolean key = false;
	   sym = was.toCharArray();
	   for(int i=0; i<sym.length; i++)
	      if(sym[i] == here) {
	      	key = true;
	      	return key;
	      }
	   return key;	      
	}
	
	private void newWord() {
	   String word_array[] = {"akumuliatorius","automobilis","avarija","benzinas","duslintuvas","gesintuvas","karbiuratorius","padanga","pakaba","ratlankis","sankaba","tepalas","vairas",
                               "aktorius","balerina","dailininkas","dubleris","molbertas","muziejus","paminklas","paroda","spektaklis","tapytojas","teptukas","trintukas",
                               "baseinas","buriavimas","hipodromas","irklavimas","jojimas","kanoja","krosas","plaukimas","ritulys","slalomas","tinklinis","vandensvydis","vartininkas"};
      newgallows();
	   int nr = (int)(Math.random()*100)%word_array.length;
		System.out.println("Spejamas zodis: " + word_array[nr]);
		word = word_array[nr].toCharArray();
		hidden_word = new char[word_array[nr].length()];
		hidden();
		newgallows();
	}
	
	private void newgallows() {
		gallows = "  ______   \n  |    |   \n  |        \n  |        \n  |        \n  |        \n__|_____   \n|      |___\n|_________|\n".toCharArray();
		bad_quess_num = 0;
	}
	
	int hang() {
      switch(bad_quess_num) {
        case 0:gallows[31] = 'O';break;
        case 1:gallows[43] = '|';break;
        case 2:gallows[55] = '|';break;
        case 3:gallows[66] = '/';break;
        case 4:gallows[68] = '\\';break;
        case 5:gallows[42] = '/';break;
        case 6:gallows[44] = '\\';break;
      }
    bad_quess_num++;                                                            
    return 0;
   }
	
	private boolean arAtspeta() {
		boolean key = true;
	   for(int i=0; i<word.length; i++)
	      if(hidden_word[i] == '*') key = false; 
	   return key;
	}
	
	private boolean newHidden(char here) {
		boolean key = false;
		for(int i=0; i<word.length; i++)
	      if(word[i] == here) {
	         hidden_word[i] = here;
	         key = true;
	      }
	   return key;	   	
	}	
	
	private void hidden() {
		for(int i = 0; i < word.length; i++)
			hidden_word[i] = '*';
	}
}