CREATE TABLE vlmi3715.studija(
    Pavadinimas	VARCHAR(30)	NOT NULL,
    Adresas	VARCHAR(30),
    Telefonas	CHAR(20),
    Elpastas	VARCHAR(50),
    PRIMARY KEY (Pavadinimas)
);

CREATE TABLE vlmi3715.kasete(
    Nr		INTEGER		NOT NULL CHECK (Nr > 0),
    Pavadinimas	VARCHAR(30)	NOT NULL,
    Studija	VARCHAR(30), 
    Trukme	INTEGER 	NOT NULL,
    Kaina	DECIMAL(5, 2)	NOT NULL CHECK (Kaina > 0),
    Metai	INTEGER 	NOT NULL CHECK (Metai > 1980 AND Metai <=2005),
    PRIMARY KEY (Nr),
    FOREIGN KEY (Studija)	REFERENCES vlmi3715.Studija ON DELETE CASCADE ON UPDATE RESTRICT
);

CREATE TABLE vlmi3715.klientas(
    Nr		INTEGER		NOT NULL CHECK (Nr > 0),
    Vardas	VARCHAR(30)	NOT NULL,
    Pavarde	VARCHAR(30)	NOT NULL,
    Ak		CHAR(11)	NOT NULL,
    Adresas	VARCHAR(30),
    Telefonas	CHAR(20),
    PRIMARY KEY (Nr)
); 

CREATE TABLE vlmi3715.egzempliorius(
    Nr		INTEGER		NOT NULL CHECK (Nr > 0),
    Paimta	DATE,
    Grazinti	DATE,
    Klientas	INTEGER,
    Kasete	INTEGER		NOT NULL,
    PRIMARY KEY (Nr),
    FOREIGN KEY (Klientas)	REFERENCES vlmi3715.klientas ON DELETE SET NULL,
    FOREIGN KEY (Kasete)	REFERENCES vlmi3715.kasete ON DELETE RESTRICT ON UPDATE RESTRICT,
    CONSTRAINT	GrazintiVeliau	CHECK(Grazinti >= Paimta)
);