import java.io.*;
import java.net.*;
	
public class Client {
   private static int port = 3000;
   private static String serverName = "127.0.0.1";
   private static Socket serverSock = null;
   private static PrintStream output = null;
   private static BufferedReader console = null;
   
   public static void main(String args[]) {
	  if(args.length == 2) { // args.length - elementu kiekis, ivestas per komandine eilute
	     serverName = args[0]; // jei ju 2 - tai imam parametrus is komandines eilutes
	     port = Integer.parseInt(args[1]);
	  }
	  System.out.println("Type \"!e\" to exit!");
	  	  
     Client client = new Client();
     listening listen = new listening(serverSock); // per sita klase gaunam message is serverio i konsole
     Thread clientThread = new Thread(listen); // padarom gija, kad vienu metu ir priimti message ir siust serveriui
     clientThread.start();
     try {
     	 output = new PrintStream(serverSock.getOutputStream());
     } catch(IOException excp) {
     	   System.err.println("Failed I/O: " + excp);
     }
     try {
	     console = new BufferedReader(new InputStreamReader(System.in));
	     String str = null;
	     while(!(str = console.readLine()).equals("!e")) {
				output.println(str);                                              
	     }
	  } catch(IOException excp) {
		   System.out.println("Skaitymo klaida: " + excp);
	  }
	  disconnect();
   }
   
   public Client() {
   	  try {
   	  	 serverSock = new Socket(serverName, port);
   	  } catch(IOException excp) {
   	  	   System.err.println("Unable listen port " + port + 
   	  	                      ": " + excp);
   	  	   System.exit(1);
   	  }
      
   }    
   
   public static void disconnect() {
      try {
         serverSock.close();
         System.out.println("Disconnected.");
          System.exit(1);
      } catch (IOException excp) {
           System.err.println(excp);
           System.exit(1);
      }
	}
}

class listening implements Runnable {
   private Socket server = null;
   private DataInputStream input = null;
   
   listening(Socket newSocket) {
      server = newSocket;
   }
   
   public void run() {
      try {
         input = new DataInputStream(server.getInputStream());
      } catch(IOException excp) {
      	   System.err.println("I/O failed: " + excp);
      }
      try {
		 String line;
         while(true) {
         	line = input.readLine();
         	if(line == null) throw new IOException();
	   		System.out.println(line);
         }
	  } catch (IOException excp) {
   	  	 System.out.println("Connection lost. " + excp + "\n");
   	  	 System.exit(2);
      } 
   }
}
