//Server.java
import java.io.*;
import java.net.*;

public class Server {
	private static final int MAX_CLIENTS = 50;
	private static ServerSocket listenSocket = null;
	private static Socket clientSocket = null;
	private static int port;
	
   public static void main(String[] args) {
	   
		if(args.length != 1) port = 3000;
		else port = Integer.parseInt(args[0]);    	
	
	   try {
   	   listenSocket = new ServerSocket(port, MAX_CLIENTS);
   	} catch(IOException excp) {
   	   System.err.println("Unable listen port " + port + 
   	  	                   ": " + excp);	     
   	  }              
   	try {
   	  	 while(true) {
   	  	 	clientSocket = listenSocket.accept();
   	  	 	Thread newClientThread = new Thread(new ServerThread(clientSocket));
   	  	 	newClientThread.start();
   	  	 }
   	} catch(IOException excp) {
   	  	   System.err.println("Failed thread: " + excp);
   	  }  	                   
   }
}                   
