import java.util.Random;
import java.io.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.util.*;
import javax.swing.*;
import java.awt.Panel.*;

public class Pasaulis extends JFrame {
	
  private MyCanvas canvas;
  public static final int WIDTH = 600;
  public static final int HEIGHT = 600;
  
  public Pasaulis() {
   setSize(WIDTH, HEIGHT);
   setTitle("~ Bites Majos Pasaulis ~");
   setBackground(Color.white);

   Container contentPane = getContentPane();
   canvas = new MyCanvas();
   canvas.setBackground(Color.white);
   contentPane.add(canvas, BorderLayout.CENTER);
   JPanel buttonPanel = new JPanel();
   addButton(buttonPanel, "Paleisti Bitute",
     new ActionListener() {
        public void actionPerformed(ActionEvent evt) {
        	addMaja();
        	}
      });
   addButton(buttonPanel, "Baigti Zaidima",
     new ActionListener() {
        public void actionPerformed(ActionEvent evt) {
         System.exit(0);
        }
      });
   contentPane.add(buttonPanel, BorderLayout.SOUTH);
  }
  
  public void addButton(Container c, String title, ActionListener listener) {
   JButton button = new JButton(title);
   c.add(button);
   button.addActionListener(listener);
  }

  public void addMaja() {
   Bite biene = new Bite(canvas,"Maja");
   canvas.add(biene);
   Thread myThread = new Thread(biene);
   myThread.start();
  }
    	
  public static void main(String[] args) {
      JFrame frame = new Pasaulis();
      frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      frame.show();
  } 

} 


class MyCanvas extends JPanel {
	
  private ArrayList bees = new ArrayList();
 // private ArrayList bullets = new ArrayList();
  public MediaTracker tracker;
  public BufferedImage ImageBee, ImageFlower;
  
  public MyCanvas() {	
	try{
		tracker = new MediaTracker(this);
		ImageBee = ImageUtilities.getBufferedImage("./bitute.gif", this);
		ImageFlower = ImageUtilities.getBufferedImage("./gelyte.gif", this);
		tracker.addImage(ImageFlower, 0);
		tracker.waitForID(1);
		tracker.addImage(ImageBee, 0);
		tracker.waitForID(0);
	} catch(Exception ex){
		System.err.println("Klaida!");
		System.exit(1);
	}
	
  }
  
  public void add(Bite biene) {
	  bees.add(biene);
  }
  
  public void remove(Bite biene) {
	  bees.remove(biene);
  }
  
  public void paintComponent(Graphics g) {
	  BufferedImage img, img2;
	  super.paintComponent(g);
	  Graphics2D g2 = (Graphics2D)g;
	  img2 = ImageFlower;
      g2.drawImage(img2, null, 50, 50);
      g2.drawImage(img2, null, 100, 500);
      g2.drawImage(img2, null, 250, 200);
      g2.drawImage(img2, null, 500, 80);
      g2.drawImage(img2, null, 300, 70);
      g2.drawImage(img2, null, 500, 500);
      g2.drawImage(img2, null, 180, 80);
      g2.drawImage(img2, null, 75, 600);
      g2.drawImage(img2, null, 290, 1);
      g2.drawImage(img2, null, 400, 400);
      g2.drawImage(img2, null, 60, 290);
      
	  for (int i = 0; i < bees.size(); i++) {
		  Bite biene = (Bite)bees.get(i);
		  img = ImageBee;
		  g2.drawImage(img, null, biene.getX(), biene.getY());
	  }
  }
  
}
