import java.net.*;
import java.io.*;

public class Client {

  public static void main (String[] args ) throws IOException {

    if ( ( args.length < 2 ) || ( args.length > 2 ) )
      throw new IllegalArgumentException( "Parameter(s): <Server> [<Port>]" );

    String server = args[0];
    int servPort = Integer.parseInt( args[1]);

    Socket socket = new Socket( server, servPort );

    byte[] byteBuffer = new byte[9];
    byte[] victory = {0};
    Game game = new Game();
    InputStream in = socket.getInputStream();
    OutputStream out = socket.getOutputStream();
    for (;;){
      game.printBoard();
      int recvSize = 0;
      int tempsize = 0;
      try {
      	while ( recvSize != 9 ){
          tempsize = in.read( byteBuffer, recvSize, 9 - recvSize );
          recvSize += tempsize;
        }
      }
      catch( SocketException e ){
        System.out.println( "Gavimo klaida..." );
        break;
      }
      game.parseBoardRecv( byteBuffer );
      System.out.println( "Priesininkas padare ejima..." );
      game.printBoard();
      recvSize = 0;
      try {
        recvSize = in.read( victory );
      }
      catch( SocketException e ){
        System.out.println( "Gavimo klaida..." );
        break;
      }
    
      if ( victory[0] == 1 ) {
        System.out.println( "Jus pralaimejote..." );
        System.exit(0);
      }
      if ( victory[0] == 2 ){
        System.out.println( "Lygiosios..." );
        System.exit(0);
      }
      
      byte[] move = new byte[3];
      boolean allow = false;
      while( !allow ){
        System.out.println( "\nJusu ejimas... : " );
        System.in.read( move, 0, 3 );
        allow = game.makeMove( (char)move[0], 'o');
      }
      game.parseBoardSend( byteBuffer );
      try {
        out.write( byteBuffer, 0, 9 );
      }
      catch( SocketException e ){
        System.out.println( "\nSiuntimo klaida...\n" );
        break;
      }
      if ( game.victory( 'o' ) ) {
        victory[0] = 1;
        try {
          out.write( victory, 0, 1 );
        }
        catch( SocketException e ){
          System.out.println( "\nSiuntimo klaida...\n" );
          break;
        }
		System.out.println( "Jus nugalejote" );
        System.exit(0);
      }
      if( game.checkGameOver() && !game.victory( 'x' ) && !game.victory( 'o' ) ){
        victory[0] = 2;
        try {
          out.write( victory, 0, 1 );
        }
        catch( SocketException e ){
          System.out.println( "\nSiuntimo klaida...\n" );
          break;
        }
		System.out.println(  "Lygiosios..." );
        System.exit(0);
      }
      else {
        victory[0] = 0;
        try {
          out.write( victory, 0, 1 );
        }
        catch( SocketException e ){
          System.out.println( "\nSiuntimo klaida...\n" );
          break;
        }
      }
    }
    in.close();
    out.close();
    socket.close();
  }
}
