#include "Socket.h"
#include "SocketException.h"
#include <iostream>
#include <winsock2.h>

typedef int socklen_t;
typedef char raw_type;

using namespace std;

static bool initialized = false;

MySocket::MySocket(){
}    

MySocket::MySocket( int type, int protocol ) throw( SocketException ){
  if ( !initialized ) {
    WORD version;
    WSADATA wsaData;
    
    version = MAKEWORD( 2, 0 );
    if ( WSAStartup( version, &wsaData ) != 0 ) {
      cout << "Unable to load WinSock DLL" << endl;
    }
    else {
      if ( ( this->sock = socket( PF_INET, type, protocol ) ) == INVALID_SOCKET ) {
        throw SocketException( "Neisejo sukurti socket'o..." );
      }
      else {
        initialized = true;
      }
    }
  }
}

//---Standartines funkcijos su socket'ais---//

void MySocket::connect( const string &foreignAddress, unsigned short foreignPort ) throw( SocketException ){
  sockaddr_in destAddr;
  
  memset( &destAddr, 0, sizeof( destAddr ) );
  destAddr.sin_family = AF_INET;
  hostent *host;
  if ( ( host = gethostbyname( foreignAddress.c_str() ) ) == NULL ) {
    throw SocketException( "Nesugebejome gauti adreso..." );
  }
  destAddr.sin_addr.s_addr = *((unsigned long *) host->h_addr_list[0]);
  destAddr.sin_port = htons( foreignPort );
  
  if ( ::connect( this->sock, (sockaddr *) &destAddr, sizeof( destAddr ) ) == SOCKET_ERROR ) {
    throw SocketException( "Nesugebejome prisijungti..." );
  }
}

void MySocket::send( const void *buffer, int bufferLenght ) throw( SocketException ){
  if ( ::send( this->sock, (raw_type *) buffer, bufferLenght, 0) == SOCKET_ERROR ) {
    throw SocketException( "Siuntimo klaida..." );
  }
}

int MySocket::recv( void *buffer, int bufferLenght ) throw ( SocketException ){
  int rtn;
  if ( ( rtn = ::recv( this->sock, (raw_type *) buffer, bufferLenght, 0 ) ) == SOCKET_ERROR ) {
    throw SocketException( "Gavimo klaida..." );
  }
  return rtn;
}

int MySocket::accept() throw( SocketException ){
  int newConnSD;
  if ( ( newConnSD = ::accept( this->sock, NULL, 0 ) ) == INVALID_SOCKET ) {
    throw SocketException( "Priemimo klaida.." );
  }
  return newConnSD;
}


void MySocket::setListen( int queueLenght ) throw( SocketException ){
  if ( listen( this->sock, queueLenght ) == SOCKET_ERROR ) {
    throw SocketException( "Nepavyko listen..." );
  }
}

void MySocket::setLocalPort( unsigned short localPort ) throw( SocketException ) {
  sockaddr_in localAddr;
  memset( &localAddr, 0, sizeof( localAddr ) );
  localAddr.sin_family = AF_INET;
  localAddr.sin_addr.s_addr = htonl( INADDR_ANY );
  localAddr.sin_port = htons( localPort );

  if ( bind( this->sock, ( sockaddr * ) &localAddr, sizeof( sockaddr_in ) ) < 0 ) {
    throw SocketException( "Nepavyko priristi port'o..." );
  }
}

//---------------------------------------------------//

void MySocket::setSocket( int Socket ){
  this->sock = Socket;
}    

MySocket::~MySocket(){
  ::closesocket( sock );
  sock = -1;
  this->cleanUp();
}

void MySocket::cleanUp() throw( SocketException ){
  if (WSACleanup() != 0) {
    throw SocketException( "Nepavyko visko isvalyti tvarkingai" );
  }
}

