import java.net.*;
import java.io.*;

public class Server {

  public static void main( String[] args ) throws IOException {
  	ServerSocket servSock = null;

    if ( args.length != 1 )
      throw new IllegalArgumentException( "Parameter(s): <Port>" );

	try {
      int servPort = Integer.parseInt( args[0] );
      servSock = new ServerSocket( servPort );
    }
    catch( NumberFormatException e ){
      System.out.println( e );
    }
    catch( IOException e ){
      System.out.println( e );
    }

    int recvMsgSize;
    byte[] byteBuffer = new byte[9];
    byte[] victory = {0};

    for (;;){
      Game game = new Game();
	  System.out.println( "\nLaukiame naujo zaidejo...\n" );
      Socket clntSock = servSock.accept();
      InputStream in = clntSock.getInputStream();
      OutputStream out = clntSock.getOutputStream();
      for (;;){
      	game.printBoard();
        byte[] move = new byte[3];
      	boolean allow = false;
      	while( !allow ){
      	  System.out.println( "\nJusu ejimas... : " );
      	  System.in.read( move, 0, 3 );
      	  allow = game.makeMove( (char)move[0], 'x');
      	}
        game.parseBoardSend( byteBuffer );
        try {
          out.write( byteBuffer, 0, 9 );
        }
        catch( SocketException e ){
        	System.out.println( "\nSiuntimo klaida...\n" );
        	break;
        }
        
	if ( game.victory( 'x' ) ) {
          victory[0] = 1;
          try {
            out.write( victory, 0, 1 );
          }
          catch( SocketException e ){
        	System.out.println( "\nSiuntimo klaida...\n" );
        	break;
          }
          System.out.println( "Jus nugalejote" );
          break;
        }
        if( game.checkGameOver() && !game.victory( 'x' ) && !game.victory( 'o' ) ){
          victory[0] = 2;
          try {
            out.write( victory, 0, 1 );
          }
          catch( SocketException e ){
        	System.out.println( "\nSiuntimo klaida...\n" );
        	break;
          }
          System.out.println( "Lygiosios..." );
          break;
        }
        else {
          victory[0] = 0;
          try {
            out.write( victory, 0, 1 );
          }
          catch( SocketException e ){
        	System.out.println( "\nSiuntimo klaida...\n" );
        	break;
          } 
        }
        
        int recvSize = 0;
        int tempsize = 0;
        try {
          while ( recvSize != 9 ){
            tempsize = in.read( byteBuffer, recvSize, 9 - recvSize );
            recvSize += tempsize;
          }
        }
        catch( SocketException e ){
          System.out.println( "Gavimo klaida..." );
          break;
        }

        game.parseBoardRecv( byteBuffer );
        recvSize = 0;
        try {
          recvSize = in.read( victory );
        }
        catch( SocketException e ){
          System.out.println( "Gavimo klaida..." );
          break;
        }
           
        System.out.println( "Priesininkas padare ejima..." );
        game.printBoard();
        if ( victory[0] == 1 ) {
          System.out.println( "Jus pralaimejote..." );
          break;
        }
        if ( victory[0] == 2 ) {
          	System.out.println( "Lygiosios..." );
            break;
        }
      }
      in.close();
      out.close();
      clntSock.close();
    }
  }
}
