#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdlib.h>
#include <stdio.h>
#include <netdb.h>
#include <errno.h>
#include <string.h>

void dostuff (int );


main( int argc, char *argv[] ) {

	/* argv[0] -- programos vardas
		argv[1] -- hosto vard. prie kurio jungsimes
		argv[2] -- hosto (serverio) portas per kuri jungsimes
		*/
		
	struct sockaddr_in name;
	struct hostent *hp;
	int sock, n;

	if( argc < 3 ) {
		printf( " Ivesta nevisi duomenys\n" );
		printf( " Naudojimas:\n\t[executable name] [host name] [port no]\n" );
		exit( 1 );
	}
	if( ( sock = socket( AF_INET, SOCK_STREAM, 0 ) ) < 0 ) {
		perror( "Client: socket" );
		exit( 1 );
	}
	printf("\nClient socket descriptor: %d\n", sock);
	
	memset( &name, 0, sizeof( struct sockaddr_in ) );
	name.sin_port = htons(atoi(argv[2])); // server port 
	name.sin_family = AF_INET; // internet domain 
		
	/* obtain server host information */
	
	if ((hp = gethostbyname(argv[1])) < 0) {
		printf( " fialure on gethostbyname\n" );
		perror( "network client" );
		close( sock );
		exit( 1 );	
	}
	else {
      printf( "Server information obtained via"
      			" gethostbyname:\n" );
      printf( "\tThe official host name is %s\n", hp -> h_name );
      printf( "\tThe address type is %d\n", hp -> h_addrtype );
      printf( "\tThe length of the address is %d bytes\n", hp -> h_length );
      printf( "\tThe server port number in host order is %d\n", ntohs( name.sin_port ) );
      //printf( "\tThe first host address is %f\n", ntohl( *( int * ) hp -> h_addr_list[0] ) );
	}
	/* hosto addr nukopinamas i s_addr
	 	h_addr_list yra char tipo */
	
	memcpy( &name.sin_addr.s_addr, hp -> h_addr_list[0], hp -> h_length );
	
	/* jungiamasi prie serverio */
	/* s yra servo adresas + portas */
	
	if( connect( sock, ( struct sockaddr * )&name, sizeof( name ) ) < 0 ) {
		perror( "client connection" );
		exit( 1 );	
	} 
	else 
		printf( " Connected successful\n" );
		
	dostuff( sock );

}

/****************************/
void dostuff( int sock ) {

	char buf[100], c;

	memset( buf, 0, sizeof( buf ) );
	if( recv(sock, buf, sizeof( buf ), 0 ) < 0 )
		perror( "receive error" );
	else
		printf( " The received message is:\n\t %s\n", buf );		
	//printf(" Noredamas baigti vykdyma ivesk 'q'\n");
	
	while( 1 ) {	
	
		/* clear buf */
	
		memset( buf, 0, sizeof( buf ) );
		printf( " Enter a number:\n\t" );
		fgets( buf, sizeof( buf ), stdin );	// stdin -- standart input 	
		if( buf[0] == 'q' ) {
			close( sock );
			exit( 0 );
		}
	
		/* send string to server */
	
		if( send( sock, buf, sizeof( buf ), 0 ) < 0 ) {
			printf( "error number: %d\n", errno );
			perror( "sendig error" );
		}

		/* zinutes gavimas */
	
		memset( buf, 0, sizeof( buf ) );
		if( recv( sock, buf, sizeof( buf ), 0 ) < 0 )
			perror( "receive error" );
		else
			printf( " The result is:\n\t %s\n", buf );
	}	/* end of while	*/
	
	/* Nusiunciam tuscia zinute, kad serveris uzdarytu
		socketa ir neatsirastu zombiai	*/
	
	memset( buf, 0, sizeof( buf ) );
	if( send( sock, buf, sizeof( buf ), 0 ) < 0 ) {
			printf( "error number: %d\n", errno );
			perror( "sendig error" );
		}
}

