#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <netdb.h>
#include <signal.h>
#include "calc.h"

#define name "localhost";

void dostuff(int);


main(int argc, char *argv[]) {

	struct sockaddr_in myname;		// Internet socket name 
	int mysock,	sock,	// serverio/cliento socketo descriptorius 
			n;
 	
 	/* Ar ivesti visi duomenys */
 	if(argc < 2) {
 		printf(" Nevisi duomenys ivesti:\n");
 		printf(" Naudojimas:\n\t[programos vardas] [porto nr]\n");
 		exit(1);
 		/* 0 -- normalus sustabdymas,  jei >0  - tikrina klaidas	*/
 	}
 	
	/* sukuria kanala per kuri klausomes su lisen()
 	 	protocol - 0 reiskia, kad sistema parenka pirma
 		tinkama prot. pagal ankstesnes dvi reiksmes 
 	 	grazina failo deskriptoriu i socketa	*/
 	
 	if((mysock = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
 		close(mysock);
 		perror("socket error");
 		exit(1);
 	}
 	
 	// isvalo rodykles adresa 
 	memset(&myname, 0, sizeof(struct sockaddr_in)); 	
 	
 	/* inicializuoja strukturos sockaddr_in laukus */
 	 // interneto adresas 
 	myname.sin_family = AF_INET; 
 							
 	// simboline konst. kuri grazina masinos IP is lauko s_addr
 	myname.sin_addr.s_addr = INADDR_ANY; 					
 	
 	/* ivesta adresa pavercia i integer po to i
 		network tipa	*/	
 	myname.sin_port = htons(atoi(argv[1])); 				 
 		
 	/* susieja serverio socketa ir interneto adresa */
	if (bind(mysock, (struct sockaddr *)&myname, sizeof(myname)) < 0) {
		close(mysock);
		printf(" Network server bind failure %d\n", errno);
		perror("ERROR on binding");
		exit(1);	
	}

	/* laukia uzklausimo is cliento	*/
	listen(mysock, 5);
	
	printf("\nServeris sekmingai pasileido su siais duomenimis\n");
	printf("\tServer socket file descriptor: %d\n", mysock);
	printf("\tInternet address: %lx\n", myname.sin_addr.s_addr);
	printf("\tInternet family ID: %d\n", myname.sin_family);
   printf("\tPort number used: %d\n", myname.sin_port);
   printf ("\tPresent server status: listen\n");
   
   /* isgaudo zombius. Signalus, kuriu neprieme	*/
	
	signal(SIGCHLD, SIG_IGN);
	
	/* PID -- a unique process ID
   		fork() -- isskiria viena procesa i du identiskus:
   		parent and child on success grazina 0 child procesui
   		ir vaiko proceso ID i parent. On failure grazina -1
   	i	 parent procesa ir nesukuria child	*/

   while(1) {
   
   	/* gauna cliento socketa per kuri ir vyksta bendravimas */
   		
		if((sock = accept(mysock, 0, 0)) < 0) {
      		printf("network server error number: %d\n", errno);
         	perror("accept error");
         	close (mysock);
         	exit(5);
   	}
   	printf(" Connected successful\n");
   	switch( fork() ) {
		case -1:   		
   		perror("fork error");
   		close(sock);
   		close(mysock);
   		exit(1);
   	case 0:
   		close(mysock);
   		dostuff(sock);
   		exit(0);
   	default:
   		close(sock);
   		continue;
   	}
   }	/* end of while	*/  
}	/* end of main()	*/

/****************************/
void dostuff(int sock) {
	
	char buf[100];
	int n;
	
	strcpy(buf, "Programa skaiciuoja tik pagrindines"
		"f-jas: +, -, *, /\n\t"
		"Naudojimas: [OP1][operacijos zenklas][OP2]\n");
	if (send(sock, buf, sizeof(buf), 0) < 0) 
		perror("sendig error");
		
	/* sukuriam amzina cikla. Klientas prisijunges gali begalo
		naudotis serveriu. Klientui atsijungus recv() grazina '0'
		tokiu atveju ciklas baigiamas ir uzdaromas kliento socketas */
		
	while( 1 ) {
		memset(buf, 0, sizeof(buf));
   	if( ( n = recv( sock, buf, sizeof( buf ), 0 ) ) <= 0 ) {
			printf( " error number: %d\n", errno );
   		perror( "receive error" );
   		close( sock );
   		break;
   	}
   	else {
   		printf( " The numeber of receved byte: %d\n", n );
			ctoi(buf);	// ctoi grazina atsakyma char tipo
		
			/* send a message */
		if (send(sock, buf, sizeof(buf), 0) < 0)	
			perror("sendig error");
   	}
   } /* end of while	*/
}	/* end of dostuff	*/
