/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *    Uzduoti atliko: Artur Karaznevic, Informatika II k, 5gr.                   *
 *    Uzduotis: Zaidimas                                                         *
 *    Prie serverio jungiasi klientai,jiems uzduodami klausimai                  *
 *    Atsakymas i klausima gali buti: TAIP arba NE                               *
 *    Programos pabaigoje pateikiama statistika                                  *
 *                                                                               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>                           // defines the structure hostent
#include <string.h>
#include <stdio.h>
#define SOCKET_ERROR        -1
#define BUFFER_SIZE         256
#define KLAUSIMU_SK        10

//------------------------------------------------------------------------------
void send_line(int new_fd, char * Buffer) {
    send(new_fd, Buffer, BUFFER_SIZE, 0);
    send(new_fd, "$", 1, 0);
}
//------------------------------------------------------------------------------
void recv_line(int new_fd, char * Buffer, int size) {
    int len = 0;
    while (1) {
        int n = recv(new_fd, &Buffer[len], 1, 0);
        if (n <= 0 || Buffer[len] == '$')
            break;
        if (len < size - 1)
            len++;
    }
    Buffer[len] = '$';
}
//------------------------------------------------------------------------------
int  main(int argc, char* argv[]) {
    int sockfd;                              // handle to socket
    struct hostent* hostInfo;                // holds info about a machine
    struct sockaddr_in Address;              // Internet socket address struct
    char pBuffer[BUFFER_SIZE];
    int hostPort;
    int ksk=0, bsk=0;                        // klausimu ir balu skaicius
    char atsakymas[1];
    char vardas[25];

    if(argc < 3) {
        printf("\nRasyti: client host-name host-port\n");
	return 0;
    }
    else
        hostPort = atoi(argv[2]);

    printf("\nMaking a socket");
    /* make a socket */
    sockfd = socket(AF_INET, SOCK_STREAM, 0);

    if (sockfd == SOCKET_ERROR) {
        printf("\nCould not make a socket\n");
        return 0;
    }

    hostInfo = gethostbyname(argv[1]);       // get IP address from name

    bzero((char*)&Address, sizeof(Address)); //buffer to zero
    /* fill address struct */
    Address.sin_addr = *((struct in_addr *)hostInfo->h_addr);
    Address.sin_port = htons(hostPort);
    Address.sin_family = AF_INET;

    printf("\nConnecting to %s on port %d", inet_ntoa(*((struct in_addr *)hostInfo->h_addr)), hostPort);

    /* connect to host */
    if (connect(sockfd, (struct sockaddr*) &Address, sizeof(Address)) == SOCKET_ERROR) {
        printf("\nCould not connect to host\n");
        return 0;
    }

    //--------------------KLIENTO VEIKSMAI------------------------------------

    //---------------- Suzinome zaidejo varda ------------------------------------
    recv_line(sockfd, pBuffer, BUFFER_SIZE);
    printf("\n%s\n", pBuffer);
    scanf("%s", &vardas);
    send_line(sockfd, vardas);

    //--------- Klausimu uzdavimo ir atsakymo siuntimo ciklas------------
    int i;
    for(i=1; i<=KLAUSIMU_SK; i++) {
        recv_line(sockfd, pBuffer, BUFFER_SIZE);
        printf("[%d] : %s", i, pBuffer);
        scanf("%s", &atsakymas);
        send_line(sockfd, atsakymas);
    }

    //------ Pateikiama teisingu klausimu bei balu ataskaita---------------
    recv_line(sockfd, (char*) &ksk, BUFFER_SIZE);
    printf("\nJums buvo pateikta %d klausimu.", KLAUSIMU_SK);
    printf("\nJus atsakete teisingai i: %d klausima (-us) ", ksk);
    recv_line(sockfd, (char*) &bsk, BUFFER_SIZE);
    printf("uz kuriuos gavote: %d balu.", bsk);
    printf("\nAciu, kad zaidete si zaidima.\n");

    if (close(sockfd) == SOCKET_ERROR) {
        printf("\nCould not close socket\n");
        return 0;
    }
    return 0;
}
