/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *    Uzduoti atliko: Artur Karaznevic, Informatika II k, 5gr.                   *
 *    Uzduotis: Zaidimas                                                         *
 *    Prie serverio jungiasi klientai,jiems uzduodami klausimai                  *
 *    Atsakymas i klausima gali buti: TAIP arba NE                               *
 *    Programos pabaigoje pateikiama statistika                                  *
 *                                                                               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#define SOCKET_ERROR     -1
#define BUFFER_SIZE      256
#define MESSAGE1         "Iveskite savo varda:"
#define QUEUE_SIZE       5
#define KLAUSIMU_SK        10
#define N 100

//-------------------------------------------------------------------------
void send_line(int new_fd, char * Buffer) {
    send(new_fd, Buffer, BUFFER_SIZE, 0);
    send(new_fd, "$", 1, 0);
}
//-------------------------------------------------------------------------
void recv_line(int new_fd, char * Buffer, int size) {
    int len = 0;
    while (1) {
        int n = recv(new_fd, &Buffer[len], 1, 0);
        if (n <= 0 || Buffer[len] == '$')
            break;
        if (len < size - 1)
            len++;
    }
    Buffer[len] = '$';
}
//-------------------------------------------------------------------------
int main(int argc, char* argv[]) {
    int new_fd, sockfd, clilen;                   // handle to socket
    struct hostent* pHostInfo;                    // holds info about a machine
    struct sockaddr_in my_addr, their_addr;       // Internet socket my_addr stuct
    int my_addrSize = sizeof(struct sockaddr_in);
    char Buffer[BUFFER_SIZE];
    int hostPort;
    int teisingu = 0;
    char *klausimas[]={
        "I floppy diska telpa 799Mb duomenu. (t/n)\n",
        "MIF'o dekanas Justasiunas. (t/n)\n",
        "Dabartinis Kauno 'Zalgirio' vyriausias treneris A. Bagatskis. (t/n)\n",
	"Vilniaus meras yra R. Paksas. (t/n)\n",
	"V. Adamkus yra vienas garsiausiu pop zvaigzdziu atlykeju. (t/n)\n",
	"doc. Misevicius desto matematine analize. (t/n)\n",
	"5 grupe valdo (t/n)\n",
	"As atsiskaitysiu sia programa! (t/n)\n",
	"Sita programa parasyta su Paskaliu. (t/n)\n",
	"Jus zaidziate zaidima pagauk katina. (t/n)\n",
	"2006m. kovo 30d. Lietuvoje buvo saules uztemimas. (t/n)\n",
	"Metai turi 12 menesiu. (t/n)\n",
	"Kompiuteris be monitoriaus, kaip zmogus be lezuvio. (t/n)\n",
	"Dabartinis LR Prezidentas yra V.Sustauskas. (t/n)\n",
	"Java programavimo kalba atsirado vidaramziu laikais. (t/n)\n",
	"Dabartiniai DVD diskai gali sutalpinti virs 8GB duomenu. (t/n)\n",
	"Du kart du yra saknys is keturiu plius 1. (t/n)\n",
	"WindowsXp tai Solaris produktas. (t/n)\n",
	"E-mailas yra labai greitas ir patogus pastas. (t/n)\n"
    };
    char *atsakymas[]={"n","n","t","n","n","t","t","t","n","n","t","t","t","n","n","t","n","n","t"};

    if (argc < 2) {
        printf("\nRasykite: server port\n");
        exit(1);
    }

    printf("\nStarting server");
    hostPort = atoi(argv[1]);                     // man atoi = convert a string to an integer

    /*------------------------------------ S O C K E T () ------------------------------------------------
     * make a socket
     * sukuriamas lizdas kvieciant socket(), kaip parametrai perduodama:
              i)   domenas
              ii)  lizdo tipas
              iii) protokolas
     * funkcija socket() tiesiog sukuria lizda, kuriuo galima bandyti jungtis kur nors arba
     * klausytis kokio nors porto, bet nenustato kam konkreciai tas lizdas bus naudojamas
     ----------------------------------------------------------------------------------------------------*/
    printf("\nMaking socket");
    sockfd = socket(AF_INET, SOCK_STREAM, 0);

    if (sockfd == SOCKET_ERROR) {
        printf("\nCould not make a socket\n");
        return 0;
    }
     bzero((char*) &my_addr, sizeof(my_addr));    // man bzero = write zero bytes

    /* fill my_addr struct */
    my_addr.sin_family = AF_INET;
    my_addr.sin_addr.s_addr = INADDR_ANY;
    my_addr.sin_port = htons(hostPort);           // man htons = convert values between host and network byte order


    /*----------------------------------------- B I N D () -------------------------------------------------
     * bind to a port
     * susieja lizda su konkreciu tinklo interfeiso portu, kaip parametrai perduodama:
               i)  lizdo deskriptorius
	       ii) adresas (priklauso nuo pasirinkto domeno ir protokolo)
     * funkcija bind() 'priskiria lizdui varda'
     ----------------------------------------------------------------------------------------------------*/
    printf("\nBinding to port %d", hostPort);
    if (bind(sockfd, (struct sockaddr*) &my_addr, sizeof(my_addr)) == SOCKET_ERROR) {
        printf("\nCould not connect to host\n");
        return 0;
    }

    /*-------------------------------------- L I S T E N () ----------------------------------------------
    * kvieciant listen() funkcija yra parodomas ketinimas priimti prisijungimus prie lizdo (priristu adresu)
    * kaip parametrai siai funkcijai yra perduodamas:
               i) skaicius, kiek daugiausia prisijungimu bus priimama; laukti kol jie bus apdoroti
     ----------------------------------------------------------------------------------------------------*/
    printf("\nMaking a listen queue of %d elements", QUEUE_SIZE);
    /* establish listen queue */
    listen(sockfd, QUEUE_SIZE);
    clilen = sizeof(their_addr);

    //--------------------SERVERIO VEIKSMAI------------------------------------

    while (1) {
        printf("\nLaukiam prisijungimo\n");

	/*------------------------------------- A C C E P T () ---------------------------------------------
	* pats prisijungimas yra priimamas kvieciant funkcija accept(). Kaip parametrai perduodama:
	          i) rodykle i struct sockaddr
		  ii) dydis (ilgis)
        * sitas lizdas nera modifikuojamas, uztat kai priimamas prisijungimas, yra sukuriamas ir grazinamas naujas lizdas
	* jau sujungtas su klientu;struc sockaddr parametras yra uzpildomas prie serverio priisijungusio kliento adresu
	* virtualus kanalas yra sukurtas ir galima pradeti bendravima
	----------------------------------------------------------------------------------------------------*/
        new_fd = accept(sockfd, (struct sockaddr*) &their_addr, &clilen);
	if (new_fd < 0) printf("Error accept");
	printf("got connection from %s\n", inet_ntoa(their_addr.sin_addr));
	// inet_aton() converts the Internet host address cp from the standard numbers-and-dots  notation
	// into  binary data  and  stores it in the structure that inp points to. returns nonzero if the address is valid,
        // zero if not.

	if (!fork()) {                            // man fork = create a child process
	    teisingu = 0;
	    int balai=0;
	    printf("\n######## ZAIDIMAS ########");
	    strcpy(Buffer, MESSAGE1);
	    send_line(new_fd, Buffer);
	    recv_line(new_fd, Buffer, BUFFER_SIZE);
	    printf("\nVartotojas: %s prisijunge", Buffer);

	    // ------------------------ Klausimai ------------------------
	    int x,i;
	    srand((unsigned)time(NULL));
	    for(i=1; i<=KLAUSIMU_SK; i++) {
	        x=rand()%19;
	        send_line(new_fd, klausimas[x]);
	        recv_line(new_fd, Buffer, BUFFER_SIZE);
	        if (strcmp(Buffer, atsakymas[x]) == 0) {
	            teisingu++;
		    balai+=100;
	        }
		else
		    balai-=50;
		if (balai<0 ? balai=0 : balai);
	    }

	    //-------- Teisingu atsakymu ir balu siuntimas --------
	    printf("\nTeisingu atsakymu: %d", teisingu);
            send_line(new_fd, (char*) &teisingu);
	    send_line(new_fd, (char*) &balai);
     	}
	else
	    close(new_fd);
    }
}
