#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h> //defines the structure hostent
#include <string.h>
#include <stdio.h>
#define SOCKET_ERROR        -1
#define BUFFER_SIZE         256

void spausdinti(unsigned readAmount, char* buffer) {
    buffer[readAmount] = '\0';
    printf("\n%s", buffer);
}

void siusti(int sockfd, char* vardas) {
    int size;
    size = strlen(vardas);
    vardas[size] = '\n';
    vardas[size + 1] = '\0';
    send(sockfd, vardas, strlen(vardas), 0);
}

int  main(int argc, char* argv[]) {
    int sockfd;                              // handle to socket
    struct hostent* hostInfo;                // holds info about a machine
    struct sockaddr_in Address;              // Internet socket address struct
    char pBuffer[BUFFER_SIZE];
    char* buffer;
    unsigned readAmount;
    int hostPort;
    int sk, size;
    char atsakymas[1];
    char vardas[25];

    if(argc < 3) {
	printf("\nRasyti: client host-name host-port\n");
	return 0;
    }
    else
	hostPort = atoi(argv[2]);

    printf("\nMaking a socket");
    /* make a socket */
    sockfd = socket(AF_INET, SOCK_STREAM, 0);

    if (sockfd == SOCKET_ERROR) {
        printf("\nCould not make a socket\n");
        return 0;
    }

    /* get IP address from name */
    hostInfo = gethostbyname(argv[1]);

    bzero((char*)&Address, sizeof(Address)); //buffer to zero
    /* fill address struct */
    Address.sin_addr = *((struct in_addr *)hostInfo->h_addr);
    Address.sin_port = htons(hostPort);
    Address.sin_family = AF_INET;

    printf("\nConnecting to %s on port %d", inet_ntoa(*((struct in_addr *)hostInfo->h_addr)), hostPort);

    /* connect to host */
    if (connect(sockfd, (struct sockaddr*) &Address, sizeof(Address)) == SOCKET_ERROR) {
        printf("\nCould not connect to host\n");
        return 0;
    }

    /* read from socket into buffer
    ** number returned by read() and write() is the number of bytes
    ** read or written, with -1 being that an error occured */

    //## kliento veiksmai #############################################
    readAmount = recv(sockfd, pBuffer, BUFFER_SIZE, 0);
    spausdinti(readAmount, pBuffer);
    scanf("%s", &vardas);
    siusti(sockfd, vardas);

    //-- klausimai -----------------------------------------
    int i;
    for( i=1; i<=10; i++) {
        readAmount = recv(sockfd, pBuffer, BUFFER_SIZE, 0);
        spausdinti(readAmount, pBuffer);
        scanf("%s", &atsakymas);
        siusti(sockfd, atsakymas);
    }

    // -- teisingu atsakymu -----------------------------
    readAmount = recv(sockfd, pBuffer, BUFFER_SIZE, 0);
    spausdinti(readAmount, pBuffer);
    readAmount = recv(sockfd, pBuffer, BUFFER_SIZE, 0);
    spausdinti(readAmount, pBuffer);

    if (close(sockfd) == SOCKET_ERROR) {
        printf("\nCould not close socket\n");
        return 0;
    }
    return 0;
}
