/*  bank server (model)
*
*   (c)2007 Ignas Butenas
*   Compiled with DEV-C++ 4.9.9.2
*   (need to add winsock lib into project)
*/
#include <iostream>
#include <winsock.h> //winsock library
#include "headers/App.h"
using namespace std;

int start(SOCKET sock, unsigned short port);
char* action(char* output);

App* app = new App();

int main(int argc, char *argv[])
{
    WSADATA info;
    SOCKET sock;
    int portas;
    
    cout << "Enter the port number which will be used to create the socket: "<< endl;
    cin >> portas;
    
    /*creating a socket*/
    if (WSAStartup(MAKEWORD(1,1),&info) != 0) { //initializing library. MAKEWORD(1,1) - variable to get version, &info - address to default struct
       cout << "Socket cannot be created!" << endl;            
       return 0;                        
    }
    
    sock = socket(AF_INET,SOCK_STREAM,0); //AF_INET - TCP/IP connection, SOCK_STREAM - stream type of socket
    if (sock == INVALID_SOCKET) {         //function socket() returns this type of variable if no socket was created
       cout << "Socket cannot be created!" << endl;         
       return 0;
    }
    /*socket was created succesfully if program still works :) */

    start(sock,portas);                //starting server at last
    cout << "Server started and waiting for a client." << endl;       //hooray, server is now ready for work
    
    //waiting for connections
    
    
    
    while (true) {
          SOCKET new_sock = accept(sock,NULL,NULL);
          
          cout << "Conection accepted! User is online." << endl;
          
          if (new_sock == INVALID_SOCKET) {
             cout << "Connection failed!" << endl;             
          }     
          //sending welcome message to client
          send(new_sock, "Hello! Welcome to the server.\n", (int)strlen("Hello! Welcome to the server.\n"), 0);
          
          char buffer[2] = "0";
          char output[255] = "";
          
          //send / receive
          do {
			char buf[2] = "0";
			char output[255] = "";
			
			// Read string from client
			while (buf[0] != '\n') {
				if (recv(new_sock, buf, 1, 0) > 0) {
					cout << buf[0];
					strncat(output, buf, 1);
				}
			}

			if (!strcmp(output,"exit\r\n")) {
				// Say goodbye
				char* bye_str = "Bye\n";
				send(new_sock, bye_str, (int)strlen(bye_str), 0);
				closesocket(new_sock);
				printf("*** Client disconnected\n");
				break;
			} else {
				//here goes the functions of server
				
				char* tmp = action(output);
				
                // Send string to client
				send(new_sock, tmp, (int)strlen(tmp), 0);
			}
		} while (true);
           
    }
    delete app;
    //we finished the job
    return 0;
}

/*functions*/

int start(SOCKET sock, unsigned short port) {
     
     struct sockaddr_in sin;                //getting default socket struct
     memset( &sin, 0, sizeof sin );         //clear our address
     sin.sin_family = AF_INET;              //internet type connection
     sin.sin_addr.s_addr = INADDR_ANY;      //any address
     sin.sin_port = htons( port );          //setting port number whick will be listen

     if (bind(sock, (struct sockaddr *)&sin, sizeof(struct sockaddr_in)) == SOCKET_ERROR) { //bind the socket
		closesocket(sock);           //if there was ay problems
		return -2;
	 }
	 
	 listen(sock,3);
	 
	 return 0;
     
        
}

char* action(char* _output) { //function to call the app object's method checkCommand and give the full control to it. 
                              //This function returns what we need to send to the user.
     char endl[2] = "\n";
     string tmpstr = ""; //carrying value which was returned from functions.
     string str = _output;
     
     tmpstr = app->checkCommand(str); //checks what to do.
     
     strcpy(_output, tmpstr.c_str()); //copying string to standart array of chars   
     strncat(_output, endl, 1);        //adding \n to the end of array to keep wrking server
     return _output;     
}
