/*
/App class:
/    This is the class which helps ot make inteface and kernel interact to each other.
*/

#include <iostream>
#include <string>
#include <sstream>
#include "../headers/App.h"

using namespace std;

App::App() : auth(0), putget(0) { user = new User(); db = new Db(); }

App::~App() { delete user; delete db; }

string App::checkCommand(string _com) {
      string str;
      int tmp = 0;
      
      if (auth == 1) { str = login(_com); tmp = 1; }
      if (putget == 1) { str = putMoney(_com); tmp = 1; }
      if (putget == 2) { str = getMoney(_com); tmp = 1; }
      if (_com == "help\r\n") { str = help(); tmp = 1; }
      if (_com == "login\r\n") {str = "Please type your name:"; tmp = 1; auth = 1;}
      if (_com == "logout\r\n") { str = logout(); tmp = 1; }
      if (_com == "user\r\n") {str = getUserName(); tmp = 1;}
      if (_com == "balance\r\n") {str = getBalance(); tmp = 1;}
      if (_com == "put\r\n") { str = "You choosed to put money in your account. Please enter amount:"; tmp = 1; putget = 1; }
      if (_com == "get\r\n") { str = "You chosed to get money. Please enter amount:"; tmp = 1; putget = 2; }
      if (tmp == 0) { str = "Unknown command! Type 'help' for help."; }
      
      return str;
     
}

string App::help() {
      return "Commands: *help *exit *login *user *balance *logout *put *get";      
}

string App::login(string _name) {
       
       db->readDatabase(_name);
       int tmp = db->getUserNumber();
       if (tmp >= 1) {
          cout << "User logged in with number:  " << tmp << endl;
          user->setUsername(_name);
          auth = 0;
          return  "Username: " + user->getUsername();       
       } else {
          auth = 1;
          return "Your username is not valid! Please enter another: ";       
       }
}

string App::logout() {
       user->logout();
       db->clear();
       cout << "User logged out." << endl;
       return "You have been disconnected from system.";       
}


string App::getBalance() {
       int auth = user->getAuth();  
       string usern = user->getUsername();    
       return db->getBalance(usern, auth);
}

string App::getUserName() { return user->getUsername(); }

string App::intToStr(int _numb) { //converts integer to string

    stringstream ss;
    ss << _numb;
    return ss.str();
       
}

int App::strToInt(string _str) { //converts string to integer

    stringstream ss(_str);
    int n;
    ss >> n;
    return n;
      
}

string App::putMoney(string _str) {
       int amount = strToInt(_str);
       putget = 0;
       return db->putMoney(amount);     
}

string App::getMoney(string _str) {
       int amount = strToInt(_str);
       putget = 0;
      return db->getMoney(amount);           
}
