//import java.applet.*;
import javax.swing.JApplet;
import java.awt.*;
/**
 *
 * @author Audrone
 */
public class Medis extends JApplet
{
    Graphics page;
    int depth;
    Choice depthChoice;

    Choice depthColor, depthKaip;
    String spalva;
    int depthSp;

    int kamienas = 150;
    int x0 = 350;
    int y0 = 600;

    int[][] saka;
    int[][] lineNew = new int[2][2];

    public Medis()
    {
         saka = new int[2][2]; // 0-x:1-y
         saka[0][0] = x0;
         saka[0][1] = y0;
         saka[1] = transformationT(saka[0], kamienas, (-(Math.PI/2)), 0);
    }

    public void init()
    {
        page = getGraphics();
        page.setColor(Color.black);
    	setBackground(Color.white);
        
        setLayout(null);

        depth = 1;
        depthChoice = new Choice();
        int ilyg = 14; //ilyg gali buti ne daugiau 17
        for (int i=0; i<ilyg; i++)
            depthChoice.addItem("" + i);        
        depthChoice.select(depth);
        this.add(depthChoice);
        depthChoice.setBounds(0,0,40,20);

        depthColor = new Choice();
        depthColor.addItem("Juoda");
        depthColor.addItem("Žalia");
        spalva = "Juoda";
        depthColor.select(spalva);
        this.add(depthColor);
        depthColor.setBounds(45, 0, 60, 20);
                
        depthSp = 1;
        depthKaip = new Choice();
        for (int i=1; i<=6; i++)        
            depthKaip.addItem("" + i);        
        depthKaip.select(depthSp-1);
        this.add(depthKaip);
        depthKaip.setBounds(110,0,40,20);
        depthKaip.setVisible(false);
    }

    @Override
    public void paint(Graphics g)
    {
        if (spalva.equals("Žalia"))
        {
            g.setColor(new Color(178, 88, 5));
            g.drawLine(saka[0][0], saka[0][1], saka[1][0], saka[1][1]);
            drawSakos(saka[1], 0, g, (-(Math.PI/2)), kamienas);
        }
        else
        {
            g.setColor(Color.BLACK);
            g.drawLine(saka[0][0], saka[0][1], saka[1][0], saka[1][1]);
            drawSakosJ(saka[1], 0, g, (-(Math.PI/2)), kamienas);
        }
    }

//    @Override
    public void perrepaint()
    {
        page.clearRect(0, 0,  x0*2+100, y0 + 100);
        paint(page);
//        this.setForeground(Color.WHITE);
//        update(this.getGraphics());
    }

    public void drawSakos(int[] line, int level, Graphics g, double alfa, double R)
    {
        switch(depthSp)
        {
            case  6: drawSakosSp1(line, level, g, alfa, R); break;
            case  5: drawSakosSp2(line, level, g, alfa, R); break;
            case  3: drawSakosSp3(line, level, g, alfa, R); break;
            case  2: drawSakosSp4(line, level, g, alfa, R); break;
            case  4: drawSakosSp5(line, level, g, alfa, R); break;
            case  1: drawSakosSp0(line, level, g, alfa, R); break;
            default: drawSakosSp0(line, level, g, alfa, R); break;
        }        
    }

    public void drawSakosSp0(int[] line, int level, Graphics g, double alfa, double R)
    {
        if (level < depth)
        {
            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.59, (alfa-(Math.PI*3/7)), 0);
            g.setColor(new Color(0, 120+(level*9), 0));//zalia
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosSp0(lineNew[1], level+1, g, (alfa-(Math.PI*3/7)), R*0.59);

            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.64, (alfa+(Math.PI*6/13)), 0);
            g.setColor(new Color(0+(level*17), 120+(level*9), 0+(level*3)));//geltona
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosSp0(lineNew[1], level+1, g, (alfa+(Math.PI*6/13)), R*0.64);

            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.75, (alfa+(Math.PI/12)), 0);
            g.setColor(new Color(0+(level*17), 120+(level*3), 0));//oranzine
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosSp0(lineNew[1], level+1, g, (alfa+(Math.PI/12)), R*0.75);
        }
    }

    public void drawSakosSp4(int[] line, int level, Graphics g, double alfa, double R)
    {
        if (level < depth)
        {
            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.75, (alfa+(Math.PI/12)), 0);
            g.setColor(new Color(0+(level*17), 120+(level*3), 0));//oranzine
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosSp4(lineNew[1], level+1, g, (alfa+(Math.PI/12)), R*0.75);

            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.64, (alfa+(Math.PI*6/13)), 0);
            g.setColor(new Color(0+(level*17), 120+(level*9), 0+(level*3)));//geltona
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosSp4(lineNew[1], level+1, g, (alfa+(Math.PI*6/13)), R*0.64);

            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.59, (alfa-(Math.PI*3/7)), 0);
            g.setColor(new Color(0, 120+(level*9), 0));//zalia
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosSp4(lineNew[1], level+1, g, (alfa-(Math.PI*3/7)), R*0.59);
        }
    }

    public void drawSakosSp1(int[] line, int level, Graphics g, double alfa, double R)
    {
        if (level < depth)
        {
            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.59, (alfa-(Math.PI*3/7)), 0);
            g.setColor(new Color(0+(level*6), 120+(level*6), 0+(level*7)));//zalia
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosSp1(lineNew[1], level+1, g, (alfa-(Math.PI*3/7)), R*0.59);

            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.75, (alfa+(Math.PI/12)), 0);
            g.setColor(new Color(0+(level*17), 120+(level*3), 0));//oranzine
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosSp1(lineNew[1], level+1, g, (alfa+(Math.PI/12)), R*0.75);

            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.64, (alfa+(Math.PI*6/13)), 0);
            g.setColor(new Color(0+(level*14), 120-(level*4), 0));//geltona
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosSp1(lineNew[1], level+1, g, (alfa+(Math.PI*6/13)), R*0.64);
        }
    }

    public void drawSakosSp2(int[] line, int level, Graphics g, double alfa, double R)
    {
        if (level < depth)
        {
            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.64, (alfa+(Math.PI*6/13)), 0);
            g.setColor(new Color(0+(level*16), 120+(level*6), 0+(level)));//geltona
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosSp2(lineNew[1], level+1, g, (alfa+(Math.PI*6/13)), R*0.64);

            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.59, (alfa-(Math.PI*3/7)), 0);
            g.setColor(new Color(0, 120-(level*2), 0));//zalia
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosSp2(lineNew[1], level+1, g, (alfa-(Math.PI*3/7)), R*0.59);

            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.75, (alfa+(Math.PI/12)), 0);
            g.setColor(new Color(0+(level*17), 120-(level*7), 0));//oranzine
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosSp2(lineNew[1], level+1, g, (alfa+(Math.PI/12)), R*0.75);
        }
    }

    public void drawSakosSp3(int[] line, int level, Graphics g, double alfa, double R)
    {
        if (level < depth)
        {
            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.64, (alfa+(Math.PI*6/13)), 0);
            g.setColor(new Color(0+(level*11), 120-(level), 0));//geltona
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosSp3(lineNew[1], level+1, g, (alfa+(Math.PI*6/13)), R*0.64);

            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.75, (alfa+(Math.PI/12)), 0);
            g.setColor(new Color(0+(level*9), 120-(level*6), 0));//oranzine
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosSp3(lineNew[1], level+1, g, (alfa+(Math.PI/12)), R*0.75);

            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.59, (alfa-(Math.PI*3/7)), 0);
            g.setColor(new Color(0+(level*13), 120+(level*9), 0+(level*9)));//zalia
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosSp3(lineNew[1], level+1, g, (alfa-(Math.PI*3/7)), R*0.59);
        }
    }

    public void drawSakosSp5(int[] line, int level, Graphics g, double alfa, double R)
    {
        if (level < depth)
        {
            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.75, (alfa+(Math.PI/12)), 0);
            g.setColor(new Color(0+(level*14), 120-(level*4), 0));//geltona
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosSp5(lineNew[1], level+1, g, (alfa+(Math.PI/12)), R*0.75);

            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.59, (alfa-(Math.PI*3/7)), 0);
            g.setColor(new Color(0+(level*6), 120+(level*6), 0+(level*7)));//zalia
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosSp5(lineNew[1], level+1, g, (alfa-(Math.PI*3/7)), R*0.59);

            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.64, (alfa+(Math.PI*6/13)), 0);
            g.setColor(new Color(0+(level*17), 120+(level*9), 0+(level*3)));//geltona
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosSp5(lineNew[1], level+1, g, (alfa+(Math.PI*6/13)), R*0.64);
        }
    }

    public void drawSakosJ(int[] line, int level, Graphics g, double alfa, double R)
    {
        if (level < depth)
        {
            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.59, (alfa-(Math.PI*3/7)), 0);            
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosJ(lineNew[1], level+1, g, (alfa-(Math.PI*3/7)), R*0.59);

            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.64, (alfa+(Math.PI*6/13)), 0);           
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosJ(lineNew[1], level+1, g, (alfa+(Math.PI*6/13)), R*0.64);

            lineNew[0] = line;
            lineNew[1] = transformationT(line, R*0.75, (alfa+(Math.PI/12)), 0);            
            g.drawLine(lineNew[0][0], lineNew[0][1], lineNew[1][0], lineNew[1][1]);
            drawSakosJ(lineNew[1], level+1, g, (alfa+(Math.PI/12)), R*0.75);
        }
    }

    @Override
    public boolean action(Event e, Object obj) {
        if (e.target == depthChoice)
        {
            String theChoice = depthChoice.getSelectedItem();
            depth = Integer.parseInt(theChoice);
            if (spalva.equals("Žalia"))
                if (depth < 7)
                    depthKaip.setVisible(false);
                else depthKaip.setVisible(true);
            perrepaint();
            return true;
        }
        else if (e.target == depthColor)
        {
            spalva = String.valueOf( depthColor.getSelectedItem());
            if (spalva.equals("Juoda"))                
                depthKaip.setVisible(false);
            else if (depth < 9)
                    depthKaip.setVisible(false);
                else depthKaip.setVisible(true);                
            perrepaint();
            return true;
        }
        else if (e.target == depthKaip)
        {
            String theChoice = depthKaip.getSelectedItem();
            depthSp = Integer.parseInt(theChoice);            
            perrepaint();
            return true;
        }
        else{return super.action(e, obj);}
    }

    private int[] transformationT(int[] centras, double R , double alfa, double pAlfa)
    {
    	int[] tmp = new int[2];
        tmp[0] = (int) (Math.cos(alfa+pAlfa)* R + centras[0]);
        tmp[1] = (int) (Math.sin(alfa+pAlfa)* R + centras[1]);
        return tmp;
    }
}

   
