#include <GL/gl.h>
#include <GL/glut.h>
#include <iostream>
#include <cstring>

using namespace std;
int k = 1;
int displayMode;
int displayMenu, mainMenu;
enum {TRANSFORMACIJA_1, TRANSFORMACIJA_2, TRANSFORMACIJA_3, TRANSFORMACIJA_4};

/* Viewer state */
float sphi=90.0, stheta=45.0;
float sdepth = 10;
float zNear=1.0, zFar=100.0;
float aspect = 5.0/4.0;
float xcam = 0, ycam = 0;

#define milliseconds_per_frame  33
#define step  0.01    
                                                                             
int width;
int height;

int winWidth = 640;      
int winHeight = 640;

float x_rotate = 0.0;   
float y_rotate = 0.0f;  
float z_rotate = 0.0;

bool ortho = false;    
bool animating = false;  

int curX, curY;        
int leftButtonDown, rightButtonDown; 

float x_scale = 1;          
float y_scale = 1;
float z_scale = 1;


float x_move = 0;
float y_move = 0;
float z_move = 0;


int max_lines = 7;

int transformationID = 0;
int recDepth = 1;
bool enableCubeMoving = true;
bool colors = true; 

float control = 1;
void MyInit(){
      
 
    GLfloat ambient_light[] = { 0.6f, 0.6f, 0.6f, 1.0f };
    GLfloat diffuse_light[] = { 0.8f, 0.8f, 0.8, 1.0f };
    GLfloat specular_light[] = { 0.5f, 0.5f, 0.5f, 1.0f };
    GLfloat light_position[] = { -60.0f, -40.0f, -50.0f, 1.0f };
    glEnable( GL_DEPTH_TEST );
    glEnable( GL_BLEND );
    glEnable( GL_LIGHTING );
    glEnable( GL_LIGHT0 );
    
    glShadeModel (GL_FLAT);
    
    glEnable( GL_AUTO_NORMAL );
    glEnable( GL_NORMALIZE );
    glEnable( GL_COLOR_MATERIAL );
    
    glDepthFunc (GL_LESS);
    glEnable( GL_DEPTH_TEST);
    glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );  
         
    glLightfv (GL_LIGHT0, GL_AMBIENT, ambient_light);
    glLightfv (GL_LIGHT0, GL_DIFFUSE, diffuse_light);
    glLightfv (GL_LIGHT0, GL_POSITION, light_position);     
    glLightfv (GL_LIGHT0, GL_SPECULAR, specular_light);
    
   }

void setDefault(){
     enableCubeMoving= true;
     transformationID = 0;
     x_rotate = z_rotate = y_rotate = 0.0f; 
     x_scale = y_scale = z_scale = 1.0f;
     x_move= y_move= z_move= 0.0f;
     glutPostRedisplay();   
    
     }

void drawObjects(int i, int times) {

   if (i <= 1 ) 
    {
           
   glBegin(GL_TRIANGLES);
    
//   if (!colors) glColor3f(0,0,0.8); 
	      glVertex3f(10.0, -10.0, -10.0);
	      glVertex3f(-10.0, -10.0, -10.0);
	      glVertex3f(-10.0, 10.0, -10.0);

//   if(!colors) glColor3f(0,0.8,0);
	      glVertex3f(-10.0, -10.0, -10.0);
	      glVertex3f(-10.0, -10.0, 10.0);
	      glVertex3f(-10.0, 10.0, -10.0);

//   if (!colors) glColor3f(0.8,0,0); 
	      glVertex3f(-10.0, -10.0, 10.0);
          glVertex3f(10.0, -10.0, -10.0);
	      glVertex3f(-10.0, 10.0, -10.0);

 //  if (!colors) glColor3f(0.8,0.8,0); 
	      glVertex3f(10.0, -10.0, -10.0);
	      glVertex3f(-10.0, -10.0, -10.0);
	      glVertex3f(-10.0, -10.0, 10.0);      
     
	    glEnd();
    }
    else 
    {
         
	   --i; 
           
  if (times==1)   if (colors) glColor3f(1,1,0); 
       glPushMatrix();
       glTranslatef(-5.0, -5.0, -5.0);
	   glRotatef(90.0, 0.0, 0.0, 1.0);
       glRotatef(90.0, 1.0, 0.0, 0.0);
       glScalef(0.5, 0.5, 0.5);
	   drawObjects(i, times+1);
	   glPopMatrix();
      
 if (times==1)   if (colors)glColor3f(1,0,0);
	   glPushMatrix();  
       glTranslatef(-5.0, -5.0, 5.0);
       glScalef(0.5, 0.5, 0.5);
       drawObjects(i, times+1);
       glPopMatrix();
             
  if (times==1)  if (colors) glColor3f(0,1,0);
      
	   glPushMatrix();
	   glTranslatef(5.0, -5.0, -5.0);
	   glScalef(0.5, -0.5, 0.5);     
	   drawObjects(i, times+1);
	   glPopMatrix();

 if (times==1)   if (colors)glColor3f(0,0,1);
       glPushMatrix();
	   glTranslatef(-5.0, 5.0, -5.0);
	   glScalef(0.5, 0.5, 0.5);
	   drawObjects(i, times+1);
	   glPopMatrix();
	   
	  
    }
    
    
}
void reshape(int new_width, int new_height) {
      
   glViewport(0,0,new_width,new_height);
   height = new_height;
   width = new_width;
}



void timer(int id) {
   
      
  switch (transformationID) {
      
      
case 1:{ //ok
        x_move -=2*step;
        y_move -=2*step;
        z_move +=2*step;   
        
        x_scale -= step/10;
        y_scale -= step/10;
        z_scale -= step/10;
        
       
        control -=step/10;
        if (control  == 0.5 || control < 0.5){
                     transformationID = 0;
                     animating= false;
                      glLoadIdentity(); 
                      
              
           }
        else {
            
            glutTimerFunc(33,timer, 1);
        glutPostRedisplay();
        }
       break;              
       
       }
       
    case 2:{ 
         
        control -= step/10;   
        x_move -=2*step;
        y_move -=2*step;
        z_move -=step; 
        
       
        x_scale -= step/10;
        z_scale -= step/10;
      if (control == 0.999f)
       y_scale = step/10 -y_scale;
      else 
      y_scale +=step/10;

        
        z_rotate += 0.18;
      
        
        if (control  == 0.5 || control < 0.5){
                     transformationID = 0;
                     animating= false;
                     glLoadIdentity(); 
                     glutPostRedisplay();
            }
        else {
            
            glutTimerFunc(33,timer, 1);
            glutPostRedisplay();
        }
                     
      break;
       }
       
   case 3:{  //ok 
        
        x_scale -= step/10;
        y_scale -= step/10;
        z_scale -= step/10;
        
        x_move -=2*step;
        y_move -=2*step;
        z_move -=2*step; 
        
       z_rotate +=0.18;
        control -=step/10;
        if (control  == 0.5 || control < 0.5){
                     transformationID = 0;
                     animating= false;
                      glLoadIdentity(); 
                   
           }
        else {
            
            glutTimerFunc(33,timer, 1);
        glutPostRedisplay();
        }
                     
       break;
       }
       
       
   case 4:{ //ok  
        
        x_scale -= step/10;
        y_scale -= step/10;
        z_scale -= step/10;
        
        x_move -=1.5*step;
        y_move +=2*step;
        z_move +=2*step;
         
        control -=step/10;
        
        if (control  == 0.5 || control < 0.5){
                         transformationID = 0;
                     animating= false;
                      glLoadIdentity(); 
                   
           }
           
        else {
            
            glutTimerFunc(33,timer, 1);
            glutPostRedisplay();
        }
                     
       break;
       }
       
       
       }
  
   
}


void drawCube (){
 
      glColor3f( 1.0f, 1.0f, 1.0f );
      glLineWidth ( 3 );
      glutWireCube( 20.01 );
      glLineWidth ( 0.001);
} 


void initTransformation() {
     
     
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   double aspect = ((double)height)/((double)width);
   if (ortho) {
      if (aspect >= 1)
         glOrtho(-16,16,-16*aspect,16*aspect,30,70);
      else
         glOrtho(-16/aspect,16/aspect,-16,16,30,70);
   }
   else {
      if (aspect >= 1)
         glFrustum(-10,10,-10*aspect,10*aspect,30,70);
      else
         glFrustum(-10/aspect,10/aspect,-10,10,30,70);
   }
   
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   gluLookAt(0,0,50,0,0,0,0,1,0);
   

 
   if (!enableCubeMoving)
     drawCube ();// fixed cube
   
   glRotatef(x_rotate,1,0,0);  
   glRotatef(y_rotate,0,1,0);
   glRotatef(z_rotate,0,0,1);
   
    
   glScalef(x_scale,y_scale,z_scale);
   
  
   glTranslatef(x_move,y_move,z_move);
   
   if (enableCubeMoving)
      drawCube ();// moveable cube
      
      

}


void display() {
   if (animating) {
   
      glutTimerFunc(milliseconds_per_frame,timer,1);                                                                                                //jc
   }  
    glMatrixMode(GL_MODELVIEW);
    
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);  
   initTransformation();           
    
   drawObjects(recDepth, 1);
   glFlush();
   glutSwapBuffers(); 
}


void keyboard(unsigned char key, int x, int y) {
  
  
   if (animating)
       return; 
               
   else if (key == 'p' || key == 'P') {
      ortho = !ortho;
      if (!animating)
         glutPostRedisplay();
         }
            
   else if ( key == 27){
        setDefault();
        animating=false;
        glutPostRedisplay();
         } 
   else if ( key == 'c' || key == 'C'){
            colors =!colors;
             glutPostRedisplay();
         }        
   }


void special(int key, int x, int y) {
   
  if (animating)
    return;
    
    if(key == GLUT_KEY_PAGE_UP){
            recDepth++;
            glutPostRedisplay();
            }
           
   else if (key == GLUT_KEY_PAGE_DOWN){ 
            recDepth--;
            glutPostRedisplay();
            }
  
}

 
void MouseClick(int button, int state, int x, int y) {

  int i;


 
  if ((x >= 0) && (x <= winWidth) && (y >= 0) && (y <= winHeight)) {

   
    if (state == GLUT_DOWN)
      
      if (button == GLUT_LEFT_BUTTON) {
	     rightButtonDown = FALSE;
	     leftButtonDown = TRUE;
	     curX = x;
	     curY = y;
      }
      
      else
       if (button == GLUT_RIGHT_BUTTON) {
	   leftButtonDown = FALSE;
	   rightButtonDown = TRUE;
	   curX = x;
	   curY = y;
      }

    
   else if (state == GLUT_UP) {
        leftButtonDown = FALSE;
        rightButtonDown = FALSE;
    }
    }

}


void MouseDrag(int x, int y) {

  float diffX, diffY;

  diffX = x - curX;
  diffY = y - curY;
  curX = x;
  curY = y;
  
  
  if (leftButtonDown) {
     if (x_rotate <= 90.0f && x_rotate > -90.0f)
    y_rotate += diffX;
    if (y_rotate>=360.0f) y_rotate -= 360.0f;
    if (y_rotate<=-360.0f) y_rotate += 360.0f;
    x_rotate += diffY;
    if (x_rotate>=360.0f) x_rotate -= 360.0f;
    if (x_rotate<=-360.0f) x_rotate += 360.0f;
  } 
  glutPostRedisplay();

}
void SetDisplayMenu(int value) {
  displayMode = value;
  switch(value) {
    case TRANSFORMACIJA_1: {
      
      setDefault(); 
      enableCubeMoving= false;
      animating = true;
      transformationID = 1;
      glutPostRedisplay();
      control = 1;   
      
   } 
        break;
    case TRANSFORMACIJA_2: {
      setDefault(); 
      enableCubeMoving= false;
      animating = true;
      transformationID = 2;
      glutPostRedisplay();
      control = 1;
   }
        break;
    case TRANSFORMACIJA_3: {
      setDefault(); 
      enableCubeMoving= false;
      animating = true;
      transformationID = 3;
      glutPostRedisplay();
      control = 1;
   }
        break; 
    case TRANSFORMACIJA_4: {
      setDefault();
      enableCubeMoving= false; 
      animating = true;
      transformationID = 4;
      glutPostRedisplay();
      control = 1;
   }      
        break; 
  }
  
  glutPostRedisplay();
}

void SetMainMenu(int value) {switch(value) {case 99: exit(0); break;}} 

void DisplayCallback(void) {
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(64.0, aspect, zNear, zFar);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity(); 
  glTranslatef(0.0,0.0,-sdepth);
  glRotatef(-stheta, 1.0, 0.0, 0.0);
  glRotatef(sphi, 0.0, 0.0, 1.0);
  switch (displayMode) {
    case TRANSFORMACIJA_1: {
      
      setDefault(); 
      enableCubeMoving= false;
      animating = true;
      transformationID = 1;
      glutPostRedisplay();
      control = 1;   
      
   } ;     break;
    case TRANSFORMACIJA_2: {
      setDefault(); 
      enableCubeMoving= false;
      animating = true;
      transformationID = 2;
      glutPostRedisplay();
      control = 1;
   };     break;
    case TRANSFORMACIJA_3: {
      setDefault(); 
      enableCubeMoving= false;
      animating = true;
      transformationID = 3;
      glutPostRedisplay();
      control = 1;
   };     break;   
    case TRANSFORMACIJA_4: {
      setDefault();
      enableCubeMoving= false; 
      animating = true;
      transformationID = 4;
      glutPostRedisplay();
      control = 1;
   };     break;   }
  glutSwapBuffers();
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); }

void InitMenu() {
  displayMenu = glutCreateMenu(SetDisplayMenu);
  glutAddMenuEntry("Transformacija 1", TRANSFORMACIJA_1);
  glutAddMenuEntry("Transformacija 2", TRANSFORMACIJA_2);
  glutAddMenuEntry("Transformacija 3", TRANSFORMACIJA_3);
  glutAddMenuEntry("Transformacija 4", TRANSFORMACIJA_4);
  mainMenu = glutCreateMenu(SetMainMenu);
  glutAddSubMenu("Transformacijos", displayMenu);
  glutAddMenuEntry("Exit", 99);
  glutAttachMenu(GLUT_RIGHT_BUTTON); 
}

void printInstructions (){
      cout << "\n MENIU \n\n"; 
      cout << "   Q           - baigti\n";
      cout << "   ESC         - is naujo pakrauti \n";
      cout << "   PgUp,PgDn   - iteracijos\n";
      cout << "   P           - orthographic <-> perspective\n";
      cout << "   C           - keisti spalva\n";          
     
     }

int main(int argc, char **argv) {

    glutInit(&argc,argv);
    glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH);
    glutInitWindowSize(winWidth,winHeight);     
    glutInitWindowPosition(150,50);    
  	glutCreateWindow("Donatas Vitkus 3gr.");
    printInstructions();
    glutDisplayFunc(display);
    glutReshapeFunc(reshape);
 
    glutMouseFunc(MouseClick);        
    glutMotionFunc(MouseDrag);     
 
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glPushMatrix();
//	
     InitMenu();
    glEnable(GL_DEPTH_TEST);
/*	GLfloat ambientLight[] = { 0.0f, 0.0f, 0.0f, 1.0f };
    GLfloat diffuseLight[] = { 1.0f, 1.0f, 1.0f, 1.0f };
    GLfloat specularLight[] = { 1.0f, 1.0f, 1.0f, 1.0f };
    GLfloat position[] = { -40.0f, 190.0f, 160.0f, 1.0f };  
    GLfloat position1[] = { 30.0f, 30.0f, -30.0f, 1.0f };
    
 	glLightfv(GL_LIGHT2, GL_AMBIENT, ambientLight);
    glLightfv(GL_LIGHT2, GL_DIFFUSE, diffuseLight);
    glLightfv(GL_LIGHT2, GL_SPECULAR, specularLight);
    glLightfv(GL_LIGHT2, GL_POSITION, position);
    glLightfv(GL_LIGHT1, GL_AMBIENT, ambientLight);
    glLightfv(GL_LIGHT1, GL_DIFFUSE, diffuseLight);
    glLightfv(GL_LIGHT1, GL_SPECULAR, specularLight);
    glLightfv(GL_LIGHT1, GL_POSITION, position1);
   
    glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT2);
	glEnable(GL_LIGHT1);
	
	glEnable(GL_COLOR_MATERIAL);
*/
//	glColorMaterial(GL_FRONT, GL_DIFFUSE);



    glutKeyboardFunc(keyboard); 
    glutSpecialFunc(special);   
    MyInit();

   glutMainLoop();
  
}

