#ifndef _MAIN_H
#define _MAIN_H

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <gl\gl.h>										// Header File For The OpenGL32 Library
#include <gl\glu.h>										// Header File For The GLu32 Library
#include "3DMath.h"
#include "Camera.h"
#include "main.h"


#define SCREEN_WIDTH 640								// We want our screen width 800 pixels
#define SCREEN_HEIGHT 480								// We want our screen height 600 pixels
#define SCREEN_DEPTH 16									// We want 16 bits per pixel

extern CCamera	g_Camera;									// This will be our global camera data
extern bool  g_bFullScreen;									// Set full screen as default
extern HWND  g_hWnd;										// This is the handle for the window
extern RECT  g_rRect;										// This holds the window dimensions
extern HDC   g_hDC;											// General HDC - (handle to device context)
extern HGLRC g_hRC;											// General OpenGL_DC - Our Rendering Context for OpenGL
extern HINSTANCE g_hInstance;								// This holds our window hInstance

extern int g_mousex;
extern int g_mousey;
extern int g_anglex;
extern int g_angley;
extern int g_leftButton;
extern int g_middleButton;
extern int g_moving;
extern int g_mousestartx;
extern int g_mousestarty;
extern float g_radius;
extern int directionalLight;
extern GLfloat lightPosition[4];
extern GLfloat lightPosition2[4];
extern GLfloat lightColor[4];
extern int ViewMode;
extern int g_cameraMoving;
extern int not_shadow;
extern int LightMode;
extern int MenuProjection;

extern GLUnurbsObj *nurbsas1, *nurbsas2, *nurbsas3, *nurbsas4, *nurbsas5, *nurbsas6;

enum { MENU_ORTHO, MENU_PROJ, MENU_VIEWPOINT1, MENU_VIEWPOINT2, MENU_VIEWPOINT3, MENU_LIGHT_SPOTLIGHT, MENU_LIGHT_DIRECTIONAL, MENU_LIGHT_OFF };

      

// This is our MAIN() for windows
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hprev, PSTR cmdline, int ishow);

// The window proc which handles all of window's messages.
LRESULT CALLBACK WinProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);

// This controls our main program loop
WPARAM MainLoop();

// This changes the screen to full screen mode
void ChangeToFullScreen();

// This is our own function that makes creating a window modular and easy
HWND CreateMyWindow(LPSTR strWindowName, int width, int height, DWORD dwStyle, bool bFullScreen, HINSTANCE hInstance);

// This allows us to configure our window for OpenGL and backbuffered
bool bSetupPixelFormat(HDC hdc);

// This inits our screen translations and projections
void SizeOpenGLScreen(int width, int height);

// This sets up OpenGL
void InitializeOpenGL(int width, int height);

// This initializes the whole program
void Init(HWND hWnd);

// This draws everything to the screen
void RenderScene();

// This frees all our memory in our program
void DeInit();

#endif 
