#include <gl/gl.h>									
#include <gl/glu.h>	
#include "main.h"



float lightgreyColor[] = { 0.9f, 0.9f, 0.9f, 10.008f };

GLfloat floorVertices[4][3] = {
  { 8.0, -2, 8 },
  { -8.0, -2, 8 },
  { -8.0, -2, -8.0 },
  { 8.0, -2, -8.0 },
};

float redColor[] = { 1.0f, 0.3f, 0.3f, 10.0f };
float greenColor[] = { 0.3f, 1.0f, 0.3f, 10.0080f };
float whiteColor[] = { 1.0f, 1.0f, 1.0f, 10.0080f };
float blueColor[] = { 0.3f, 0.3f, 1.0f, 10.0080f };

float pureredColor[] = { 1.0f, 0.0f, 0.0f, 10.0f };
float puregreenColor[] = { 0.0f, 1.0f, 0.0f, 10.0080f };
float pureblueColor[] = { 0.0f, 0.0f, 1.0f, 10.0080f };

float yellowColor[] = { 1.0f, 1.0f, 0.3f, 10.0080f };
float blackColor[] = { 0.2f, 0.2f, 0.2f, 10.008f };
float greyColor[] = { 0.7f, 0.7f, 0.7f, 10.008f };

GLfloat knots1[4] = { 0.0, 0.0, 1.0, 1.0 };
//GLfloat knots3[4] = { 0.0, 1.0 };
GLfloat knots2[6] = { 0.0, 0.0, 0.0, 1.0, 1.0, 1.0 };
GLfloat pts1[2][3][4], pts2[2][3][4], pts3[2][3][4], pts4[3][3][4], pts5[2][3][4], pts6[2][3][4];


GLfloat mat_red_diffuse[] = { 0.7, 0.0, 0.1, 1.0 };
GLfloat mat_green_diffuse[] = { 0.0, 0.7, 0.1, 1.0 };
GLfloat mat_blue_diffuse[] = { 0.0, 0.1, 0.7, 1.0 };
GLfloat mat_yellow_diffuse[] = { 0.7, 0.8, 0.1, 1.0 };
GLfloat mat_specular[] = { 1.0, 1.0, 1.0, 1.0 };
GLfloat mat_shininess[] = { 80.0 };

void DrawLight()
{
     
     if (LightMode == MENU_LIGHT_DIRECTIONAL)
     {
         glPushMatrix();
              glDisable(GL_LIGHTING);
              glColor3f(1.0, 1.0, 0.0);
              
               glTranslatef(lightPosition[0], lightPosition[1], lightPosition[2]);
                glBegin(GL_TRIANGLE_FAN);
                  	  glVertex3f(0, 0, 0);
                	  glVertex3f(1, 0.4, 0.4);
                	  glVertex3f(1, -0.4, 0.4);
                	  glVertex3f(1, -0.4, -0.4);
                	  glVertex3f(1, 0.4, 0.4);
                glEnd();
              glEnable(GL_LIGHTING);
         glPopMatrix();
     }
     else    
     if (LightMode == MENU_LIGHT_SPOTLIGHT)
     { 
         glPushMatrix();
              glDisable(GL_LIGHTING);
              glColor3f(1.0, 1.0, 1.0);
              
               glTranslatef(lightPosition2[0], lightPosition2[1], lightPosition2[2]);
                glBegin(GL_TRIANGLE_FAN);
                  	  glVertex3f(0, 0, 0);
                	  glVertex3f(.25, 0.25, 0.25);
                	  glVertex3f(.25, -0.25, 0.25);
                	  glVertex3f(.25, -0.25, -0.25);
                	  glVertex3f(.25, 0.25, 0.25);
                glEnd();
                
              glEnable(GL_LIGHTING);
         glPopMatrix(); 
     }
 }

void DrawCubes()
{
     float radius = g_radius;
   
       	glBegin(GL_QUADS );            	      
           if (not_shadow == 1)        	
	      glColor4fv( blueColor );
	      
          glNormal3f(0, 1, 0);
            // pats virsus	 
          glVertex3f(0, 1, -radius);                              	      
	      glVertex3f(0, 1, -1);                              	      
	      glVertex3f(-1+radius, 1, -1);                              	      
	      glVertex3f(-1+radius, 1, -radius);                              	      
       	glEnd();
                            	                                              	      
         glBegin(GL_QUADS );
                    if (not_shadow == 1)
	      glColor4fv( redColor );
       	   glNormal3f(0, 0, 1);   
	      // oninis deinys onas
	      glVertex3f(0, 0, 0);                              	      
	      glVertex3f(0, 1-radius, 0);                              	                                              	      
	      glVertex3f(-1+radius, 1-radius, 0);          // nurbs                     	      
	      glVertex3f(-1+radius, 0, 0);          // nurbs
       	glEnd();
                   
         glBegin(GL_QUADS );      
                    if (not_shadow == 1)             
	      glColor4fv( yellowColor );
           glNormal3f(-1, 0, 0);          
          // onas, kurio nesimato
	      glVertex3f(-1, 0, -radius);           // nurbs                	      
	      glVertex3f(-1, 0, -1.0);                                        	                                              	       
	      glVertex3f(-1, 1-radius, -1.0);                     	      
	      glVertex3f(-1, 1-radius, -radius);           // nurbs 
          
          glEnd();
                    
         glBegin(GL_QUADS );
                    if (not_shadow == 1)
        	      glColor4fv( pureblueColor );          
                  glNormal3f(0, 0, -1);        	      
                  // oninis kairys onas, kurio nesimato
        	      glVertex3f(0, 0, -1);                           	      
 	              glVertex3f(-1, 0, -1);  
 	              glVertex3f(-1, 1-radius, -1); 
	              glVertex3f(0, 1-radius, -1); 
       	 glEnd();	              
         glBegin(GL_QUADS );
                    if (not_shadow == 1)
        	      glColor4fv( redColor );     
                  glNormal3f(0, 0, -1);         	              
        	      glVertex3f(0, 1-radius, -1);                           	      
        	      glVertex3f(-1+radius, 1-radius, -1); 
 	              glVertex3f(-1+radius, 1, -1);                                         	                      	              	                                  	      
        	      glVertex3f(0, 1, -1);           
          glEnd();	 
                  
         glBegin(GL_QUADS );
           if (not_shadow == 1)
              glColor4fv( whiteColor );
              // priekinis onas maas
              glNormal3f(1, 0, 0); 
	          glVertex3f(0, 0, -radius);
	          glVertex3f(0, 0, -1); 	          	                        
    	      glVertex3f(0, 1, -1);                              	                              	                                              	                  	                                           
    	      glVertex3f(0, 1, -radius); 
         glEnd();
         glBegin(GL_QUADS );      
              if (not_shadow == 1)                                 
              glColor4fv( blueColor );
              glNormal3f(1, 0, 0); 
              // priekinis onas maas
    	      glVertex3f(0, 0, 0);       	      
	          glVertex3f(0, 1-radius, 0);
	          glVertex3f(0, 1-radius, -radius); 	          	                        
    	      glVertex3f(0, 0, -radius); 
          glEnd();	           	      


// didelis kubas  
         glBegin(GL_QUADS );  
                    if (not_shadow == 1)
	      glColor4fv( greyColor ); 
            // pats virsus	 	          
          glNormal3f(0, 1, 0);  
                       
	      glVertex3f(1, 0, 1);                           	      
	      glVertex3f(-1, 0, 1);                              	                                              	      
	      glVertex3f(-1, 0, -1);                              	      
	      glVertex3f(1, 0, -1);  
	   glEnd();	      	      
          
         glBegin(GL_QUADS );   
                    if (not_shadow == 1)         	      
          glColor4fv( pureredColor );
          // priekinis onas DYDELIS
          glNormal3f(1, 0, 0);
          
	      glVertex3f(1, 0, -1);                              	      
	      glVertex3f(1, -1, -1);                              	                                              	      
	      glVertex3f(1, -1, 1);                              	      
	      glVertex3f(1, 0, 1);     
	   glEnd();	                                         	                                              	      

         glBegin(GL_QUADS );
                    if (not_shadow == 1)
	      glColor4fv( puregreenColor );         	      
	      // oninis deinys onas DYDELIS
          glNormal3f(0, 0, 1);
          	      
	      glVertex3f(-1, 0, 1);                              	      
	      glVertex3f(1, 0, 1);                              	                                              	      
	      glVertex3f(1, -1, 1);                              	      
	      glVertex3f(-1, -1, 1);
	   glEnd();	                    
        
         glBegin(GL_QUADS );  
                    if (not_shadow == 1)      
	      glColor4fv( blueColor );                    
          // onas, kurio nesimato
          glNormal3f(-1, 0, 0);
                    
	      glVertex3f(-1, 0, 1);                           	      
	      glVertex3f(-1, 0, -1);                              	                                              	      
	      glVertex3f(-1, -1, -1);                              	      
	      glVertex3f(-1, -1, 1);      
	   glEnd();	      	      
          
         glBegin(GL_QUADS );  
                    if (not_shadow == 1)        
	      glColor4fv( greyColor );          
          // oninis kairys onas, kurio nesimato
          glNormal3f(0, 0, -1);
                    
	      glVertex3f(1, 0, -1);                           	      
	      glVertex3f(-1, 0, -1);                              	                                              	      
	      glVertex3f(-1, -1, -1);                              	      
	      glVertex3f(1, -1, -1);           	                       	                                              	                                    	     
	   glEnd();	      
          //////////////////////////////////
          // dugnas
         glBegin(GL_QUADS );  
                    if (not_shadow == 1)        
	      glColor4fv(yellowColor );   
          
          glNormal3f(0, -1, 0);
                           
	      glVertex3f(1, -1, 1);                           	      
	      glVertex3f(-1, -1, 1);                              	                                              	      
	      glVertex3f(-1, -1, -1);                              	      
	      glVertex3f(1, -1, -1);  
                  
                 	                                              	                                    	     
	   glEnd();
    
          //    glTranslatef( -50, -50, -5);                   	   
          
}

void DrawFloor()
{    	  
            glDisable(GL_LIGHTING); 
    glBegin(GL_QUADS );    
       glColor4f(0.8, 0.8, 0.8, 1);
       glVertex3fv(floorVertices[0]);
       glVertex3fv(floorVertices[1]);
       glVertex3fv(floorVertices[2]);
       glVertex3fv(floorVertices[3]);                                 
    glEnd();   	
        glEnable(GL_LIGHTING); 
}



/////////// NURBSAI

void Draw1(void) 
{
    if (not_shadow == 1) glColor3f(.4,.7,.4);
  //glColor3f(1, 1, 1);
 // glNormal3f(-1, 0, 1);

  glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, mat_blue_diffuse);
  glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
  glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess);
  
  gluNurbsSurface(nurbsas1, 4, knots1, 6, knots2, 3 * 4, 4, &pts1[0][0][0], 2, 3, GL_MAP2_VERTEX_3);
}

// problematiskas
void Draw2(void)
{
  if (not_shadow == 1) glColor3f(.4,.7,.4);

  glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, mat_blue_diffuse);
  glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
  glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess);
  
 // glNormal3f(0, 0, 1);
  gluNurbsSurface(nurbsas2, 4, knots1, 6, knots2,3 * 4, 4, &pts2[0][0][0], 2, 3, GL_MAP2_VERTEX_3);
}

void Draw3(void) 
{
  if (not_shadow == 1)  glColor3f(.4,.7,.4);
 
  glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, mat_blue_diffuse);
  glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
  glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess);
  
  gluNurbsSurface(nurbsas3, 4, knots1, 6, knots2, 3 * 4, 4, &pts3[0][0][0], 2, 3, GL_MAP2_VERTEX_3);
}

void Draw4(void) 
{
  if (not_shadow == 1) glColor3f(.4,.7,.4);
  
  glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, mat_blue_diffuse);
  glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
  glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess);
  
  gluNurbsSurface(nurbsas4, 6, knots2, 6, knots2, 3 * 4, 4, &pts4[0][0][0], 3, 3, GL_MAP2_VERTEX_3);
}

void Draw5(void)
{
  if (not_shadow == 1) glColor3f(.5,.8,.5);

  glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, mat_blue_diffuse);
  glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
  glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess);
  
  gluNurbsSurface(nurbsas5, 4, knots1, 6, knots2, 3 * 4, 4, &pts5[0][0][0], 2, 3, GL_MAP2_VERTEX_3);
}

void Draw6(void) 
{
  if (not_shadow == 1) glColor3f(.6, 1,.6);

  glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, mat_blue_diffuse);
  glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
  glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess);
  
  gluNurbsSurface(nurbsas6, 4, knots1, 6, knots2, 3 * 4, 4, &pts6[0][0][0], 2, 3, GL_MAP2_VERTEX_3);
}

// END NURBSAI

void setR(float R){
     float radius = R;
//------ 1
pts1[0][0][0] = -1+radius;   pts1[0][0][1] = 0.0;    pts1[0][0][2] = 0.0;         pts1[0][0][3] = 1.0;//des ap
pts1[0][1][0] = -1.0;        pts1[0][1][1] = 0.0;    pts1[0][1][2] = 0.0;         pts1[0][1][3] = 1.41421;
pts1[0][2][0] = -1.0;        pts1[0][2][1] = 0.0;    pts1[0][2][2] = -0-radius;   pts1[0][2][3] = 1.0;//k ap

pts1[1][0][0] = -1+radius;   pts1[1][0][1] = 1-radius;    pts1[1][0][2] = 0.0;        pts1[1][0][3] = 1.0;//des virsus
pts1[1][1][0] = -1.0;        pts1[1][1][1] = 1-radius;    pts1[1][1][2] = 0.0;        pts1[1][1][3] = 1.41421;
pts1[1][2][0] = -1.0;        pts1[1][2][1] = 1-radius;    pts1[1][2][2] = 0-radius;   pts1[1][2][3] = 1.0;//k virsus

//-------------- 2

pts2[0][2][0] = 0.0;   pts2[0][2][1] = 1-radius;    pts2[0][2][2] = 0.0;       pts2[0][2][3] = 1.0;//des ap
pts2[0][1][0] = 0.0;   pts2[0][1][1] = 1.0;         pts2[0][1][2] = 0.0;       pts2[0][1][3] = 1.41421;
pts2[0][0][0] = 0.0;   pts2[0][0][1] = 1.0;         pts2[0][0][2] = -radius;   pts2[0][0][3] = 1.0;//k ap


pts2[1][2][0] = -1+radius;   pts2[1][2][1] = 1-radius;    pts2[1][2][2] = 0.0;       pts2[1][2][3] = 1.0;//des ap
pts2[1][1][0] = -1+radius;   pts2[1][1][1] = 1.0;         pts2[1][1][2] = 0.0;       pts2[1][1][3] = 1.41421;
pts2[1][0][0] = -1+radius;   pts2[1][0][1] = 1.0;         pts2[1][0][2] = -radius;   pts2[1][0][3] = 1.0;//k ap


//-------------- 3 
pts3[0][0][0] = -1+radius;   pts3[0][0][1] = 1.0;      pts3[0][0][2] = -radius;   pts3[0][0][3] = 1.0;//des ap
pts3[0][1][0] = -1.0;        pts3[0][1][1] = 1.0;      pts3[0][1][2] = -radius;   pts3[0][1][3] = 1.41421;
pts3[0][2][0] = -1.0;        pts3[0][2][1] = 1-radius; pts3[0][2][2] = -radius;   pts3[0][2][3] = 1.0;//k ap

pts3[1][0][0] = -1+radius;   pts3[1][0][1] = 1.0;         pts3[1][0][2] = -1.0;   pts3[1][0][3] = 1.0;//des v
pts3[1][1][0] = -1.0;        pts3[1][1][1] = 1.0;         pts3[1][1][2] = -1.0;   pts3[1][1][3] = 1.41421;
pts3[1][2][0] = -1.0;        pts3[1][2][1] = 1-radius;    pts3[1][2][2] = -1.0;   pts3[1][2][3] = 1.0;//k v

//--------------- 4
pts4[0][0][0] = -1+radius;   pts4[0][0][1] = 1.0;   pts4[0][0][2] = -radius;    pts4[0][0][3] = 1.0;//des ap
pts4[0][1][0] = -1+radius;   pts4[0][1][1] = 1.0;   pts4[0][1][2] = -radius;    pts4[0][1][3] = 1.0;//des vir
pts4[0][2][0] = -1+radius;   pts4[0][2][1] = 1.0;   pts4[0][2][2] = -radius;    pts4[0][2][3] = 1.0;//des vir

//
pts4[1][0][0] = -1.0;        pts4[1][0][1] = 1.0;   pts4[1][0][2] = -radius;   pts4[1][0][3] = 1.41421;
pts4[1][1][0] = -1.0;        pts4[1][1][1] = 1.0;   pts4[1][1][2] = 0.0;       pts4[1][1][3] = 1.41421;
pts4[1][2][0] = -1+radius;   pts4[1][2][1] = 1.0;   pts4[1][2][2] = 0.0;       pts4[1][2][3] = 1.41421;
//

pts4[2][0][0] = -1.0;        pts4[2][0][1] = 1-radius;    pts4[2][0][2] = -radius;   pts4[2][0][3] = 1.41421;
pts4[2][1][0] = -1.0;        pts4[2][1][1] = 1-radius;    pts4[2][1][2] = 0.0;       pts4[2][1][3] = 1.0;//k ap
pts4[2][2][0] = -1+radius;   pts4[2][2][1] = 1-radius;    pts4[2][2][2] = 0.0;       pts4[2][2][3] = 1.0;//k vir
//--------

pts5[1][0][0] = 0;   pts5[1][0][1] = 1;          pts5[1][0][2] = -radius;   pts5[1][0][3] = 1.0;  // pilkas
pts5[1][1][0] = 0;   pts5[1][1][1] = 1;          pts5[1][1][2] = 0;         pts5[1][1][3] = 1.0;  // pilkas
pts5[1][2][0] = 0;   pts5[1][2][1] = 1-radius;   pts5[1][2][2] = 0;         pts5[1][2][3] = 1.0;  // pilkas

pts5[0][0][0] = 0;   pts5[0][0][1] = 1-radius; pts5[0][0][2] = -radius;   pts5[0][0][3] = 1.0;  // pilkas
pts5[0][1][0] = 0;   pts5[0][1][1] = 1-radius; pts5[0][1][2] = -radius;   pts5[0][1][3] = 1.0;  // pilkas
pts5[0][2][0] = 0;   pts5[0][2][1] = 1-radius; pts5[0][2][2] = -radius;   pts5[0][2][3] = 1.0;  // pilkas


pts6[1][0][0] = -1;          pts6[1][0][1] = 1-radius;       pts6[1][0][2] = -1;   pts6[1][0][3] = 1.0;  // pilkas
pts6[1][1][0] = -1;          pts6[1][1][1] = 1;              pts6[1][1][2] = -1;   pts6[1][1][3] = 1.0;  // pilkas
pts6[1][2][0] = -1+radius;   pts6[1][2][1] = 1;              pts6[1][2][2] = -1;   pts6[1][2][3] = 1.0;  // pilkas

pts6[0][0][0] = -1+radius;   pts6[0][0][1] = 1-radius; pts6[0][0][2] = -1;   pts6[0][0][3] = 1.0;  // pilkas
pts6[0][1][0] = -1+radius;   pts6[0][1][1] = 1-radius; pts6[0][1][2] = -1;   pts6[0][1][3] = 1.0;  // pilkas
pts6[0][2][0] = -1+radius;   pts6[0][2][1] = 1-radius; pts6[0][2][2] = -1;   pts6[0][2][3] = 1.0;  // pilkas


 
     }
