#pragma comment(lib, "opengl32.lib")
#pragma comment(lib, "glu32.lib")
#pragma comment(lib, "winmm.lib")

#include "main.h"

#include "2uzd.h"
#include <gl/glu.h>

// seseliavimui skirti kintamieji
float l[] = { -5, 4, 0 }; 
float n[] = { 0.0,  -1.0, 0.0 }; 
float e[] = { 0.0, -1.9999, 0.0 };

CCamera g_Camera;										// kamera

bool  g_bFullScreen = false;							
HWND  g_hWnd;											
RECT  g_rRect;											
HDC   g_hDC;
HGLRC g_hRC;											
HINSTANCE g_hInstance;
HMENU g_hMainMenu;
int g_cameraMoving = 0;

int LightMode = MENU_LIGHT_DIRECTIONAL;
int MenuProjection = MENU_PROJ;

int g_mousex = 0;
int g_mousey = 0;
int g_leftButton = 0;
int g_middleButton = 0;
int g_moving = 0;
int g_mousestartx = 0;
int g_mousestarty = 0;
int g_anglex = 0;
int g_angley = 0;
float g_radius = 0.2;

GLfloat g_Rotangley = 0;
GLfloat g_Rotanglex = 0;

float camXpos = 0;
float camYpos = 0;
float camZpos = 0;
double lightAngle = 0;
double lightHeight = 4;
int not_shadow = 1;

int directionalLight = 1;
GLfloat lightPosition[4] =  { -5, 0, 0, 0}; // directional
GLfloat lightPosition2[4] =  { 1, 2.5, 1, 1}; // spotlight
GLfloat spotDirection[4] =  { -1, -1, -1 };

GLfloat lightColor[] = {1.0,1.0, 1.0, 1}; 
GLfloat ambientColor[] = {0,0,0, 1}; 
GLfloat specularColor[] = {1,1,1, 1};

GLfloat juodaColor[] = {0,0,0, 1.0};

GLUnurbsObj *nurbsas1, *nurbsas2, *nurbsas3, *nurbsas4, *nurbsas5, *nurbsas6;

// Kolizijai skirta
int g_NumberOfVerts = 0;
CVector3 *g_vWorld=NULL;

// skaiciuojam projekcija
void glShadowProjection(float * l, float * e, float * n)
{
  float d, c;
  float mat[16];

  d = n[0]*l[0] + n[1]*l[1] + n[2]*l[2];
  c = e[0]*n[0] + e[1]*n[1] + e[2]*n[2] - d;

  mat[0]  = l[0]*n[0]+c; 
  mat[4]  = n[1]*l[0]; 
  mat[8]  = n[2]*l[0]; 
  mat[12] = -l[0]*c-l[0]*d;
  
  mat[1]  = n[0]*l[1];        
  mat[5]  = l[1]*n[1]+c;
  mat[9]  = n[2]*l[1]; 
  mat[13] = -l[1]*c-l[1]*d;
  
  mat[2]  = n[0]*l[2];        
  mat[6]  = n[1]*l[2]; 
  mat[10] = l[2]*n[2]+c; 
  mat[14] = -l[2]*c-l[2]*d;
  
  mat[3]  = n[0];        
  mat[7]  = n[1]; 
  mat[11] = n[2]; 
  mat[15] = -d;

  glMultMatrixf(mat);
}

// idedam vektoriu i pasauliuka.
// naudojama kolizijoms
int g_index = 0;
void AddVector(float x, float y, float z)
{
     double n = 1.1;
     x = x * n;
     y = y * n;
     z = z * n;
     g_vWorld[g_index].x = x;
     g_vWorld[g_index].y = y;
     g_vWorld[g_index++].z = z;          
}

// uzkraunam kolizinius vektoriukus
void LoadVertices()
{	
	g_NumberOfVerts = 36;
	g_vWorld  = new CVector3[g_NumberOfVerts];
		
   // AddVector(4, -1.5, -4); AddVector(4, -1.5, 4); AddVector(-4, -1.5, 4);                              	                                              	      	
   // AddVector(-4, -1.5, -4); AddVector(-4, -1.5, 4); AddVector(4, -1.5, -4); 
	
    AddVector(-1, 0, 1); AddVector(1, 0, 1); AddVector(1, -1, 1);                              	                                              	      	
    AddVector(-1, 0, 1); AddVector(-1, -1, 1); AddVector(1, -1, 1); 

    AddVector(-1, 0, 1); AddVector(-1, -1, 1); AddVector(-1, -1, -1);                              	                                              	      		
	AddVector(-1, -1, -1); AddVector(-1, 0, -1); AddVector(-1, 0, 1);                              	                                              	      				

    AddVector(-1, 0, -1); AddVector(-1, -1, -1); AddVector(1, -1, -1); 	
    AddVector(1, 0, -1); AddVector(1, -1, -1); AddVector(-1, 0, -1); 
	
    AddVector(1, 0, -1); AddVector(1, -1, -1); AddVector(1, -1, 1); 	
	AddVector(1, -1, 1); AddVector(1, 0, 1); AddVector(1, 0, -1);	
      
    // dabar virsus
    AddVector(-1, 0, 1); AddVector(1, 0, 1); AddVector(1, 0, -1); 	
    AddVector(-1, 0, 1); AddVector(-1, 0, -1); AddVector(1, 0, -1);  	

    AddVector(-1, -1, 1); AddVector(1, -1, 1); AddVector(1, -1, -1); 	
    AddVector(-1, -1, 1); AddVector(1, -1, -1); AddVector(-1, -1, -1);  	

}

void Init(HWND hWnd)
{
	g_hWnd = hWnd;										// Assign the window handle to a global window handle
	GetClientRect(g_hWnd, &g_rRect);					// Assign the windows rectangle to a global RECT
    InitializeOpenGL(g_rRect.right, g_rRect.bottom);	// Init OpenGL with the global rect
    
    g_hMainMenu = CreatePopupMenu();
    AppendMenu(g_hMainMenu, MF_STRING, MENU_ORTHO, "Orthographic projekcija");
    AppendMenu(g_hMainMenu, MF_STRING, MENU_PROJ, "Projektyvine projekcija");
    AppendMenu(g_hMainMenu, MF_MENUBREAK, 0, NULL);
    AppendMenu(g_hMainMenu, MF_STRING, MENU_VIEWPOINT1, "Viewpoint 1");
    AppendMenu(g_hMainMenu, MF_STRING, MENU_VIEWPOINT2, "Viewpoint 2");
    AppendMenu(g_hMainMenu, MF_STRING, MENU_VIEWPOINT3, "Viewpoint 3");            
    AppendMenu(g_hMainMenu, MF_MENUBREAK, 0, NULL);    
    AppendMenu(g_hMainMenu, MF_STRING, MENU_LIGHT_SPOTLIGHT, "LIGHT: Spotlight");
    AppendMenu(g_hMainMenu, MF_STRING, MENU_LIGHT_DIRECTIONAL, "LIGHT: Directional (reguliuojama)");            
    AppendMenu(g_hMainMenu, MF_STRING, MENU_LIGHT_OFF, "LIGHT: Off (Isjungti)"); 
    
 // glEnable( GL_MAP2_VERTEX_3 );
    
//  glShadeModel(GL_FLAT );
   // glDisable(GL_LINE_SMOOTH);
   
    glEnable( GL_DEPTH_TEST );

    glEnable(GL_NORMALIZE);
    glEnable(GL_AUTO_NORMAL);
    glColorMaterial( GL_FRONT, GL_EMISSION ) ;
    glEnable( GL_COLOR_MATERIAL ) ;

     glEnable(GL_LIGHTING);     
     glEnable(GL_LIGHT0);
     glEnable(GL_LIGHT1);
     
      glLightf(GL_LIGHT1, GL_SPOT_EXPONENT, 1.0f);
        
      glLightf(GL_LIGHT1, GL_CONSTANT_ATTENUATION, 1.0f);
      glLightf(GL_LIGHT1, GL_LINEAR_ATTENUATION, 0.0f);
      glLightf(GL_LIGHT1, GL_QUADRATIC_ATTENUATION, 0.0f);       
    	
    glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
    
      glMaterialfv(GL_FRONT, GL_SPECULAR, specularColor);
      glMaterialfv(GL_FRONT, GL_EMISSION, juodaColor);

      glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST );
      glHint(GL_LINE_SMOOTH_HINT, GL_FASTEST);
      glHint(GL_POINT_SMOOTH_HINT, GL_FASTEST);

        

   	g_Camera.PositionCamera(0, 2, 10,   0, 0, 0,   0, 1, 0);

	g_Camera.SetCameraRadius(1);
		
  nurbsas1 = gluNewNurbsRenderer();
  gluNurbsProperty(nurbsas1, GLU_SAMPLING_TOLERANCE, 50.0);
  gluNurbsProperty(nurbsas1, GLU_DISPLAY_MODE, GLU_FILL);
  
  nurbsas2 = gluNewNurbsRenderer();
  gluNurbsProperty(nurbsas2, GLU_SAMPLING_TOLERANCE, 50.0);
  gluNurbsProperty(nurbsas2, GLU_DISPLAY_MODE, GLU_FILL);
  
  nurbsas3 = gluNewNurbsRenderer();
  gluNurbsProperty(nurbsas3, GLU_SAMPLING_TOLERANCE, 50.0);
  gluNurbsProperty(nurbsas3, GLU_DISPLAY_MODE, GLU_FILL);
  
  nurbsas4 = gluNewNurbsRenderer();
  gluNurbsProperty(nurbsas4, GLU_SAMPLING_TOLERANCE, 50.0);
  gluNurbsProperty(nurbsas4, GLU_DISPLAY_MODE, GLU_FILL);
  
  nurbsas5 = gluNewNurbsRenderer();
  gluNurbsProperty(nurbsas5, GLU_SAMPLING_TOLERANCE, 50.0);
  gluNurbsProperty(nurbsas5, GLU_DISPLAY_MODE, GLU_FILL);
  
  nurbsas6 = gluNewNurbsRenderer();
  gluNurbsProperty(nurbsas6, GLU_SAMPLING_TOLERANCE, 50.0);
  gluNurbsProperty(nurbsas6, GLU_DISPLAY_MODE, GLU_FILL);   
  	
	LoadVertices();

	glClearColor(0.3, 0.3, 0.3, 1);	
}


WPARAM MainLoop()
{
	MSG msg;
	while(1)											// Do our infinate loop
	{													// Check if there was a message
		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) 
        { 
			if(msg.message == WM_QUIT)					// If the message wasnt to quit
				break;
            TranslateMessage(&msg);						// Find out what the message does
            DispatchMessage(&msg);						// Execute the message
        }
		else											// if there wasn't a message
		{ 
			g_Camera.Update(g_mousex, g_mousey);							// Update the camera info
			RenderScene();								// Update the screen	
        } 
	}

	DeInit();											// Clean up and free all allocated memory


	// Before the program ends, we need to free the world data that was allocated
	delete [] g_vWorld;									

	return(msg.wParam);									// Return from the program
}

void DrawAll()
{
         // piesiam kubus
         DrawCubes();
            
         //piesiam NURBS'us     
        if (g_radius > 0)
        {
             setR(g_radius); // formuojam nurbsu 'control' points, pagal R
             Draw1();
             Draw2();
             Draw3();
             Draw4();
             Draw5();
             Draw6();
        }
}

void RenderScene() 
{     
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	
	glMatrixMode(GL_PROJECTION);						
	glLoadIdentity();									

	 if (MenuProjection == MENU_PROJ)
	 {
      	 gluPerspective(45.0f,(GLfloat)SCREEN_WIDTH/(GLfloat)SCREEN_HEIGHT, 0.5 ,50.0f);
     }
     else
         glOrtho(-10.0, 10.0, -10.0, 10.0, 0.1, 100);

     lightPosition[0] = 5*cos(lightAngle);
     lightPosition[1] = lightHeight;
     lightPosition[2] = 5*sin(lightAngle);

	g_Camera.CheckCameraCollision(g_vWorld, g_NumberOfVerts);
	g_Camera.Look();  

	glMatrixMode(GL_MODELVIEW);	
	glPushMatrix();
	
       	     
    glRotatef(camXpos, 1.0, 0.0, 0.0);            	     
    glRotatef(camYpos, 0.0, 1.0, 0.0); 

    if (LightMode == MENU_LIGHT_SPOTLIGHT)
    {
      glEnable(GL_LIGHT1);
      glDisable(GL_LIGHT0);      
    }
    else
    if (LightMode == MENU_LIGHT_DIRECTIONAL)
    {
      glEnable(GL_LIGHT0);
      glDisable(GL_LIGHT1);      
    }
    if (LightMode == MENU_LIGHT_OFF)    
    {
      glDisable(GL_LIGHT0);      
      glDisable(GL_LIGHT1);      
    }    
        
      glLightfv(GL_LIGHT0, GL_POSITION, lightPosition); 
      glLightfv(GL_LIGHT0, GL_DIFFUSE, specularColor);
      glLightfv(GL_LIGHT0, GL_AMBIENT, ambientColor);
      glLightfv(GL_LIGHT0, GL_SPECULAR, specularColor);
      
      glLightfv(GL_LIGHT1, GL_POSITION, lightPosition2); 
      glLightfv(GL_LIGHT1, GL_DIFFUSE, specularColor);
      glLightfv(GL_LIGHT1, GL_AMBIENT, ambientColor);
      
      glLightfv(GL_LIGHT1, GL_SPECULAR, specularColor);  
      
      glLightfv(GL_LIGHT1, GL_SPOT_DIRECTION, spotDirection);
      glLightf(GL_LIGHT1, GL_SPOT_CUTOFF, 28);          

    // piesiam GRINDIS
    DrawFloor();
    // piesiam SVIESA
    DrawLight();  
          
    glPushMatrix(); 
        glEnable(GL_LIGHTING);      
        not_shadow = 1;
        
        // piesiam pacia figura
        DrawAll();

        // piesiam seseli
        if (LightMode == MENU_LIGHT_SPOTLIGHT)
        {
                      
            l[0] = lightPosition2[0];
            l[1] = lightPosition2[1];
            l[2] = lightPosition2[2];    
            glShadowProjection(l,e,n);  
                              
            glDisable(GL_LIGHTING);
            glColor3f(0.6,0.6,0.6);
            not_shadow = 0;        
    
            DrawAll();                                  
            
        }
        else
        if (LightMode == MENU_LIGHT_DIRECTIONAL)        
        {
            l[0] = lightPosition[0];
            l[1] = lightPosition[1];
            l[2] = lightPosition[2];                
            
            glShadowProjection(l,e,n);  
                              
            glDisable(GL_LIGHTING);
            glColor3f(0.6,0.6,0.6);
            not_shadow = 0;        
    
            DrawAll();              
        }
       
    glPopMatrix();
    
    glPopMatrix();

  SwapBuffers(g_hDC);								
}

// menu handleris
void HandleMenu(int code)
{
     float zNear=1.0, zFar=100.0;
     if (code == MENU_ORTHO)
     {
        MenuProjection = MENU_ORTHO;
        g_Rotanglex = 0;
        g_Rotangley = 0;
        camXpos = 0;
        camYpos = 0;
     	g_Camera.PositionCamera(0, 2, 10,   0, 0, 0,   0, 1, 0);         
     }
     else
     if (code == MENU_PROJ)
         MenuProjection = MENU_PROJ;
     else
     if (code == MENU_VIEWPOINT1)
     {
        g_Rotanglex = 0;
        g_Rotangley = 0;
        camXpos = 0;
        camYpos = 0;
     	g_Camera.PositionCamera(0, 2, 10,   0, 0, 0,   0, 1, 0);
      }
     else
     if (code == MENU_VIEWPOINT2)
     {
       g_Rotanglex = 0;
       g_Rotangley = 0;
       camXpos = 0;
       camYpos = 0;       
     	g_Camera.PositionCamera(-5, 5, 5,   0, 0, 0,   0, 1, 0);     	
      }
     else
     if (code == MENU_VIEWPOINT3)
     {
        g_Rotanglex = 0;
        g_Rotangley = 0;         
        camXpos = 0;
        camYpos = 0;       
     	g_Camera.PositionCamera(5, 5, 10,   0, 0, 0,   0, 1, 0);     	              	              
      }
     else
     if (code == MENU_LIGHT_SPOTLIGHT)
     {
        LightMode = MENU_LIGHT_SPOTLIGHT;
     }
     else
     if (code == MENU_LIGHT_DIRECTIONAL)
     {
        LightMode = MENU_LIGHT_DIRECTIONAL;
     }
     else
     if (code == MENU_LIGHT_OFF)
     {
        LightMode = MENU_LIGHT_OFF;
     }     
}

LRESULT CALLBACK WinProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    LONG    lRet = 0; 
    PAINTSTRUCT    ps;

    switch (uMsg)
	{ 
    case WM_SIZE:										// If the window is resized
		if(!g_bFullScreen)								// Do this is we are not in full screen
		{
			SizeOpenGLScreen(LOWORD(lParam),HIWORD(lParam));// LoWord=Width, HiWord=Height
			GetClientRect(hWnd, &g_rRect);					// Get the window rectangle
		}
        break; 
        
  case WM_COMMAND:
       {
          if (HIWORD(wParam) == 0)
             HandleMenu(LOWORD(wParam));
       }
       break;
	case WM_MBUTTONDOWN:										// If we need to repaint the scene
		  POINT mousePos1;	
		 GetCursorPos(&mousePos1);
         g_mousestartx = mousePos1.x;
         g_mousestarty = mousePos1.y;
	     g_middleButton = 1;
		break;
	case WM_MBUTTONUP:										// If we need to repaint the scene
	     g_middleButton = 0;
		break;
                       
	case WM_RBUTTONDOWN:										// If we need to repaint the scene
	     POINT Pos;	
		GetCursorPos(&Pos);
        TrackPopupMenu(g_hMainMenu, TPM_LEFTALIGN, Pos.x, Pos.y, 0, g_hWnd, NULL);
		break;
                
	case WM_LBUTTONDOWN:										// If we need to repaint the scene
	     POINT mousePos;	
		GetCursorPos(&mousePos);
         g_mousestartx = mousePos.x;
         g_mousestarty = mousePos.y;
        g_leftButton = 1;   
		break; 
				
	case WM_LBUTTONUP:										// If we need to repaint the scene
	    ShowCursor(TRUE);
        g_leftButton = 0;        
		break; 		
		
	case WM_MOUSEMOVE:
         if (g_leftButton == 1)        
         {    	  
           g_anglex = g_mousestartx -(int)wParam;
           g_angley = g_mousestarty - (int)lParam;
           g_mousex = (int)wParam;
           g_mousey = (int)lParam;
         }		
		break;		
 
	case WM_PAINT:										// If we need to repaint the scene
		BeginPaint(hWnd, &ps);							// Init the paint struct		
		EndPaint(hWnd, &ps);							// EndPaint, Clean up
		break;

	case WM_KEYDOWN:

		switch(wParam) {								// Check if we hit a key
			case VK_ESCAPE:								// If we hit the escape key
				PostQuitMessage(0);						// Send a QUIT message to the window
				break;
			case VK_UP:
                 g_cameraMoving = 0;
                 break;
			case VK_DOWN:
                 g_cameraMoving = 0;
                 break;   
            case VK_SPACE:
                 lightAngle = lightAngle+(double)1/40;
                 break;              
		}
		break;

	case WM_KEYUP:

		switch(wParam) {								// Check if we hit a key
			case VK_UP:
                 g_cameraMoving = 0;
                 break;
			case VK_DOWN:
                 g_cameraMoving = 0;
                 break;                 
		}
		break;

    case WM_CLOSE:										// If the window is being closes
        PostQuitMessage(0);								// Send a QUIT Message to the window
        break; 
        
    case WM_CHAR:
         if (((char)wParam == '+') || ((char)wParam == 'R'))
         {
            if (g_radius < 0.995)
            g_radius += 0.005;
         }
         else
         if (((char)wParam == '-') || ((char)wParam == 'r'))
         {
            if (g_radius > 0.005)         
            g_radius -= 0.005;
         }
         else
         if ((char)wParam == '1')
         {
            camXpos += 2;
         }         
         else
         if ((char)wParam == '2')
         {
            camYpos += 2;
         }         
         else
         if ((char)wParam == '4')
         {
            camXpos -= 2;
         }      
         else
         if ((char)wParam == '5')
         {
            camYpos -= 2;
         }         
         else
         if ((char)wParam == 's')
         {
            lightAngle = lightAngle+(double)1/40;
         }  
                         
         break;              
     
    default:											// Return by default
        lRet = DefWindowProc (hWnd, uMsg, wParam, lParam); 
        break; 
    } 
 
    return lRet;										// Return by default
}

