.model small

bufDydis	EQU 20		;konstanta bufDydis (lygi 20) - skaitymo ir raymo buferi dydiai

.stack 100h

.data
	duom	db "duom.txt",0		;duomen failo pavadinimas, pasibaigiantis nuliniu simboliu (C sintakse - '\0')
	rez	db "rez.txt",0		;rezultat failo pavadinimas, pasibaigiantis nuliniu simboliu
	skBuf	db bufDydis dup ('?')	;skaitymo buferis
	raBuf	db bufDydis dup ('?')	;raymo buferis
	dFail	dw ?			;vieta, skirta saugoti duomen failo deskriptoriaus numer ("handle")
	rFail	dw ?			;vieta, skirta saugoti rezultato failo deskriptoriaus numer

.code
  pradzia:
	MOV	ax, @data	;reikalinga kiekvienos programos pradzioj
	MOV	ds, ax		;reikalinga kiekvienos programos pradzioj


;*****************************************************
;Duomen failo atidarymas skaitymui
;*****************************************************
	MOV	ah, 3Dh				;21h pertraukimo failo atidarymo funkcijos numeris
	MOV	al, 00				;00 - failas atidaromas skaitymui
	MOV	dx, offset duom			;vieta, kur nurodomas failo pavadinimas, pasibaigiantis nuliniu simboliu
	INT	21h				;failas atidaromas skaitymui
	JC	klaidaAtidarantSkaitymui	;jei atidarant fail skaitymui vyksta klaida, nustatomas carry flag
	MOV	dFail, ax			;atmintyje isisaugom duomen failo deskriptoriaus numer

;*****************************************************
;Rezultato failo sukrimas ir atidarymas raymui
;*****************************************************
	MOV	ah, 3Ch				;21h pertraukimo failo sukrimo funkcijos numeris
	MOV	cx, 0				;kuriamo failo atributai
	MOV	dx, offset rez			;vieta, kur nurodomas failo pavadinimas, pasibaigiantis nuliniu simboliu
	INT	21h				;sukuriamas failas; jei failas jau egzistuoja, visa jo informacija itrinama
	JC	klaidaAtidarantRasymui		;jei kuriant fail skaitymui vyksta klaida, nustatomas carry flag
	MOV	rFail, ax			;atmintyje isisaugom rezultato failo deskriptoriaus numer

;*****************************************************
;Duomen nuskaitymas i failo
;*****************************************************
  skaityk:
	MOV	ah, 3Fh				;21h pertraukimo duomen nuskaitymo funkcijos numeris
	MOV	bx, dFail			; bx raom duomen failo deskriptoriaus numer
	MOV	cl, bufDydis			;cx - kiek bait reikia nuskaityti i failo
	MOV	ch, 0				;ivalom vyresnj cx bait
	MOV	dx, offset skBuf		;vieta,  kuri raoma nuskaityta informacija
	INT	21h				;skaitymas i failo
	JC	klaidaSkaitant			;jei skaitant i failo vyksta klaida, nustatomas carry flag
	CMP	ax, 0				;prieingu atveju,  ax raoma, kiek bait buvo nuskaityta
	JE	uzdarytiRasymui

;*****************************************************
;Darbas su nuskaityta informacija
;*****************************************************
	MOV	cx, ax
	MOV	si, offset skBuf
	MOV	di, offset raBuf
  dirbk:
	MOV	dl, [si]
	CMP	dl, 'a'
	JB	tesk
	CMP	dl, 'z'
	JA	tesk
	SUB	dl, 20h
  tesk:
	MOV	[di], dl
	INC	si
	INC	di
	LOOP	dirbk
	
;*****************************************************
;Rezultato raymas  fail
;*****************************************************
	MOV	cx, ax				;cx - kiek bait reikia rayti
	MOV	ah, 40h				;21h pertraukimo duomen raymo funkcijos numeris
	MOV	bx, rFail			; bx raom rezultato failo deskriptoriaus numer
	MOV	dx, offset raBuf		;vieta, i kurios raom  fail
	INT	21h				;raymas  fail
	JC	klaidaRasant			;jei raant  fail vyksta klaida, nustatomas carry flag

	CMP	cx, bufDydis			;jeigu vyko darbas su pilnu buferiu -> i duomen failo buvo nuskaitytas pilnas buferis ->
	JE	skaityk				;-> reikia skaityti toliau
  
;*****************************************************
;Rezultato failo udarymas
;*****************************************************
  uzdarytiRasymui:
	MOV	ah, 3Eh				;21h pertraukimo failo udarymo funkcijos numeris
	MOV	bx, rFail			; bx raom rezultato failo deskriptoriaus numer
	INT	21h				;failo udarymas
	JC	klaidaUzdarantRasymui		;jei udarant fail vyksta klaida, nustatomas carry flag
	
;*****************************************************
;Duomen failo udarymas
;*****************************************************
  uzdarytiSkaitymui:
	MOV	ah, 3Eh				;21h pertraukimo failo udarymo funkcijos numeris
	MOV	bx, dFail			; bx raom duomen failo deskriptoriaus numer
	INT	21h				;failo udarymas
	JC	klaidaUzdarantSkaitymui		;jei udarant fail vyksta klaida, nustatomas carry flag

  pabaiga:
	MOV	ah, 4Ch		;reikalinga kiekvienos programos pabaigoj
	MOV	al, 0		;reikalinga kiekvienos programos pabaigoj
	INT	21h		;reikalinga kiekvienos programos pabaigoj

  klaidaAtidarantSkaitymui:
	;<klaidos praneimo ivedimo kodas>
	JMP	pabaiga
  klaidaAtidarantRasymui:
	;<klaidos praneimo ivedimo kodas>
	JMP	uzdarytiSkaitymui
  klaidaSkaitant:
	;<klaidos praneimo ivedimo kodas>
	JMP	uzdarytiRasymui
  klaidaRasant:
	;<klaidos praneimo ivedimo kodas>
	JMP	uzdarytiRasymui
  klaidaUzdarantRasymui:
	;<klaidos praneimo ivedimo kodas>
	JMP	uzdarytiSkaitymui
  klaidaUzdarantSkaitymui:
	;<klaidos praneimo ivedimo kodas>
	JMP	pabaiga
END pradzia


40 int spausdinam i ekrana