.286

.model small

locals @@

.stack 100h

.data
 strHex db "0123456789ABCDEF"
 bitMASK dw 0Fh ;4 bitu maske

 byteCnt equ 5 ;maximalus baitu skaicius call instrukcijai
 inst db byteCnt dup(0) ;instrukcijos baitai
 bytesLeft db 0 ;kiek nuskaityta baitu
 segmentPrefix db 0 ;segmento numeris
 IP dw 100h
 printFar db 0 ;jei 0 tai nespausdina, jei 1 tai spausdina zodi far
 
 msgOpenError db "Klaida bandant atidaryti faila$"
 msgHelp db "Programos iskvietimo pavyzdys: disasm programa.com kodas.asm$"
 
 asmFile dw 0 ;rezultatu failo deskriptorius
 comFile dw 0
 fname1 db 128 dup (0) ;programos failas
 fname2 db 128 dup (0)   ;rezultatu failas
 EOF db 0
 
 strCall db "call   ", 0
 newLine db 13, 10, 0
 colon db ":", 0
 strAdd db "+", 0
 strSub db "-", 0
 segments db 0, "CS:", 0, "DS:", 0, "ES:", 0, "SS:", 0
 registers db "AX", 0, "CX", 0, "DX", 0, "BX", 0, "SP", 0, "BP", 0, "SI", 0, "DI", 0
 strModMem db "BX+SI", 0, "BX+DI", 0, "BP+SI", 0, "BP+DI", 0, "SI", 0, "DI", 0, "BP", 0, "BX", 0
 strFar db "far ", 0
 addrStart db "[", 0
 addrEnd db "]", 0

.code

proc CopyBuff ;si - is kurio, di - i kuri, cx baitu kiekis
 pusha
 cmp cx, 0
 je @@end
 
 @@copy:
 mov al, [si]
 mov [di], al 
 inc si
 inc di
 loop @@copy
 
 @@end:
 popa
 ret
endp

proc ShiftBytes ;si - buferio adresas, cx - baitu per kuriuos paslingti, skaicius
 pusha
 mov di, si
 add si, cx ;pradiniu duomenu offsetas
 mov bx, cx
 mov cx, byteCnt
 sub cx, bx
 jz @@end
 
 call CopyBuff
 
 @@end:
 popa
 ret
endp ShiftBytes

proc GetFileNames
 push bx cx dx si di
 xor ax, ax
 xor cx, cx
 mov cl, es:[80h] ;parametru ilgis
 cmp cl, 0
 je @@noParams
 dec cx ;numetamas pirmas tarpas
 
 mov si, 82h ;parametru pradzia be tarpu
 lea di, fname1
 
 @@copyName1:
 mov bl, es:[si]
 inc si
 dec cx ;likusiu simboliu skaicius
 cmp cx, 0
 je @@noParams
 cmp bl, " "
 je @@spaceFound
 
 mov [di], bl
 inc di
 jmp @@copyName1
 
 @@spaceFound: 
 lea di, fname2
 
 @@copyName2: ;kopijuojamas antras failo vardas
 mov bl, es:[si]
 mov [di], bl
 inc si
 inc di
 loop @@copyName2
 jmp @@end
 
 @@noParams:
 mov ax, 1
 
 @@end:
 pop di si dx cx bx
 ret
endp GetFileNames

fOpenError:
 mov ah, 9
 lea dx, msgOpenError
 int 21h
 mov ah, 4Ch
 int 21h ;baigiamas programos darbas

proc OpenFile ;failo vardas dx registre
 push ds
 mov ah, 3Dh
 mov al, 2 ;read/write
 int 21h
 pop ds
 jc fOpenError
 ret
endp OpenFile

proc CloseFile ;bx - file handle
 push ax
 mov ah, 3Eh
 int 21h
 pop ax
 ret
endp CloseFile

proc CreateFile
 pusha
 mov ah, 3Ch
 xor cx, cx
 int 21h
 popa
 ret
endp

proc ReadFromFile ;dx - buferio adresas, cx - baitu skaicius
 push bx
 mov ah, 3Fh
 mov bx, comFile
 int 21h
 pop bx
 ret
endp ReadFromFile

proc WriteToFile ;dx - adresas i buferi, cx - baitu kiekis
 pusha
 mov ah, 40h
 mov bx, asmFile
 int 21h
 popa
 ret
endp WriteToFile

proc PrintHex ;spauzdina ax reiksme, dx skaitmenu kiekis
 pusha
 
 mov cx, 0  
 @@get_nums:  ;ciklas gaunantis visus skaitmenis is skaiciaus
 mov bx, ax
 and bx, bitMASK 
 shr ax, 4   
 push bx     
 inc cx  
 cmp ax, 0   
 jne @@get_nums ;jei dar liko skaitmenu tesiamas ciklas

 mov bx, dx
 sub dx, cx
 cmp dx, 0   ;jei skaitmenu kiekis yra toks koki pageidaujama spauzdinti
 mov cx, bx
 je @@print_nums ;pereinam prie spauzdinimo 

 mov cx, dx
 @@add_zero: ;prideti nuliu prie skaiciaus priekio
 push 0    ;i steka idemas skaitmuo kurio reiksme nulis
 loop @@add_zero
 mov cx, bx

 @@print_nums:
 pop bx
 lea dx, strHex
 add dx, bx
 push cx
 mov cx, 1
 call WriteToFile
 pop cx
 loop @@print_nums
 
 popa
 ret
endp PrintHex 

proc PrintStr ;dx - stringo adresas
 pusha
 mov si, dx
 call StrLength
 call WriteToFile
 popa
 ret
endp PrintStr

proc FindStrStart ;si - stringu masyvo adresas, cx - stringo numeris
 push ax bx
 xor bx, bx
 cmp bx, cx
 je @@dontSearch
 @@findSeparator:
  mov al, [si]
  inc si
  cmp al, 0
  jne @@findSeparator
  inc bx
  cmp bx, cx
  jne @@findSeparator  
 
 @@dontSearch: 
 pop bx ax
 ret
endp FindStrStart

proc StrLength ;si - stringo pradzia; grazina cx - stringo ilgis
 push ax si
 xor cx, cx
 @@strEnd:
 mov al, [si]
 inc si
 inc cx
 cmp al, 0
 jnz @@strEnd
 dec cx
 pop si ax
 ret
endp StrLength

proc PrintPrefix
 pusha
 cmp [segmentPrefix], 0
 je @@end
 lea si, segments
 xor cx, cx
 mov cl, segmentPrefix
 call FindStrStart
 mov dx, si
 call PrintStr
 
 @@end:
 popa
 ret
endp PrintPrefix

proc FarDirect ;si - instrukcijos baitu buferio adresas
 pusha
 lea dx, strCall
 call PrintStr
 cmp [segmentPrefix], 0
 je @@no_prefix
 call PrintPrefix
 
 @@no_prefix:
 mov dx, 4
 mov al, [si+2]
 mov ah, [si+3]
 call PrintHex
 lea dx, colon
 call PrintStr ;spausdinamas dvitaskis
 mov dx, 4
 mov al, [si]
 mov ah, [si+1]
 call PrintHex
 lea dx, newLine
 call PrintStr
 popa
 ret
endp FarDirect

proc NearRelative ;si - instrukcijos baitu buferio adresas
 pusha
 lea dx, strCall
 call PrintStr
 cmp [segmentPrefix], 0
 je @@no_prefix
 call PrintPrefix
 
 @@no_prefix: 
 mov bl, [si]
 mov bh, [si+1]
 mov ax, bx
 shr ax, 15
 jz @@positive ;offsetas teigiamas
 not bx ;is neigiamo konvertuojam i teigiama
 inc bx
 mov ax, [IP]
 sub ax, bx
 jmp @@print
 
 @@positive:
 mov ax, bx
 add ax, [IP]
 
 @@print:
 mov dx, 4
 call PrintHex ;spausdinamas adresas
 lea dx, newLine
 call PrintStr
 popa
 ret
endp NearRelative

proc PrintSigned ;ax - spausdinamas skaicius, dx baitu kiekis
 pusha
 cmp dx, 2
 je @@word
 ;spauzdinamas baitas
 mov cx, 2
 test al, al
 js @@negByte
 lea dx, strAdd
 jmp @@end
 
 @@negByte:
 lea dx, strSub
 not al
 inc al
 jmp @@end
 
 @@word:
 mov cx, 4
 test ax, ax
 js @@negWord
 lea dx, strAdd
 jmp @@end
 
 @@negWord:
 lea dx, strSub
 not ax
 inc ax
 
 @@end:
 call PrintStr
 mov dx, cx
 call PrintHex
 popa
 ret
endp PrintSigned

proc Indirect
 pusha
 lea dx, strCall
 call PrintStr
 cmp [printFar], 0
 je @@not_far
 lea dx, strFar
 call PrintStr
 
 @@not_far:
 cmp [segmentPrefix], 0
 je @@no_prefix
 call PrintPrefix
 
 @@no_prefix: 
 
 mov al, [si]
 mov ah, al
 shr ah, 6 ;mod
 and al, 7 ;r/m
 
 cmp ah, 3
 je @@print_reg
 
 lea dx, addrStart
 call PrintStr 
 
 cmp ah, 0
 je @@no_offs
 jmp @@not_disp16
 
 @@no_offs:
 cmp al, 6
 jne @@not_disp16
 
 ;mod 00 r/m 110 atvejis
 add [IP], 2
 mov al, [si+1]
 mov ah, [si+2]
 mov dx, 4
 call PrintHex ;spausdinamas Disp16 
 jmp @@print_addr
 
 @@not_disp16:
 mov di, si
 lea si, strModMem
 mov cl, al
 mov ch, 0
 call FindStrStart
 mov dx, si
 call PrintStr    ;spausdinamas adresacijos budas: bx+si, bp+di ir t.t.
 
 cmp ah, 1
 je @@byte_offs
 cmp ah, 2
 je @@word_offs
 jmp @@print_addr
 
 @@byte_offs:
 add [IP], 1
 xor ax, ax
 mov al, [di+1]
 mov dx, 1
 call PrintSigned
 jmp @@print_addr
 
 @@word_offs:
 add [IP], 2
 mov al, [di+1]
 mov ah, [di+2]
 mov dx, 2
 call PrintSigned
 jmp @@print_addr 
 
 @@print_reg:
 lea si, registers
 mov cl, al
 mov ch, 0
 call FindStrStart
 mov dx, si
 call PrintStr
 jmp @@end
 
 @@print_addr:
 lea dx, addrEnd
 call PrintStr
 
 @@end:
 lea dx, newLine
 call PrintStr
 popa
 ret
endp Indirect

proc Disassemble ;si - instrukcijos baitu buferio adresas
 pusha
 
 @@beginning:
 mov al, [si]
 cmp al, 2Eh
 je @@cs_prefix
 cmp al, 3Eh
 je @@ds_prefix
 cmp al, 26h
 je @@es_prefix
 cmp al, 36h
 je @@ss_prefix
 cmp al, 9Ah
 je @@far_direct
 cmp al, 0E8h
 je @@near_relative
 cmp al, 0FFh
 jne @@not_call
 mov al, [si+1]
 shr al, 3
 and al, 7 ;gaunam reg bitus, kurie nurodo kokia yra instrukcija
 cmp al, 2
 je @@near_indirect
 cmp al, 3
 je @@far_indirect
 
 @@not_call:
 inc si
 add [IP], 1
 jmp @@end
 
 @@cs_prefix:
 add [IP], 1
 mov segmentPrefix, 1
 inc si
 jmp @@beginning
 
 @@ds_prefix:
 add [IP], 1
 mov segmentPrefix, 2
 inc si
 jmp @@beginning
 
 @@es_prefix:
 add [IP], 1
 mov segmentPrefix, 3
 inc si
 jmp @@beginning
 
 @@ss_prefix:
 add [IP], 1
 mov segmentPrefix, 4
 inc si
 jmp @@beginning
 
 @@far_direct:
 add [IP], 5
 inc si
 call FarDirect
 jmp @@end
 
 @@near_relative:
 add [IP], 3
 inc si
 call NearRelative
 jmp @@end
 
 @@near_indirect:
 add [IP], 2 ;pradzioj instrukcijos ilgis 2: opcode ir adresavimo baitas
 inc si
 mov [printFar], 0
 call Indirect
 jmp @@end
 
 @@far_indirect:
 add [IP], 2
 inc si
 mov [printFar], 1
 call Indirect
 jmp @@end
 
 @@end:
 popa
 ret
endp Disassemble

start:
 mov ax, @data
 mov ds, ax
 
 call GetFileNames
 cmp ax, 1 ;ar buvo klaidu
 jne @@start1
 lea dx, msgHelp
 mov ah, 9
 int 21h
 mov ah, 4Ch
 int 21h

 @@start1:
 lea dx, fname1
 call OpenFile
 mov comFile, ax ;irasomas handle
 
 lea dx, fname2
 call CreateFile
 
 lea dx, fname2
 call OpenFile
 mov asmFile, ax
 
 lea dx, inst
 mov cx, byteCnt
 call ReadFromFile
 mov [bytesLeft], al
 
 @@keepReading:
 mov ax, [IP]
 mov segmentPrefix, 0
 lea si, inst
 call Disassemble ;spausdinamas assemblerio kodas
 
 mov cx, [IP]
 sub cx, ax ;praejusios instrukcijos ilgis
 lea si, inst
 call ShiftBytes
 sub [bytesLeft], cl
 
 cmp [EOF], 0
 jne @@fileEnded
 
 lea dx, inst
 mov ax, byteCnt
 sub ax, cx
 add dx, ax
 call ReadFromFile
 add [bytesLeft], al
 
 cmp ax, cx
 je @@fileEnded
 mov [EOF], 1
 
 @@fileEnded:
 cmp [bytesLeft], 0
 jne @@keepReading ;dar ne failo pabaiga
 
 @@stopReading:
 
 mov bx, comFile
 call CloseFile
 
 mov bx, asmFile
 call CloseFile
 
 @@end:
 mov ah, 4Ch
 int 21h
end start