.model small

.stack 100h

.data
 sk db " $"
 TF1 dw 100h                    ;maske trap flagui ijungt
 sMUL db "imul $"               ;mul string
 opMASK db 7                    ;operand mask
 reg8 db "alcldlblahchdhbh"     ;8 bitu registru sarasas
 reg16 db "axcxdxbxspbpsidi"    ;16 bitu registru sarasas
 regAddr dw 0                   ;adresas i registra
 base16 db "0123456789ABCDEF"   ;skaitmenys sudarantis sesioliktaine skaiciavimo sistema
 skaic dw 3
 bitMASK dw 15                  ;4 bitu maske
 tarpas db "    $";
 bPointerStr db "byte ptr[$"
 wPointerStr db "word ptr[$"
 PointerStr dw 0
 lygu db " = $"
 axVAlue dw 0                   ;ax registro reiksme
 instp dw 0
 cseg dw 0
 stackp dw 0                    ;stack pointer
 machineCode dw 0               ;pirmi du instrukcijos baitai

.code

Print16:
 push ax
 push bx
 push dx
 push cx
 push si

 mov cx, 0
 get_nums:
 mov bx, ax
 and bx, bitMASK
 shr ax, 4
 push bx
 inc cx
 cmp ax, 0
 jne get_nums

 print_nums:
 pop bx
 lea si, base16 
 mov al, [si+bx]
 mov sk, al
 lea dx, sk
 mov ah, 9
 int 21h
 loop print_nums

 pop si
 pop cx
 pop dx
 pop bx
 pop ax
 ret

PrintReg: ;spauzdina registra
 push ax
 push cx
 push dx

 mov al, ah
 mov ah, 0
 mov cl, 2
 mul cl

 mov dx, regAddr
 add dx, ax    ;apskaiciuojamas instrukcijos offsetas stringe    
 mov bx, 1     
 mov ah, 40h      
 mov cx, 2   
 int 21h       ;spauzdinti registra

 pop dx
 pop cx
 pop ax
ret

PrintComment: ;spauzdinamas komentaras kur nurodoma operando reiksme
 push ax

 mov ah, 9
 lea dx, tarpas
 int 21h           ;spauzdinamas tarpas
 mov al, ';'
 mov sk, al
 mov ah, 9
 lea dx, sk
 int 21h           ;spauzdinamas kabliataskis

 pop ax
ret

Disassemble:
 mov al, es:[si+1] ;paimamas sekantis instrukcijos baitas

 lea dx, sMUL
 mov ah, al
 shr ah, 3
 and ah, opMASK
 cmp ah, 4
 jne check_imul    ;patikrinti ar tai imul instrukcija
 inc dx            ;jei instrukcija mul
 jmp check_operand

 check_imul:
 cmp ah, 5
 je check_operand

 jmp singleStep_pab ;jei instrukcija nei mul, nei imul

 check_operand:
 push dx
 mov ax, cseg
 call Print16      ;spauzdinamas instrukcijos segmentas
 mov al, ':'
 mov sk, al
 mov ah, 9
 lea dx, sk
 int 21h           ;spauzdinamas dvitaskis

 mov ax, instp
 call Print16      ;spauzdinamas instrukcijos ip

 mov al, ':'
 mov sk, al
 mov ah, 9
 lea dx, sk
 int 21h           ;spauzdinamas dvitaskis
 mov al, ' '
 mov sk, al
 mov ah, 9
 lea dx, sk
 int 21h           ;spauzdinamas tarpas

 mov ax, machineCode
 call Print16      ;spauzdinamas sesioliktainis instrukcijos kodas

 pop dx

 mov al, es:[si+1]
 mov ah, al
 shr ah, 6
 cmp ah, 3         ;ar operandas registras
 je op_register

 ;jei operandas ne registras
 mov ah, es:[si+2]
 mov al, es:[si+3]
 call Print16      ;spauzdinamas isntrukcijos sesioliktainis kodas
 mov ah, 9
 push dx           ;issaugomas instrukcijos stringo adresas
 lea dx, tarpas
 int 21h           ;spauzdinamas tarpas

 pop dx
 mov ah, 9
 int 21h           ;spauzdinti instrukcija

 mov ah, 9
 mov dx, PointerStr
 int 21h           ;spauzdinamas tarpas
 mov al, es:[si+2]
 mov ah, es:[si+3]
 call Print16      ;spauzdinamas operandas
 mov al, ']'
 mov sk, al
 mov ah, 9
 lea dx, sk
 int 21h           ;spauzdinamas lauztinis skliaustas
 jmp disasm_end

 op_register:
 push dx        ;issaugoma buvusi dx reiksme
 mov ah, 9
 lea dx, tarpas
 int 21h           ;spauzdinamas tarpas
 pop dx
 mov ah, 9
 int 21h           ;spauzdinti instrukcija

 mov al, es:[si+1]
 mov ah, al
 and ah, opMASK
 call PrintReg    ;spauzdinamas registro pavadinimas

 disasm_end:
 call PrintComment
 mov ah, 0        ;registras ax
 call PrintReg
 lea dx, lygu
 mov ah, 9
 int 21h         ;spauzdinamas lygybes zenklas
 mov ax, axValue
 call Print16
 mov al, 'h'
 mov sk, al
 mov ah, 9
 lea dx, sk
 int 21h           ;spauzdinamas dvitaskis

ret

SingleStep:
 mov stackp, sp

 push ax         ;issaugomos registru reiksmes
 push bx
 push cx
 push dx
 push si
 push es

 mov axValue, ax
 mov si, stackp      
 mov ax, ss:[si+2] ;gaunamas cs
 mov es, ax
 mov cseg, ax

 mov ax, ss:[si]   ;gaunamas ip
 mov instp, ax
 mov si, ax

 mov ah, es:[si]   
 mov al, es:[si+1]
 mov machineCode, ax
 
 mov al, es:[si]   ;opcode
 cmp al, 0F6h
 je mul8
 cmp al, 0F7h
 je mul16
 
 jmp singleStep_pab ;jei instrukcija nera nei mul, nei imul
 
 mul8:            ;kai operandai 8 bitu
 lea ax, reg8
 mov regAddr, ax
 lea ax, bPointerStr
 mov PointerStr, ax
 call Disassemble
 jmp set_trap

 mul16:           ;kai operandai 16 bitu
 lea ax, reg16
 mov regAddr, ax
 lea ax, wPointerStr
 mov PointerStr, ax
 call Disassemble

 set_trap:
 mov si, stackp
 mov ax, ss:[si+4]
 xor ax, TF1          
 mov ss:[si+4], ax     ;isjungiamas trap flagas

 singleStep_pab:
 pop es               ;grazinamos registru reiksmes
 pop si
 pop dx
 pop cx
 pop bx
 pop ax
iret



start:
 mov ax, @data
 mov ds, ax

 mov ax, es:[4]
 push ax        ;issaugomas ip is interuptu vektroiu lenteles
 mov ax, es:[6]
 push ax        ;issaugomas cs 

 mov ax, 0
 mov es, ax
 mov ax, offset SingleStep
 mov es:[4], ax              ;i interuptu vektoriu lentele idedamas handlerio ip
 mov es:[6], cs              ;idedamas cs

 mov cl, 3
 pushf
 mov si, sp
 mov ax, ss:[si]
 or ax, TF1          
 mov ss:[si], ax
 popf                       ;nustatomas trap flagas

 mov ax, 2
 mov bx, 2
 mov dx, 0
 imul skaic

 pabaiga:
 pop ax
 mov es:[6], ax
 pop ax
 mov es:[4], ax

 mov ah, 4Ch
 int 21h
end start