.model small

.stack 100h ;stekui iskiriami 256 baitai

.data
 Param db 256 dup(0) ;programos parametrai perduodami komandineje eiluteje
 ParamLength db 0    ;parametru eilutes ilgis
 fname1 db 80 dup(0) ;pirmo failo vardas
 fname2 db 80 dup(0) ;antro failo vardas
 fname3 db 80 dup(0) ;trecio failo vardas
 handler1 dw 0       ;pirmo skaitymo failo deskriptorius
 handler2 dw 0       ;antro skaitymo failo deskriptorius
 handlew dw 0        ;rasymo failo deskriptorius
 tekst db 256 dup(0) ;tekstas nuskaitytas is failo
 did_ilg dw 0        ;didesnio skaiciaus ilgis
 maz_ilg dw 0        ;mazesnio skaiciaus ilgis
 did_sk db 256 dup(30h) ;didesnis skaicius
 maz_sk db 256 dup(30h) ;mazesnis skaicius
 skaic db 256 dup(0) ;skaicius reikalingas keiciant vietoms didesni ir mazesni
 neig db 0           ;ar rezultatas neigiamas
 minus db "-"
 OpenError db "Ivyko klaida atidarant faila!", 10, 13
 CreateError db "Ivyko klaida sukuriant nauja faila!", 10, 13
 ReadError db "Ivyko klaida skaitant is failo!", 10, 13 
 WriteError db "Ivyko klaida rasant i faila!", 10, 13
 pagalb db "Programa parase Povilas Balciunas.Naudojimas: i 1 tekstini faila irasomas 1 skaicius, i 2 - 2, rezultatai rasomi i nurodyta 3 faila.Leidziant programa kaip parametrai perduodami 1 ir 2 duomenu failai ir rezultatu failas$"

.code

GetParam:        ;procedure nuskaitanti parametrus i Param
 mov ax, @data
 mov ds, ax
 mov si, 80h     ;poslinkis kuris nurodo parametru eilutes ilgi
 mov cx, 0
 mov cl, es:[si] ;gaunamas parametru eilutes ilgis
 mov ParamLength, cl
 lea di, Param   ;load effective address, i registra ikeliamas duomenu poslinkis
 inc si          ;einama i parametru eilutes pradzia, poslinkiu 81h
 dec cx          ;registro reiskme sumazinamas vienetu
 toliau:         ;komandos perrasymas i buferi
 mov al, es:[si + 1] ;i al ikeliamas simbolis is parametru
 mov ds:[di], al     ;simbolis ikeliamas i duomenu segmenta, i  Param
 inc si          ;didinama registro reiksme vienetu
 inc di          ;didinama registro reiksme vienetu
 loop toliau     ;kol cx > 0 tesiamas ciklas
 mov al, ParamLength
 mov ah, 0
 mov di, ax
 mov al, 0
 mov Param[di - 1], al ;ikeliamas pabaigos simbolis i paskutini simboli
 ret             ;grizti kur buvo iskviesta procedura

GetFileNames:   ;procedura is Param gaunanti failu vardus
 lea di, Param  ;i di ikeliamas zymes Param poslinkis
 lea si, fname1 ;i si ikeliamas zymes fname1 poslinkis
 iesk_f1:
 mov al, ds:[di] ;i al ikeliamas simbolis is Param
 mov ds:[si], al ;i zyme fname1 perkeliamas simbolis is Param
 inc di          ;didinama reiksme vienetu, pereinama prei kito simbolio
 inc si          ;didinama reiksme vienetu, pereinama prei kito simbolio
 cmp al, " "
 jne iesk_f1     ;kol al nelygus tarpo simboliui perrasineti pirmo failo varda
 mov al, 0     ;i al ikeliamas eilutes pabaigos simbolis
 mov ds:[si - 1], al ;i paskutinima fname1 simboli ikeliamas pabaigos ismbolis 
 lea si, fname2  ;i si ikeliamas zymes fname2 poslinkis
 iesk_f2:
 mov al, ds:[di] ;i al ikeliamas simbolis is Param
 mov ds:[si], al ;i zyme fname2 perkeliamas simbolis is Param
 inc di          ;didinama reiksme vienetu, pereinama prei kito simbolio
 inc si          ;didinama reiksme vienetu, pereinama prei kito simbolio
 cmp al, " "
 jne iesk_f2     ;kol al nelygus tarpo simboliui perrasineti antra failo varda
 mov al, 0     ;i al ikeliamas eilutes pabaigos simbolis
 mov ds:[si - 1], al ;i paskutinima fname2 simboli ikeliamas pabaigos ismbolis  
 lea si, fname3  ;i si ikeliamas zymes fname3 poslinkis
 iesk_f3:
 mov al, ds:[di] ;i al ikeliamas simbolis is Param
 mov ds:[si], al ;i zyme fname2 perkeliamas simbolis is Param
 inc di          ;didinama reiksme vienetu, pereinama prei kito simbolio
 inc si          ;didinama reiksme vienetu, pereinama prei kito simbolio
 cmp al, 0
 jne iesk_f3  ;kol al nelygus 0, perrasineti antro trecio varda
 ret          ;grizti kur buvo iskviesta procedura

fopenr1:       ;procedura pirmo failo atidarymui is kurio skaitoma
 push ax      ;i steka idedami registrai kad poto neprarast ju reiksmiu
 push dx
 mov ah, 3dh  ;failo atidarimo funkcija
 mov al, 2    ;read/write
 mov dx, offset fname1   ;ikeliamas failo poslinkis
 int 21h      ;atidaryti faila
 mov handler1, ax ;gaunamas failo deskriptorius, handle
 jc fOpenError ;jei ivyko klaida atidarant persokti i kita procedura
 pop dx      ;is steko isimamos registru reiksmes
 pop ax
 ret

fcloser1:      ;procedura pirmo failo uzdarymui is kurio skaitoma
 push ax      ;i steka idedami registrai kad poto neprarast ju reiksmiu
 mov bx, handler1
 mov ah, 3eh
 int 21h
 pop ax       ;is steko isimamos registru reiksmes
 ret

freadr1:       ;procedure skaitanti is pirmo failo duomenis
 mov bx, handler1 ;i bx ikeliamas skaitymo failo identifikatorius
 mov ah, 3fh  ;skaitymo funkcija
 mov cx, 512  ;i cx ikeliamas baitu skaicius kiek norima nuskaityti
 mov dx, offset did_sk ;i dx ikeliamas tekst zymes poslinkis
 int 21h      ;skaityti
 mov did_ilg, ax 
 jc fReadError ;jei ivyko klaida skaitant persokti i kita procedura
 ret

fopenr2:       ;procedura antro failo atidarymui is kurio skaitoma
 push ax      ;i steka idedami registrai kad poto neprarast ju reiksmiu
 push dx
 mov ah, 3dh  ;failo atidarimo funkcija
 mov al, 2    ;read/write
 mov dx, offset fname2   ;ikeliamas failo poslinkis
 int 21h      ;atidaryti faila
 mov handler2, ax ;gaunamas failo deskriptorius, handle
 jc fOpenError ;jei ivyko klaida atidarant persokti i kita procedura
 pop dx      ;is steko isimamos registru reiksmes
 pop ax
 ret

fcloser2:      ;procedura antro failo uzdarymui is kurio skaitoma
 push ax      ;i steka idedami registrai kad poto neprarast ju reiksmiu
 mov bx, handler2
 mov ah, 3eh
 int 21h
 pop ax       ;is steko isimamos registru reiksmes
 ret

freadr2:       ;procedure skaitanti is pirmo failo duomenis
 mov bx, handler2 ;i bx ikeliamas skaitymo failo identifikatorius
 mov ah, 3fh  ;skaitymo funkcija
 mov cx, 512  ;i cx ikeliamas baitu skaicius kiek norima nuskaityti
 mov dx, offset maz_sk ;i dx ikeliamas tekst zymes poslinkis
 int 21h      ;skaityti
 mov maz_ilg, ax 
 jc fReadError ;jei ivyko klaida skaitant persokti i kita procedura
 ret

fReadError: ;procedura kai ivyksta klaida skaitant
 mov bx, 1 ;stdout
 mov dx, offset ReadError
 mov cx, 33  ;baitu skaicus kuriuos rasys
 mov ah, 40h ;rasymo funkcija
 int 21h
 jmp pabaiga

fOpenError: ;procedura vykdoma kai ivyksta klaida atidarant faila
 mov bx, 1 ;stdout
 mov dx, offset OpenError
 mov cx, 31  ;baitu skaicus kuriuos rasys
 mov ah, 40h ;rasymo funkcija
 int 21h
 jmp pabaiga

fcreatew: ;procedura sukurianti faila i kuri bus rasoma
 mov ah, 3Ch ;sukurimo funkcija
 mov cx, 0 ;failo atributai
 mov dx, offset fname3
 int 21h ;sukurti faila
 jc fCreateError ;jei ivyksta klaida tai pranesti
 ret

fCreateError: ;procedura vykdoma kai sukuriant nauja faila ivyksta klaida
 mov bx, 1 ;stdout
 mov dx, offset CreateError
 mov cx, 37  ;baitu skaicus kuriuos rasys
 mov ah, 40h ;rasymo funkcija
 int 21h
 jmp pabaiga

fopenw:       ;procedura failo atidarymui i kuri rasoma
 push ax      ;i steka idedami registrai kad poto neprarast ju reiksmiu
 push dx
 mov ah, 3dh  ;failo atidarimo funkcija
 mov al, 2    ;read/write
 mov dx, offset fname3   ;ikeliamas failo poslinkis
 int 21h      ;atidaryti faila
 mov handlew, ax ;gaunamas failo identifikatorius, handle
 jc fOpenError ;jei ivyko klaida atidarant persokti i kita procedura
 pop dx      ;is steko isimamos registru reiksmes
 pop ax
 ret

fclosew:      ;procedura failo uzdarymui i kuri rasoma
 push ax      ;i steka idedami registrai kad poto neprarast ju reiksmiu
 mov bx, handlew
 mov ah, 3eh
 int 21h
 pop ax       ;is steko isimamos registru reiksmes
 ret

fwritew: ;procedura rasanti i rasymo faila
 push ax
 push bx
 push cx
 lea si, did_sk
 trinti_nulius:
 mov al, ds:[si]
 inc si
 dec did_ilg
 cmp al, 30h
 je trinti_nulius
 dec si
 inc did_ilg
 mov bx, handlew ;nustatomas rasymo deskriptorius
 mov dx, si
 mov cx, did_ilg  ;baitu skaicus kuriuos rasys
 mov ah, 40h ;rasymo funkcija
 int 21h
 jc fWriteError ;jei ivyko klaida rasant persokti i kita procedura
 pop ax
 pop bx
 pop cx
 ret

fWriteError: ;procedura kuri vykdoma kai ivyksta klaida rasant 
 mov bx, 1 ;stdout
 mov dx, offset WriteError
 mov cx, 30  ;baitu skaicus kuriuos rasys
 mov ah, 40h ;rasymo funkcija
 int 21h
 jmp pabaiga

Didesnis: ;procedura surandanti ar nuskaitytas pirmas skaicius didesnis uz antra, jei ju ilgiai vienodi
 push ax
 mov cx, did_ilg
 mov bl, 0 ;pirmas skaicius mazesnis
 lea si, did_sk
 lea di, maz_sk
 lyginti_skaicius:
 mov al, ds:[si]
 mov ah, ds:[di]
 cmp al, ah
 ja pirmas_didesnis
 jb Didesnis_pab
 inc si
 inc di
 loop lyginti_skaicius
 pirmas_didesnis:
 mov bl, 1 ;pirmas skaicius didesnis
 Didesnis_pab:
 pop ax
 ret
 
SurastiDidesni: ;procedura surandanti kuris is nuskaitytu skaiciu didesnis
 mov ax, did_ilg
 cmp maz_ilg, ax
 ja keisti_vietom
 je vienodi_ilgiai
 jmp nekeisti_vietom
 vienodi_ilgiai:
 call Didesnis
 cmp bl, 0
 je keisti_vietom
 jmp SurastiDidesni_pab
 nekeisti_vietom:
 mov bx, ax
 sub bx, maz_ilg
 mov cx, maz_ilg
 lea si, maz_sk
 add si, cx
 inc cx
 stumti_maz_sk:
 mov di, si
 add di, bx
 mov al, ds:[si]
 mov ds:[di], al
 mov al, 30h
 mov ds:[si], al
 dec si
 loop stumti_maz_sk ;mazesniojo skaiciaus skaitmenis pastumti i desine
 jmp SurastiDidesni_pab
 keisti_vietom:
 mov neig, 1 ;rezultatas bus neigiamas
 lea si, did_sk
 lea di, skaic
 mov cx, did_ilg
 mov bx, did_ilg
 kop_did:
 mov al, ds:[si]
 mov ds:[di], al
 inc si
 inc di
 loop kop_did ;kopijuoti didesni skaiciu i zyme skaic
 lea si, maz_sk
 lea di, did_sk
 mov cx, maz_ilg
 mov did_ilg, cx
 kop_maz:
 mov al, ds:[si]
 mov ds:[di], al
 inc si
 inc di
 loop kop_maz ;kopijuoti mazesni skaiciu i zyme did_sk
 lea di, maz_sk
 mov cx, did_ilg
 sub cx, bx
 add di, cx
 inc cx
 rasyt_nul:
 mov al, 30h
 mov si, cx
 mov maz_sk[si - 1], al
 loop rasyt_nul
 mov cx, bx
 mov maz_ilg, bx
 lea si, skaic
 kop_skaic:
 mov al, ds:[si]
 mov ds:[di], al
 inc di
 inc si
 loop kop_skaic ;kopijuoti is zymes skaic i zyme maz_sk 
 SurastiDidesni_pab:
 ret

TvarkytiLiekana: ;procedura vykdoma kai atimant viena skaiciu lieka neigiamas skaicius liekanos
 push si
 push bx
 mov dl, 0
 dec dl
 imul dl
 mov ah, al
 mov al, 10
 sub al, ah
 mov ah, 0
 dec si
 mov bl, ds:[si]
 sub bl, 30h
 cmp bl, 0
 je paimti_desim
 ja atimti_liekana
 jmp TvarkytiLiek_pab
 paimti_desim:
 mov bl, 39h
 mov ds:[si], bl
 dec si
 mov bl, ds:[si]
 sub bl, 30h
 cmp bl, 0
 je paimti_desim ;is didesnio skaitmens paimt sveika dali
 ja atimti_liekana
 atimti_liekana:
 dec bl
 add bl, 30h
 mov ds:[si], bl
 TvarkytiLiek_pab:
 pop bx
 pop si
 jmp ideti_rezultata

Atimti: ;procedura atimanti is didesnio mazesni skaiciu
 mov cx, did_ilg
 lea si, did_sk
 lea di, maz_sk
 atimineti:
 mov al, ds:[si]
 mov bl, ds:[di]
 sub al, bl
 cmp al, 0
 jl TvarkytiLiekana 
 ideti_rezultata: ;idedamas skaitmenu atimimo rezultatas i skaiciaus eilute
 add al, 30h
 mov ds:[si], al
 inc di
 inc si
 loop atimineti ;atimti keikviena skaitmeni
 ret

START:
 call GetParam ;iskvieciama procedura parametras perkelti i Param
 lea di, Param
 mov al, "/"
 cmp ds:[di], al 
 jne failas
 inc di
 mov al, "?"
 cmp ds:[di], al
 je pagalba 
 failas:
 call GetFileNames ;iskvieciama procedura is parametru gauti failu vardams
 call fopenr1   ;atidaromas pirmas skaitymo failas
 call freadr1   ;skaitomas tekstas is pirmo failo
 call fcloser1  ;uzdaromas pirmas skaitymo failas
 call fopenr2   ;atidaromas antras skaitymo failas
 call freadr2   ;skaitomas tekstas is antro failo
 call fcloser2  ;uzdaromas antras skaitymo failas
 call SurastiDidesni ;surasti didesni skaiciu is nuskaitytuju
 call Atimti
 call fcreatew ;sukuriamas failas rasymui
 call fopenw   ;atidaromas failas rasymui
 cmp neig, 0
 je rasyti_teig
 mov bx, handlew ;nustatomas rasymo deskriptorius
 mov dx, offset minus
 mov cx, 1  ;baitu skaicus kuriuos rasys
 mov ah, 40h ;rasymo funkcija
 int 21h
 rasyti_teig:
 call fwritew  ;rasomas rezultatas i faila
 call fclosew  ;uzdaromas rasymo failas
 jmp pabaiga
 pagalba:
 mov dx, offset pagalb
 mov ah, 9
 int 21h
 pabaiga:
 mov ah, 4ch
 int 21h     ;perduodamas valdymas operacinei sistemai
END START