/** RM - reali masina
 * ----------------------
 * @author 
 * ----------------------
 */

import java.io.*;

public class RM
{ 
    private String IC;
    private String SP;
    private int PI;
    private int SI;
    private int IOI;
    private int TI;
    private String MODE;
    private int C;
    private RA ra;
    private VM vm;
    private String PLR;
    private Puslapiavimas psl;
    private String klaida;
    private Kanalas1 kanalas1;
    private Kanalas2 kanalas2;
    private Kanalas3 kanalas3;
    
    public RM()
    {
        this.IC = "00";
        this.SP = "00";
        this.PI = 0;
        this.SI = 0;
        this.IOI = 0;
        this.TI = 0;
        this.MODE = "U";  
        this.C = 0;        
        this.ra = new RA();
        this.vm = null;
        this.PLR = "000";
        this.psl = null;
        this.klaida = "";
        this.kanalas1 = new Kanalas1();
        this.kanalas2 = new Kanalas2();
        this.kanalas3 = new Kanalas3();
    }
    
    public String getIC(){ return this.IC; }
    public String getSP(){ return this.SP; }
    public int getPI(){ return this.PI; }
    public int getSI(){ return this.SI; }
    public int getIOI(){ return this.IOI; }
    public int getTI(){ return this.TI; }
    public String getMODE(){ return this.MODE; }
    public int getC(){ return this.C; }
    public String getPLR(){ return this.PLR; }

    public void setPLR(String PLR){ this.PLR = PLR; } 
    public void setIC(String IC){ this.IC = IC; }
    public void setSP(String SP){ this.SP = SP; }
    public void setPI(int PI){ this.PI = PI; }
    public void setSI(int SI){ this.SI = SI; }
    public void setIOI(int IOI){ this.IOI = IOI; }
    public void setTI(int TI){ this.TI = TI; }
    public void setMODE(String MODE){ this.MODE = MODE; }
    public void setC(int C){ this.C = C; }

    public RA getRA(){ return this.ra; }
    public void setRA(RA ra){ this.ra = ra; }

    public VM getVM(){ return this.vm; }
    public void setVM(VM vm){ this.vm = vm; }

    public void setPsl(Puslapiavimas psl){ this.psl = psl; }
    public Puslapiavimas getPsl(){ return this.psl; }

    public void spausdintiRegistrus()
    {
        System.out.println("IC: "+this.IC);
        System.out.println("SP: "+this.SP);
        System.out.println("PI: "+this.PI);
        System.out.println("SI: "+this.SI);
        System.out.println("IOI: "+this.IOI);
        System.out.println("TI: "+this.TI);
        System.out.println("MODE: "+this.MODE);
        System.out.println("PLR: "+this.PLR);
        System.out.println("C: "+this.C);
    }
    
    public void spausdintiKlaida()
    {
        System.out.println();
        System.out.println("***  " + this.klaida + "  ***");
        System.out.println();
    }
    
    public void setKlaida(String klaida)
    {
        this.klaida = klaida;
    }
    
    public void komanda(Converter vertejas, int duomSk, int codeSk)
    {        
        int skaitinisAdresas = vertejas.HexToInt(IC);
        String atlikti = vm.getVA().getZodis(skaitinisAdresas).getTurinys();
        //veiksmai
        if (atlikti.equals("ADD0")){
            this.ADD(vertejas);
        }else if (atlikti.equals("SUB0")){
            this.SUB(vertejas);
        }else if (atlikti.equals("CMP0")){
            this.CMP(vertejas);
        }else if (atlikti.startsWith("JM")){
            this.JM(vertejas, atlikti.substring(2, 4));
        }else if (atlikti.startsWith("JL")){
            this.JL(vertejas, atlikti.substring(2, 4));
        }else if (atlikti.startsWith("JE")){
            this.JE(vertejas, atlikti.substring(2 ,4));            
        }else if (atlikti.startsWith("JP")){
            this.JP(vertejas, atlikti.substring(2, 4));
        }else if (atlikti.equals("HA00")){
            this.HA();
        }else if (atlikti.equals("PUT0")){
            this.PUT(vertejas);
        }else if (atlikti.equals("GET0")){
            this.GET(vertejas);
        }else if (atlikti.startsWith("PO")){
            this.PO(vertejas, atlikti.substring(2, 4));
        }else if (atlikti.startsWith("PU")){
            this.PU(vertejas, atlikti.substring(2, 4));
        }else if (atlikti.startsWith("EX")){            
            this.EX(vertejas, atlikti.substring(2, 4), duomSk, codeSk);
        }else{
            PI = 1;
            klaida = "Nepazistama komanda";
        }
        
        if ((!(atlikti.startsWith("EX")))&&(!atlikti.startsWith("JM"))&&(!atlikti.startsWith("JL"))&&(!atlikti.startsWith("JE"))&&(!atlikti.startsWith("JP")))
        {
            skaitinisAdresas++;        
            IC = vertejas.IntToHex(skaitinisAdresas);        
            vm.setIC(this.IC);
        }        
    }
    
    public void ADD(Converter vertejas)
    {
        int skaitinisAdresas = vertejas.HexToInt(SP);
        if (skaitinisAdresas < 65)
        {
            klaida = "Steke nepakanka skaiciu sudeciai";
            PI = 0;
        }else{
            try
            {
                Integer.parseInt(vm.getVA().getZodis(skaitinisAdresas).getTurinys());
                try
                {
                    Integer.parseInt(vm.getVA().getZodis(skaitinisAdresas-1).getTurinys());
                    int rezultatas = Integer.parseInt(vm.getVA().getZodis(skaitinisAdresas).getTurinys()) +
                                Integer.parseInt(vm.getVA().getZodis(skaitinisAdresas-1).getTurinys());
                    this.SP = vertejas.IntToHex(skaitinisAdresas - 1);
                    String strRez = Integer.toString(rezultatas);
                    if (strRez.length() >= 4)
                        strRez = strRez.substring(0, 4);
                    else
                        strRez = vertejas.papildyti(strRez, 4, 0);
                    vm.getVA().getZodis(skaitinisAdresas - 1).setTurinys(strRez);
                    vm.setSP(this.SP);
                }catch (Exception e){
                    this.klaida = "Netinkamas formatas sudeciai";
                    this.PI = 1;
                }
            }catch (Exception e){
                this.klaida = "Netinkamas formatas sudeciai";
                this.PI = 1;
            }
        }

    }
    
    public void SUB(Converter vertejas)
    {
        int skaitinisAdresas = vertejas.HexToInt(SP);
        if (skaitinisAdresas < 65)
        {
            klaida = "Steke nepakanka skaiciu atimciai";
            PI = 0;
        }else
            try{
                Integer.parseInt(vm.getVA().getZodis(skaitinisAdresas).getTurinys());
                try{
                    Integer.parseInt(vm.getVA().getZodis(skaitinisAdresas-1).getTurinys());
                    int rezultatas = Integer.parseInt(vm.getVA().getZodis(skaitinisAdresas).getTurinys()) - Integer.parseInt(vm.getVA().getZodis(skaitinisAdresas-1).getTurinys());
                    this.SP = vertejas.IntToHex(skaitinisAdresas - 1);
                    String strRez = Integer.toString(rezultatas);
                    if (strRez.length() >= 4)
                        strRez = strRez.substring(0, 4);
                    else
                        strRez = vertejas.papildyti(strRez, 4, 0);
                    vm.getVA().getZodis(skaitinisAdresas - 1).setTurinys(strRez);
                    vm.setSP(this.SP);
                }catch (Exception e){
                    this.klaida = "Netinkamas formatas atimciai";
                    this.PI = 1;
                }
            }catch (Exception e){
                this.klaida = "Netinkamas formatas atimciai";
                this.PI = 1;
            }
    }
    
    public void CMP(Converter vertejas)
    {
        int skaitinisAdresas = vertejas.HexToInt(SP);
        if (skaitinisAdresas < 65)
        {
            klaida = "Steke nepakanka skaiciu palyginimui";
            PI = 0;
        }else
            try{
                Integer.parseInt(vm.getVA().getZodis(skaitinisAdresas).getTurinys());
                try{
                    Integer.parseInt(vm.getVA().getZodis(skaitinisAdresas-1).getTurinys());
                    int rezultatas;
                    if (Integer.parseInt(vm.getVA().getZodis(skaitinisAdresas).getTurinys()) > Integer.parseInt(vm.getVA().getZodis(skaitinisAdresas-1).getTurinys()))
                        rezultatas = 1;
                    else if (Integer.parseInt(vm.getVA().getZodis(skaitinisAdresas).getTurinys()) < Integer.parseInt(vm.getVA().getZodis(skaitinisAdresas-1).getTurinys()))
                        rezultatas = 2;
                    else
                        rezultatas = 3;             
                    this.SP = vertejas.IntToHex(skaitinisAdresas - 1);
                    String strRez = Integer.toString(rezultatas);
                    if (strRez.length() >= 4)
                        strRez = strRez.substring(0, 4);
                    else
                        strRez = vertejas.papildyti(strRez, 4, 0);
                    vm.getVA().getZodis(skaitinisAdresas - 1).setTurinys(strRez);
                    vm.setSP(this.SP);
                }catch (Exception e){
                    this.klaida = "Netinkamas formatas palyginimui";
                    this.PI = 1;
                }
            }catch (Exception e){
                this.klaida = "Netinkamas formatas palyginimui";
                this.PI = 1;
            }                   
    }
    
    public void JM(Converter vertejas, String adresas)
    {
        if (vertejas.tikrinti(adresas) == 0)
        {
            klaida = "Neteisingas adresas";
            PI = 1;
        }else if (vertejas.HexToInt(adresas) < 128){
            klaida = "Neteisingas adresas";
            PI = 1;
        }else{
            int skaitinisAdresas = vertejas.HexToInt(SP);
            if (vm.getVA().getZodis(skaitinisAdresas).getTurinys().equals("0001"))
            {
                IC = adresas;
                vm.setIC(this.IC);
            }else{
                IC = vertejas.IntToHex(vertejas.HexToInt(IC)+1);
                vm.setIC(this.IC);
            }
        }     
    }
    
    public void JL(Converter vertejas, String adresas)
    {
        if (vertejas.tikrinti(adresas) == 0)
        {
            klaida = "Neteisingas adresas";
            PI = 1;
        }else if (vertejas.HexToInt(adresas) < 128){
            klaida = "Neteisingas adresas";
            PI = 1;
        }else{ // jei viskas gerai
            int skaitinisAdresas = vertejas.HexToInt(SP);
            if (vm.getVA().getZodis(skaitinisAdresas).getTurinys().equals("0002"))
            { // jei maziau
                IC = adresas;
                vm.setIC(this.IC);
            }else{
                IC = vertejas.IntToHex(vertejas.HexToInt(IC)+1);
                vm.setIC(this.IC);
            }
        }
    }
    
    public void JE(Converter vertejas, String adresas)
    {
        if (vertejas.tikrinti(adresas) == 0)
        {
            klaida = "Neteisingas adresas";
            PI = 1;
        }else if (vertejas.HexToInt(adresas) < 128){
            klaida = "Neteisingas adresas";
            PI = 1;
        }else{
            int skaitinisAdresas = vertejas.HexToInt(SP);
            if (vm.getVA().getZodis(skaitinisAdresas).getTurinys().equals("0003"))
            {
                IC = adresas;
                vm.setIC(this.IC);
            }else{
                IC = vertejas.IntToHex(vertejas.HexToInt(IC)+1);
                vm.setIC(this.IC);
            }
        }    
    }
    
    public void JP(Converter vertejas, String adresas)
    {
        if (vertejas.tikrinti(adresas) == 0)
        {
            klaida = "Neteisingas adresas";
            PI = 1;
        }else if (vertejas.HexToInt(adresas) < 128){
            klaida = "Neteisingas adresas";
            PI = 1;
        }else{
            int skaitinisAdresas = vertejas.HexToInt(SP);                
            IC = adresas;
            vm.setIC(this.IC);    
        }    
    }
    
    public void PO(Converter vertejas, String adresas)
    {
        int skaitinisAdresas = vertejas.HexToInt(SP);
        if (skaitinisAdresas < 64)
        {
            klaida = "Steke nepakanka skaiciu POP operacijai";
            PI = 0;
        }else if (vertejas.tikrinti(adresas) == 0){
            klaida = "Neteisingas adresas";
            PI = 1;
        }else if (vertejas.HexToInt(adresas) > 63){
            klaida = "Neteisingas adresas";
            PI = 1;
        }else{                       
            vm.getVA().getZodis(vertejas.HexToInt(adresas)).setTurinys(vm.getVA().getZodis(skaitinisAdresas).getTurinys());
            SP = vertejas.IntToHex(skaitinisAdresas - 1);
            vm.setSP(this.SP);
        }        
    }

    public void PU(Converter vertejas, String adresas)
    {
        int skaitinisAdresas = vertejas.HexToInt(SP);        
        if (vertejas.tikrinti(adresas) == 0)
        {
            klaida = "Neteisingas adresas";
            PI = 1;
        }else if (vertejas.HexToInt(adresas) > 63){
            klaida = "Neteisingas adresas";
            PI = 1;
        }else{   
            SP = vertejas.IntToHex(skaitinisAdresas + 1);
            vm.setSP(this.SP);
            vm.getVA().getZodis(skaitinisAdresas+1).setTurinys(vm.getVA().getZodis(vertejas.HexToInt(adresas)).getTurinys());                                                
        }       
    }
    
    public void EX(Converter vertejas, String adresas, int duomSk, int codeSk)
    {        
        if (vertejas.tikrinti(adresas) == 0 )
        {
            PI = 1;
            klaida = "Neteisingas adresas";            
        }else{            
           int puslapis = vertejas.HexToInt(adresas.substring(0, 1));
           if (puslapis > 3)
           {
               PI = 1;
               klaida = "Neteisingas adresas";               
           }else{               
               String pavadinimas = "";
               int skaitliukas = 0;
               while (skaitliukas < 16)
               {                   
                   pavadinimas = pavadinimas + vm.getVA().getZodis(puslapis*16+skaitliukas).getTurinys();                   
                   skaitliukas++;                   
               }                              
               while (pavadinimas.endsWith("0"))                   
               {                         
                   pavadinimas = pavadinimas.substring(0, pavadinimas.length()-1);
               }
              
               DataInputStream in = kanalas3.atidarytiFaila(pavadinimas);
               BufferedReader br = new BufferedReader(new InputStreamReader(in));
               String strLine = "";
               
               String naujasAdresas = vertejas.IntToHex(vertejas.HexToInt(IC)+1);
               this.IC = vertejas.IntToHex(codeSk);
               vm.setIC(this.IC);               
               
               while(((strLine = kanalas3.skaitytiEilute(br)) != null)&& !(strLine.startsWith("HA")))
               {
                   if ((strLine.length() >= 2)&&(strLine.substring(0, 2).equals("DI")))
                   {          
                        if (strLine.length() >= 6)
                            vm.getVA().getZodis(duomSk).setTurinys(vertejas.papildyti(strLine.substring(2, 6), 4, 0));                                                                                        
                        else
                            vm.getVA().getZodis(duomSk).setTurinys(vertejas.papildyti(strLine.substring(2), 4, 0));                                            
                        duomSk++;
                   }else{
                        if (strLine.length() >= 4)
                            vm.getVA().getZodis(codeSk).setTurinys(strLine.substring(0, 4));    
                        else
                            vm.getVA().getZodis(codeSk).setTurinys(vertejas.papildyti(strLine.substring(0), 4, 1));
                        codeSk++;
                   }                       
              }
              vm.getVA().getZodis(codeSk).setTurinys("JP"+naujasAdresas);    
              codeSk++;
              kanalas3.uzdarytiFaila(in);
           }
        }
        
    }
    
    public void HA()
    {
        SI = 1;
        klaida = "Programos pabaiga"; //siuo atveju ne klaida, tiesiog naudojamas tas pats kintamasis
    }
    
    public void GET(Converter vertejas)
    {
        int skaitinisAdresas = vertejas.HexToInt(SP);        
        skaitinisAdresas++;
        SP = vertejas.IntToHex(skaitinisAdresas);
        vm.setSP(this.SP);
        vm.getVA().getZodis(skaitinisAdresas).setTurinys(kanalas1.ivesti());
    }
    
    public void PUT(Converter vertejas)
    {
        int skaitinisAdresas = vertejas.HexToInt(SP);        
        kanalas2.isvesti(vm.getVA().getZodis(skaitinisAdresas).getTurinys());        
    }
    
    public void atnaujinti()
    {
        this.SI = 0;
        this.PI = 0;
        this.IOI = 0;
        this.TI = 0;
        this.klaida = "";
    }
}
