#include <stdio.h>
#include <stdlib.h>
#define N 1000

enum bald{taip = 1, ne = 0};

struct butas
{
     char adresas[N];
     unsigned char kambariai;
     int nuoma;
     float elektra;
     enum bald baldai;
};

struct el
{
     struct butas duom;
     struct el *kitas;
     struct el *pries;
};

void
ideti (struct el **virsune, struct butas b)
{
     struct el *elem;
     
     elem = malloc (sizeof(struct el));
     
     if (elem == NULL)
      {
        printf ("Nepavyko isskirti atminties\n");
        exit;
      }
    else
      {
        elem->duom = b;
        
        if (*virsune == NULL)
          {
            elem->kitas = NULL;
            elem->pries = NULL;
            *virsune = elem;
          }
        else
          {
            elem->kitas = *virsune;
            elem->pries = NULL;
            *virsune = elem;
          }
      }
}

void
naujas (struct el **virsune)
{
     struct butas b;
     
     printf ("Iveskite nauja elementa taip: adresas kambariai nuoma elektra baldai\n");
     
     scanf ("%s", b.adresas);
     scanf ("%d", &b.kambariai);
     scanf ("%d", &b.nuoma);
     scanf ("%f", &b.elektra);
     scanf ("%d", &b.baldai);  
       
     struct el *elem;
     
     elem = malloc (sizeof(struct el));
     
     if (elem == NULL)
      {
        printf ("Nepavyko isskirti atminties\n");
        exit;
      }
    else
      {
        elem->duom = b;
        
        if (*virsune == NULL)
          {
            elem->kitas = NULL;
            elem->pries = NULL;
            *virsune = elem;
          }
        else
          {
            elem->kitas = *virsune;
            elem->pries = NULL;
            *virsune = elem;
          }
      }
}

void
spausdinti_steka (struct el *virsune, FILE *rez) 
{
    struct el *darb;
    
    if (virsune == NULL) 
      printf ("Stekas yra tuscias\n");
    else
      {
        darb = virsune;
        
        while (darb != NULL)
          {
            printf ("1");
            fprintf (rez, "%s ", (darb->duom).adresas);
            fprintf (rez, "%d ", (darb->duom).kambariai);
            fprintf (rez, "%d ", (darb->duom).nuoma);
            fprintf (rez, "%.2f ", (darb->duom).elektra);
            switch ((darb->duom).baldai)
              {
                case 1: fprintf (rez, "taip\n"); break;
                case 0: fprintf (rez, "ne\n"); break;
                default: fprintf (rez, "bloga reiksme\n"); break;
              }
            darb = darb->kitas;
          }
          
        printf ("\n");
      }
} 

void
isimti (struct el **virsune)
{
     if (*virsune == NULL) 
       printf ("Stekas yra tuscias\n");
     else
       {
         struct el *elem;
         
         elem = *virsune;
         *virsune = elem->kitas;
         free (elem);
       }
}

void
istrinti_steka (struct el **virsune)
{
     if (virsune == NULL) 
       printf ("Stekas yra tuscias\n");
     else
       {
         struct el *elem;
         
         while (*virsune != NULL)
           {
             elem = *virsune;
             *virsune = elem->kitas;
             free (elem);
           }
       }
}

int
main()
{
     FILE *duom, *rez;
     char d[20], r[20];
     struct el *virsune=NULL;
     int elem_sk=0;
     struct butas b;
     int pasirinkimas;
     
     printf ("Iveskite duomenu failo varda\n");
     scanf ("%s", d);
     
     duom = fopen (d, "r");
     
     if (duom == NULL)
       printf ("Nepavyko atidaryti duomenu failo\n");
     else
       {
         printf ("Iveskite rezultatu railo varda\n");
         scanf ("%s", r);
         
         rez = fopen (r, "w");
         
         if (rez == NULL)
           printf ("Nepavyko atidaryti rezultatu failo\n");
         else
           {
             while (!feof(duom))
               {
                 fscanf (duom, "%s", b.adresas);
                 fscanf (duom, "%d", &b.kambariai);
                 fscanf (duom, "%d", &b.nuoma);
                 fscanf (duom, "%f", &b.elektra);
                 fscanf (duom, "%d", &b.baldai);
                 elem_sk++;
                 ideti (&virsune, b);
                 printf("%d", elem_sk);
               }
           }
       }
     
     if ( (duom == NULL) || (rez == NULL) ) 
       {
         system ("pause");
         return 0;
       }
     
     puts ("Pasirinkite ka norite daryti:");
     puts ("1 - iterpti nauja elementa");
     puts ("2 - pasalinti elementa");
     puts ("3 - atspausdinti sarasa");
     puts ("0 - baigti programa");
     
     scanf("%d", &pasirinkimas);
     
     while (pasirinkimas != 0)
       {
         switch (pasirinkimas)
           {
             case 1: naujas (&virsune); break;
             case 2: isimti (&virsune); break;
             case 3: spausdinti_steka (virsune, rez); printf ("sarasas buvo atspausdintas i faila: %s\n", r); break;
             case 0: break;
             default: printf ("Ivesta bloga reiksme\n"); break;
           }
           
         puts ("Pasirinkite ka norite daryti:");
         puts ("1 - iterpti nauja elementa");
         puts ("2 - pasalinti elementa");
         puts ("3 - atspausdinti sarasa");
         puts ("0 - baigti programa");
     
         scanf("%d", &pasirinkimas);
       }    
     
     istrinti_steka(&virsune);
     
     system("pause");
}
