
#include <iostream>
#include <cstdlib>
#include <string>
#include <cstring>

using namespace std;

// --- Klases ------------------------------------------------------------------
class Elementas {
   public:
      char  vardas[50];
      char  pavarde[50];
      int   lsp_nr;
      
      Elementas   *kaire;
      Elementas   *desine;
   
      Elementas (const char* vard, const char* pav, int lsp) {
         strcpy (vardas, vard);
         strcpy (pavarde, pav);
         lsp_nr  = lsp;      
         kaire   = NULL;
         desine  = NULL;
      }
};

class Medis {
   public:
      Elementas *virsune;
   
   Medis () {
      virsune = NULL;
   }
   void pridetiElementa (Elementas *&pozicija, const char* vard, const char* pav, int lsp);
};

// --- F-jos -------------------------------------------------------------------
void Medis::pridetiElementa (Elementas *&pozicija, const char* vard, const char* pav, int lsp) {
   if ( pozicija == NULL ) {
      pozicija = new Elementas(vard, pav, lsp);
      return;
   } else if ( lsp < pozicija->lsp_nr ) {
      pridetiElementa( pozicija->kaire, vard, pav, lsp);
   } else {
      pridetiElementa( pozicija->desine, vard, pav, lsp);
   }
}

void spausdinti(Elementas *&pozicija, int lsp, Elementas *&virsune)
{
	if ( pozicija != NULL ) //rekursyvi f-ja, todel tikriname, ar nera pabaiga
	{
		if ( lsp == pozicija->lsp_nr ) //jeigu lsp nr lygus - isvedame i ekrana
		{
			cout << "in-order" << endl;
			if (virsune->kaire != NULL)
			cout << (virsune->kaire)->vardas << " " << (virsune->kaire)->pavarde << " " << (virsune->kaire)->lsp_nr << endl;
			cout << virsune->vardas << " " << virsune->pavarde << " " << virsune->lsp_nr << endl;
			if (virsune->desine != NULL)
			cout << (virsune->desine)->vardas << " " << (virsune->desine)->pavarde << " " << (virsune->desine)->lsp_nr << endl;
			
			cout << "in-order" << endl;
			if (pozicija->kaire != NULL)
			cout << (pozicija->kaire)->vardas << " " << (pozicija->kaire)->pavarde << " " << (pozicija->kaire)->lsp_nr << endl;
			cout << pozicija->vardas << " " << pozicija->pavarde << " " << pozicija->lsp_nr << endl;
			if (pozicija->desine != NULL)
			cout << (pozicija->desine)->vardas << " " << (pozicija->desine)->pavarde << " " << (pozicija->desine)->lsp_nr << endl;
			
		}
		if ( lsp < pozicija->lsp_nr ) spausdinti(pozicija->kaire, lsp, virsune); //jeigu ne, tikriname pagal i lsp nr i kuria saka eiti
		else spausdinti(pozicija->desine, lsp, virsune);
	}

}

void print(Elementas *&pozicija) //f-ja skirta apeiti visam medziui nuo virsunes iki pat lapu
{
	 
	if (pozicija != NULL ) //rekursyvi f-ja, todel tikriname, ar nera pabaiga
	{

		spausdinti(pozicija->kaire, pozicija->lsp_nr, pozicija); //imame virsune ir siunciame jos kaire saka i f-ja bei lsp nr pagal kuri ieskome
		spausdinti(pozicija->desine, pozicija->lsp_nr, pozicija); //analogiskai su desine
		print(pozicija->kaire); //einame i kaires sakos virsune
		print(pozicija->desine); //analogiskai i desines
		
	}
}
// --- MAIN --------------------------------------------------------------------
int main () {
   Medis* medis_1 = new Medis();  
   
   medis_1->pridetiElementa (medis_1->virsune, "Tadas",     "Blinda",      50123);
   medis_1->pridetiElementa (medis_1->virsune, "Maryte",    "Melninkaite", 70576);
   medis_1->pridetiElementa (medis_1->virsune, "Tadeusas",  "Blinda",      11153);
   medis_1->pridetiElementa (medis_1->virsune, "Jeronimas", "Tucka",       60435);
   medis_1->pridetiElementa (medis_1->virsune, "Motiejus",  "Blinda",      60435);
   medis_1->pridetiElementa (medis_1->virsune, "Juozapas",  "Blinda",      31486);
   medis_1->pridetiElementa (medis_1->virsune, "Bernardas", "Gruinius",    50123);
   print(medis_1->virsune);
   return 0;  
}
