unit ADT_LongInt;

Interface
	type IlgasSkaicius = ^IlgSk;
		 IlgSk = record
			          skaicius :integer;
					  buves, sekantis :IlgasSkaicius;
					end;
					
	procedure SukuriamSkaiciu (var a :IlgasSkaicius; const s :string; var err :integer);
		//skaiciu eilute pavercia i ilga sveika skaiciu
		//negiami skaiciai prasideda minuso zenklu ("-")
		//err: 1 - nekorektiska skaiciu eilute, ("+", ar kitu spec simboliu rasyti negalima)
	
	procedure SukuriamStringa (const a :IlgasSkaicius; var s :string; var err :integer);
		//ilga sveika skaiciu pavercia skaiciu eilute
		//err: 1 - skaitmuo per ilgas (>255)
	
	function Palyginimas (const a, b :IlgasSkaicius) :integer;
		//palygina skaicius
			// 1 - (a > b)
			// 0 - (a = b)
			//-1 - (a < b)
		
	procedure Modulis (var a :IlgasSkaicius);
		//skaiciu vercia teigiamu (modulis)
		
	procedure Kopijuoti (const a :IlgasSkaicius; var b :IlgasSkaicius);
		//perkopijuoja skaii a  skaiiu b (a->b)
		
	procedure SunaikintiSk (var a :IlgasSkaicius);
		//sunaikina skaiciu, isvalo atminti
	
	function Sudetys (const a, b :IlgasSkaicius) :IlgasSkaicius;
		//dvieju skaiciu suma (a + b)
		
	function Atimtis (const a, b :IlgasSkaicius) :IlgasSkaicius;
		//dvieju skaiciu atimtis (a - b)
		
	function Daugyba (const a, b :IlgasSkaicius) :IlgasSkaicius;
		//dvieju skaiciu daugyba (a * b)
		
	procedure Dalyba (const a, b :IlgasSkaicius; var dalmuo, liekana :IlgasSkaicius; var err :integer);
		//dvieju skaiciu dalyba (a div b = dalmuo ir a mod b = liekana); dalmuo - dalmuo; liekana - liekana
		//err: 1 - dalyba is 0
		
//==========================================================Koreagavime prireike

    procedure ApkeistiOp (var a, b :IlgasSkaicius);

//==============================================================================
			
Implementation
  type Numbers = set of '0'..'9';
  const max = 255;

  //i rodykls  string'
  procedure SukuriamSkaiciu(var a :IlgasSkaicius; const s :string; var err :integer);
	var Laik :IlgasSkaicius;
		i, si, n, start_at :integer;
		Sign :boolean;
		sLaik :string;
  begin
    sLaik := s;
	n := length(sLaik);
	err := 0;
	Laik := NIL;
	Sign := FALSE;

	//zenklo nustatymas
	if sLaik[1] = '-' then
	begin
      start_at := 2;                     //jei skaicius su zenklu - pradeti pozicija 2
	  Sign := TRUE;                      // sign true - sk. su zenklu
	  if n = 1 then err := 1;
	end
	else start_at := 1;
		
	//nuliu nuemimas nuo skaiciu eilutes priekio
	i := start_at;
	while ((sLaik[i] = '0') and (i < n)) do
	begin
	  if sLaik[i] = '0' then start_at := start_at + 1;  //kiek yra pradzioje nuliu per tiek pasislinks pradejimo taskas
	  i := i + 1;
	end;
		
	for i := start_at to n do
	begin
	  if not (sLaik[i] in Numbers) then     //jei skaiciuje yra bent vienas spec. zenklas
  	  begin
		err := 1;
		a := NIL;
		//i := n;
		break;
	  end
	  else
  	  begin
		new(a);
		val(sLaik[i],si);
		a^.skaicius := si;

		if i = start_at then
		begin
		  a^.buves := NIL;
		  a^.sekantis := NIL;
		  if Sign then a^.skaicius := a^.skaicius * -1;     //jei sign true - pirmas skaitmuo paverciamas neigiamu
		  Laik := a;
		end
		else
        begin
		  a^.buves := Laik;
	   	  a^.sekantis := NIL;
		  Laik^.sekantis := a;
		  Laik := a;
	    end;
	  end;
	end;
  end;


  //i rodykls  string'
  procedure SukuriamStringa(const a :IlgasSkaicius; var s :string; var err :integer);
	var si :string;
		sk :integer;
		aLaik :IlgasSkaicius;
  begin
	aLaik := a;
	sk := 0;
	err := 0;
	s := '';
		
	if aLaik <> NIL then while aLaik^.buves <> NIL do aLaik := aLaik^.buves; //atsukama rodykle i pradzia
		
	while aLaik <> NIL do
	begin
	  sk := sk + 1;
	  if sk > max then         //jei skaicius didesnis uz max (255 - stringo maximalus ilgis)
	  begin
		aLaik := NIL;
		s := '';
		err := 1;
		break;
	  end
	  else
	  begin
		if aLaik^.skaicius < 0 then sk := sk + 1;   //jei skaicius neigiamas(pirmas), skiriamos 2 stringo pozicijos
		Str(aLaik^.skaicius,si);                    //is integerio i stringa
		s := s + si;                             //formuojamas stringas
	  end;
	  aLaik := aLaik^.sekantis;
	end;
  end;
	
  // nukopijuoja skaii   (visose procedurose ir funkcijose dirbama ne su ivestais skaiciais o ju kopijomis)
  procedure Kopijuoti (const a :IlgasSkaicius; var b :IlgasSkaicius);
	var aLaik, bLaik :IlgasSkaicius;
  begin
	aLaik := a;
    if aLaik <> NIL then
	begin
	  new(b);
	  b^.buves := NIL;
	  b^.sekantis := NIL;
	  while aLaik^.buves <> NIL do aLaik := aLaik^.buves;
	  while aLaik^.sekantis <> NIL do
  	  begin
		b^.skaicius := aLaik^.skaicius;
		aLaik := aLaik^.sekantis;
		new(bLaik);
		bLaik^.sekantis := NIL;
		bLaik^.buves := b;
		b^.sekantis := bLaik;
		b := b^.sekantis;
	  end;
	  b^.skaicius := aLaik^.skaicius;
	end;
  end;


  // sukeisti operandus vietomis
  procedure ApkeistiOp (var a, b :IlgasSkaicius);
	var c :IlgasSkaicius;
  begin
	c := b;
	b := a;
	a := c;
  end;
	
  //skaiciaus modulis
  procedure Modulis (var a :IlgasSkaicius);
  begin
	if a <> NIL then
	begin
	  while a^.buves <> NIL do a := a^.buves;           //nukeliauja i rod pradzia
	  if a^.skaicius < 0 then a^.skaicius := a^.skaicius * -1;  //tikrina ar neigiamas
	  while a^.sekantis <> NIL do a := a^.sekantis;               //grizta i rod pabaiga
	end;
  end;

  // panaikinti nulius
  procedure PasalintiNulius (var a :IlgasSkaicius);
	var Laik :IlgasSkaicius;
  begin
	if a <> NIL then
	begin
	  while a^.buves <> NIL do a := a^.buves;        //nukeliauja i pradzia
			
	  while ((a^.sekantis <> NIL) and (a^.skaicius = 0)) do   //tikrina po viena sk ar ne 0
	  begin
	    Laik := a;
	    a := a^.sekantis;
	    a^.buves := NIL;
	    Dispose(Laik);                                   //jei 0, ji disposina
	  end;
			
	  while a^.sekantis <> NIL do a := a^.sekantis;            //grizta atgal
	end;
  end;
	
  // sunaikina rodykle
  procedure SunaikintiSk (var a :IlgasSkaicius);
	var Laik :IlgasSkaicius;
  begin
	if a <> NIL then
	begin
	  while a^.sekantis <> NIL do a := a^.sekantis;
	  while a <> NIL do
	  begin
	    Laik := a;
	    a := a^.buves;
	    Dispose(Laik);
	  end;
	end;
  end;
	
  //palygina skaiius
  function Palyginimas (const a, b :IlgasSkaicius) :integer;
	var aLaik, bLaik :IlgasSkaicius;
		T, Sign :boolean;
		err, nr1, nr2 :integer;
  begin
	Kopijuoti (a, aLaik);
	Kopijuoti (b, bLaik);
		
	Sign := FALSE;
	T := FALSE;
	Palyginimas := 0;
		
	if aLaik = NIL then SukuriamSkaiciu(aLaik,'0',err);
	if bLaik = NIL then SukuriamSkaiciu(bLaik,'0',err);
		
	while aLaik^.buves <> NIL do aLaik := aLaik^.buves;
	while bLaik^.buves <> NIL do bLaik := bLaik^.buves;
	nr1 := aLaik^.skaicius;                        // isaugomos pirm skaitmen reikms
	nr2 := bLaik^.skaicius;
		
	if ((aLaik^.skaicius < 0) and (bLaik^.skaicius < 0)) then Sign := TRUE;  //zenklai neigiami
		
	if ((aLaik^.skaicius >= 0) and (bLaik^.skaicius < 0)) then    //pirmas skaiius didesnis uz antra
	begin
	  T := TRUE;
	  Palyginimas := 1;
	end;

    if ((aLaik^.skaicius < 0) and (bLaik^.skaicius >= 0)) then    //antras skaiius didesnis uz pirma
    begin
      T := TRUE;
      Palyginimas := -1;
    end;
		
    Modulis(aLaik);
    Modulis(bLaik);
		
    if ((aLaik <> NIL) and (bLaik <> NIL) and not T) then
    begin
      while ((aLaik^.buves <> NIL) and (bLaik^.buves <> NIL) and not T) do
      begin
		aLaik := aLaik^.buves;
		bLaik := bLaik^.buves;
				
		if ((aLaik^.buves = NIL) and (bLaik^.buves <> NIL)) then    // pirmas trumpesnis
		begin
		  T := TRUE;
		    Palyginimas := -1;
		end;
				
		if ((bLaik^.buves = NIL) and (aLaik^.buves <> NIL)) then   // antras trumpesnis
		begin
	  	  T := TRUE;
		  Palyginimas := 1
		end;
      end;
			
      //jei a vienzenklis
      if ((aLaik^.buves = NIL) and (aLaik^.sekantis = NIL) and (bLaik^.buves <> NIL)) then
      begin
        T := TRUE;
        Palyginimas := -1;
      end;

      //jei b vienzenklis
      if ((bLaik^.buves = NIL) and (bLaik^.sekantis = NIL) and (aLaik^.buves <> NIL)) then
      begin
	    T := TRUE;
        Palyginimas := 1;
      end;
			
      while aLaik^.buves <> NIL do aLaik := aLaik^.buves;
	  while bLaik^.buves <> NIL do bLaik := bLaik^.buves;

	  //jei skaiciu ilgiai lygus
	  if not T then
	  begin
	    while ((aLaik^.sekantis <> NIL) and (bLaik^.sekantis <> NIL) and not T) do
  	    begin
		  if aLaik^.skaicius < bLaik^.skaicius then      //antras didesnis
		  begin
		    T := TRUE;
		    Palyginimas := -1;
		  end;
					
		  if aLaik^.skaicius > bLaik^.skaicius then       //pirmas didesnis
		  begin
		    T := TRUE;
		    Palyginimas := 1;
		  end;
					
		  aLaik := aLaik^.sekantis;
		  bLaik := bLaik^.sekantis;
	    end;
				
	    if ((aLaik^.sekantis = NIL) and (bLaik^.sekantis = NIL) and not T) then    //ilgiai lygus, tikrinami paskutiniai skaitmenys
	    if aLaik^.skaicius < bLaik^.skaicius then
	    begin
		  T := TRUE;
	      Palyginimas := -1;
	    end
	    else if aLaik^.skaicius > bLaik^.skaicius then
		     begin
			   T := TRUE;
			   Palyginimas := 1;
		     end;
  	  end;
    end;
    while aLaik^.buves <> NIL do aLaik := aLaik^.buves;
    while bLaik^.buves <> NIL do bLaik := bLaik^.buves;
    aLaik^.skaicius := nr1;
    bLaik^.skaicius := nr2;
    if Sign then Palyginimas := Palyginimas * -1;     //jei buvo neigiami
		
    while aLaik^.buves <> NIL do aLaik := aLaik^.buves;
    while bLaik^.buves <> NIL do bLaik := bLaik^.buves;
  end;





	
//===========================================================Sudeties algoritmas

    function SudetiesAlg(const a,b:IlgasSkaicius):IlgasSkaicius;
	var
        aLaik, bLaik, Laik1, Laik2:IlgasSkaicius;
		mintis, err:integer;
    begin
  
        Kopijuoti(a,aLaik);
        Kopijuoti(b,bLaik);
		
        if aLaik=nil then SukuriamSkaiciu(aLaik,'0',err);
        if bLaik=nil then SukuriamSkaiciu(bLaik,'0',err);
		
        mintis:=0;
        new(Laik1);
        Laik1^.sekantis:=nil;
        Laik1^.buves:=nil;
    
        while(bLaik^.buves<>nil) do
        begin
            Laik1^.skaicius:=aLaik^.skaicius+bLaik^.skaicius+mintis;
        
            if Laik1^.skaicius>9 then
            begin
                Laik1^.skaicius:=Laik1^.skaicius-10;
                mintis:=1;
            end
            else
            begin
                mintis:=0;
            end;
        
            aLaik:=aLaik^.buves;
            bLaik:=bLaik^.buves;
            new(Laik2);
            Laik2^.sekantis:=Laik1;
            Laik2^.buves:=nil;
            Laik1^.buves:=Laik2;
            Laik1:=Laik1^.buves;
        end;
	
        Laik1^.skaicius:=aLaik^.skaicius+bLaik^.skaicius+mintis;
        mintis:=0;
	
        if Laik1^.skaicius>9 then
        begin
            Laik1^.skaicius:=Laik1^.skaicius-10;
            mintis:=1;
        end;
	
        if (aLaik^.buves=nil) then
        begin
            new(bLaik);
            bLaik^.skaicius:=mintis;
            bLaik^.sekantis:=Laik1;
            bLaik^.buves:=nil;
            Laik1^.buves:=bLaik;
            Laik1:=Laik1^.buves;
        end
        else
        begin
            if aLaik^.buves<>nil then
            begin
                aLaik:=aLaik^.buves;
                new(Laik2);
                Laik2^.sekantis:=Laik1;
                Laik2^.buves:=nil;
                Laik1^.buves:=Laik2;
                Laik1:=Laik1^.buves;
            
                while aLaik^.buves<>nil do
                begin
                    Laik1^.skaicius:=aLaik^.skaicius+mintis;
                
                    if Laik1^.skaicius>9 then
                    begin
                        Laik1^.skaicius:=Laik1^.skaicius-10;
                        mintis:=1;
                    end
                    else
                    begin
                        mintis:=0;
                    end;
                
                    aLaik:=aLaik^.buves;
                    new(Laik2);
                    Laik2^.sekantis:=Laik1;
                    Laik2^.buves:=nil;
                    Laik1^.buves:=Laik2;
                    Laik1:=Laik1^.buves;
                end;

                Laik1^.skaicius:=aLaik^.skaicius+mintis;
                mintis:=0;
            
                if Laik1^.skaicius>9 then
                begin
                    Laik1^.skaicius:=Laik1^.skaicius-10;
                    mintis:=1;
                end;

                if ((aLaik^.buves=nil) and (mintis=1)) then
                begin
                    new (bLaik);
                    bLaik^.skaicius:=mintis;
                    bLaik^.sekantis:=Laik1;
                    bLaik^.buves:=nil;
                    Laik1^.buves:=bLaik;
                    Laik1:=Laik1^.buves;
                end;
            end;
        end;
        
        SudetiesAlg:=Laik1;
    end;
//==============================================================================
  
  
  

  // atimties algoritmas
  function AtimtiesAlg (const a, b :IlgasSkaicius) :IlgasSkaicius;
	var aLaik, bLaik, Laik1, Laik2 :IlgasSkaicius;
		mintis, err :integer;
  begin
  	Kopijuoti (a, aLaik);
	Kopijuoti (b, bLaik);
		
	if aLaik = NIL then SukuriamSkaiciu(aLaik,'0',err);
	if bLaik = NIL then SukuriamSkaiciu(bLaik,'0',err);
		
	mintis := 0;
    new(Laik1);
    Laik1^.sekantis := NIL;
    Laik1^.buves :=NIL;
	while (bLaik^.buves <> NIL)  do
	begin
	  Laik1^.skaicius := aLaik^.skaicius - bLaik^.skaicius - mintis;
	  if Laik1^.skaicius < 0 then             //jei atimdami gaunam maziau uz 0
	  begin
	    Laik1^.skaicius := Laik1^.skaicius + 10;
		mintis := 1;
	  end
	  else mintis := 0;
	  aLaik := aLaik^.buves;
	  bLaik := bLaik^.buves;
	  new(Laik2);
      Laik2^.sekantis := Laik1;
      Laik2^.buves := NIL;
      Laik1^.buves := Laik2;
	  Laik1 := Laik1^.buves;
	end;

	Laik1^.skaicius := aLaik^.skaicius - bLaik^.skaicius - mintis;
	mintis := 0;

	if Laik1^.skaicius < 0 then
	begin
	  Laik1^.skaicius := Laik1^.skaicius + 10;
      mintis := 1;
	end;

	if (aLaik^.buves = NIL) and (mintis = 1) then      //jei pirmas skaicius baigiasi, bet dar yra mintis
	begin
	  new(bLaik);
	  bLaik^.skaicius := mintis;
	  bLaik^.sekantis := Laik1;
	  bLaik^.buves := NIL;
	  Laik1^.buves := bLaik;
	  Laik1 := Laik1^.buves;
	end
	else if aLaik^.buves <> NIL then        // jei pirmas skaicius dar nesibaige
	    begin
		  aLaik := aLaik^.buves;
		  new(Laik2);
          Laik2^.sekantis := Laik1;
          Laik2^.buves := NIL;
          Laik1^.buves := Laik2;
	      Laik1 := Laik1^.buves;
		  while aLaik^.buves <> NIL do
	      begin
			Laik1^.skaicius := aLaik^.skaicius - mintis;
			if Laik1^.skaicius < 0 then
			begin
			  Laik1^.skaicius := Laik1^.skaicius + 10;
			  mintis := 1;
			end
			else mintis := 0;
			aLaik := aLaik^.buves;
		    new(Laik2);
            Laik2^.sekantis := Laik1;
            Laik2^.buves := NIL;
            Laik1^.buves := Laik2;
            Laik1 := Laik1^.buves;
		  end;

		  Laik1^.skaicius := aLaik^.skaicius - mintis;
		  mintis := 0;
		  if Laik1^.skaicius < 0 then
		  begin
			Laik1^.skaicius := Laik1^.skaicius + 10;
			mintis := 1;
          end;
		  if (a^.buves = NIL) and  (mintis = 1) then     //jei ivyksta perpildymas(mintis = 1)
		  begin
		    new (bLaik);
			bLaik^.skaicius := mintis;
			bLaik^.sekantis := Laik1;
			bLaik^.buves := NIL;
			Laik1^.buves := bLaik;
			Laik1 := Laik1^.buves;
		  end;
		end;
      AtimtiesAlg := Laik1;
	end;
	
  // dalybos algoritmas
  procedure DalybosAlg (const a, b :IlgasSkaicius; var c, d :IlgasSkaicius; var err :integer);
	var vienetukas, aLaik, bLaik :IlgasSkaicius;
		T :boolean;
		i :integer;
  begin
	Kopijuoti (a, aLaik);
	Kopijuoti (b, bLaik);
		
	SukuriamSkaiciu(c,'0',err);
	SukuriamSkaiciu(d,'0',err);
	if aLaik = NIL then SukuriamSkaiciu(aLaik,'0',err);
	if bLaik = NIL then SukuriamSkaiciu(bLaik,'0',err);
		
	PasalintiNulius(aLaik);
	PasalintiNulius(bLaik);
	Modulis(aLaik);
	Modulis(bLaik);
		
	i := Palyginimas(aLaik,bLaik);
	if ((i = 1) or (i = 0)) then T := TRUE
    else T := FALSE;       //mazesnis sk.

    if ((bLaik^.buves = NIL) and (bLaik^.sekantis = NIL) and (bLaik^.skaicius = 0)) then  //dalyba is 0
    begin
      c := NIL;
      d := NIL;
      err := 1;
    end
	else if ((aLaik^.buves = NIL) and (aLaik^.sekantis = NIL) and (aLaik^.skaicius = 0)) then  //pirmas sk. 0
        begin
          SukuriamSkaiciu(c,'0',err);
	      SukuriamSkaiciu(d,'0',err);
	    end
	    else
	    begin
	      while T do    //kol pirmas didesnis
	      begin
		    aLaik := AtimtiesAlg(aLaik,bLaik);
		    SukuriamSkaiciu(vienetukas,'1',err);
		    c := SudetiesAlg(c,vienetukas);         //c kiek kartu ivyko ciklas
		    PasalintiNulius(aLaik);
		    PasalintiNulius(c);
            i := Palyginimas(aLaik,bLaik);
		    if ((i = 1) or (i = 0)) then T := TRUE
		    else T := FALSE;
		  end;
	  	  while aLaik^.sekantis <> NIL do aLaik := aLaik^.sekantis;
          d^.skaicius := aLaik^.skaicius;
          while aLaik^.buves <> NIL do        //aLaik  d
	      begin
            aLaik :=aLaik^.buves;
            new(bLaik);
            bLaik^.buves := NIL;
            bLaik^.sekantis := d;
            d^.buves := bLaik;
            d := d^.buves;
            d^.skaicius := aLaik^.skaicius;
		  end;

		end;
      PasalintiNulius(d);
      PasalintiNulius(c);

      if c <> NIL then while c^.sekantis <> NIL do c := c^.sekantis;
      if d <> NIL then while d^.sekantis <> NIL do d := d^.sekantis;
	end;

//===============================================================Pridedam nulius
	procedure PridedamNulius(var a, n:IlgasSkaicius);
	var
        Laik, vienetukas, n2:IlgasSkaicius;
		err:integer;
	begin
		SukuriamSkaiciu(n2,'0',err);
		
		if ((a<>nil) and (n<>nil)) then
		begin
//Pasiruosimas
			while a^.sekantis<>nil do
            begin
                a:=a^.sekantis;
            end;
            
//Algoritmas pridedantis nulius
			while ((n^.buves<>nil) or (n^.skaicius>0)) do
			begin
				SukuriamSkaiciu(vienetukas,'1',err);
				n:=AtimtiesAlg(n,vienetukas);
				PasalintiNulius(n);

				SukuriamSkaiciu(vienetukas,'1',err);
				n2:=SudetiesAlg(n2,vienetukas);
				PasalintiNulius(n2);
				
				new(Laik);
				Laik^.skaicius:=0;
				Laik^.sekantis:=nil;
				Laik^.buves:=a;
				a^.sekantis:=Laik;
				a:=Laik;
			end;
			
			n:=n2;
		end;
	end;
//==============================================================================
	



//==========================================================Sudeties iskvietimas
	function Sudetys(const a, b:IlgasSkaicius):IlgasSkaicius;
	var
        aLaik, bLaik:IlgasSkaicius;
		Dydis, err:integer;
		Sign, Z1, Z2:boolean;
	begin
//Skaiciu tvarkymas, paruosimas skaiciavimams

		Kopijuoti(a,aLaik);
		Kopijuoti(b,bLaik);
		
		if aLaik=nil then SukuriamSkaiciu(aLaik,'0',err);
		if bLaik=nil then SukuriamSkaiciu(bLaik,'0',err);
		
		Z1:=false;
		Z2:=false;

		while aLaik^.buves<>nil do
        begin
            aLaik:=aLaik^.buves;
        end;

        while bLaik^.buves<>nil do
        begin
            bLaik:=bLaik^.buves;
		end;
		
		if aLaik^.skaicius<0 then Z1:=true;
		if bLaik^.skaicius<0 then Z2:=true;

		while aLaik^.sekantis<>nil do aLaik:=aLaik^.sekantis;
		while bLaik^.sekantis<>nil do bLaik:=bLaik^.sekantis;


		Modulis(aLaik);
		Modulis(bLaik);
		PasalintiNulius(aLaik);
		PasalintiNulius(bLaik);
		
		while aLaik^.sekantis<>nil do
        begin
            aLaik:=aLaik^.sekantis;
        end;
        
		while bLaik^.sekantis<>nil do
        begin
            bLaik:=bLaik^.sekantis;
		end;
		
		Dydis:=Palyginimas(aLaik,bLaik);

//Pradedam algoritmu iskvietimus
//==================================================================Abu neigiami
		if (not Z1 and not Z2) then
		begin
			Sign:=false;
			
			if Palyginimas(aLaik,bLaik)=(-1) then
            begin
                ApkeistiOp(aLaik,bLaik);
            end;
            
            Sudetys:=SudetiesAlg(aLaik,bLaik);
		end;
//==================================================================Abu teigiami
		if (Z1 and Z2) then
		begin
			Sign:=true;
			
			if Palyginimas(aLaik,bLaik)=(-1) then
            begin
                ApkeistiOp(aLaik,bLaik);
            end;
            
            Sudetys:=SudetiesAlg(aLaik,bLaik);
		end;
//===============================a neigiamas(Abu vienodo ilgio, arba a ilgesnis)
		if (not Z1 and Z2 and ((Dydis=0) or (Dydis=1))) then
		begin
			Sign:=false;
			
			if Palyginimas(aLaik,bLaik)=(-1) then
            begin
                ApkeistiOp(aLaik, bLaik);
            end;

            Sudetys:=AtimtiesAlg(aLaik,bLaik);
		end;
//=======================================================a neigiamas(b ilgesnis)
		if (not Z1 and Z2 and (Dydis=(-1))) then
		begin
			Sign:=true;
			
			if Palyginimas(aLaik,bLaik)=(-1) then
            begin
                ApkeistiOp(aLaik,bLaik);
            end;

            Sudetys:=AtimtiesAlg(aLaik,bLaik);
		end;
//===============================b neigiamas(Abu vienodo ilgio, arba a ilgesnis)
		if (Z1 and not Z2 and ((Dydis=0) or (Dydis=1))) then
		begin
			Sign:=true;
			
			if Palyginimas(aLaik,bLaik)=(-1) then
            begin
                ApkeistiOp(aLaik,bLaik);
            end;
            
            Sudetys:=AtimtiesAlg(aLaik,bLaik);
		end;
//=======================================================b neigiamas(b ilgesnis)
		if (Z1 and not Z2 and (Dydis=(-1))) then
		begin
			Sign:=false;
			
			if Palyginimas(aLaik,bLaik)=(-1) then
            begin
                ApkeistiOp(aLaik,bLaik);
            end;
            
			Sudetys:=AtimtiesAlg(aLaik,bLaik);
		end;
		
		PasalintiNulius(Sudetys);
		if Sign then
		begin
			while Sudetys^.buves<>nil do
            begin
                Sudetys:=Sudetys^.buves;
            end;
            
            Sudetys^.skaicius:=Sudetys^.skaicius*(-1);
		end;
		
		while Sudetys^.sekantis<>nil do
        begin
            Sudetys:=Sudetys^.sekantis;
        end;
	end;
//==============================================================================



	
  // atimtis
  function Atimtis (const a, b :IlgasSkaicius) :IlgasSkaicius;
	var aLaik, bLaik :IlgasSkaicius;
		Dydis, err :integer;
		Sign, Z1, Z2 :boolean;
  begin
	Kopijuoti (a, aLaik);
	Kopijuoti (b, bLaik);
		
	if aLaik = NIL then SukuriamSkaiciu(aLaik,'0',err);
	if bLaik = NIL then SukuriamSkaiciu(bLaik,'0',err);
		
	Z1 := FALSE;
	Z2 := FALSE;
		
	while aLaik^.buves <> NIL do aLaik := aLaik^.buves;
	while bLaik^.buves <> NIL do bLaik := bLaik^.buves;
		
	if aLaik^.skaicius < 0 then Z1 := TRUE;
	if bLaik^.skaicius < 0 then Z2 := TRUE;
	
 	while aLaik^.sekantis <> NIL do aLaik := aLaik^.sekantis;
	while bLaik^.sekantis <> NIL do bLaik := bLaik^.sekantis;


	Modulis(aLaik);
	Modulis(bLaik);
	PasalintiNulius(aLaik);
	PasalintiNulius(bLaik);

	while aLaik^.sekantis <> NIL do aLaik := aLaik^.sekantis;
	while bLaik^.sekantis <> NIL do bLaik := bLaik^.sekantis;
	Dydis := Palyginimas(aLaik, bLaik);
		
	if (not Z1 and not Z2 and ((Dydis = 0) or (Dydis = 1))) then   //abu teigiami, pirmas didesnis arba lygs
	begin
	  Sign := FALSE;
	  if Palyginimas(aLaik, bLaik) = -1 then ApkeistiOp(aLaik, bLaik);
	  Atimtis := AtimtiesAlg(aLaik,bLaik);
	end;

	if (not Z1 and not Z2 and (Dydis = -1)) then     //abu teigiami, antras didesnis
	begin
	  Sign := TRUE;
	  if Palyginimas(aLaik, bLaik) = -1 then ApkeistiOp(aLaik, bLaik);
	  Atimtis := AtimtiesAlg(aLaik,bLaik);
	end;

	if (Z1 and Z2 and ((Dydis = 0) or (Dydis = 1))) then    //abu neigiami pirmas didesnis, arba lygs
	begin
	  Sign := TRUE;
	  if Palyginimas(aLaik, bLaik) = -1 then ApkeistiOp(aLaik, bLaik);
	  Atimtis := AtimtiesAlg(aLaik,bLaik);
	end;

	if (Z1 and Z2 and (Dydis = -1)) then      //abu neigiami, antras didesnis
	begin
	  Sign := FALSE;
	  if Palyginimas(aLaik, bLaik) = -1 then ApkeistiOp(aLaik, bLaik);
	  Atimtis := AtimtiesAlg(aLaik,bLaik);
	end;

	if (not Z1 and Z2) then      // pirmas +, antras -
	begin
      Sign := FALSE;
	  if Palyginimas(aLaik, bLaik) = -1 then ApkeistiOp(aLaik, bLaik);
	  Atimtis := SudetiesAlg(aLaik,bLaik);
	end;

	if (Z1 and not Z2) then     // pirmas -, antras +
	begin
	  Sign := TRUE;
	  if Palyginimas(aLaik, bLaik) = -1 then ApkeistiOp(aLaik, bLaik);
	  Atimtis := SudetiesAlg(aLaik,bLaik);
	end;
		
	PasalintiNulius(Atimtis);
		
	if Sign then         //uzdeda zenkla jei neigiamas
	begin
	  while Atimtis^.buves <> NIL do Atimtis := Atimtis^.buves;
	  Atimtis^.skaicius := Atimtis^.skaicius * -1;
	end;
		
	while Atimtis^.sekantis <> NIL do Atimtis := Atimtis^.sekantis;
  end;




//===========================================================Daugybos algoritmas

    function Daugyba(const a, b:IlgasSkaicius):IlgasSkaicius;
	var
        Laik1, Laik2, aLaik, bLaik:IlgasSkaicius;
        Uodega, vienetukas, bb:IlgasSkaicius;
        First, Zenklas, Z1, Z2, Keiciam:boolean;
        mintis, n, err, i:integer;
	begin

//Paruosimas
        Keiciam:=false;
        bb:=b;
        
        while bb^.buves<>nil do bb:=bb^.buves;
        if bb^.skaicius<0 then
        begin
       	    Kopijuoti (b,aLaik);
            Kopijuoti (a,bLaik);
            Keiciam:=true;
		end else
		begin
            Kopijuoti(a,aLaik);
            Kopijuoti(b,bLaik);
        end;
        
		if aLaik=nil then SukuriamSkaiciu(aLaik,'0',err);
		if bLaik=nil then SukuriamSkaiciu(bLaik,'0',err);
		
		Z1:=false;
		Z2:=false;
		mintis:=0;
		First:=true;

		Laik1:=nil;
		Laik2:=nil;
		
		while aLaik^.buves<>nil do aLaik:=aLaik^.buves;
		while bLaik^.buves<>nil do bLaik := bLaik^.buves;

		
		if aLaik^.skaicius<0 then Z1:=true;
		if bLaik^.skaicius<0 then Z2:=true;
		
		while aLaik^.sekantis<>nil do aLaik:=aLaik^.sekantis;
		while bLaik^.sekantis<>nil do bLaik:=bLaik^.sekantis;
		
		PasalintiNulius(aLaik);
		PasalintiNulius(bLaik);
		Modulis(aLaik);
		Modulis(bLaik);
		
		if (not Z1 and not Z2) or (Z1 and Z2) then Zenklas:=false;
		if (not Z1 and Z2) or (Z1 and not Z2) then Zenklas:=true;

		SukuriamSkaiciu(Uodega,'0',err);
		SukuriamSkaiciu(Daugyba,'0',err);

//Skaiciavimai
		
		while aLaik<>nil do
		begin
			while bLaik<>nil do
			begin
				n:=aLaik^.skaicius*bLaik^.skaicius+mintis;
				mintis:=0;
				if n>9 then
				begin
					mintis:=n div 10;
					n:=n mod 10;
				end;

				if Laik1=nil then
				begin
					new(Laik1);
					Laik1^.skaicius:=n;
					Laik1^.sekantis:=nil;
					Laik1^.buves:=nil;
				end
				else
				begin
					new(Laik1);
					Laik1^.skaicius:=n;
					Laik1^.sekantis:=Laik2;
					Laik1^.buves:=nil;
					Laik2^.buves:=Laik1;
				end;
				
				Laik2:=Laik1;
				bLaik:=bLaik^.buves;

				if ((bLaik=nil) and (mintis>0)) then
				begin
					while Laik1^.buves<>nil do Laik1:=Laik1^.buves;
					new(Laik2);
					Laik2^.skaicius:=mintis;
					Laik2^.buves:=nil;
					Laik2^.sekantis:=Laik1;
					Laik1^.buves:=Laik2;
					mintis:=0;
				end;
			end;

			if not First then
			begin
				SukuriamSkaiciu(vienetukas,'1',err);
				Uodega:=SudetiesAlg(Uodega,vienetukas);
				PasalintiNulius(Uodega);
				PridedamNulius(Laik1,Uodega);
				Modulis(Daugyba);
				Modulis(Laik1);
				while Daugyba^.sekantis<>nil do Daugyba:=Daugyba^.sekantis;
				i:=Palyginimas(Daugyba,Laik1);
				if i=-1 then ApkeistiOp(Daugyba,Laik1);
				Daugyba:=SudetiesAlg(Daugyba,Laik1);
				PasalintiNulius(Daugyba);
			end
			else
			begin
				First:=false;
				Daugyba:=Laik1;
			end;

			Laik1:=nil;
            if Keiciam then Kopijuoti(a,bLaik) else
			Kopijuoti(b,bLaik);
			aLaik:=aLaik^.buves;
		end;
		
		PasalintiNulius(Daugyba);
		if (Zenklas and (Daugyba<>NIL)) then
		begin
			while Daugyba^.buves<>nil do Daugyba:=Daugyba^.buves;
			Daugyba^.skaicius:=Daugyba^.skaicius*-1;
		end;
		
		if Daugyba<>nil then while Daugyba^.sekantis<>nil do Daugyba:=Daugyba^.sekantis;
	end;
//==============================================================================



	
  // dalyba   (dalmuo - sveikoji dalis, liekana - liekana)
  procedure Dalyba (const a, b :IlgasSkaicius; var dalmuo, liekana :IlgasSkaicius; var err :integer);
	var aLaik, bLaik, Laik1, Laik2, dalmuoLaik, liekanaLaik :IlgasSkaicius;
		Zenklas1, Zenklas2, Z1, Z2, First :boolean;
  begin
	Kopijuoti (a, aLaik);
	Kopijuoti (b, bLaik);

	if aLaik = NIL then SukuriamSkaiciu(aLaik,'0',err);
	if bLaik = NIL then SukuriamSkaiciu(bLaik,'0',err);
		
	Z1 := FALSE;
	Z2 := FALSE;
		
	while aLaik^.buves <> NIL do aLaik := aLaik^.buves;
	while bLaik^.buves <> NIL do bLaik := bLaik^.buves;
		
	if aLaik^.skaicius < 0 then Z1 := TRUE;
	if bLaik^.skaicius < 0 then Z2 := TRUE;
		
	while aLaik^.sekantis <> NIL do aLaik := aLaik^.sekantis;
	while bLaik^.sekantis <> NIL do bLaik := bLaik^.sekantis;
		
	PasalintiNulius(aLaik);
	PasalintiNulius(bLaik);
	Modulis(aLaik);
	Modulis(bLaik);
		
	if (not Z1 and not Z2) or (Z1 and Z2) then Zenklas1 := FALSE;   //ar teigiamas ar neigiamas ats bus
	if (not Z1 and Z2) or (Z1 and not Z2) then Zenklas1 := TRUE;
    Zenklas2 := Z1;
		
	SukuriamSkaiciu(dalmuo,'0',err);
	SukuriamSkaiciu(liekana,'0',err);
		
	First := TRUE;

	if ((bLaik^.buves = NIL) and (bLaik^.sekantis = NIL) and (bLaik^.skaicius = 0)) then   //dalyba is 0
	begin
	  dalmuo := NIL;
	  liekana := NIL;
	  err := 1;
	end
	else
	begin
	  while aLaik <> NIL do
	  begin
	    if First then    // pirmam elementui
		begin
		  while aLaik^.buves <> NIL do aLaik := aLaik^.buves;
		  Laik1 := aLaik;        //galva
		  aLaik := aLaik^.sekantis;
		  if aLaik <> NIL then aLaik^.buves := NIL;
		  Laik1^.sekantis := NIL;
		  First := FALSE;
		end
	    else            // tolesnius elementus prijungt
	    begin
	 	  while aLaik^.buves <> NIL do aLaik := aLaik^.buves;
		  while Laik1^.sekantis <> NIL do Laik1 := Laik1^.sekantis;
		  Laik2 := aLaik;
		  aLaik := aLaik^.sekantis;
    	  if aLaik <> NIL then aLaik^.buves := NIL;
		  Laik1^.sekantis := Laik2;
		  Laik2^.buves := Laik1;
		  Laik2^.sekantis := NIL;
		  Laik1 := Laik1^.sekantis;
	    end;
				
	    DalybosAlg(Laik1,bLaik,dalmuoLaik,liekanaLaik,err);   //dalina
	    while dalmuoLaik^.buves <> NIL do dalmuoLaik := dalmuoLaik^.buves;
	    while liekanaLaik^.buves <> NIL do liekanaLaik := liekanaLaik^.buves;
	    while dalmuo^.sekantis <> NIL do dalmuo := dalmuo^.sekantis;

	    dalmuo^.sekantis := dalmuoLaik;
	    dalmuoLaik^.buves := dalmuo;
	    PasalintiNulius(dalmuo);
				
	    liekana := liekanaLaik;
	    Laik1 := liekanaLaik;
	    if ((liekanaLaik^.skaicius = 0) and (liekanaLaik^.sekantis = NIL) and
           (liekanaLaik^.buves = NIL)) then
        First := TRUE;
	  end;
   	end;
	PasalintiNulius(liekana);
	PasalintiNulius(dalmuo);

	if (Zenklas1 and (dalmuo <> NIL)) then      //neigiama dalyba
	begin
	  while dalmuo^.buves <> NIL do dalmuo := dalmuo^.buves;
      dalmuo^.skaicius := dalmuo^.skaicius * -1;
	end;
   	if (Zenklas2 and (liekana <> NIL)) then      //neigiama liekana
	begin
	  while liekana^.buves <> NIL do liekana := liekana^.buves;
	  liekana^.skaicius := liekana^.skaicius * -1;
	end;
		
	if dalmuo <> NIL then while dalmuo^.sekantis <> NIL do dalmuo := dalmuo^.sekantis;
	if liekana <> NIL then while liekana^.sekantis <> NIL do liekana := liekana^.sekantis;
  end;
end.
