public class SquareSolver {

	public int solve(int[][] square) {
		return square.length < square[0].length ? calculate(square,
				square.length) : calculate(square, square[0].length);
	}

	private int calculate(int[][] square, int time) {
		int counter = 0;
		for (int i = 2; i < time+1; i++) {
			counter += calculateMagicSqures(square, i);
		}
		return counter;
	}

	private int calculateMagicSqures(int[][] square, int size) {
		int counter = 0, rowSum, columnSum, diagnolSum;
		for (int i = 0; i < square.length - (size - 1); i++) {
			for (int j = 0; j < square[0].length - (size - 1); j++) {
				rowSum = sumRow(square, size, i, j, 1, -1);
				columnSum = sumColumn(square, size, i, j, 1, -1);
				diagnolSum = sumDiagnol(square, size, i, j);
				if ((rowSum == columnSum && rowSum == diagnolSum && columnSum == diagnolSum)
						&& (rowSum != -2 && columnSum != -2 && diagnolSum != -2)) {
					counter++;
				}
			}
		}
		return counter;
	}

	private int sumRow(int[][] square, int size, int startAtRow,
			int startAtColumn, int time, int sum) {
		int rowSum = 0;
		for (int i = startAtColumn; i < startAtColumn + size; i++) {
			rowSum += square[startAtRow][i];
		}
		if (orContinue(sum, rowSum, time, size)) {
			sum = sumRow(square, size, ++startAtRow, startAtColumn, ++time,
					rowSum);
		}
		if (sum != rowSum) {
			return -2;
		}
		return rowSum;

	}

	private int sumColumn(int[][] square, int size, int startAtRow,
			int startAtColumn, int time, int sum) {
		int columnSum = 0;
		for (int i = startAtRow; i < startAtRow + size; i++) {
			columnSum += square[i][startAtColumn];
		}
		if (orContinue(sum, columnSum, time, size)) {
			sum = sumColumn(square, size, startAtRow, ++startAtColumn, ++time,
					columnSum);
		}
		if (sum != columnSum) {
			return -2;
		}
		return columnSum;
	}

	private int sumDiagnol(int[][] square, int size, int startAtRow,
			int startAtColumn) {
		int firstDiagnolSum = 0, secondDiagnolSum = 0;
		for (int i = startAtRow; i < startAtRow + size; i++) {
			firstDiagnolSum += square[i][startAtColumn];
			startAtColumn++;
		}
		startAtColumn--;
		for (int i = startAtRow; i < startAtRow + size; i++) {
			secondDiagnolSum += square[i][startAtColumn];
			startAtColumn--;
		}
		return secondDiagnolSum == firstDiagnolSum ? firstDiagnolSum : -2;
	}

	private boolean orContinue(int previousSum, int currentSum, int time,
			int size) {
		return ((previousSum == -1) || (time < size && previousSum == currentSum)) ? true
				: false;
	}
}
